/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.model.UploadedResource;
import alfio.model.modification.UploadBase64FileModification;
import alfio.repository.UploadedResourceRepository;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Transactional
public class UploadedResourceManager {
    public static final String ATTR_IMG_WIDTH = "width";
    public static final String ATTR_IMG_HEIGHT = "height";
    private static final Logger log = LoggerFactory.getLogger(UploadedResourceManager.class);
    private final UploadedResourceRepository uploadedResourceRepository;

    public UploadedResourceManager(UploadedResourceRepository uploadedResourceRepository) {
        this.uploadedResourceRepository = uploadedResourceRepository;
    }

    public boolean hasResource(String name) {
        return this.uploadedResourceRepository.hasResource(name);
    }

    public boolean hasResource(int organizationId, String name) {
        return this.uploadedResourceRepository.hasResource(organizationId, name);
    }

    public boolean hasResource(int organizationId, int eventId, String name) {
        return this.uploadedResourceRepository.hasResource(organizationId, eventId, name);
    }

    public UploadedResource get(String name) {
        return this.uploadedResourceRepository.get(name);
    }

    public UploadedResource get(int organizationId, String name) {
        return this.uploadedResourceRepository.get(organizationId, name);
    }

    public UploadedResource get(int organizationId, int eventId, String name) {
        return this.uploadedResourceRepository.get(organizationId, eventId, name);
    }

    public void outputResource(String name, OutputStream out) {
        this.uploadedResourceRepository.fileContent(name, out);
    }

    public void outputResource(int organizationId, String name, OutputStream out) {
        this.uploadedResourceRepository.fileContent(organizationId, name, out);
    }

    public void outputResource(int organizationId, int eventId, String name, OutputStream out) {
        this.uploadedResourceRepository.fileContent(organizationId, eventId, name, out);
    }

    public Optional<Integer> saveResource(UploadBase64FileModification file) {
        if (this.hasResource(file.getName())) {
            this.uploadedResourceRepository.delete(file.getName());
        }
        return Optional.ofNullable(this.uploadedResourceRepository.upload(null, null, file, UploadedResourceManager.getAttributes((UploadBase64FileModification)file)));
    }

    public Optional<Integer> saveResource(int organizationId, UploadBase64FileModification file) {
        if (this.hasResource(organizationId, file.getName())) {
            this.uploadedResourceRepository.delete(organizationId, file.getName());
        }
        return Optional.ofNullable(this.uploadedResourceRepository.upload(Integer.valueOf(organizationId), null, file, UploadedResourceManager.getAttributes((UploadBase64FileModification)file)));
    }

    public Optional<Integer> saveResource(int organizationId, int eventId, UploadBase64FileModification file) {
        if (this.hasResource(organizationId, eventId, file.getName())) {
            this.uploadedResourceRepository.delete(organizationId, eventId, file.getName());
        }
        return Optional.ofNullable(this.uploadedResourceRepository.upload(Integer.valueOf(organizationId), Integer.valueOf(eventId), file, UploadedResourceManager.getAttributes((UploadBase64FileModification)file)));
    }

    public void deleteResource(String name) {
        this.uploadedResourceRepository.delete(name);
    }

    public void deleteResource(int organizationId, String name) {
        this.uploadedResourceRepository.delete(organizationId, name);
    }

    public void deleteResource(int organizationId, int eventId, String name) {
        this.uploadedResourceRepository.delete(organizationId, eventId, name);
    }

    public List<UploadedResource> findAll() {
        return this.uploadedResourceRepository.findAll();
    }

    public List<UploadedResource> findAll(int organizationId) {
        return this.uploadedResourceRepository.findAll(organizationId);
    }

    public List<UploadedResource> findAll(int organizationId, int eventId) {
        return this.uploadedResourceRepository.findAll(organizationId, eventId);
    }

    private static Map<String, String> getAttributes(UploadBase64FileModification file) {
        if (!StringUtils.startsWith((CharSequence)file.getType(), (CharSequence)"image/")) {
            return file.getAttributes();
        }
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(file.getFile()));
            HashMap<String, String> attributes = new HashMap<String, String>(file.getAttributes());
            attributes.put("width", String.valueOf(image.getWidth()));
            attributes.put("height", String.valueOf(image.getHeight()));
            return attributes;
        }
        catch (IOException e) {
            log.error("error while processing image: ", (Throwable)e);
            return file.getAttributes();
        }
    }

    public Optional<byte[]> findCascading(int organizationId, Integer eventId, String savedName) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (eventId != null && this.hasResource(organizationId, eventId.intValue(), savedName)) {
            this.outputResource(organizationId, eventId.intValue(), savedName, (OutputStream)baos);
            return Optional.of(baos.toByteArray());
        }
        if (this.hasResource(organizationId, savedName)) {
            this.outputResource(organizationId, savedName, (OutputStream)baos);
            return Optional.of(baos.toByteArray());
        }
        if (this.hasResource(savedName)) {
            this.outputResource(savedName, (OutputStream)baos);
            return Optional.of(baos.toByteArray());
        }
        return Optional.empty();
    }
}

