/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.EventStatisticsManager;
import alfio.manager.ExtensionManager;
import alfio.manager.NotificationManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.model.CustomerName;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.EventStatisticView;
import alfio.model.PurchaseContext;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketCategoryStatisticView;
import alfio.model.WaitingQueueSubscription;
import alfio.model.modification.ReservationRequest;
import alfio.model.modification.TicketReservationModification;
import alfio.model.modification.TicketReservationWithOptionalCodeModification;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Organization;
import alfio.repository.EventRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.repository.WaitingQueueRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.util.ClockProvider;
import alfio.util.EventUtil;
import alfio.util.PreReservedTicketDistributor;
import alfio.util.RenderedTemplate;
import alfio.util.TemplateManager;
import alfio.util.TemplateResource;
import alfio.util.WorkingDaysAdjusters;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Component;

@Component
public class WaitingQueueManager {
    private static final Logger log = LoggerFactory.getLogger(WaitingQueueManager.class);
    private final WaitingQueueRepository waitingQueueRepository;
    private final TicketRepository ticketRepository;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final ConfigurationManager configurationManager;
    private final EventStatisticsManager eventStatisticsManager;
    private final NotificationManager notificationManager;
    private final TemplateManager templateManager;
    private final MessageSourceManager messageSourceManager;
    private final OrganizationRepository organizationRepository;
    private final EventRepository eventRepository;
    private final ExtensionManager extensionManager;
    private final ClockProvider clockProvider;

    public boolean subscribe(Event event, CustomerName customerName, String email, Integer selectedCategoryId, Locale userLanguage) {
        try {
            if (this.configurationManager.getFor(ConfigurationKeys.STOP_WAITING_QUEUE_SUBSCRIPTIONS, ConfigurationLevel.event((EventAndOrganizationId)event)).getValueAsBooleanOrDefault()) {
                log.info("waiting list subscription denied for event {} ({})", (Object)event.getShortName(), (Object)event.getId());
                return false;
            }
            WaitingQueueSubscription.Type subscriptionType = this.getSubscriptionType(event);
            this.validateSubscriptionType((EventAndOrganizationId)event, subscriptionType);
            this.validateSelectedCategoryId(event.getId(), selectedCategoryId);
            AffectedRowCountAndKey key = this.waitingQueueRepository.insert(event.getId(), customerName.getFullName(), customerName.getFirstName(), customerName.getLastName(), email, event.now(this.clockProvider), userLanguage.getLanguage(), subscriptionType, selectedCategoryId);
            this.notifySubscription(event, customerName, email, userLanguage, subscriptionType);
            this.extensionManager.handleWaitingQueueSubscription(this.waitingQueueRepository.loadById(((Integer)key.getKey()).intValue()));
            return true;
        }
        catch (DuplicateKeyException e) {
            return true;
        }
        catch (Exception e) {
            log.error("error during subscription", (Throwable)e);
            return false;
        }
    }

    private void validateSelectedCategoryId(int eventId, Integer selectedCategoryId) {
        Optional.ofNullable(selectedCategoryId).ifPresent(id -> Validate.isTrue((boolean)this.ticketCategoryRepository.findUnboundedOrderByExpirationDesc(eventId).stream().anyMatch(c -> id.equals(c.getId()))));
    }

    private void notifySubscription(Event event, CustomerName name, String email, Locale userLanguage, WaitingQueueSubscription.Type subscriptionType) {
        MessageSource messageSource = this.messageSourceManager.getMessageSourceFor((PurchaseContext)event);
        Organization organization = this.organizationRepository.getById(event.getOrganizationId());
        Map model = TemplateResource.buildModelForWaitingQueueJoined((Organization)organization, (Event)event, (CustomerName)name);
        this.notificationManager.sendSimpleEmail((PurchaseContext)event, null, email, messageSource.getMessage("email-waiting-queue.subscribed.subject", new Object[]{event.getDisplayName()}, userLanguage), () -> this.templateManager.renderTemplate((PurchaseContext)event, TemplateResource.WAITING_QUEUE_JOINED, model, userLanguage));
        if (this.configurationManager.getFor(ConfigurationKeys.ENABLE_WAITING_QUEUE_NOTIFICATION, ConfigurationLevel.event((EventAndOrganizationId)event)).getValueAsBooleanOrDefault()) {
            String adminTemplate = messageSource.getMessage("email-waiting-queue.subscribed.admin.text", new Object[]{subscriptionType, event.getDisplayName()}, Locale.ENGLISH);
            this.notificationManager.sendSimpleEmail((PurchaseContext)event, null, organization.getEmail(), messageSource.getMessage("email-waiting-queue.subscribed.admin.subject", new Object[]{event.getDisplayName()}, Locale.ENGLISH), () -> RenderedTemplate.plaintext((String)this.templateManager.renderString((PurchaseContext)event, adminTemplate, model, Locale.ENGLISH, TemplateManager.TemplateOutput.TEXT), (Map)model));
        }
    }

    private WaitingQueueSubscription.Type getSubscriptionType(Event event) {
        ZonedDateTime now = event.now(this.clockProvider);
        return this.ticketCategoryRepository.findAllTicketCategories(event.getId()).stream().filter(tc -> !tc.isAccessRestricted()).filter(tc -> now.isAfter(tc.getInception(event.getZoneId()))).findFirst().map(tc -> WaitingQueueSubscription.Type.SOLD_OUT).orElse(WaitingQueueSubscription.Type.PRE_SALES);
    }

    private void validateSubscriptionType(EventAndOrganizationId event, WaitingQueueSubscription.Type type) {
        if (type == WaitingQueueSubscription.Type.PRE_SALES) {
            Validate.isTrue((boolean)this.configurationManager.getFor(ConfigurationKeys.ENABLE_PRE_REGISTRATION, ConfigurationLevel.event((EventAndOrganizationId)event)).getValueAsBooleanOrDefault(), (String)"PRE_SALES Waiting list is not active", (Object[])new Object[0]);
        } else {
            Validate.isTrue((boolean)this.eventStatisticsManager.noSeatsAvailable().test(event), (String)"SOLD_OUT Waiting list is not active", (Object[])new Object[0]);
        }
    }

    public List<WaitingQueueSubscription> loadAllSubscriptionsForEvent(int eventId) {
        return this.waitingQueueRepository.loadAllWaiting(eventId);
    }

    public Optional<WaitingQueueSubscription> updateSubscriptionStatus(int id, WaitingQueueSubscription.Status newStatus, WaitingQueueSubscription.Status currentStatus) {
        return Optional.of(this.waitingQueueRepository.updateStatus(id, newStatus, currentStatus)).filter(i -> i > 0).map(i -> this.waitingQueueRepository.loadById(id));
    }

    public int countSubscribers(int eventId) {
        return this.waitingQueueRepository.countWaitingPeople(eventId);
    }

    Stream<Triple<WaitingQueueSubscription, TicketReservationWithOptionalCodeModification, ZonedDateTime>> distributeSeats(Event event) {
        int eventId = event.getId();
        List subscriptions = this.waitingQueueRepository.loadAllWaitingForUpdate(eventId);
        int waitingPeople = subscriptions.size();
        int waitingTickets = this.ticketRepository.countWaiting(eventId);
        if (waitingPeople == 0 && waitingTickets > 0) {
            this.ticketRepository.revertToFree(eventId);
        } else {
            if (waitingPeople > 0 && waitingTickets > 0) {
                return this.distributeAvailableSeats(event, waitingPeople, waitingTickets);
            }
            if (subscriptions.stream().anyMatch(WaitingQueueSubscription::isPreSales) && this.configurationManager.getFor(ConfigurationKeys.ENABLE_PRE_REGISTRATION, ConfigurationLevel.event((EventAndOrganizationId)event)).getValueAsBooleanOrDefault()) {
                return this.handlePreReservation(event, waitingPeople);
            }
        }
        return Stream.empty();
    }

    private Stream<Triple<WaitingQueueSubscription, TicketReservationWithOptionalCodeModification, ZonedDateTime>> handlePreReservation(Event event, int waitingPeople) {
        List ticketCategories = this.ticketCategoryRepository.findAllTicketCategories(event.getId());
        Optional<TicketCategory> categoryWithInceptionInFuture = ticketCategories.stream().min(TicketCategory.COMPARATOR).filter(t -> event.now(this.clockProvider).isBefore(t.getInception(event.getZoneId()).minusMinutes(5L)));
        int ticketsNeeded = Math.min(waitingPeople, this.eventRepository.countExistingTickets(event.getId()));
        if (ticketsNeeded > 0) {
            this.preReserveIfNeeded(event, ticketsNeeded);
            if (categoryWithInceptionInFuture.isEmpty()) {
                return this.distributeAvailableSeats(event, Ticket.TicketStatus.PRE_RESERVED, () -> ticketsNeeded);
            }
        }
        return Stream.empty();
    }

    private void preReserveIfNeeded(Event event, int ticketsNeeded) {
        int eventId = event.getId();
        int alreadyReserved = this.ticketRepository.countPreReservedTickets(eventId);
        if (alreadyReserved < ticketsNeeded) {
            this.preReserveTickets(event, ticketsNeeded, eventId, alreadyReserved);
        }
    }

    private void preReserveTickets(Event event, int ticketsNeeded, int eventId, int alreadyReserved) {
        int toBeGenerated = Math.abs(alreadyReserved - ticketsNeeded);
        EventStatisticView eventStatisticView = this.eventRepository.findStatisticsFor(eventId);
        Map ticketCategoriesStats = this.ticketCategoryRepository.findStatisticsForEventIdByCategoryId(eventId);
        List collectedTickets = (List)this.ticketCategoryRepository.findAllTicketCategories(eventId).stream().filter(tc -> !tc.isAccessRestricted()).sorted(Comparator.comparing(t -> t.getExpiration(event.getZoneId()))).map(tc -> Pair.of((Object)EventUtil.determineAvailableSeats((TicketCategoryStatisticView)((TicketCategoryStatisticView)ticketCategoriesStats.get(tc.getId())), (EventStatisticView)eventStatisticView), (Object)((TicketCategoryStatisticView)ticketCategoriesStats.get(tc.getId())))).collect(new PreReservedTicketDistributor(toBeGenerated));
        List ids = collectedTickets.stream().flatMap(p -> this.selectTicketsForPreReservation(eventId, p).stream()).collect(Collectors.toList());
        this.ticketRepository.preReserveTicket(ids);
    }

    private List<Integer> selectTicketsForPreReservation(int eventId, Pair<Integer, TicketCategoryStatisticView> p) {
        TicketCategoryStatisticView category = (TicketCategoryStatisticView)p.getValue();
        Integer amount = (Integer)p.getKey();
        if (category.isBounded()) {
            return this.ticketRepository.selectFreeTicketsForPreReservation(eventId, amount.intValue(), category.getId());
        }
        return this.ticketRepository.selectNotAllocatedFreeTicketsForPreReservation(eventId, amount.intValue());
    }

    private Stream<Triple<WaitingQueueSubscription, TicketReservationWithOptionalCodeModification, ZonedDateTime>> distributeAvailableSeats(Event event, int waitingPeople, int waitingTickets) {
        return this.distributeAvailableSeats(event, Ticket.TicketStatus.RELEASED, () -> Math.min(waitingPeople, waitingTickets));
    }

    private Stream<Triple<WaitingQueueSubscription, TicketReservationWithOptionalCodeModification, ZonedDateTime>> distributeAvailableSeats(Event event, Ticket.TicketStatus status, IntSupplier availableSeatSupplier) {
        int availableSeats = availableSeatSupplier.getAsInt();
        int eventId = event.getId();
        log.debug("processing {} subscribers from waiting list", (Object)availableSeats);
        List unboundedCategories = this.ticketCategoryRepository.findUnboundedOrderByExpirationDesc(eventId);
        Iterator tickets = this.ticketRepository.selectWaitingTicketsForUpdate(eventId, status.name(), availableSeats).stream().filter(t -> t.getCategoryId() != null || !unboundedCategories.isEmpty()).iterator();
        int expirationTimeout = this.configurationManager.getFor(ConfigurationKeys.WAITING_QUEUE_RESERVATION_TIMEOUT, ConfigurationLevel.event((EventAndOrganizationId)event)).getValueAsIntOrDefault(4);
        ZonedDateTime expiration = event.now(this.clockProvider).plusHours(expirationTimeout).with(WorkingDaysAdjusters.defaultWorkingDays());
        if (!tickets.hasNext()) {
            log.warn("Unable to assign tickets, returning an empty stream");
            return Stream.empty();
        }
        return this.waitingQueueRepository.loadWaiting(eventId, availableSeats).stream().map(wq -> Pair.of((Object)wq, (Object)((Ticket)tickets.next()))).map(pair -> {
            TicketReservationModification ticketReservation = new TicketReservationModification();
            ticketReservation.setQuantity(Integer.valueOf(1));
            Integer categoryId = Optional.ofNullable(((Ticket)pair.getValue()).getCategoryId()).orElseGet(() -> ((TicketCategory)this.findBestCategory(unboundedCategories, (WaitingQueueSubscription)pair.getKey()).orElseThrow(RuntimeException::new)).getId());
            ticketReservation.setTicketCategoryId(categoryId);
            return Pair.of((Object)((WaitingQueueSubscription)pair.getLeft()), (Object)new TicketReservationWithOptionalCodeModification((ReservationRequest)ticketReservation, Optional.empty()));
        }).map(pair -> Triple.of((Object)((WaitingQueueSubscription)pair.getKey()), (Object)((TicketReservationWithOptionalCodeModification)pair.getValue()), (Object)expiration));
    }

    private Optional<TicketCategory> findBestCategory(List<TicketCategory> unboundedCategories, WaitingQueueSubscription subscription) {
        Integer selectedCategoryId = subscription.getSelectedCategoryId();
        Optional<TicketCategory> firstMatch = unboundedCategories.stream().filter(tc -> selectedCategoryId == null || selectedCategoryId.equals(tc.getId())).findFirst();
        if (firstMatch.isPresent()) {
            return firstMatch;
        }
        return unboundedCategories.stream().findFirst();
    }

    public void fireReservationConfirmed(String reservationId) {
        this.updateStatus(reservationId, WaitingQueueSubscription.Status.ACQUIRED.toString());
    }

    public void fireReservationExpired(String reservationId) {
        this.waitingQueueRepository.bulkUpdateExpiredReservations(Collections.singletonList(reservationId));
    }

    public void cleanExpiredReservations(List<String> reservationIds) {
        this.waitingQueueRepository.bulkUpdateExpiredReservations(reservationIds);
    }

    private void updateStatus(String reservationId, String status) {
        this.waitingQueueRepository.updateStatusByReservationId(reservationId, status);
    }

    @ConstructorProperties(value={"waitingQueueRepository", "ticketRepository", "ticketCategoryRepository", "configurationManager", "eventStatisticsManager", "notificationManager", "templateManager", "messageSourceManager", "organizationRepository", "eventRepository", "extensionManager", "clockProvider"})
    @Generated
    public WaitingQueueManager(WaitingQueueRepository waitingQueueRepository, TicketRepository ticketRepository, TicketCategoryRepository ticketCategoryRepository, ConfigurationManager configurationManager, EventStatisticsManager eventStatisticsManager, NotificationManager notificationManager, TemplateManager templateManager, MessageSourceManager messageSourceManager, OrganizationRepository organizationRepository, EventRepository eventRepository, ExtensionManager extensionManager, ClockProvider clockProvider) {
        this.waitingQueueRepository = waitingQueueRepository;
        this.ticketRepository = ticketRepository;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.configurationManager = configurationManager;
        this.eventStatisticsManager = eventStatisticsManager;
        this.notificationManager = notificationManager;
        this.templateManager = templateManager;
        this.messageSourceManager = messageSourceManager;
        this.organizationRepository = organizationRepository;
        this.eventRepository = eventRepository;
        this.extensionManager = extensionManager;
        this.clockProvider = clockProvider;
    }
}

