/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.EventManager;
import alfio.manager.NotificationManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.WaitingQueueManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.system.ConfigurationManager;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.PurchaseContext;
import alfio.model.TicketInfo;
import alfio.model.WaitingQueueSubscription;
import alfio.model.modification.TicketReservationWithOptionalCodeModification;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Organization;
import alfio.repository.TicketRepository;
import alfio.repository.WaitingQueueRepository;
import alfio.util.ClockProvider;
import alfio.util.TemplateManager;
import alfio.util.TemplateResource;
import java.beans.ConstructorProperties;
import java.sql.Date;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Component
@Transactional
public class WaitingQueueSubscriptionProcessor {
    private static final Logger log = LoggerFactory.getLogger(WaitingQueueSubscriptionProcessor.class);
    private final EventManager eventManager;
    private final TicketReservationManager ticketReservationManager;
    private final ConfigurationManager configurationManager;
    private final WaitingQueueManager waitingQueueManager;
    private final NotificationManager notificationManager;
    private final WaitingQueueRepository waitingQueueRepository;
    private final MessageSourceManager messageSourceManager;
    private final TemplateManager templateManager;
    private final TicketRepository ticketRepository;
    private final PlatformTransactionManager transactionManager;
    private final ClockProvider clockProvider;

    public void handleWaitingTickets() {
        Map<Boolean, List<Event>> activeEvents = this.eventManager.getActiveEvents().stream().collect(Collectors.partitioningBy(arg_0 -> this.isWaitingListFormEnabled(arg_0)));
        activeEvents.get(true).forEach(event -> {
            TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition(3));
            try {
                this.ticketReservationManager.revertTicketsToFreeIfAccessRestricted(event.getId());
                this.revertTicketToFreeIfCategoryIsExpired(event);
                this.distributeAvailableSeats(event);
                this.transactionManager.commit(transaction);
            }
            catch (Exception ex) {
                if (!(ex instanceof TransactionException)) {
                    this.transactionManager.rollback(transaction);
                }
                log.error("cannot process waiting list for event {}", (Object)event.getShortName(), (Object)ex);
            }
        });
        activeEvents.get(false).forEach(arg_0 -> ((EventManager)this.eventManager).resetReleasedTickets(arg_0));
    }

    public void revertTicketToFreeIfCategoryIsExpired(Event event) {
        int eventId = event.getId();
        List releasedButExpired = this.ticketRepository.findReleasedBelongingToExpiredCategories(eventId, event.now(this.clockProvider));
        Map releasedByCategory = releasedButExpired.stream().collect(Collectors.groupingBy(t -> Pair.of((Object)t.getTicketCategoryId(), (Object)t.isTicketCategoryBounded()), Collectors.mapping(TicketInfo::getTicketId, Collectors.toList())));
        releasedByCategory.forEach((ticketCategory, ticketIds) -> {
            int ticketCategoryId = (Integer)ticketCategory.getKey();
            boolean isTicketCategoryBounded = (Boolean)ticketCategory.getRight();
            if (!ticketIds.isEmpty()) {
                if (isTicketCategoryBounded) {
                    this.ticketRepository.revertToFree(eventId, ticketCategoryId, ticketIds);
                } else {
                    this.ticketRepository.unbindTicketsFromCategory(eventId, ticketCategoryId, ticketIds);
                }
            }
        });
    }

    private boolean isWaitingListFormEnabled(EventAndOrganizationId event) {
        Map res = this.configurationManager.getFor(Set.of(ConfigurationKeys.ENABLE_WAITING_QUEUE, ConfigurationKeys.ENABLE_PRE_REGISTRATION), event.getConfigurationLevel());
        return ((ConfigurationManager.MaybeConfiguration)res.get(ConfigurationKeys.ENABLE_WAITING_QUEUE)).getValueAsBooleanOrDefault() || ((ConfigurationManager.MaybeConfiguration)res.get(ConfigurationKeys.ENABLE_PRE_REGISTRATION)).getValueAsBooleanOrDefault();
    }

    public void distributeAvailableSeats(Event event) {
        MessageSource messageSource = this.messageSourceManager.getMessageSourceFor((PurchaseContext)event);
        this.waitingQueueManager.distributeSeats(event).forEach(triple -> {
            WaitingQueueSubscription subscription = (WaitingQueueSubscription)triple.getLeft();
            Locale locale = subscription.getLocale();
            ZonedDateTime expiration = (ZonedDateTime)triple.getRight();
            Organization organization = this.eventManager.loadOrganizerUsingSystemPrincipal((EventAndOrganizationId)event);
            String reservationId = this.createReservation(event, (TicketReservationWithOptionalCodeModification)triple.getMiddle(), expiration, locale);
            String subject = messageSource.getMessage("email-waiting-queue-acquired.subject", new Object[]{event.getDisplayName()}, locale);
            String reservationUrl = this.ticketReservationManager.reservationUrl(reservationId, (PurchaseContext)event);
            Map model = TemplateResource.buildModelForWaitingQueueReservationEmail((Organization)organization, (Event)event, (WaitingQueueSubscription)subscription, (String)reservationUrl, (ZonedDateTime)expiration);
            this.notificationManager.sendSimpleEmail((PurchaseContext)event, reservationId, subscription.getEmailAddress(), subject, () -> this.templateManager.renderTemplate((PurchaseContext)event, TemplateResource.WAITING_QUEUE_RESERVATION_EMAIL, model, locale));
            this.waitingQueueRepository.flagAsPending(reservationId, subscription.getId());
        });
    }

    private String createReservation(Event event, TicketReservationWithOptionalCodeModification reservation, ZonedDateTime expiration, Locale locale) {
        return this.ticketReservationManager.createTicketReservation(event, Collections.singletonList(reservation), Collections.emptyList(), Date.from(expiration.toInstant()), Optional.empty(), locale, true, null);
    }

    @ConstructorProperties(value={"eventManager", "ticketReservationManager", "configurationManager", "waitingQueueManager", "notificationManager", "waitingQueueRepository", "messageSourceManager", "templateManager", "ticketRepository", "transactionManager", "clockProvider"})
    @Generated
    public WaitingQueueSubscriptionProcessor(EventManager eventManager, TicketReservationManager ticketReservationManager, ConfigurationManager configurationManager, WaitingQueueManager waitingQueueManager, NotificationManager notificationManager, WaitingQueueRepository waitingQueueRepository, MessageSourceManager messageSourceManager, TemplateManager templateManager, TicketRepository ticketRepository, PlatformTransactionManager transactionManager, ClockProvider clockProvider) {
        this.eventManager = eventManager;
        this.ticketReservationManager = ticketReservationManager;
        this.configurationManager = configurationManager;
        this.waitingQueueManager = waitingQueueManager;
        this.notificationManager = notificationManager;
        this.waitingQueueRepository = waitingQueueRepository;
        this.messageSourceManager = messageSourceManager;
        this.templateManager = templateManager;
        this.ticketRepository = ticketRepository;
        this.transactionManager = transactionManager;
        this.clockProvider = clockProvider;
    }
}

