/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.i18n;

import alfio.model.ContentLanguage;
import alfio.repository.EventRepository;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class I18nManager {
    private final EventRepository eventRepository;

    public I18nManager(EventRepository eventRepository) {
        this.eventRepository = eventRepository;
    }

    public List<ContentLanguage> getAvailableLanguages() {
        return ContentLanguage.ALL_LANGUAGES;
    }

    public List<ContentLanguage> getEventLanguages(String eventName) {
        return this.eventRepository.findLocalesByShortName(eventName).map(arg_0 -> this.getEventLanguages(arg_0)).orElse(Collections.emptyList());
    }

    public List<ContentLanguage> getEventLanguages(int eventLocales) {
        List system = this.getAvailableLanguages();
        return ContentLanguage.findAllFor((int)eventLocales).stream().filter(system::contains).collect(Collectors.toList());
    }
}

