/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.i18n;

import alfio.manager.i18n.MessageSourceManager;
import alfio.model.PurchaseContext;
import alfio.repository.system.ConfigurationRepository;
import alfio.util.CustomResourceBundleMessageSource;
import alfio.util.LocaleUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.context.MessageSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class MessageSourceManager {
    public static final Predicate<String> ADMIN_FRONTEND = key -> true;
    public static final Predicate<String> PUBLIC_FRONTEND = key -> !key.startsWith("admin.");
    private static final Pattern ARGUMENT_FINDER = Pattern.compile("\\{+(\\d+)}+");
    private final CustomResourceBundleMessageSource messageSource;
    private final ConfigurationRepository configurationRepository;
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Pattern PLACEHOLDER_TO_REPLACE = Pattern.compile("\\{(\\d+)\\}");

    public MessageSourceManager(CustomResourceBundleMessageSource messageSource, ConfigurationRepository configurationRepository) {
        this.messageSource = messageSource;
        this.configurationRepository = configurationRepository;
    }

    public Set<String> getKeys(String basename, Locale locale) {
        return this.messageSource.getKeys(basename, locale);
    }

    public Pair<MessageSource, Map<String, Map<String, String>>> getMessageSourceForPurchaseContextAndOverride(PurchaseContext purchaseContext) {
        Map override = purchaseContext.event().map(event -> this.configurationRepository.getEventOverrideMessages(event.getOrganizationId(), event.getId())).orElseGet(() -> this.configurationRepository.getOrganizationOverrideMessages(purchaseContext.getOrganizationId()));
        return Pair.of((Object)new MessageSourceWithOverride(this.messageSource, override), (Object)override);
    }

    public MessageSource getMessageSourceFor(PurchaseContext purchaseContext) {
        return (MessageSource)this.getMessageSourceForPurchaseContextAndOverride(purchaseContext).getLeft();
    }

    public MessageSource getMessageSourceFor(int orgId, int eventId) {
        Map override = this.configurationRepository.getEventOverrideMessages(orgId, eventId);
        return new MessageSourceWithOverride(this.messageSource, override);
    }

    public MessageSource getRootMessageSource() {
        return this.getRootMessageSource(true);
    }

    public MessageSource getRootMessageSource(boolean withSystemOverride) {
        if (withSystemOverride) {
            return new MessageSourceWithOverride(this.messageSource, this.configurationRepository.getSystemOverrideMessages());
        }
        return this.messageSource;
    }

    private static String convertPlaceholder(String value) {
        return PLACEHOLDER_TO_REPLACE.matcher(value).replaceAll("{{$1}}").replace("''", "'");
    }

    public static Map<String, Map<String, String>> convertPlaceholdersForEachLanguage(Map<String, Map<String, String>> bundles) {
        HashMap<String, Map<String, String>> res = new HashMap<String, Map<String, String>>(bundles.size());
        bundles.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> res.put((String)entry.getKey(), MessageSourceManager.convertPlaceholders((Map)((Map)entry.getValue()))));
        return res;
    }

    private static Map<String, String> convertPlaceholders(Map<String, String> bundle) {
        HashMap<String, String> res = new HashMap<String, String>(bundle.size());
        bundle.forEach((k, v) -> res.put((String)k, MessageSourceManager.convertPlaceholder((String)v)));
        return res;
    }

    public Map<String, String> getBundleAsMap(String baseName, boolean withSystemOverride, String lang, Predicate<String> keysFilter) {
        Locale locale = LocaleUtil.forLanguageTag((String)lang);
        MessageSource rootMessageSource = this.getRootMessageSource(withSystemOverride);
        return this.getKeys(baseName, locale).stream().filter(keysFilter).collect(Collectors.toMap(Function.identity(), k -> MessageSourceManager.convertPlaceholder((String)rootMessageSource.getMessage(k, (Object[])EMPTY_ARRAY, locale))));
    }

    static String cleanArguments(String translation, String replacement) {
        return ARGUMENT_FINDER.matcher(translation).replaceAll(replacement);
    }

    static Map<String, String> cleanTranslationsForFrontend(Map<String, String> translations) {
        return translations.entrySet().stream().map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)MessageSourceManager.cleanArguments((String)((String)entry.getValue()), (String)"{{$1}}").replace("''", "'"))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }
}

