/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.openid;

import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.model.system.ConfigurationKeys;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.web.util.UriComponentsBuilder;

public record OpenIdConfiguration(String domain, String clientId, String clientSecret, String callbackURI, String authenticationUrl, String tokenEndpoint, String givenNameClaim, String familyNameClaim, String contentType, String rolesParameter, String alfioGroupsParameter, String logoutUrl, String logoutRedirectUrl, String jwksPath) {
    private final String domain;
    private final String clientId;
    private final String clientSecret;
    private final String callbackURI;
    private final String authenticationUrl;
    private final String tokenEndpoint;
    private final String givenNameClaim;
    private final String familyNameClaim;
    private final String contentType;
    private final String rolesParameter;
    private final String alfioGroupsParameter;
    private final String logoutUrl;
    private final String logoutRedirectUrl;
    private final String jwksPath;

    @JsonCreator
    public OpenIdConfiguration(@JsonProperty(value="domain") String domain, @JsonProperty(value="clientId") String clientId, @JsonProperty(value="clientSecret") String clientSecret, @JsonProperty(value="callbackURI") String callbackURI, @JsonProperty(value="authenticationUrl") String authenticationUrl, @JsonProperty(value="tokenEndpoint") String tokenEndpoint, @JsonProperty(value="givenNameClaim") String givenNameClaim, @JsonProperty(value="familyNameClaim") String familyNameClaim, @JsonProperty(value="contentType") String contentType, @JsonProperty(value="rolesParameter") String rolesParameter, @JsonProperty(value="alfioGroupsParameter") String alfioGroupsParameter, @JsonProperty(value="logoutUrl") String logoutUrl, @JsonProperty(value="logoutRedirectUrl") String logoutRedirectUrl, @JsonProperty(value="jwksPath") String jwksPath) {
        this.domain = domain;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.callbackURI = callbackURI;
        this.authenticationUrl = authenticationUrl;
        this.tokenEndpoint = tokenEndpoint;
        this.givenNameClaim = Objects.requireNonNullElse(givenNameClaim, "given_name");
        this.familyNameClaim = Objects.requireNonNullElse(familyNameClaim, "family_name");
        this.contentType = Objects.requireNonNullElse(contentType, "application/x-www-form-urlencoded");
        this.rolesParameter = rolesParameter;
        this.alfioGroupsParameter = alfioGroupsParameter;
        this.logoutUrl = logoutUrl;
        this.logoutRedirectUrl = logoutRedirectUrl;
        this.jwksPath = Objects.requireNonNullElse(jwksPath, "/.well-known/jwks.json");
    }

    public ClientRegistration toClientRegistration(String registrationId, String fallbackRedirectURI, boolean fullScopeList) {
        UriComponentsBuilder baseURI = UriComponentsBuilder.newInstance().scheme("https").host(this.domain);
        ArrayList<String> scopes = new ArrayList<String>(List.of("openid", "email", "profile"));
        if (fullScopeList) {
            scopes.add("openid");
            scopes.add(this.rolesParameter);
            scopes.add(this.alfioGroupsParameter);
            scopes.add(this.givenNameClaim);
            scopes.add(this.familyNameClaim);
        }
        String redirectUri = Objects.requireNonNullElse(StringUtils.trimToNull((String)this.callbackURI), fallbackRedirectURI);
        return ClientRegistration.withRegistrationId((String)registrationId).clientId(this.clientId).clientSecret(this.clientSecret).redirectUri(redirectUri).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).scope(scopes).authorizationUri(baseURI.replacePath(this.authenticationUrl).toUriString()).jwkSetUri(baseURI.replacePath(this.jwksPath).toUriString()).tokenUri(baseURI.replacePath(this.tokenEndpoint).toUriString()).build();
    }

    public static OpenIdConfiguration from(Environment environment, ConfigurationManager configurationManager) {
        String baseUrl = StringUtils.removeEnd((String)configurationManager.getFor(ConfigurationKeys.BASE_URL, ConfigurationLevel.system()).getRequiredValue(), (String)"/");
        return new OpenIdConfiguration(environment.getProperty("openid.domain"), environment.getProperty("openid.clientId"), environment.getProperty("openid.clientSecret"), environment.getProperty("openid.callbackURI", baseUrl + "/callback"), environment.getProperty("openid.authenticationUrl"), environment.getProperty("openid.tokenEndpoint", "/authorize"), environment.getProperty("openid.givenNameClaim"), environment.getProperty("openid.familyNameClaim"), environment.getProperty("openid.contentType", "application/x-www-form-urlencoded"), environment.getProperty("openid.rolesParameter"), environment.getProperty("openid.alfioGroupsParameter"), environment.getProperty("openid.logoutUrl"), environment.getProperty("openid.logoutRedirectUrl", baseUrl + "/admin"), environment.getProperty("openid.jwksPath"));
    }

    public String domain() {
        return this.domain;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public String callbackURI() {
        return this.callbackURI;
    }

    public String authenticationUrl() {
        return this.authenticationUrl;
    }

    public String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public String givenNameClaim() {
        return this.givenNameClaim;
    }

    public String familyNameClaim() {
        return this.familyNameClaim;
    }

    public String contentType() {
        return this.contentType;
    }

    public String rolesParameter() {
        return this.rolesParameter;
    }

    public String alfioGroupsParameter() {
        return this.alfioGroupsParameter;
    }

    public String logoutUrl() {
        return this.logoutUrl;
    }

    public String logoutRedirectUrl() {
        return this.logoutRedirectUrl;
    }

    public String jwksPath() {
        return this.jwksPath;
    }
}

