/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.payment;

import alfio.manager.payment.PaymentManagerUtils;
import alfio.manager.payment.PaymentSpecification;
import alfio.manager.support.PaymentResult;
import alfio.manager.system.ConfigurationManager;
import alfio.model.Event;
import alfio.model.PurchaseContext;
import alfio.model.TicketReservation;
import alfio.model.system.ConfigurationKeys;
import alfio.model.transaction.PaymentContext;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.PaymentProvider;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.Transaction;
import alfio.model.transaction.TransactionRequest;
import alfio.repository.TicketReservationRepository;
import alfio.repository.TransactionRepository;
import alfio.util.ClockProvider;
import alfio.util.WorkingDaysAdjusters;
import java.beans.ConstructorProperties;
import java.lang.constant.Constable;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class BankTransferManager
implements PaymentProvider {
    private static final Logger log = LoggerFactory.getLogger(BankTransferManager.class);
    private static final EnumSet<ConfigurationKeys> OPTIONS_TO_LOAD = EnumSet.of(ConfigurationKeys.BANK_TRANSFER_ENABLED, new ConfigurationKeys[]{ConfigurationKeys.DEFERRED_BANK_TRANSFER_ENABLED, ConfigurationKeys.OFFLINE_PAYMENT_DAYS, ConfigurationKeys.REVOLUT_ENABLED, ConfigurationKeys.REVOLUT_API_KEY, ConfigurationKeys.REVOLUT_LIVE_MODE, ConfigurationKeys.REVOLUT_MANUAL_REVIEW});
    private final ConfigurationManager configurationManager;
    private final TicketReservationRepository ticketReservationRepository;
    private final TransactionRepository transactionRepository;
    private final ClockProvider clockProvider;

    public Set<PaymentMethod> getSupportedPaymentMethods(PaymentContext paymentContext, TransactionRequest transactionRequest) {
        return EnumSet.of(PaymentMethod.BANK_TRANSFER);
    }

    public PaymentProxy getPaymentProxy() {
        return PaymentProxy.OFFLINE;
    }

    public boolean accept(PaymentMethod paymentMethod, PaymentContext paymentContext, TransactionRequest transactionRequest) {
        Map options = this.options(paymentContext);
        return this.bankTransferEnabledForMethod(paymentMethod, paymentContext, options) && !((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.REVOLUT_ENABLED)).getValueAsBooleanOrDefault();
    }

    boolean bankTransferEnabledForMethod(PaymentMethod paymentMethod, PaymentContext paymentContext, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> options) {
        if (paymentMethod != PaymentMethod.BANK_TRANSFER) {
            return false;
        }
        return this.bankTransferActive(paymentContext, options);
    }

    boolean bankTransferActive(PaymentContext paymentContext, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> options) {
        return options.get(ConfigurationKeys.BANK_TRANSFER_ENABLED).getValueAsBooleanOrDefault() && (paymentContext.getPurchaseContext() == null || BankTransferManager.getOfflinePaymentWaitingPeriod((PurchaseContext)paymentContext.getPurchaseContext(), (int)options.get(ConfigurationKeys.OFFLINE_PAYMENT_DAYS).getValueAsIntOrDefault(5)).orElse(0) > 0);
    }

    Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> options(PaymentContext paymentContext) {
        return this.configurationManager.getFor((Collection)OPTIONS_TO_LOAD, paymentContext.getConfigurationLevel());
    }

    boolean isPaymentDeferredEnabled(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> options) {
        return options.get(ConfigurationKeys.DEFERRED_BANK_TRANSFER_ENABLED).getValueAsBooleanOrDefault();
    }

    public PaymentResult doPayment(PaymentSpecification spec) {
        this.transitionToOfflinePayment(spec);
        this.overrideExistingTransactions(spec);
        return PaymentResult.successful((String)"not-paid");
    }

    void overrideExistingTransactions(PaymentSpecification spec) {
        PaymentManagerUtils.invalidateExistingTransactions((String)spec.getReservationId(), (TransactionRepository)this.transactionRepository);
        this.transactionRepository.insert(UUID.randomUUID().toString(), null, spec.getReservationId(), ZonedDateTime.now(this.clockProvider.getClock()), spec.getPriceWithVAT(), spec.getCurrencyCode(), "", PaymentProxy.OFFLINE.name(), 0L, 0L, Transaction.Status.PENDING, Map.of());
    }

    public Map<String, ?> getModelOptions(PaymentContext context) {
        OptionalInt delay = BankTransferManager.getOfflinePaymentWaitingPeriod((PaymentContext)context, (ConfigurationManager)this.configurationManager);
        PurchaseContext purchaseContext = context.getPurchaseContext();
        if (delay.isEmpty()) {
            log.error("Already started event {} has been found with OFFLINE payment enabled", (Object)purchaseContext.getDisplayName());
        }
        HashMap<String, Constable> model = new HashMap<String, Constable>();
        model.put("delayForOfflinePayment", Integer.valueOf(Math.max(1, delay.orElse(0))));
        boolean recaptchaEnabled = this.configurationManager.isRecaptchaForOfflinePaymentAndFreeEnabled(purchaseContext.getConfigurationLevel());
        model.put("captchaRequestedForOffline", Boolean.valueOf(recaptchaEnabled));
        if (recaptchaEnabled) {
            model.put("recaptchaApiKey", this.configurationManager.getForSystem(ConfigurationKeys.RECAPTCHA_API_KEY).getValue().orElse(null));
        }
        return model;
    }

    private void transitionToOfflinePayment(PaymentSpecification spec) {
        ZonedDateTime deadline = BankTransferManager.getOfflinePaymentDeadline((PaymentContext)spec.getPaymentContext(), (ConfigurationManager)this.configurationManager);
        this.postponePayment(spec, TicketReservation.TicketReservationStatus.OFFLINE_PAYMENT, deadline);
    }

    void postponePayment(PaymentSpecification spec, TicketReservation.TicketReservationStatus status, ZonedDateTime deadline) {
        int updatedReservation = this.ticketReservationRepository.postponePayment(spec.getReservationId(), status, Date.from(deadline.toInstant()), spec.getEmail(), spec.getCustomerName().getFullName(), spec.getCustomerName().getFirstName(), spec.getCustomerName().getLastName(), spec.getBillingAddress(), spec.getCustomerReference());
        Validate.isTrue((updatedReservation == 1 ? 1 : 0) != 0, (String)("expected exactly one updated reservation, got " + updatedReservation), (Object[])new Object[0]);
    }

    public static ZonedDateTime getOfflinePaymentDeadline(PaymentContext context, ConfigurationManager configurationManager) {
        PurchaseContext purchaseContext = context.getPurchaseContext();
        ZonedDateTime now = purchaseContext.now(ClockProvider.clock());
        int waitingPeriod = BankTransferManager.getOfflinePaymentWaitingPeriod((PaymentContext)context, (ConfigurationManager)configurationManager).orElse(0);
        if (waitingPeriod == 0) {
            log.warn("accepting offline payments the same day is a very bad practice and should be avoided. Please set cash payment as payment method next time");
            return now.plusHours(2L);
        }
        return ZonedDateTime.from(WorkingDaysAdjusters.addDays((Temporal)now.truncatedTo(ChronoUnit.HALF_DAYS), (int)waitingPeriod));
    }

    public static OptionalInt getOfflinePaymentWaitingPeriod(PaymentContext paymentContext, ConfigurationManager configurationManager) {
        PurchaseContext purchaseContext = paymentContext.getPurchaseContext();
        return BankTransferManager.getOfflinePaymentWaitingPeriod((PurchaseContext)purchaseContext, (int)configurationManager.getFor(ConfigurationKeys.OFFLINE_PAYMENT_DAYS, purchaseContext.getConfigurationLevel()).getValueAsIntOrDefault(5));
    }

    private static OptionalInt getOfflinePaymentWaitingPeriod(PurchaseContext purchaseContext, int configuredValue) {
        ZonedDateTime now = purchaseContext.now(ClockProvider.clock());
        ZonedDateTime maxDate = purchaseContext.event().map(BankTransferManager::getMaxPaymentDate).orElse(purchaseContext.getBegin());
        int daysToBegin = (int)ChronoUnit.DAYS.between(now.toLocalDate(), maxDate.toLocalDate());
        if (daysToBegin < 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(Math.min(daysToBegin, configuredValue));
    }

    private static ZonedDateTime getMaxPaymentDate(Event event) {
        if (event.getSameDay()) {
            return event.getBegin();
        }
        return event.getEnd();
    }

    public boolean accept(Transaction transaction) {
        return PaymentProxy.OFFLINE == transaction.getPaymentProxy();
    }

    public PaymentMethod getPaymentMethodForTransaction(Transaction transaction) {
        return PaymentMethod.BANK_TRANSFER;
    }

    public boolean isActive(PaymentContext paymentContext) {
        return this.bankTransferActive(paymentContext, this.options(paymentContext));
    }

    @ConstructorProperties(value={"configurationManager", "ticketReservationRepository", "transactionRepository", "clockProvider"})
    @Generated
    public BankTransferManager(ConfigurationManager configurationManager, TicketReservationRepository ticketReservationRepository, TransactionRepository transactionRepository, ClockProvider clockProvider) {
        this.configurationManager = configurationManager;
        this.ticketReservationRepository = ticketReservationRepository;
        this.transactionRepository = transactionRepository;
        this.clockProvider = clockProvider;
    }
}

