/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.payment;

import alfio.manager.payment.BaseStripeManager;
import alfio.manager.payment.MetadataBuilder;
import alfio.manager.payment.PaymentSpecification;
import alfio.manager.support.FeeCalculator;
import alfio.manager.support.PaymentResult;
import alfio.manager.system.ConfigurationManager;
import alfio.model.Configurable;
import alfio.model.PaymentInformation;
import alfio.model.PurchaseContext;
import alfio.model.system.ConfigurationKeys;
import alfio.model.system.ConfigurationPathLevel;
import alfio.model.transaction.PaymentContext;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.Transaction;
import alfio.repository.TicketRepository;
import alfio.repository.system.ConfigurationRepository;
import alfio.util.MonetaryUtil;
import com.stripe.Stripe;
import com.stripe.exception.ApiConnectionException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.Charge;
import com.stripe.model.Event;
import com.stripe.model.Refund;
import com.stripe.net.RequestOptions;
import com.stripe.net.Webhook;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;

/*
 * Exception performing whole class analysis ignored.
 */
class BaseStripeManager {
    static final String STRIPE_MANAGER_TYPE_KEY = "stripeManagerType";
    static final String SUCCEEDED = "succeeded";
    static final String PENDING = "pending";
    private static final Logger log = LoggerFactory.getLogger(BaseStripeManager.class);
    private final ConfigurationManager configurationManager;
    private final ConfigurationRepository configurationRepository;
    private final TicketRepository ticketRepository;
    private final Environment environment;
    private final Map<Class<? extends StripeException>, StripeExceptionHandler> handlers = Map.of(CardException.class, arg_0 -> this.handleCardException(arg_0), InvalidRequestException.class, arg_0 -> this.handleInvalidRequestException(arg_0), AuthenticationException.class, arg_0 -> this.handleAuthenticationException(arg_0), ApiConnectionException.class, arg_0 -> this.handleApiConnectionException(arg_0), StripeException.class, arg_0 -> this.handleGenericException(arg_0));

    String getSecretKey(Configurable configurable) {
        return this.configurationManager.getFor(ConfigurationKeys.STRIPE_SECRET_KEY, configurable.getConfigurationLevel()).getRequiredValue();
    }

    String getWebhookSignatureKey() {
        return this.configurationManager.getForSystem(ConfigurationKeys.STRIPE_WEBHOOK_KEY).getRequiredValue();
    }

    String getPublicKey(PaymentContext context) {
        if (this.isConnectEnabled(context)) {
            return this.configurationManager.getForSystem(ConfigurationKeys.STRIPE_PUBLIC_KEY).getRequiredValue();
        }
        return this.configurationManager.getFor(ConfigurationKeys.STRIPE_PUBLIC_KEY, context.getConfigurationLevel()).getRequiredValue();
    }

    Map<String, ?> getModelOptions(PaymentContext context) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("enableSCA", this.configurationManager.getFor(ConfigurationKeys.STRIPE_ENABLE_SCA, context.getConfigurationLevel()).getValueAsBooleanOrDefault());
        options.put("stripe_p_key", this.getPublicKey(context));
        return options;
    }

    private boolean isConnectEnabled(PaymentContext context) {
        return this.configurationManager.getFor(ConfigurationKeys.PLATFORM_MODE_ENABLED, context.getConfigurationLevel()).getValueAsBooleanOrDefault();
    }

    String getSystemSecretKey() {
        return this.configurationManager.getForSystem(ConfigurationKeys.STRIPE_SECRET_KEY).getRequiredValue();
    }

    Optional<Boolean> processWebhookEvent(String body, String signature) {
        try {
            Event event = Webhook.constructEvent((String)body, (String)signature, (String)this.getWebhookSignatureKey());
            if ("account.application.deauthorized".equals(event.getType()) && Boolean.TRUE.equals(event.getLivemode()) == this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"dev", "test", "demo"}))) {
                return Optional.of(this.revokeToken(event.getAccount()));
            }
            return Optional.of(true);
        }
        catch (Exception e) {
            log.error("got exception while handling stripe webhook", (Throwable)e);
            return Optional.empty();
        }
    }

    private boolean revokeToken(String accountId) {
        String key = ConfigurationKeys.STRIPE_CONNECTED_ID.getValue();
        Optional optional = this.configurationRepository.findOrganizationIdByKeyAndValue(key, accountId);
        if (optional.isPresent()) {
            Integer organizationId = (Integer)optional.get();
            log.warn("revoking access token {} for organization {}", (Object)accountId, (Object)organizationId);
            this.configurationManager.deleteOrganizationLevelByKey(key, organizationId.intValue(), "admin");
            return true;
        }
        return false;
    }

    Optional<Charge> chargeCreditCard(PaymentSpecification spec) throws StripeException {
        Map chargeParams = this.createParams(spec, Map.of());
        chargeParams.put("card", spec.getGatewayToken().getToken());
        return this.charge(spec, chargeParams);
    }

    protected Map<String, Object> createParams(PaymentSpecification spec, Map<String, String> baseMetadata) {
        int items = spec.getPurchaseContext().getType() == PurchaseContext.PurchaseContextType.event ? this.ticketRepository.countTicketsInReservation(spec.getReservationId()) : 1;
        HashMap<String, Object> chargeParams = new HashMap<String, Object>();
        chargeParams.put("amount", spec.getPriceWithVAT());
        PurchaseContext purchaseContext = spec.getPurchaseContext();
        ((Optional)FeeCalculator.getCalculator((Configurable)purchaseContext, (ConfigurationManager)this.configurationManager, (String)spec.getCurrencyCode()).apply(items, Long.valueOf(spec.getPriceWithVAT()))).filter(l -> l > 0L).ifPresent(fee -> chargeParams.put("application_fee_amount", fee));
        chargeParams.put("currency", purchaseContext.getCurrency());
        String description = purchaseContext.ofType(PurchaseContext.PurchaseContextType.event) ? "ticket(s) for event" : "x subscription";
        chargeParams.put("description", String.format("%d %s %s", items, description, purchaseContext.getDisplayName()));
        chargeParams.put("metadata", MetadataBuilder.buildMetadata((PaymentSpecification)spec, baseMetadata));
        return chargeParams;
    }

    protected Optional<Charge> charge(PaymentSpecification spec, Map<String, Object> chargeParams) throws StripeException {
        Optional opt = this.options(spec.getPurchaseContext(), builder -> builder.setIdempotencyKey(spec.getReservationId()));
        if (opt.isEmpty()) {
            return Optional.empty();
        }
        RequestOptions options = (RequestOptions)opt.get();
        Charge charge = Charge.create(chargeParams, (RequestOptions)options);
        if (charge.getBalanceTransactionObject() == null) {
            try {
                charge.setBalanceTransactionObject(this.retrieveBalanceTransaction(charge.getBalanceTransaction(), options));
            }
            catch (Exception e) {
                log.warn("can't retrieve balance transaction", (Throwable)e);
            }
        }
        return Optional.of(charge);
    }

    PaymentResult getToken(PaymentSpecification spec) {
        if (spec.getGatewayToken() != null && spec.getGatewayToken().getPaymentProvider() == PaymentProxy.STRIPE) {
            return PaymentResult.initialized((String)spec.getGatewayToken().getToken());
        }
        return PaymentResult.failed((String)"error.STEP_2_MISSING_STRIPE_TOKEN");
    }

    BalanceTransaction retrieveBalanceTransaction(String balanceTransaction, RequestOptions options) throws StripeException {
        return BalanceTransaction.retrieve((String)balanceTransaction, (RequestOptions)options);
    }

    Charge retrieveCharge(String chargeId, RequestOptions requestOptions) throws StripeException {
        return Charge.retrieve((String)chargeId, (RequestOptions)requestOptions);
    }

    Optional<RequestOptions> options(PurchaseContext purchaseContext) {
        return this.options(purchaseContext, UnaryOperator.identity());
    }

    Optional<RequestOptions> options(PurchaseContext purchaseContext, UnaryOperator<RequestOptions.RequestOptionsBuilder> optionsBuilderConfigurer) {
        RequestOptions.RequestOptionsBuilder builder = (RequestOptions.RequestOptionsBuilder)optionsBuilderConfigurer.apply(RequestOptions.builder());
        if (this.isConnectEnabled(new PaymentContext(purchaseContext))) {
            return this.configurationManager.getFor(ConfigurationKeys.STRIPE_CONNECTED_ID, purchaseContext.getConfigurationLevel()).getValue().map(connectedId -> {
                builder.setStripeAccount(connectedId);
                return builder.setApiKey(this.getSystemSecretKey()).build();
            });
        }
        return Optional.of(builder.setApiKey(this.getSecretKey((Configurable)purchaseContext)).build());
    }

    Optional<String> getConnectedAccount(PaymentContext paymentContext) {
        if (this.isConnectEnabled(paymentContext)) {
            return this.configurationManager.getFor(ConfigurationKeys.STRIPE_CONNECTED_ID, paymentContext.getConfigurationLevel()).getValue();
        }
        return Optional.empty();
    }

    Optional<PaymentInformation> getInfo(Transaction transaction, PurchaseContext purchaseContext) {
        try {
            Optional requestOptionsOptional = this.options(purchaseContext);
            if (requestOptionsOptional.isPresent()) {
                RequestOptions options = (RequestOptions)requestOptionsOptional.get();
                Charge charge = this.retrieveCharge(transaction.getTransactionId(), options);
                String paidAmount = MonetaryUtil.formatCents((long)charge.getAmount(), (String)charge.getCurrency());
                String refundedAmount = MonetaryUtil.formatCents((long)charge.getAmountRefunded(), (String)charge.getCurrency());
                List fees = this.retrieveBalanceTransaction(charge.getBalanceTransaction(), options).getFeeDetails();
                return Optional.of(new PaymentInformation(paidAmount, refundedAmount, BaseStripeManager.getFeeAmount((List)fees, (String)"stripe_fee"), BaseStripeManager.getFeeAmount((List)fees, (String)"application_fee")));
            }
            return Optional.empty();
        }
        catch (StripeException e) {
            return Optional.empty();
        }
    }

    static String getFeeAmount(List<BalanceTransaction.FeeDetail> fees, String feeType) {
        return fees.stream().filter(f -> f.getType().equals(feeType)).findFirst().map(BalanceTransaction.FeeDetail::getAmount).map(String::valueOf).orElse(null);
    }

    boolean refund(Transaction transaction, PurchaseContext purchaseContext, Integer amountToRefund) {
        Optional<Integer> amount = Optional.ofNullable(amountToRefund);
        String chargeId = transaction.getTransactionId();
        try {
            Optional requestOptionsOptional;
            String amountOrFull = amount.map(p -> MonetaryUtil.formatCents((int)p, (String)transaction.getCurrency())).orElse("full");
            log.info("Stripe: trying to do a refund for payment {} with amount: {}", (Object)chargeId, (Object)amountOrFull);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("charge", chargeId);
            amount.ifPresent(a -> params.put("amount", a));
            if (transaction.getPlatformFee() > 0L && this.isConnectEnabled(new PaymentContext(purchaseContext))) {
                params.put("refund_application_fee", true);
            }
            if ((requestOptionsOptional = this.options(purchaseContext)).isPresent()) {
                RequestOptions options = (RequestOptions)requestOptionsOptional.get();
                Refund r = Refund.create(params, (RequestOptions)options);
                boolean pending = "pending".equals(r.getStatus());
                if ("succeeded".equals(r.getStatus()) || pending) {
                    log.info("Stripe: refund for payment {} {} for amount: {}", new Object[]{chargeId, pending ? "registered" : "executed with success", amountOrFull});
                    return true;
                }
                log.warn("Stripe: was not able to refund payment with id {}, returned status is not 'succeded' but {}", (Object)chargeId, (Object)r.getStatus());
                return false;
            }
            return false;
        }
        catch (StripeException e) {
            log.warn("Stripe: was not able to refund payment with id " + chargeId, (Throwable)e);
            return false;
        }
    }

    boolean accept(PaymentMethod paymentMethod, PaymentContext context, EnumSet<ConfigurationKeys> additionalKeys, Predicate<Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration>> subValidator) {
        return paymentMethod == PaymentMethod.CREDIT_CARD && this.isActive(context, additionalKeys, subValidator);
    }

    boolean isActive(PaymentContext context, EnumSet<ConfigurationKeys> additionalKeys, Predicate<Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration>> subValidator) {
        EnumSet<ConfigurationKeys> optionsToLoad = EnumSet.copyOf(additionalKeys);
        optionsToLoad.addAll(EnumSet.of(ConfigurationKeys.STRIPE_CC_ENABLED, ConfigurationKeys.PLATFORM_MODE_ENABLED, ConfigurationKeys.STRIPE_CONNECTED_ID));
        Map configuration = this.configurationManager.getFor(optionsToLoad, context.getConfigurationLevel());
        return ((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.STRIPE_CC_ENABLED)).getValueAsBooleanOrDefault() && (!((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.PLATFORM_MODE_ENABLED)).getValueAsBooleanOrDefault() || context.getConfigurationLevel().getPathLevel() == ConfigurationPathLevel.SYSTEM || ((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.STRIPE_CONNECTED_ID)).isPresent()) && subValidator.test(configuration);
    }

    String handleException(StripeException exc) {
        return this.findExceptionHandler(exc).handle(exc);
    }

    private StripeExceptionHandler findExceptionHandler(StripeException exc) {
        Optional<StripeExceptionHandler> eh = Optional.ofNullable((StripeExceptionHandler)this.handlers.get(((Object)((Object)exc)).getClass()));
        if (eh.isEmpty()) {
            log.warn("cannot find an ExceptionHandler for {}. Falling back to the default one.", ((Object)((Object)exc)).getClass());
        }
        return eh.orElseGet(() -> (StripeExceptionHandler)this.handlers.get(StripeException.class));
    }

    private String handleCardException(StripeException e) {
        CardException ce = (CardException)e;
        return "error.STEP2_STRIPE_" + ce.getCode();
    }

    private String handleInvalidRequestException(StripeException e) {
        InvalidRequestException ire = (InvalidRequestException)e;
        return "error.STEP2_STRIPE_invalid_" + ire.getParam();
    }

    private String handleAuthenticationException(StripeException e) {
        log.error("an AuthenticationException has occurred. Please fix configuration!!", (Throwable)e);
        return "error.STEP2_STRIPE_abort";
    }

    private String handleApiConnectionException(StripeException e) {
        log.error("unable to connect to the Stripe API", (Throwable)e);
        return "error.STEP2_STRIPE_abort";
    }

    private String handleGenericException(StripeException e) {
        log.error("unexpected error during transaction", (Throwable)e);
        return "error.STEP2_STRIPE_unexpected";
    }

    @ConstructorProperties(value={"configurationManager", "configurationRepository", "ticketRepository", "environment"})
    @Generated
    public BaseStripeManager(ConfigurationManager configurationManager, ConfigurationRepository configurationRepository, TicketRepository ticketRepository, Environment environment) {
        this.configurationManager = configurationManager;
        this.configurationRepository = configurationRepository;
        this.ticketRepository = ticketRepository;
        this.environment = environment;
    }

    static {
        Stripe.setAppInfo((String)"Alf.io", (String)"2.x", (String)"https://alf.io");
    }
}

