/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.payment;

import alfio.manager.payment.BankTransferManager;
import alfio.manager.payment.PaymentSpecification;
import alfio.manager.support.PaymentResult;
import alfio.model.TicketReservation;
import alfio.model.transaction.PaymentContext;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.PaymentProvider;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.Transaction;
import alfio.model.transaction.TransactionRequest;
import alfio.repository.TicketReservationRepository;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0)
public class DeferredBankTransferManager
implements PaymentProvider {
    private final TicketReservationRepository ticketReservationRepository;
    private final BankTransferManager bankTransferManager;

    public DeferredBankTransferManager(TicketReservationRepository ticketReservationRepository, BankTransferManager bankTransferManager) {
        this.ticketReservationRepository = ticketReservationRepository;
        this.bankTransferManager = bankTransferManager;
    }

    public Set<PaymentMethod> getSupportedPaymentMethods(PaymentContext paymentContext, TransactionRequest transactionRequest) {
        return this.bankTransferManager.getSupportedPaymentMethods(paymentContext, transactionRequest);
    }

    public PaymentProxy getPaymentProxy() {
        return this.bankTransferManager.getPaymentProxy();
    }

    public boolean accept(PaymentMethod paymentMethod, PaymentContext paymentContext, TransactionRequest transactionRequest) {
        Map options = this.bankTransferManager.options(paymentContext);
        return paymentContext.getPurchaseContext() != null && this.bankTransferManager.bankTransferEnabledForMethod(paymentMethod, paymentContext, options) && this.bankTransferManager.isPaymentDeferredEnabled(options);
    }

    public PaymentResult doPayment(PaymentSpecification spec) {
        this.bankTransferManager.postponePayment(spec, TicketReservation.TicketReservationStatus.DEFERRED_OFFLINE_PAYMENT, Objects.requireNonNull(spec.getPurchaseContext()).getBegin());
        this.bankTransferManager.overrideExistingTransactions(spec);
        return PaymentResult.successful((String)"not-paid");
    }

    public Map<String, ?> getModelOptions(PaymentContext context) {
        return Map.of("deferred", true);
    }

    public boolean accept(Transaction transaction) {
        return PaymentProxy.OFFLINE == transaction.getPaymentProxy() && this.isReservationStatusCompatible(transaction) != false;
    }

    public PaymentMethod getPaymentMethodForTransaction(Transaction transaction) {
        return this.bankTransferManager.getPaymentMethodForTransaction(transaction);
    }

    public boolean isActive(PaymentContext paymentContext) {
        Map options = this.bankTransferManager.options(paymentContext);
        return this.bankTransferManager.bankTransferActive(paymentContext, options) && this.bankTransferManager.isPaymentDeferredEnabled(options);
    }

    private Boolean isReservationStatusCompatible(Transaction transaction) {
        return this.ticketReservationRepository.findOptionalStatusAndValidationById(transaction.getReservationId()).map(sv -> sv.getStatus() == TicketReservation.TicketReservationStatus.DEFERRED_OFFLINE_PAYMENT).orElse(false);
    }
}

