/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.payment;

import alfio.manager.payment.PaymentSpecification;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

class MetadataBuilder {
    static final String RESERVATION_ID = "reservationId";

    private MetadataBuilder() {
    }

    static Map<String, String> buildMetadata(PaymentSpecification spec, Map<String, String> base) {
        HashMap<String, String> initialMetadata = new HashMap<String, String>(base);
        initialMetadata.put(RESERVATION_ID, spec.getReservationId());
        initialMetadata.put("email", spec.getEmail());
        initialMetadata.put("fullName", spec.getCustomerName().getFullName());
        if (StringUtils.isNotBlank((CharSequence)spec.getBillingAddress())) {
            initialMetadata.put("billingAddress", spec.getBillingAddress().lines().collect(Collectors.joining(",")));
        }
        return initialMetadata;
    }
}

