/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.payment;

import alfio.manager.ExtensionManager;
import alfio.manager.payment.MollieConnectManager;
import alfio.manager.payment.OAuthPaymentProviderConnector;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.model.system.Configuration;
import alfio.model.system.ConfigurationKeys;
import alfio.util.oauth2.AccessTokenResponseDetails;
import alfio.util.oauth2.AuthorizationRequestDetails;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.beans.ConstructorProperties;
import java.net.http.HttpClient;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MollieConnectManager
implements OAuthPaymentProviderConnector {
    public static final String MOLLIE_CONNECT_REDIRECT_PATH = "/admin/configuration/payment/mollie/authorize";
    private static final Logger log = LoggerFactory.getLogger(MollieConnectManager.class);
    private static final String SCOPES = "payments.read payments.write refunds.read refunds.write";
    private final ExtensionManager extensionManager;
    private final ConfigurationManager configurationManager;
    private final HttpClient httpClient;

    public AuthorizationRequestDetails getConnectURL(int organizationId) {
        Map options = this.configurationManager.getFor(Set.of(ConfigurationKeys.MOLLIE_API_KEY, ConfigurationKeys.MOLLIE_CONNECT_CLIENT_ID, ConfigurationKeys.MOLLIE_CONNECT_CALLBACK, ConfigurationKeys.BASE_URL), ConfigurationLevel.organization((int)organizationId));
        String callbackURL = ((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.MOLLIE_CONNECT_CALLBACK)).getValueOrDefault(((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.BASE_URL)).getRequiredValue() + MOLLIE_CONNECT_REDIRECT_PATH);
        String state = this.extensionManager.generateOAuth2StateParam(organizationId).orElse(UUID.randomUUID().toString());
        return new AuthorizationRequestDetails(new MollieConnectApi().getAuthorizationUrl("code", ((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.MOLLIE_CONNECT_CLIENT_ID)).getRequiredValue(), callbackURL, SCOPES, state, Collections.emptyMap()), state);
    }

    public AccessTokenResponseDetails storeConnectedAccountId(String code, int organizationId) {
        try {
            ConfigurationLevel configurationLevel = ConfigurationLevel.organization((int)organizationId);
            Map options = this.configurationManager.getFor(Set.of(ConfigurationKeys.MOLLIE_API_KEY, ConfigurationKeys.MOLLIE_CONNECT_CLIENT_ID, ConfigurationKeys.MOLLIE_CONNECT_CLIENT_SECRET, ConfigurationKeys.MOLLIE_CONNECT_CALLBACK, ConfigurationKeys.BASE_URL), configurationLevel);
            OAuth20Service service = new ServiceBuilder(((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.MOLLIE_CONNECT_CLIENT_ID)).getRequiredValue()).apiSecret(((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.MOLLIE_CONNECT_CLIENT_SECRET)).getRequiredValue()).callback(((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.MOLLIE_CONNECT_CALLBACK)).getRequiredValue()).build((DefaultApi20)new MollieConnectApi());
            OAuth2AccessToken accessTokenResponse = service.getAccessToken(code);
            String refreshToken = accessTokenResponse.getRefreshToken();
            if (refreshToken != null) {
                this.configurationManager.saveConfig(Configuration.from((int)organizationId, (ConfigurationKeys)ConfigurationKeys.MOLLIE_CONNECT_REFRESH_TOKEN), refreshToken);
            }
            return new AccessTokenResponseDetails(accessTokenResponse.getAccessToken(), refreshToken, null, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Request interrupted while retrieving access token", (Throwable)e);
            return new AccessTokenResponseDetails(null, null, e.getMessage(), false);
        }
        catch (Exception e) {
            log.warn("Got exception while retrieving access token", (Throwable)e);
            return new AccessTokenResponseDetails(null, null, e.getMessage(), false);
        }
    }

    public AccessTokenResponseDetails refreshAccessToken(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> options) {
        try {
            OAuth20Service service = new ServiceBuilder(options.get(ConfigurationKeys.MOLLIE_CONNECT_CLIENT_ID).getRequiredValue()).apiSecret(options.get(ConfigurationKeys.MOLLIE_CONNECT_CLIENT_SECRET).getRequiredValue()).callback(options.get(ConfigurationKeys.MOLLIE_CONNECT_CALLBACK).getRequiredValue()).build((DefaultApi20)new MollieConnectApi());
            String refreshToken = options.get(ConfigurationKeys.MOLLIE_CONNECT_REFRESH_TOKEN).getRequiredValue();
            OAuth2AccessToken accessTokenResponse = service.refreshAccessToken(refreshToken);
            return new AccessTokenResponseDetails(accessTokenResponse.getAccessToken(), refreshToken, null, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Request interrupted while retrieving access token", (Throwable)e);
            return new AccessTokenResponseDetails(null, null, e.getMessage(), false);
        }
        catch (Exception e) {
            log.warn("Got exception while retrieving access token", (Throwable)e);
            return new AccessTokenResponseDetails(null, null, e.getMessage(), false);
        }
    }

    @ConstructorProperties(value={"extensionManager", "configurationManager", "httpClient"})
    @Generated
    public MollieConnectManager(ExtensionManager extensionManager, ConfigurationManager configurationManager, HttpClient httpClient) {
        this.extensionManager = extensionManager;
        this.configurationManager = configurationManager;
        this.httpClient = httpClient;
    }
}

