/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.payment;

import alfio.manager.PurchaseContextManager;
import alfio.manager.payment.MetadataBuilder;
import alfio.manager.payment.MollieConnectManager;
import alfio.manager.payment.MollieWebhookPaymentManager;
import alfio.manager.payment.PaymentManagerUtils;
import alfio.manager.payment.PaymentSpecification;
import alfio.manager.support.FeeCalculator;
import alfio.manager.support.PaymentResult;
import alfio.manager.support.PaymentWebhookResult;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.model.Configurable;
import alfio.model.PaymentInformation;
import alfio.model.PurchaseContext;
import alfio.model.TicketReservation;
import alfio.model.TicketReservationStatusAndValidation;
import alfio.model.system.ConfigurationKeys;
import alfio.model.transaction.PaymentContext;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.PaymentProvider;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.PaymentToken;
import alfio.model.transaction.Transaction;
import alfio.model.transaction.TransactionRequest;
import alfio.model.transaction.TransactionWebhookPayload;
import alfio.model.transaction.capabilities.PaymentInfo;
import alfio.model.transaction.capabilities.RefundRequest;
import alfio.model.transaction.capabilities.WebhookHandler;
import alfio.model.transaction.token.MollieToken;
import alfio.model.transaction.webhook.MollieWebhookPayload;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import alfio.repository.TransactionRepository;
import alfio.util.ClockProvider;
import alfio.util.HttpUtils;
import alfio.util.Json;
import alfio.util.MonetaryUtil;
import alfio.util.oauth2.AccessTokenResponseDetails;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class MollieWebhookPaymentManager
implements PaymentProvider,
WebhookHandler,
RefundRequest,
PaymentInfo {
    private static final Logger log = LoggerFactory.getLogger(MollieWebhookPaymentManager.class);
    public static final String WEBHOOK_URL_TEMPLATE = "/api/payment/webhook/mollie/reservation/{reservationId}";
    private static final Set<PaymentMethod> EMPTY_METHODS = Collections.unmodifiableSet(EnumSet.noneOf(PaymentMethod.class));
    static final Map<String, PaymentMethod> SUPPORTED_METHODS = Map.of("ideal", PaymentMethod.IDEAL, "creditcard", PaymentMethod.CREDIT_CARD, "applepay", PaymentMethod.APPLE_PAY, "bancontact", PaymentMethod.BANCONTACT, "inghomepay", PaymentMethod.ING_HOME_PAY, "belfius", PaymentMethod.BELFIUS, "przelewy24", PaymentMethod.PRZELEWY_24, "kbc", PaymentMethod.KBC);
    protected static final Set<ConfigurationKeys> ALL_OPTIONS = EnumSet.of(ConfigurationKeys.MOLLIE_CC_ENABLED, new ConfigurationKeys[]{ConfigurationKeys.PLATFORM_MODE_ENABLED, ConfigurationKeys.BASE_URL, ConfigurationKeys.MOLLIE_CONNECT_PROFILE_ID, ConfigurationKeys.MOLLIE_API_KEY, ConfigurationKeys.MOLLIE_CONNECT_LIVE_MODE, ConfigurationKeys.MOLLIE_CONNECT_CLIENT_ID, ConfigurationKeys.MOLLIE_CONNECT_CLIENT_SECRET, ConfigurationKeys.MOLLIE_CONNECT_REFRESH_TOKEN, ConfigurationKeys.MOLLIE_CONNECT_CALLBACK});
    private static final String MOLLIE_ENDPOINT = "https://api.mollie.com/v2/";
    private static final String PAYMENTS_ENDPOINT = "https://api.mollie.com/v2/payments";
    private static final String METHODS_ENDPOINT = "https://api.mollie.com/v2/methods";
    private static final String AMOUNT = "amount";
    private static final String VALUE = "value";
    private static final String CURRENCY = "currency";
    private static final String STATUS_FAILED = "failed";
    private final Cache<MethodCacheKey, Set<PaymentMethod>> methodsCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(5L)).build();
    private final Cache<Integer, String> accessTokenCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(45L)).build();
    private final HttpClient client;
    private final ConfigurationManager configurationManager;
    private final TicketReservationRepository ticketReservationRepository;
    private final TicketRepository ticketRepository;
    private final TransactionRepository transactionRepository;
    private final MollieConnectManager mollieConnectManager;
    private final ClockProvider clockProvider;
    private final PurchaseContextManager purchaseContextManager;
    public static final String ADDITIONAL_INFO_PURCHASE_CONTEXT_TYPE = "purchaseContextType";
    public static final String ADDITIONAL_INFO_PURCHASE_IDENTIFIER = "purchaseContextPublicIdentifier";
    public static final String ADDITIONAL_INFO_RESERVATION_ID = "reservationId";

    private HttpRequest.Builder requestFor(String url, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration, ConfigurationLevel configurationLevel) {
        boolean platformMode = configurationLevel.getOrganizationId().isPresent() && configuration.get(ConfigurationKeys.PLATFORM_MODE_ENABLED).getValueAsBooleanOrDefault();
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(url));
        if (platformMode) {
            return requestBuilder.header("Authorization", "Bearer " + (String)this.accessTokenCache.get((Object)configurationLevel.getOrganizationId().orElseThrow(), org -> {
                AccessTokenResponseDetails accessTokenResponseDetails = this.mollieConnectManager.refreshAccessToken(configuration);
                if (accessTokenResponseDetails.isSuccess()) {
                    return accessTokenResponseDetails.getAccessToken();
                }
                throw new IllegalStateException("cannot refresh access token");
            }));
        }
        String mollieAPIKey = configuration.get(ConfigurationKeys.MOLLIE_API_KEY).getRequiredValue();
        return requestBuilder.header("Authorization", "Bearer " + mollieAPIKey);
    }

    public Set<PaymentMethod> getSupportedPaymentMethods(PaymentContext paymentContext, TransactionRequest transactionRequest) {
        Map configuration = this.getConfiguration(paymentContext.getConfigurationLevel());
        if (this.checkIfActive(configuration) && this.isPlatformConfigurationPresent(configuration)) {
            return this.retrieveAvailablePaymentMethods(transactionRequest, configuration, paymentContext.getConfigurationLevel());
        }
        return Set.of();
    }

    public PaymentProxy getPaymentProxy() {
        return PaymentProxy.MOLLIE;
    }

    public boolean accept(PaymentMethod paymentMethod, PaymentContext context, TransactionRequest transactionRequest) {
        if (!SUPPORTED_METHODS.containsValue(paymentMethod)) {
            return false;
        }
        Map configuration = this.getConfiguration(context.getConfigurationLevel());
        return this.checkIfActive(configuration) && this.isPlatformConfigurationPresent(configuration) && this.retrieveAvailablePaymentMethods(transactionRequest, configuration, context.getConfigurationLevel()).contains(paymentMethod);
    }

    private boolean isPlatformConfigurationPresent(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration) {
        return !configuration.get(ConfigurationKeys.PLATFORM_MODE_ENABLED).getValueAsBooleanOrDefault() || configuration.get(ConfigurationKeys.MOLLIE_CONNECT_REFRESH_TOKEN).isPresent() && configuration.get(ConfigurationKeys.MOLLIE_CONNECT_PROFILE_ID).isPresent();
    }

    private Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> getConfiguration(ConfigurationLevel configurationLevel) {
        return this.configurationManager.getFor((Collection)ALL_OPTIONS, configurationLevel);
    }

    private Set<PaymentMethod> retrieveAvailablePaymentMethods(TransactionRequest transactionRequest, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration, ConfigurationLevel configurationLevel) {
        try {
            return (Set)this.methodsCache.get((Object)MethodCacheKey.from((TransactionRequest)transactionRequest, configuration), key -> this.fetchAvailablePaymentMethods(key, configuration, configurationLevel));
        }
        catch (Exception ex) {
            log.warn("cannot fetch payment methods", (Throwable)ex);
            return EMPTY_METHODS;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<PaymentMethod> fetchAvailablePaymentMethods(MethodCacheKey key, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration, ConfigurationLevel configurationLevel) {
        ArrayList<CallSite> params = new ArrayList<CallSite>();
        if (key.amount != null) {
            params.add((CallSite)((Object)("amount[value]=" + key.amount.getValue())));
            params.add((CallSite)((Object)("amount[currency]=" + key.amount.getCurrency())));
        }
        if (key.billingCountry != null) {
            params.add((CallSite)((Object)("billingCountry=" + key.billingCountry)));
        }
        if (configuration.get(ConfigurationKeys.PLATFORM_MODE_ENABLED).getValueAsBooleanOrDefault()) {
            params.add((CallSite)((Object)("testmode=" + key.testMode)));
            params.add((CallSite)((Object)("profileId=" + configuration.get(ConfigurationKeys.MOLLIE_CONNECT_PROFILE_ID).getRequiredValue())));
        }
        HttpRequest request = this.requestFor("https://api.mollie.com/v2/methods?" + String.join((CharSequence)"&", params), configuration, configurationLevel).GET().build();
        try {
            HttpResponse<InputStream> response = this.client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (!HttpUtils.callSuccessful(response)) {
                throw new IllegalStateException("fetch was unsuccessful (HTTP " + response.statusCode() + ")");
            }
            try (InputStreamReader reader = new InputStreamReader(response.body(), StandardCharsets.UTF_8);){
                JsonObject body = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                int count = body.get("count").getAsInt();
                if (count == 0) {
                    Set set = EMPTY_METHODS;
                    return set;
                }
                JsonArray methodsObj = body.getAsJsonObject("_embedded").getAsJsonArray("methods");
                ArrayList<String> rejectedMethods = new ArrayList<String>();
                EnumSet<PaymentMethod> result = EnumSet.noneOf(PaymentMethod.class);
                for (int i = 0; i < count; ++i) {
                    String methodId = methodsObj.get(i).getAsJsonObject().get("id").getAsString();
                    PaymentMethod parsed = (PaymentMethod)SUPPORTED_METHODS.get(methodId);
                    if (parsed != null) {
                        result.add(parsed);
                        continue;
                    }
                    rejectedMethods.add(methodId);
                }
                if (rejectedMethods.isEmpty()) {
                    EnumSet<PaymentMethod> enumSet = result;
                    return enumSet;
                }
                log.warn("Unsupported payment methods found: {}. Please check configuration", rejectedMethods);
                throw new IllegalStateException("unsupported methods found");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public PaymentResult getToken(PaymentSpecification spec) {
        return this.getPaymentResult(spec);
    }

    public PaymentResult doPayment(PaymentSpecification spec) {
        throw new IllegalStateException("not supported");
    }

    private PaymentResult getPaymentResult(PaymentSpecification spec) {
        try {
            PurchaseContext purchaseContext = spec.getPurchaseContext();
            Map configuration = this.getConfiguration(purchaseContext.getConfigurationLevel());
            String reservationId = spec.getReservationId();
            TicketReservation reservation = this.ticketReservationRepository.findReservationById(reservationId);
            String baseUrl = StringUtils.removeEnd((String)((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.BASE_URL)).getRequiredValue(), (String)"/");
            Optional<Transaction> existingTransaction = this.transactionRepository.loadOptionalByReservationId(reservationId).filter(t -> t.getPaymentProxy() == PaymentProxy.MOLLIE && StringUtils.isNotEmpty((CharSequence)t.getPaymentId()));
            if (existingTransaction.isEmpty()) {
                return this.initPayment(reservation, spec, baseUrl, configuration);
            }
            return this.tryToReuseExistingTransaction(existingTransaction.get(), reservation, spec, baseUrl, configuration);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Request interrupted while trying to init payment", (Throwable)e);
            return PaymentResult.failed((String)"error.STEP_2_PAYMENT_REQUEST_CREATION");
        }
        catch (Exception e) {
            log.warn("Error while processing webhook", (Throwable)e);
            return PaymentResult.failed((String)"error.STEP_2_PAYMENT_REQUEST_CREATION");
        }
    }

    private PaymentResult tryToReuseExistingTransaction(Transaction transaction, TicketReservation reservation, PaymentSpecification spec, String baseUrl, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration) throws IOException, InterruptedException {
        HttpResponse getPaymentResponse = this.callGetPayment(transaction.getPaymentId(), configuration, spec.getPurchaseContext().getConfigurationLevel());
        if (HttpUtils.callSuccessful((HttpResponse)getPaymentResponse)) {
            try (InputStreamReader responseReader = new InputStreamReader((InputStream)getPaymentResponse.body(), StandardCharsets.UTF_8);){
                MolliePaymentDetails body = new MolliePaymentDetails(JsonParser.parseReader((Reader)responseReader).getAsJsonObject());
                String status = body.getStatus();
                if (status.equals("open")) {
                    PaymentResult paymentResult = PaymentResult.redirect((String)body.getCheckoutLink());
                    return paymentResult;
                }
                if (status.equals("pending")) {
                    PaymentResult paymentResult = PaymentResult.pending((String)transaction.getPaymentId());
                    return paymentResult;
                }
            }
        }
        return this.initPayment(reservation, spec, baseUrl, configuration);
    }

    private PaymentResult initPayment(TicketReservation reservation, PaymentSpecification spec, String baseUrl, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration) throws IOException, InterruptedException {
        HttpRequest request;
        HttpResponse<InputStream> response;
        PurchaseContext purchaseContext = spec.getPurchaseContext();
        String purchaseContextUrlComponent = purchaseContext.getType().getUrlComponent();
        String publicIdentifier = purchaseContext.getPublicIdentifier();
        String reservationId = reservation.getId();
        String bookUrl = baseUrl + "/" + purchaseContextUrlComponent + "/" + publicIdentifier + "/reservation/" + reservationId + "/book";
        int items = spec.getPurchaseContext().getType() == PurchaseContext.PurchaseContextType.event ? this.ticketRepository.countTicketsInReservation(spec.getReservationId()) : 1;
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("amount", Map.of("value", spec.getOrderSummary().getTotalPrice(), "currency", spec.getPurchaseContext().getCurrency()));
        String description = purchaseContext.ofType(PurchaseContext.PurchaseContextType.event) ? "ticket(s) for event" : "x subscription";
        payload.put("description", String.format("%s - %d %s %s", this.configurationManager.getShortReservationID((Configurable)spec.getPurchaseContext(), reservation), items, description, spec.getPurchaseContext().getDisplayName()));
        payload.put("redirectUrl", bookUrl);
        payload.put("webhookUrl", baseUrl + UriComponentsBuilder.fromPath((String)"/api/payment/webhook/mollie/reservation/{reservationId}").buildAndExpand(new Object[]{reservationId}).toUriString());
        payload.put("metadata", MetadataBuilder.buildMetadata((PaymentSpecification)spec, Map.of()));
        if (configuration.get(ConfigurationKeys.PLATFORM_MODE_ENABLED).getValueAsBooleanOrDefault()) {
            payload.put("profileId", configuration.get(ConfigurationKeys.MOLLIE_CONNECT_PROFILE_ID).getRequiredValue());
            payload.put("testmode", !configuration.get(ConfigurationKeys.MOLLIE_CONNECT_LIVE_MODE).getValueAsBooleanOrDefault());
            String currencyCode = spec.getCurrencyCode();
            ((Optional)FeeCalculator.getCalculator((Configurable)spec.getPurchaseContext(), (ConfigurationManager)this.configurationManager, (String)currencyCode).apply(items, Long.valueOf(spec.getPriceWithVAT()))).filter(fee -> fee > 1L).map(fee -> MonetaryUtil.formatCents((long)fee, (String)currencyCode)).ifPresent(fee -> payload.put("applicationFee", Map.of("amount", Map.of("currency", currencyCode, "value", fee), "description", "Reservation" + reservationId)));
        }
        if (HttpUtils.callSuccessful(response = this.client.send(request = this.requestFor("https://api.mollie.com/v2/payments", configuration, spec.getPurchaseContext().getConfigurationLevel()).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(Json.GSON.toJson(payload))).build(), HttpResponse.BodyHandlers.ofInputStream()))) {
            try (InputStreamReader responseReader = new InputStreamReader(response.body(), StandardCharsets.UTF_8);){
                MolliePaymentDetails body = new MolliePaymentDetails(JsonParser.parseReader((Reader)responseReader).getAsJsonObject());
                String paymentId = body.getPaymentId();
                String checkoutLink = body.getCheckoutLink();
                ZonedDateTime expiration = ((ZonedDateTime)body.getExpiresAt().orElseThrow()).plusMinutes(5L);
                this.ticketReservationRepository.updateReservationStatus(reservationId, TicketReservation.TicketReservationStatus.EXTERNAL_PROCESSING_PAYMENT.toString());
                this.ticketReservationRepository.updateValidity(reservationId, Date.from(expiration.toInstant()));
                PaymentManagerUtils.invalidateExistingTransactions((String)reservationId, (TransactionRepository)this.transactionRepository);
                this.transactionRepository.insert(paymentId, paymentId, reservationId, ZonedDateTime.now(this.clockProvider.withZone(spec.getPurchaseContext().getZoneId())), spec.getPriceWithVAT(), spec.getPurchaseContext().getCurrency(), "Mollie Payment", PaymentProxy.MOLLIE.name(), 0L, 0L, Transaction.Status.PENDING, Map.of());
                PaymentResult paymentResult = PaymentResult.redirect((String)checkoutLink);
                return paymentResult;
            }
        }
        log.warn("was not able to create a payment for reservation id " + reservationId);
        return PaymentResult.failed((String)"error.STEP_2_PAYMENT_REQUEST_CREATION");
    }

    public boolean accept(Transaction transaction) {
        return PaymentProxy.MOLLIE == transaction.getPaymentProxy();
    }

    public PaymentMethod getPaymentMethodForTransaction(Transaction transaction) {
        return null;
    }

    public boolean isActive(PaymentContext paymentContext) {
        return this.checkIfActive(this.getConfiguration(paymentContext.getConfigurationLevel()));
    }

    private boolean checkIfActive(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration) {
        return configuration.get(ConfigurationKeys.MOLLIE_CC_ENABLED).getValueAsBooleanOrDefault() && configuration.get(ConfigurationKeys.BASE_URL).isPresent() && configuration.get(ConfigurationKeys.MOLLIE_API_KEY).isPresent() && this.connectOptionsPresent(configuration);
    }

    private boolean connectOptionsPresent(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration) {
        if (!configuration.get(ConfigurationKeys.PLATFORM_MODE_ENABLED).getValueAsBooleanOrDefault()) {
            return true;
        }
        return configuration.get(ConfigurationKeys.MOLLIE_CONNECT_CLIENT_ID).isPresent() && configuration.get(ConfigurationKeys.MOLLIE_CONNECT_CLIENT_SECRET).isPresent();
    }

    public Optional<TransactionWebhookPayload> parseTransactionPayload(String body, String signature, Map<String, String> additionalInfo, PaymentContext paymentContext) {
        StringReader reader = new StringReader(body);
        try {
            Properties properties = new Properties();
            properties.load(reader);
            Optional<TransactionWebhookPayload> optional = Optional.ofNullable(StringUtils.trimToNull((String)properties.getProperty("id"))).map(paymentId -> new MollieWebhookPayload(paymentId, PurchaseContext.PurchaseContextType.from((String)((String)additionalInfo.get("purchaseContextType"))), (String)additionalInfo.get("purchaseContextPublicIdentifier"), (String)additionalInfo.get("reservationId")));
            reader.close();
            return optional;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.warn("got exception while trying to decode Mollie Webhook Payload", (Throwable)e);
                return Optional.empty();
            }
        }
    }

    public boolean requiresSignedBody() {
        return false;
    }

    public PaymentWebhookResult processWebhook(TransactionWebhookPayload payload, Transaction transaction, PaymentContext paymentContext) {
        MollieWebhookPayload molliePayload = (MollieWebhookPayload)payload;
        String paymentId = molliePayload.getPaymentId();
        Optional optionalPurchaseContext = this.purchaseContextManager.findBy(molliePayload.getPurchaseContextType(), molliePayload.getPurchaseContextIdentifier());
        if (optionalPurchaseContext.isEmpty()) {
            return PaymentWebhookResult.notRelevant((String)"event");
        }
        PurchaseContext purchaseContext = (PurchaseContext)optionalPurchaseContext.get();
        return this.validateRemotePayment(transaction, paymentContext, paymentId, purchaseContext);
    }

    private PaymentWebhookResult validateRemotePayment(Transaction transaction, PaymentContext paymentContext, String paymentId, PurchaseContext purchaseContext) {
        try {
            Map configuration = this.getConfiguration(purchaseContext.getConfigurationLevel());
            HttpResponse response = this.callGetPayment(paymentId, configuration, paymentContext.getConfigurationLevel());
            if (HttpUtils.callSuccessful((HttpResponse)response)) {
                return this.processRemotePayment(transaction, paymentId, purchaseContext, configuration, response);
            }
            if (response.statusCode() == 404) {
                log.warn("Received suspicious call for non-existent payment id " + paymentId);
                return PaymentWebhookResult.notRelevant((String)"");
            }
            log.warn("was not able to get payment id " + paymentId + " for purchaseContext of type " + purchaseContext.getType() + " with public identifier " + purchaseContext.getPublicIdentifier());
            return PaymentWebhookResult.error((String)"internal error");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Request interrupted while processing Mollie Payment " + paymentId, (Throwable)e);
            return PaymentWebhookResult.error((String)e.getMessage());
        }
        catch (Exception ex) {
            log.error("got exception while trying to process Mollie Payment " + paymentId, (Throwable)ex);
            return PaymentWebhookResult.error((String)ex.getMessage());
        }
    }

    private PaymentWebhookResult processRemotePayment(Transaction transaction, String paymentId, PurchaseContext purchaseContext, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration, HttpResponse<InputStream> response) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(response.body(), StandardCharsets.UTF_8);){
            MolliePaymentDetails body = new MolliePaymentDetails(JsonParser.parseReader((Reader)reader).getAsJsonObject());
            if (configuration.get(ConfigurationKeys.PLATFORM_MODE_ENABLED).getValueAsBooleanOrDefault() && configuration.get(ConfigurationKeys.MOLLIE_CONNECT_LIVE_MODE).getValueAsBooleanOrDefault() != body.isLiveMode()) {
                PaymentWebhookResult paymentWebhookResult = PaymentWebhookResult.notRelevant((String)"liveMode");
                return paymentWebhookResult;
            }
            Validate.isTrue((boolean)body.getPaymentId().equals(paymentId));
            Validate.isTrue((boolean)transaction.getPaymentId().equals(paymentId));
            String status = body.getStatus();
            String reservationId = body.getReservationId();
            Optional<TicketReservationStatusAndValidation> optionalReservation = this.ticketReservationRepository.findOptionalStatusAndValidationById(reservationId).filter(reservation -> reservation.getStatus() == TicketReservation.TicketReservationStatus.EXTERNAL_PROCESSING_PAYMENT || reservation.getStatus() == TicketReservation.TicketReservationStatus.WAITING_EXTERNAL_CONFIRMATION);
            if (optionalReservation.isEmpty()) {
                PaymentWebhookResult paymentWebhookResult = PaymentWebhookResult.error((String)"reservation not found");
                return paymentWebhookResult;
            }
            Map transactionMetadata = transaction.getMetadata();
            switch (status) {
                case "paid": {
                    transactionMetadata.put("paymentMethod", Objects.requireNonNull(body.getPaymentMethod()).name());
                    this.transactionRepository.update(transaction.getId(), paymentId, paymentId, (ZonedDateTime)body.getConfirmationTimestamp().orElseThrow(), 0L, 0L, Transaction.Status.COMPLETE, transaction.getMetadata());
                    PaymentWebhookResult paymentWebhookResult = PaymentWebhookResult.successful((PaymentToken)new MollieToken(paymentId, body.getPaymentMethod()));
                    return paymentWebhookResult;
                }
                case "failed": 
                case "expired": {
                    transactionMetadata.put("paymentMethod", Optional.ofNullable(body.getPaymentMethod()).map(Enum::name).orElse(null));
                    this.transactionRepository.update(transaction.getId(), paymentId, paymentId, purchaseContext.now(this.clockProvider), transaction.getPlatformFee(), transaction.getGatewayFee(), transaction.getStatus(), transactionMetadata);
                    PaymentWebhookResult paymentWebhookResult = status.equals("failed") ? PaymentWebhookResult.failed((String)"failed") : PaymentWebhookResult.cancelled();
                    return paymentWebhookResult;
                }
                case "canceled": {
                    this.transactionRepository.update(transaction.getId(), paymentId, paymentId, purchaseContext.now(this.clockProvider), 0L, 0L, Transaction.Status.CANCELLED, transaction.getMetadata());
                    PaymentWebhookResult paymentWebhookResult = PaymentWebhookResult.cancelled();
                    return paymentWebhookResult;
                }
                case "open": {
                    PaymentWebhookResult paymentWebhookResult = PaymentWebhookResult.redirect((String)body.getCheckoutLink());
                    return paymentWebhookResult;
                }
            }
            PaymentWebhookResult paymentWebhookResult = PaymentWebhookResult.notRelevant((String)status);
            return paymentWebhookResult;
        }
    }

    public PaymentWebhookResult forceTransactionCheck(TicketReservation reservation, Transaction transaction, PaymentContext paymentContext) {
        return this.validateRemotePayment(transaction, paymentContext, transaction.getPaymentId(), paymentContext.getPurchaseContext());
    }

    private HttpResponse<InputStream> callGetPayment(String paymentId, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration, ConfigurationLevel configurationLevel) throws IOException, InterruptedException {
        String paymentResourceUrl = "https://api.mollie.com/v2/payments/" + paymentId;
        if (configuration.get(ConfigurationKeys.PLATFORM_MODE_ENABLED).getValueAsBooleanOrDefault()) {
            paymentResourceUrl = paymentResourceUrl + "?testmode=" + !configuration.get(ConfigurationKeys.MOLLIE_CONNECT_LIVE_MODE).getValueAsBooleanOrDefault();
        }
        HttpRequest request = this.requestFor(paymentResourceUrl, configuration, configurationLevel).GET().build();
        return this.client.send(request, HttpResponse.BodyHandlers.ofInputStream());
    }

    public boolean refund(Transaction transaction, PurchaseContext purchaseContext, Integer amount) {
        String currencyCode = transaction.getCurrency();
        String amountToRefund = Optional.ofNullable(amount).map(a -> MonetaryUtil.formatCents((int)a, (String)currencyCode)).orElseGet(() -> ((Transaction)transaction).getFormattedAmount());
        log.trace("Attempting to refund {} for reservation {}", (Object)amountToRefund, (Object)transaction.getReservationId());
        ConfigurationLevel configurationLevel = purchaseContext.getConfigurationLevel();
        Map configuration = this.getConfiguration(configurationLevel);
        String paymentId = transaction.getPaymentId();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("amount[currency]", currencyCode);
        parameters.put("amount[value]", amountToRefund);
        if (((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.PLATFORM_MODE_ENABLED)).getValueAsBooleanOrDefault()) {
            log.trace("Platform mode is active. Setting testmode to {}", (Object)(!((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.MOLLIE_CONNECT_LIVE_MODE)).getValueAsBooleanOrDefault() ? 1 : 0));
            parameters.put("testmode", !((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.MOLLIE_CONNECT_LIVE_MODE)).getValueAsBooleanOrDefault());
        }
        HttpRequest request = this.requestFor("https://api.mollie.com/v2/payments/" + paymentId + "/refunds", configuration, configurationLevel).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpUtils.ofFormUrlEncodedBody(parameters)).build();
        try {
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            if (HttpUtils.callSuccessful(response)) {
                log.trace("Received a successful response from Mollie. Body is {}", (Object)response.body());
                return true;
            }
            log.warn("got {} response while calling refund API for payment ID {}", (Object)response.statusCode(), (Object)paymentId);
            log.trace("detailed reply from mollie: {}", (Object)response.body());
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Request interrupted while calling refund API", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.warn("error while calling refund API", (Throwable)e);
            return false;
        }
    }

    public Optional<PaymentInformation> getInfo(Transaction transaction, PurchaseContext purchaseContext) {
        block8: {
            Optional<PaymentInformation> optional;
            ConfigurationLevel configurationLevel = purchaseContext.getConfigurationLevel();
            Map configuration = this.getConfiguration(configurationLevel);
            HttpResponse getPaymentResponse = this.callGetPayment(transaction.getPaymentId(), configuration, configurationLevel);
            if (!HttpUtils.callSuccessful((HttpResponse)getPaymentResponse)) break block8;
            InputStreamReader responseReader = new InputStreamReader((InputStream)getPaymentResponse.body(), StandardCharsets.UTF_8);
            try {
                MolliePaymentDetails body = new MolliePaymentDetails(JsonParser.parseReader((Reader)responseReader).getAsJsonObject());
                PaymentAmount paidAmount = body.getPaidAmount();
                String refundAmount = body.getRefundAmount().map(PaymentAmount::getValue).orElse(null);
                optional = Optional.of(new PaymentInformation(paidAmount.getValue(), refundAmount, null, null));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        responseReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.warn("Request interrupted while calling getInfo", (Throwable)e);
                    break block8;
                }
                catch (Exception e) {
                    log.warn("got exception while calling getInfo", (Throwable)e);
                }
            }
            responseReader.close();
            return optional;
        }
        return Optional.empty();
    }

    @ConstructorProperties(value={"client", "configurationManager", "ticketReservationRepository", "ticketRepository", "transactionRepository", "mollieConnectManager", "clockProvider", "purchaseContextManager"})
    @Generated
    public MollieWebhookPaymentManager(HttpClient client, ConfigurationManager configurationManager, TicketReservationRepository ticketReservationRepository, TicketRepository ticketRepository, TransactionRepository transactionRepository, MollieConnectManager mollieConnectManager, ClockProvider clockProvider, PurchaseContextManager purchaseContextManager) {
        this.client = client;
        this.configurationManager = configurationManager;
        this.ticketReservationRepository = ticketReservationRepository;
        this.ticketRepository = ticketRepository;
        this.transactionRepository = transactionRepository;
        this.mollieConnectManager = mollieConnectManager;
        this.clockProvider = clockProvider;
        this.purchaseContextManager = purchaseContextManager;
    }
}

