/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.payment;

import alfio.manager.payment.PaymentManagerUtils;
import alfio.manager.payment.PaymentSpecification;
import alfio.manager.support.PaymentResult;
import alfio.manager.system.ConfigurationManager;
import alfio.model.system.ConfigurationKeys;
import alfio.model.system.ConfigurationPathLevel;
import alfio.model.transaction.PaymentContext;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.PaymentProvider;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.Transaction;
import alfio.model.transaction.TransactionRequest;
import alfio.repository.TransactionRepository;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class OnSiteManager
implements PaymentProvider {
    private final ConfigurationManager configurationManager;
    private final TransactionRepository transactionRepository;

    public Set<PaymentMethod> getSupportedPaymentMethods(PaymentContext paymentContext, TransactionRequest transactionRequest) {
        return EnumSet.of(PaymentMethod.ON_SITE);
    }

    public PaymentProxy getPaymentProxy() {
        return PaymentProxy.ON_SITE;
    }

    public boolean accept(PaymentMethod paymentMethod, PaymentContext context, TransactionRequest transactionRequest) {
        return paymentMethod == PaymentMethod.ON_SITE && this.isActive(context);
    }

    public boolean accept(Transaction transaction) {
        return PaymentProxy.ON_SITE == transaction.getPaymentProxy();
    }

    public PaymentMethod getPaymentMethodForTransaction(Transaction transaction) {
        return PaymentMethod.ON_SITE;
    }

    public boolean isActive(PaymentContext paymentContext) {
        return this.configurationManager.getFor(ConfigurationKeys.ON_SITE_ENABLED, paymentContext.getConfigurationLevel()).getValueAsBooleanOrDefault() && (paymentContext.getConfigurationLevel().getPathLevel() != ConfigurationPathLevel.PURCHASE_CONTEXT || !paymentContext.isOnline());
    }

    public PaymentResult doPayment(PaymentSpecification spec) {
        PaymentManagerUtils.invalidateExistingTransactions((String)spec.getReservationId(), (TransactionRepository)this.transactionRepository);
        return PaymentResult.successful((String)"not-paid");
    }

    public Map<String, ?> getModelOptions(PaymentContext context) {
        HashMap<String, Boolean> model = new HashMap<String, Boolean>();
        boolean recaptchaEnabled = this.configurationManager.isRecaptchaForOfflinePaymentAndFreeEnabled(context.getConfigurationLevel());
        model.put("captchaRequestedForOffline", recaptchaEnabled);
        if (recaptchaEnabled) {
            model.put("recaptchaApiKey", this.configurationManager.getForSystem(ConfigurationKeys.RECAPTCHA_API_KEY).getValue().orElse(null));
        }
        return model;
    }

    @ConstructorProperties(value={"configurationManager", "transactionRepository"})
    @Generated
    public OnSiteManager(ConfigurationManager configurationManager, TransactionRepository transactionRepository) {
        this.configurationManager = configurationManager;
        this.transactionRepository = transactionRepository;
    }
}

