/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.payment;

import alfio.manager.payment.PayPalManager;
import alfio.manager.payment.PaymentManagerUtils;
import alfio.manager.payment.PaymentSpecification;
import alfio.manager.support.FeeCalculator;
import alfio.manager.support.PaymentResult;
import alfio.manager.system.ConfigurationManager;
import alfio.model.Configurable;
import alfio.model.CustomerName;
import alfio.model.PaymentInformation;
import alfio.model.PurchaseContext;
import alfio.model.TicketReservation;
import alfio.model.system.ConfigurationKeys;
import alfio.model.transaction.PaymentContext;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.PaymentProvider;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.PaymentToken;
import alfio.model.transaction.Transaction;
import alfio.model.transaction.TransactionRequest;
import alfio.model.transaction.capabilities.ExtractPaymentTokenFromTransaction;
import alfio.model.transaction.capabilities.PaymentInfo;
import alfio.model.transaction.token.PayPalToken;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import alfio.repository.TransactionRepository;
import alfio.util.ClockProvider;
import alfio.util.HttpUtils;
import alfio.util.Json;
import alfio.util.MonetaryUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.paypal.core.PayPalEnvironment;
import com.paypal.core.PayPalHttpClient;
import com.paypal.http.HttpRequest;
import com.paypal.http.HttpResponse;
import com.paypal.http.exceptions.HttpException;
import com.paypal.orders.AmountWithBreakdown;
import com.paypal.orders.ApplicationContext;
import com.paypal.orders.Capture;
import com.paypal.orders.LinkDescription;
import com.paypal.orders.MerchantReceivableBreakdown;
import com.paypal.orders.Order;
import com.paypal.orders.OrderRequest;
import com.paypal.orders.OrdersCaptureRequest;
import com.paypal.orders.OrdersCreateRequest;
import com.paypal.orders.OrdersGetRequest;
import com.paypal.orders.PurchaseUnit;
import com.paypal.orders.PurchaseUnitRequest;
import com.paypal.payments.CapturesRefundRequest;
import com.paypal.payments.Money;
import com.paypal.payments.RefundRequest;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class PayPalManager
implements PaymentProvider,
alfio.model.transaction.capabilities.RefundRequest,
PaymentInfo,
ExtractPaymentTokenFromTransaction {
    private static final Logger log = LoggerFactory.getLogger(PayPalManager.class);
    private final Cache<String, PayPalHttpClient> cachedClients = Caffeine.newBuilder().expireAfterAccess(Duration.ofHours(1L)).build();
    private final ConfigurationManager configurationManager;
    private final TicketReservationRepository ticketReservationRepository;
    private final TicketRepository ticketRepository;
    private final TransactionRepository transactionRepository;
    private final Json json;
    private final ClockProvider clockProvider;
    private static final String URL_PLACEHOLDER = "--operation--";
    private static final Set<String> MAPPED_ERROR = Set.of("FAILED_TO_CHARGE_CC", "INSUFFICIENT_FUNDS", "EXPIRED_CREDIT_CARD", "INSTRUMENT_DECLINED");

    private PayPalHttpClient getClient(Configurable configurable) {
        PayPalEnvironment apiContext = this.getApiContext(configurable);
        return (PayPalHttpClient)this.cachedClients.get((Object)this.generateKey(apiContext), key -> new PayPalHttpClient(apiContext));
    }

    private String generateKey(PayPalEnvironment environment) {
        return DigestUtils.sha256Hex((String)(environment.baseUrl() + "::" + environment.clientId() + "::" + environment.clientSecret()));
    }

    private PayPalEnvironment getApiContext(Configurable configurable) {
        Map paypalConf = this.configurationManager.getFor(Set.of(ConfigurationKeys.PAYPAL_LIVE_MODE, ConfigurationKeys.PAYPAL_CLIENT_ID, ConfigurationKeys.PAYPAL_CLIENT_SECRET), configurable.getConfigurationLevel());
        boolean isLive = ((ConfigurationManager.MaybeConfiguration)paypalConf.get(ConfigurationKeys.PAYPAL_LIVE_MODE)).getValueAsBooleanOrDefault();
        String clientId = ((ConfigurationManager.MaybeConfiguration)paypalConf.get(ConfigurationKeys.PAYPAL_CLIENT_ID)).getRequiredValue();
        String clientSecret = ((ConfigurationManager.MaybeConfiguration)paypalConf.get(ConfigurationKeys.PAYPAL_CLIENT_SECRET)).getRequiredValue();
        return isLive ? new PayPalEnvironment.Live(clientId, clientSecret) : new PayPalEnvironment.Sandbox(clientId, clientSecret);
    }

    private String createCheckoutRequest(PaymentSpecification spec) throws Exception {
        TicketReservation reservation = this.ticketReservationRepository.findReservationById(spec.getReservationId());
        String purchaseContextType = spec.getPurchaseContext().getType().getUrlComponent();
        String publicIdentifier = spec.getPurchaseContext().getPublicIdentifier();
        String baseUrl = StringUtils.removeEnd((String)this.configurationManager.getFor(ConfigurationKeys.BASE_URL, spec.getPurchaseContext().getConfigurationLevel()).getRequiredValue(), (String)"/");
        String bookUrl = baseUrl + "/" + purchaseContextType + "/" + publicIdentifier + "/reservation/" + spec.getReservationId() + "/payment/paypal/--operation--";
        String hmac = PayPalManager.computeHMAC((CustomerName)spec.getCustomerName(), (String)spec.getEmail(), (String)spec.getBillingAddress(), (PurchaseContext)spec.getPurchaseContext());
        UriComponentsBuilder bookUrlBuilder = UriComponentsBuilder.fromUriString((String)bookUrl).queryParam("hmac", new Object[]{hmac});
        String finalUrl = bookUrlBuilder.toUriString();
        ApplicationContext applicationContext = new ApplicationContext().landingPage("BILLING").cancelUrl(finalUrl.replace("--operation--", "cancel")).returnUrl(finalUrl.replace("--operation--", "confirm")).userAction("CONTINUE").shippingPreference("NO_SHIPPING");
        OrderRequest orderRequest = new OrderRequest().applicationContext(applicationContext).checkoutPaymentIntent("CAPTURE").purchaseUnits(List.of(new PurchaseUnitRequest().amountWithBreakdown(new AmountWithBreakdown().currencyCode(spec.getCurrencyCode()).value(spec.getOrderSummary().getTotalPrice()))));
        OrdersCreateRequest request = new OrdersCreateRequest().requestBody(orderRequest);
        request.header("prefer", "return=representation");
        request.header("PayPal-Request-Id", reservation.getId());
        HttpResponse response = this.getClient((Configurable)spec.getPurchaseContext()).execute((HttpRequest)request);
        if (HttpUtils.statusCodeIsSuccessful((int)response.statusCode())) {
            Order order = (Order)response.result();
            String status = order.status();
            if ("APPROVED".equals(status) || "COMPLETED".equals(status)) {
                if ("APPROVED".equals(status)) {
                    this.saveToken(reservation.getId(), spec.getPurchaseContext(), new PayPalToken(order.payer().payerId(), order.id(), hmac));
                }
                return "/" + purchaseContextType + "/" + publicIdentifier + "/reservation/" + spec.getReservationId();
            }
            if ("CREATED".equals(status)) {
                this.ticketReservationRepository.updateValidity(spec.getReservationId(), DateUtils.addMinutes((Date)reservation.getValidity(), (int)15));
                return order.links().stream().filter(l -> l.rel().equals("approve")).map(LinkDescription::href).findFirst().orElseThrow();
            }
        }
        throw new IllegalStateException();
    }

    private static String computeHMAC(CustomerName customerName, String email, String billingAddress, PurchaseContext purchaseContext) {
        return new HmacUtils(HmacAlgorithms.HMAC_SHA_256, purchaseContext.getPrivateKey()).hmacHex(StringUtils.trimToEmpty((String)customerName.getFullName()) + StringUtils.trimToEmpty((String)email) + StringUtils.trimToEmpty((String)billingAddress));
    }

    private static boolean isValidHMAC(CustomerName customerName, String email, String billingAddress, String hmac, PurchaseContext purchaseContext) {
        String computedHmac = PayPalManager.computeHMAC((CustomerName)customerName, (String)email, (String)billingAddress, (PurchaseContext)purchaseContext);
        return MessageDigest.isEqual(hmac.getBytes(StandardCharsets.UTF_8), computedHmac.getBytes(StandardCharsets.UTF_8));
    }

    private static Optional<String> mappedException(HttpException e) {
        String message = StringUtils.defaultString((String)e.getMessage());
        Optional<String> match = MAPPED_ERROR.stream().filter(message::contains).findFirst();
        if (match.isPresent()) {
            return Optional.of("error.STEP_2_PAYPAL_" + match.get());
        }
        log.warn("Exception from PayPal APIs", (Throwable)e);
        return Optional.empty();
    }

    private PayPalChargeDetails commitPayment(String reservationId, PayPalToken payPalToken, PurchaseContext purchaseContext) throws HttpException {
        try {
            OrdersCaptureRequest request = new OrdersCaptureRequest(payPalToken.getPaymentId()).payPalRequestId(reservationId);
            request.header("prefer", "return=representation");
            request.requestBody((Object)new OrderRequest());
            HttpResponse response = this.getClient((Configurable)purchaseContext).execute((HttpRequest)request);
            if (HttpUtils.statusCodeIsSuccessful((int)response.statusCode())) {
                Order result = (Order)response.result();
                if (!"COMPLETED".equals(result.status())) {
                    log.warn("error in state for reservationId {}, expected 'approved' state, but got '{}'", (Object)reservationId, (Object)result.status());
                    throw new IllegalStateException();
                }
                Optional captureOptional = result.purchaseUnits().stream().map(PurchaseUnit::payments).flatMap(pc -> pc.captures().stream()).findFirst();
                String captureId = captureOptional.map(Capture::id).orElseGet(() -> {
                    log.warn("PayPal: null Capture returned for OrderId {}", (Object)result.id());
                    return result.id();
                });
                Integer payPalFee = captureOptional.map(Capture::sellerReceivableBreakdown).map(MerchantReceivableBreakdown::paypalFee).map(money -> MonetaryUtil.unitToCents((BigDecimal)new BigDecimal(money.value()), (String)money.currencyCode())).orElse(0);
                return new PayPalChargeDetails(captureId, result.id(), (long)payPalFee.intValue());
            }
        }
        catch (HttpException e) {
            PayPalManager.mappedException((HttpException)e).ifPresent(message -> {
                throw new HandledPayPalErrorException(message);
            });
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        throw new IllegalStateException("cannot commit payment");
    }

    private Optional<PaymentInformation> getInfo(Transaction transaction, PurchaseContext purchaseContext, Supplier<String> platformFeeSupplier) {
        String transactionId = transaction.getTransactionId();
        String paymentId = transaction.getPaymentId();
        String currency = transaction.getCurrency();
        try {
            HttpResponse orderResponse;
            if (paymentId != null && HttpUtils.statusCodeIsSuccessful((int)(orderResponse = this.getClient((Configurable)purchaseContext).execute((HttpRequest)new OrdersGetRequest(paymentId))).statusCode()) && orderResponse.result() != null) {
                Order order = (Order)orderResponse.result();
                List payments = order.purchaseUnits().stream().map(PurchaseUnit::payments).collect(Collectors.toList());
                BigDecimal refund = payments.stream().flatMap(p -> CollectionUtils.emptyIfNull((Collection)p.refunds()).stream()).map(r -> new BigDecimal(r.amount().value())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal gatewayFee = payments.stream().flatMap(p -> CollectionUtils.emptyIfNull((Collection)p.captures()).stream()).map(c -> {
                    if (c != null && c.sellerReceivableBreakdown() != null) {
                        return c.sellerReceivableBreakdown().paypalFee();
                    }
                    return null;
                }).map(fee -> {
                    if (fee != null) {
                        return new BigDecimal(fee.value());
                    }
                    return BigDecimal.ZERO;
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal paidAmount = payments.stream().flatMap(p -> CollectionUtils.emptyIfNull((Collection)p.captures()).stream()).map(r -> new BigDecimal(r.amount().value())).reduce(BigDecimal.ZERO, BigDecimal::add);
                return Optional.of(new PaymentInformation(MonetaryUtil.formatUnit((BigDecimal)paidAmount, (String)currency), MonetaryUtil.formatUnit((BigDecimal)refund, (String)currency), String.valueOf(MonetaryUtil.unitToCents((BigDecimal)gatewayFee, (String)currency)), platformFeeSupplier.get()));
            }
            return Optional.empty();
        }
        catch (IOException ex) {
            log.warn("Paypal: error while fetching information for payment id " + transactionId, (Throwable)ex);
            return Optional.empty();
        }
    }

    public Optional<PaymentInformation> getInfo(Transaction transaction, PurchaseContext purchaseContext) {
        return this.getInfo(transaction, purchaseContext, () -> {
            if (transaction.getPlatformFee() > 0L) {
                return String.valueOf(transaction.getPlatformFee());
            }
            return ((Optional)FeeCalculator.getCalculator((Configurable)purchaseContext, (ConfigurationManager)this.configurationManager, (String)transaction.getCurrency()).apply(this.ticketRepository.countTicketsInReservation(transaction.getReservationId()), Long.valueOf(transaction.getPriceInCents()))).map(String::valueOf).orElse("0");
        });
    }

    public boolean refund(Transaction transaction, PurchaseContext purchaseContext, Integer amountToRefund) {
        Optional<Integer> amount = Optional.ofNullable(amountToRefund);
        String captureId = transaction.getTransactionId();
        try {
            PayPalHttpClient payPalClient = this.getClient((Configurable)purchaseContext);
            CapturesRefundRequest refundRequest = new CapturesRefundRequest(captureId);
            String currency = transaction.getCurrency();
            String amountOrFull = amount.map(a -> MonetaryUtil.formatCents((int)a, (String)currency)).orElse("full");
            amount.ifPresent(i -> refundRequest.requestBody(new RefundRequest().amount(new Money().currencyCode(currency).value(MonetaryUtil.formatCents((int)i, (String)currency)))));
            HttpResponse refundResponse = payPalClient.execute((HttpRequest)refundRequest);
            if (HttpUtils.statusCodeIsSuccessful((int)refundResponse.statusCode())) {
                log.info("Paypal: refund for payment {} executed with success for amount: {}", (Object)captureId, (Object)amountOrFull);
                return true;
            }
            log.warn("Paypal: was not able to refund payment with id {} [HTTP {}]", (Object)captureId, (Object)refundResponse.statusCode());
            return false;
        }
        catch (IOException ex) {
            log.warn("Paypal: was not able to refund payment with id " + captureId, (Throwable)ex);
            return false;
        }
    }

    public Set<PaymentMethod> getSupportedPaymentMethods(PaymentContext paymentContext, TransactionRequest transactionRequest) {
        return EnumSet.of(PaymentMethod.PAYPAL);
    }

    public PaymentProxy getPaymentProxy() {
        return PaymentProxy.PAYPAL;
    }

    public boolean accept(PaymentMethod paymentMethod, PaymentContext context, TransactionRequest transactionRequest) {
        return paymentMethod == PaymentMethod.PAYPAL && this.isActive(context);
    }

    public boolean accept(Transaction transaction) {
        return PaymentProxy.PAYPAL == transaction.getPaymentProxy();
    }

    public PaymentMethod getPaymentMethodForTransaction(Transaction transaction) {
        return PaymentMethod.PAYPAL;
    }

    public boolean isActive(PaymentContext paymentContext) {
        Map paypalConf = this.configurationManager.getFor(Set.of(ConfigurationKeys.PAYPAL_ENABLED, ConfigurationKeys.PAYPAL_CLIENT_ID, ConfigurationKeys.PAYPAL_CLIENT_SECRET), paymentContext.getConfigurationLevel());
        return ((ConfigurationManager.MaybeConfiguration)paypalConf.get(ConfigurationKeys.PAYPAL_ENABLED)).getValueAsBooleanOrDefault() && ((ConfigurationManager.MaybeConfiguration)paypalConf.get(ConfigurationKeys.PAYPAL_CLIENT_ID)).isPresent() && ((ConfigurationManager.MaybeConfiguration)paypalConf.get(ConfigurationKeys.PAYPAL_CLIENT_SECRET)).isPresent();
    }

    public PaymentResult getToken(PaymentSpecification spec) {
        try {
            PaymentToken gatewayToken = spec.getGatewayToken();
            if (gatewayToken != null && gatewayToken.getPaymentProvider() == PaymentProxy.PAYPAL) {
                return PaymentResult.initialized((String)gatewayToken.getToken());
            }
            return PaymentResult.redirect((String)this.createCheckoutRequest(spec));
        }
        catch (Exception e) {
            log.error("Error while retrieving token", (Throwable)e);
            return PaymentResult.failed((String)"error.STEP_2_PAYMENT_REQUEST_CREATION");
        }
    }

    public PaymentResult doPayment(PaymentSpecification spec) {
        try {
            PayPalToken gatewayToken = (PayPalToken)spec.getGatewayToken();
            if (!PayPalManager.isValidHMAC((CustomerName)spec.getCustomerName(), (String)spec.getEmail(), (String)spec.getBillingAddress(), (String)gatewayToken.getHmac(), (PurchaseContext)spec.getPurchaseContext())) {
                return PaymentResult.failed((String)"error.STEP_2_INVALID_HMAC");
            }
            PayPalChargeDetails chargeDetails = this.commitPayment(spec.getReservationId(), gatewayToken, spec.getPurchaseContext());
            long applicationFee = ((Optional)FeeCalculator.getCalculator((Configurable)spec.getPurchaseContext(), (ConfigurationManager)this.configurationManager, (String)spec.getCurrencyCode()).apply(this.ticketRepository.countTicketsInReservation(spec.getReservationId()), Long.valueOf(spec.getPriceWithVAT()))).orElse(0L);
            log.info("PayPalManager::: doPayment {} ", (Object)spec.getReservationId());
            Transaction existingTransaction = this.transactionRepository.loadOptionalByReservationIdAndStatus(spec.getReservationId(), Transaction.Status.COMPLETE).orElse(null);
            if (existingTransaction != null && existingTransaction.getPaymentProxy() == PaymentProxy.PAYPAL && existingTransaction.getTransactionId().equals(chargeDetails.captureId)) {
                log.info("skipped transaction already complete. This is probably due to a concurrent confirmation");
            } else {
                PaymentManagerUtils.invalidateExistingTransactions((String)spec.getReservationId(), (TransactionRepository)this.transactionRepository);
                this.transactionRepository.insert(chargeDetails.captureId, chargeDetails.orderId, spec.getReservationId(), ZonedDateTime.now(this.clockProvider.withZone(spec.getPurchaseContext().getZoneId())), spec.getPriceWithVAT(), spec.getPurchaseContext().getCurrency(), "Paypal confirmation", PaymentProxy.PAYPAL.name(), applicationFee, chargeDetails.payPalFee, Transaction.Status.COMPLETE, Map.of());
            }
            return PaymentResult.successful((String)chargeDetails.captureId);
        }
        catch (Exception e) {
            log.warn("error while processing paypal payment: " + e.getMessage(), (Throwable)e);
            if (e instanceof HttpException) {
                return PaymentResult.failed((String)"error.STEP_2_PAYPAL_unexpected");
            }
            if (e instanceof HandledPayPalErrorException) {
                return PaymentResult.failed((String)e.getMessage());
            }
            throw new IllegalStateException(e);
        }
    }

    public void saveToken(String reservationId, PurchaseContext purchaseContext, PayPalToken token) {
        PaymentManagerUtils.invalidateExistingTransactions((String)reservationId, (TransactionRepository)this.transactionRepository);
        this.transactionRepository.insert(reservationId, token.getPaymentId(), reservationId, purchaseContext.now(this.clockProvider), 0, purchaseContext.getCurrency(), "Paypal token", PaymentProxy.PAYPAL.name(), 0L, 0L, Transaction.Status.PENDING, Map.of("PAYMENT_TOKEN", this.json.asJsonString((Object)token)));
    }

    public Optional<PaymentToken> extractToken(Transaction transaction) {
        String jsonPaymentToken = transaction.getMetadata().getOrDefault("PAYMENT_TOKEN", null);
        return Optional.ofNullable(jsonPaymentToken).map(t -> (PaymentToken)this.json.fromJsonString(t, PayPalToken.class));
    }

    public void removeToken(TicketReservation reservation, String paymentId) {
        Optional optionalTransaction = this.transactionRepository.loadOptionalByReservationId(reservation.getId());
        if (optionalTransaction.isPresent()) {
            Transaction transaction = (Transaction)optionalTransaction.get();
            if (StringUtils.equals((CharSequence)transaction.getPaymentId(), (CharSequence)paymentId) && transaction.getPaymentProxy() == PaymentProxy.PAYPAL && transaction.getStatus() == Transaction.Status.PENDING) {
                PaymentManagerUtils.invalidateExistingTransactions((String)reservation.getId(), (TransactionRepository)this.transactionRepository, (PaymentProxy)PaymentProxy.PAYPAL);
            }
        } else {
            log.warn("attempting to delete non-existing transaction for reservation {}", (Object)reservation.getId());
        }
    }

    @ConstructorProperties(value={"configurationManager", "ticketReservationRepository", "ticketRepository", "transactionRepository", "json", "clockProvider"})
    @Generated
    public PayPalManager(ConfigurationManager configurationManager, TicketReservationRepository ticketReservationRepository, TicketRepository ticketRepository, TransactionRepository transactionRepository, Json json, ClockProvider clockProvider) {
        this.configurationManager = configurationManager;
        this.ticketReservationRepository = ticketReservationRepository;
        this.ticketRepository = ticketRepository;
        this.transactionRepository = transactionRepository;
        this.json = json;
        this.clockProvider = clockProvider;
    }
}

