/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.payment;

import alfio.model.CustomerName;
import alfio.model.OrderSummary;
import alfio.model.PriceContainer;
import alfio.model.PurchaseContext;
import alfio.model.TicketReservation;
import alfio.model.TotalPrice;
import alfio.model.transaction.PaymentContext;
import alfio.model.transaction.PaymentToken;
import alfio.util.LocaleUtil;
import java.util.Locale;
import lombok.Generated;

public class PaymentSpecification {
    private final String reservationId;
    private final PaymentToken gatewayToken;
    private final int priceWithVAT;
    private final PurchaseContext purchaseContext;
    private final String email;
    private final CustomerName customerName;
    private final String billingAddress;
    private final String customerReference;
    private final Locale locale;
    private final boolean invoiceRequested;
    private final boolean postponeAssignment;
    private final OrderSummary orderSummary;
    private final String vatCountryCode;
    private final String vatNr;
    private final PriceContainer.VatStatus vatStatus;
    private final boolean tcAccepted;
    private final boolean privacyAccepted;

    public PaymentSpecification(String reservationId, PaymentToken gatewayToken, int priceWithVAT, PurchaseContext purchaseContext, String email, CustomerName customerName, String billingAddress, String customerReference, Locale locale, boolean invoiceRequested, boolean postponeAssignment, OrderSummary orderSummary, String vatCountryCode, String vatNr, PriceContainer.VatStatus vatStatus, boolean tcAccepted, boolean privacyAccepted) {
        this.reservationId = reservationId;
        this.gatewayToken = gatewayToken;
        this.priceWithVAT = priceWithVAT;
        this.purchaseContext = purchaseContext;
        this.email = email;
        this.customerName = customerName;
        this.billingAddress = billingAddress;
        this.customerReference = customerReference;
        this.locale = locale;
        this.invoiceRequested = invoiceRequested;
        this.postponeAssignment = postponeAssignment;
        this.orderSummary = orderSummary;
        this.vatCountryCode = vatCountryCode;
        this.vatNr = vatNr;
        this.vatStatus = vatStatus;
        this.tcAccepted = tcAccepted;
        this.privacyAccepted = privacyAccepted;
    }

    public PaymentSpecification(TicketReservation reservation, TotalPrice totalPrice, PurchaseContext purchaseContext, PaymentToken gatewayToken, OrderSummary orderSummary, boolean tcAccepted, boolean privacyAccepted) {
        this(reservation.getId(), gatewayToken, totalPrice.getPriceWithVAT(), purchaseContext, reservation.getEmail(), new CustomerName(reservation.getFullName(), reservation.getFirstName(), reservation.getLastName(), true), reservation.getBillingAddress(), reservation.getCustomerReference(), LocaleUtil.forLanguageTag((String)reservation.getUserLanguage()), reservation.isInvoiceRequested(), !reservation.isDirectAssignmentRequested(), orderSummary, reservation.getVatCountryCode(), reservation.getVatNr(), reservation.getVatStatus(), tcAccepted, privacyAccepted);
    }

    PaymentSpecification(String reservationId, PaymentToken gatewayToken, int priceWithVAT, PurchaseContext purchaseContext, String email, CustomerName customerName) {
        this(reservationId, gatewayToken, priceWithVAT, purchaseContext, email, customerName, null, null, null, false, false, null, null, null, null, false, false);
    }

    public String getCurrencyCode() {
        return this.purchaseContext.getCurrency();
    }

    public PaymentContext getPaymentContext() {
        return new PaymentContext(this.purchaseContext);
    }

    @Generated
    public String getReservationId() {
        return this.reservationId;
    }

    @Generated
    public PaymentToken getGatewayToken() {
        return this.gatewayToken;
    }

    @Generated
    public int getPriceWithVAT() {
        return this.priceWithVAT;
    }

    @Generated
    public PurchaseContext getPurchaseContext() {
        return this.purchaseContext;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public CustomerName getCustomerName() {
        return this.customerName;
    }

    @Generated
    public String getBillingAddress() {
        return this.billingAddress;
    }

    @Generated
    public String getCustomerReference() {
        return this.customerReference;
    }

    @Generated
    public Locale getLocale() {
        return this.locale;
    }

    @Generated
    public boolean isInvoiceRequested() {
        return this.invoiceRequested;
    }

    @Generated
    public boolean isPostponeAssignment() {
        return this.postponeAssignment;
    }

    @Generated
    public OrderSummary getOrderSummary() {
        return this.orderSummary;
    }

    @Generated
    public String getVatCountryCode() {
        return this.vatCountryCode;
    }

    @Generated
    public String getVatNr() {
        return this.vatNr;
    }

    @Generated
    public PriceContainer.VatStatus getVatStatus() {
        return this.vatStatus;
    }

    @Generated
    public boolean isTcAccepted() {
        return this.tcAccepted;
    }

    @Generated
    public boolean isPrivacyAccepted() {
        return this.privacyAccepted;
    }
}

