/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.payment;

import alfio.manager.payment.BankTransferManager;
import alfio.manager.payment.PaymentSpecification;
import alfio.manager.support.PaymentResult;
import alfio.manager.system.ConfigurationManager;
import alfio.model.Configurable;
import alfio.model.PaymentInformation;
import alfio.model.PurchaseContext;
import alfio.model.TicketReservation;
import alfio.model.TicketReservationWithTransaction;
import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import alfio.model.system.ConfigurationKeys;
import alfio.model.transaction.PaymentContext;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.PaymentProvider;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.Transaction;
import alfio.model.transaction.TransactionRequest;
import alfio.model.transaction.capabilities.OfflineProcessor;
import alfio.model.transaction.capabilities.PaymentInfo;
import alfio.model.transaction.provider.RevolutTransactionDescriptor;
import alfio.repository.TransactionRepository;
import alfio.util.ClockProvider;
import alfio.util.EventUtil;
import alfio.util.Json;
import alfio.util.MonetaryUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Order(value=1)
@Transactional
public class RevolutBankTransferManager
implements PaymentProvider,
OfflineProcessor,
PaymentInfo {
    private static final Logger log = LoggerFactory.getLogger(RevolutBankTransferManager.class);
    private static final String GENERIC_ERROR = "error";
    private final BankTransferManager bankTransferManager;
    private final ConfigurationManager configurationManager;
    private final TransactionRepository transactionRepository;
    private final HttpClient client;
    private final ClockProvider clockProvider;
    private static final Cache<String, List<String>> accountsCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofHours(1L)).build();

    public Set<PaymentMethod> getSupportedPaymentMethods(PaymentContext paymentContext, TransactionRequest transactionRequest) {
        return this.bankTransferManager.getSupportedPaymentMethods(paymentContext, transactionRequest);
    }

    public PaymentProxy getPaymentProxy() {
        return this.bankTransferManager.getPaymentProxy();
    }

    public boolean accept(PaymentMethod paymentMethod, PaymentContext context, TransactionRequest transactionRequest) {
        return paymentMethod == PaymentMethod.BANK_TRANSFER && this.isActive(context);
    }

    public boolean isActive(PaymentContext paymentContext) {
        Map options = this.bankTransferManager.options(paymentContext);
        return this.bankTransferManager.bankTransferActive(paymentContext, options) && ((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.REVOLUT_ENABLED)).getValueAsBooleanOrDefault() && ((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.REVOLUT_API_KEY)).isPresent();
    }

    public PaymentResult doPayment(PaymentSpecification spec) {
        return this.bankTransferManager.doPayment(spec);
    }

    public Map<String, ?> getModelOptions(PaymentContext context) {
        return this.bankTransferManager.getModelOptions(context);
    }

    public Result<List<String>> checkPendingReservations(Collection<TicketReservationWithTransaction> reservations, PaymentContext context, ZonedDateTime lastCheck) {
        if (reservations.isEmpty()) {
            return Result.success(List.of());
        }
        Map options = this.bankTransferManager.options(context);
        String host = ((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.REVOLUT_LIVE_MODE)).getValueAsBooleanOrDefault() ? "https://b2b.revolut.com" : "https://sandbox-b2b.revolut.com";
        Optional revolutKeyOptional = ((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.REVOLUT_API_KEY)).getValue();
        if (revolutKeyOptional.isEmpty()) {
            return Result.error((ErrorCode)ErrorCode.custom((String)"unavailable", (String)"cannot retrieve Revolut API KEY. Please fix configuration"));
        }
        String revolutKey = (String)revolutKeyOptional.get();
        return this.loadAccounts(revolutKey, host).flatMap(accounts -> this.loadTransactions(lastCheck, revolutKey, host, accounts)).flatMap(revolutTransactions -> this.matchTransactions(reservations, revolutTransactions, context, ((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.REVOLUT_MANUAL_REVIEW)).getValueAsBooleanOrDefault()));
    }

    Result<List<String>> matchTransactions(Collection<TicketReservationWithTransaction> pendingReservations, List<RevolutTransactionDescriptor> transactions, PaymentContext context, boolean manualReviewRequired) {
        List matched = pendingReservations.stream().map(reservation -> Pair.of((Object)reservation, transactions.stream().filter(this.transactionMatches(reservation, context)).findFirst())).filter(pair -> ((Optional)pair.getRight()).isPresent()).map(pair -> Pair.of((Object)((TicketReservationWithTransaction)pair.getLeft()), (Object)((RevolutTransactionDescriptor)((Optional)pair.getRight()).orElseThrow()))).collect(Collectors.toList());
        return Result.success(matched.stream().map(pair -> {
            String reservationId = ((TicketReservationWithTransaction)pair.getLeft()).getTicketReservation().getId();
            Transaction transaction = ((TicketReservationWithTransaction)pair.getLeft()).getTransaction();
            Optional latestTransaction = this.transactionRepository.lockLatestForUpdate(reservationId);
            if (latestTransaction.isEmpty() || ((Transaction)latestTransaction.get()).getId() != transaction.getId() || ((Transaction)latestTransaction.get()).getStatus() != transaction.getStatus()) {
                log.trace("transaction {} has been modified while processing. Current status is: {}", (Object)transaction.getId(), (Object)latestTransaction.map(t -> t.getStatus().name()).orElse("N/A"));
                return null;
            }
            RevolutTransactionDescriptor revolutTransaction = (RevolutTransactionDescriptor)pair.getRight();
            this.transactionRepository.update(transaction.getId(), revolutTransaction.getId(), revolutTransaction.getRequestId(), revolutTransaction.getCompletedAt(), 0L, 0L, manualReviewRequired ? Transaction.Status.OFFLINE_PENDING_REVIEW : Transaction.Status.OFFLINE_MATCHING_PAYMENT_FOUND, revolutTransaction.getMetadata());
            return reservationId;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private Predicate<RevolutTransactionDescriptor> transactionMatches(TicketReservationWithTransaction reservationWithTransaction, PaymentContext context) {
        TicketReservation reservation = reservationWithTransaction.getTicketReservation();
        Transaction transaction = reservationWithTransaction.getTransaction();
        String reservationId = reservation.getId().toLowerCase();
        String shortReservationId = this.configurationManager.getShortReservationID((Configurable)context.getPurchaseContext(), reservation).toLowerCase();
        String[] terms = reservation.getHasInvoiceNumber() ? new String[]{reservation.getInvoiceNumber().toLowerCase(), shortReservationId, reservationId} : new String[]{shortReservationId, reservationId};
        return revolutTransaction -> revolutTransaction.getTransactionBalance().compareTo(BigDecimal.ZERO) > 0 && Arrays.stream(terms).anyMatch(s -> revolutTransaction.getReference().toLowerCase().contains((CharSequence)s)) && transaction.getCurrency().equals(((RevolutTransactionDescriptor.TransactionLeg)revolutTransaction.getLegs().get(0)).getCurrency()) && transaction.getPriceInCents() == MonetaryUtil.unitToCents((BigDecimal)revolutTransaction.getTransactionBalance(), (String)transaction.getCurrency());
    }

    private Result<List<RevolutTransactionDescriptor>> loadTransactions(ZonedDateTime lastCheck, String revolutKey, String revolutUrl, List<String> accounts) {
        if (accounts.isEmpty()) {
            return Result.error((ErrorCode)ErrorCode.custom((String)"no-account", (String)"No active accounts found."));
        }
        try {
            ZonedDateTime from = lastCheck != null ? lastCheck.withZoneSameInstant(this.clockProvider.getClock().getZone()) : ZonedDateTime.now(this.clockProvider.getClock()).minusDays(1L);
            HttpRequest request = HttpRequest.newBuilder(URI.create(revolutUrl + "/api/1.0/transactions?from=" + from.format(EventUtil.JSON_DATETIME_FORMATTER))).GET().header("Authorization", "Bearer " + revolutKey).build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == HttpStatus.OK.value()) {
                List result = (List)Json.fromJson((String)response.body(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                return Result.success(result.stream().filter(t -> "completed".equals(t.getState()) && t.getLegs().size() == 1 && accounts.contains(((RevolutTransactionDescriptor.TransactionLeg)t.getLegs().get(0)).getAccountId())).collect(Collectors.toList()));
            }
            return Result.error((ErrorCode)ErrorCode.custom((String)"no data received", (String)("No data received from Revolut. Status code is " + response.statusCode())));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Request interrupted while calling Revolut API", (Throwable)e);
            return Result.error((ErrorCode)ErrorCode.custom((String)GENERIC_ERROR, (String)"Cannot call Revolut API"));
        }
        catch (Exception e) {
            log.warn("cannot call Revolut APIs", (Throwable)e);
            return Result.error((ErrorCode)ErrorCode.custom((String)GENERIC_ERROR, (String)"Cannot call Revolut API"));
        }
    }

    private Result<List<String>> loadAccounts(String revolutKey, String baseUrl) {
        String key = revolutKey + "@" + baseUrl;
        try {
            return Result.success((Object)((List)accountsCache.get((Object)key, k -> this.loadAccountsFromAPI(revolutKey, baseUrl))));
        }
        catch (Exception e) {
            return Result.error((ErrorCode)ErrorCode.custom((String)GENERIC_ERROR, (String)e.getMessage()));
        }
    }

    private List<String> loadAccountsFromAPI(String revolutKey, String baseUrl) {
        HttpRequest request = HttpRequest.newBuilder(URI.create(baseUrl + "/api/1.0/accounts")).GET().header("Authorization", "Bearer " + revolutKey).build();
        try {
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == HttpStatus.OK.value()) {
                List result = (List)Json.fromJson((String)response.body(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                return result.stream().filter(m -> "active".equals(m.get("state"))).map(m -> (String)m.get("id")).collect(Collectors.toList());
            }
            throw new IllegalStateException("cannot retrieve accounts");
        }
        catch (IllegalStateException ex) {
            throw ex;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Request interrupted while retrieving accounts", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            log.warn("got error while retrieving accounts", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public Optional<PaymentInformation> getInfo(Transaction transaction, PurchaseContext purchaseContext) {
        Map metadata = transaction.getMetadata();
        if (metadata != null && metadata.containsKey("counterpartyAccountId")) {
            return Optional.of(new PaymentInformation(MonetaryUtil.formatCents((int)transaction.getPriceInCents(), (String)transaction.getCurrency()), null, String.valueOf(transaction.getGatewayFee()), String.valueOf(transaction.getPlatformFee())));
        }
        return Optional.empty();
    }

    public boolean accept(Transaction transaction) {
        return false;
    }

    public PaymentMethod getPaymentMethodForTransaction(Transaction transaction) {
        return this.bankTransferManager.getPaymentMethodForTransaction(transaction);
    }

    @ConstructorProperties(value={"bankTransferManager", "configurationManager", "transactionRepository", "client", "clockProvider"})
    @Generated
    public RevolutBankTransferManager(BankTransferManager bankTransferManager, ConfigurationManager configurationManager, TransactionRepository transactionRepository, HttpClient client, ClockProvider clockProvider) {
        this.bankTransferManager = bankTransferManager;
        this.configurationManager = configurationManager;
        this.transactionRepository = transactionRepository;
        this.client = client;
        this.clockProvider = clockProvider;
    }
}

