/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.payment;

import alfio.manager.payment.PaymentManagerUtils;
import alfio.manager.payment.PaymentSpecification;
import alfio.manager.payment.SaferpayManager;
import alfio.manager.payment.saferpay.PaymentPageAssertRequestBuilder;
import alfio.manager.payment.saferpay.PaymentPageInitializeRequestBuilder;
import alfio.manager.payment.saferpay.TransactionCaptureRequestBuilder;
import alfio.manager.payment.saferpay.TransactionInquireRequestBuilder;
import alfio.manager.payment.saferpay.TransactionRefundBuilder;
import alfio.manager.support.PaymentResult;
import alfio.manager.support.PaymentWebhookResult;
import alfio.manager.system.ConfigurationManager;
import alfio.model.Configurable;
import alfio.model.PaymentInformation;
import alfio.model.PurchaseContext;
import alfio.model.TicketReservation;
import alfio.model.system.ConfigurationKeys;
import alfio.model.transaction.PaymentContext;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.PaymentProvider;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.PaymentToken;
import alfio.model.transaction.Transaction;
import alfio.model.transaction.TransactionRequest;
import alfio.model.transaction.TransactionWebhookPayload;
import alfio.model.transaction.capabilities.PaymentInfo;
import alfio.model.transaction.capabilities.WebhookHandler;
import alfio.model.transaction.token.SaferpayToken;
import alfio.model.transaction.webhook.EmptyWebhookPayload;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import alfio.repository.TransactionRepository;
import alfio.util.ClockProvider;
import alfio.util.HttpUtils;
import alfio.util.MonetaryUtil;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class SaferpayManager
implements PaymentProvider,
PaymentInfo,
WebhookHandler {
    private static final String LIVE_ENDPOINT = "https://www.saferpay.com/api";
    private static final String TEST_ENDPOINT = "https://test.saferpay.com/api";
    private static final Logger LOGGER = LoggerFactory.getLogger(SaferpayManager.class);
    private static final String RETRY_COUNT = "retryCount";
    private static final String TRANSACTION = "Transaction";
    private static final String STATUS = "Status";
    private final ConfigurationManager configurationManager;
    private final HttpClient httpClient;
    private final TicketReservationRepository ticketReservationRepository;
    private final TransactionRepository transactionRepository;
    private final TicketRepository ticketRepository;
    private final ClockProvider clockProvider;

    public Set<PaymentMethod> getSupportedPaymentMethods(PaymentContext paymentContext, TransactionRequest transactionRequest) {
        return EnumSet.of(PaymentMethod.CREDIT_CARD);
    }

    public PaymentProxy getPaymentProxy() {
        return PaymentProxy.SAFERPAY;
    }

    public boolean accept(PaymentMethod paymentMethod, PaymentContext context, TransactionRequest transactionRequest) {
        return paymentMethod == PaymentMethod.CREDIT_CARD && this.isActive(context);
    }

    public boolean accept(Transaction transaction) {
        return transaction.getPaymentProxy() == PaymentProxy.SAFERPAY;
    }

    public PaymentMethod getPaymentMethodForTransaction(Transaction transaction) {
        return PaymentMethod.CREDIT_CARD;
    }

    public boolean isActive(PaymentContext paymentContext) {
        Map configurationMap = this.configurationManager.getFor(EnumSet.of(ConfigurationKeys.SAFERPAY_ENABLED, ConfigurationKeys.SAFERPAY_API_USERNAME, ConfigurationKeys.SAFERPAY_API_PASSWORD, ConfigurationKeys.SAFERPAY_CUSTOMER_ID, ConfigurationKeys.SAFERPAY_TERMINAL_ID), paymentContext.getConfigurationLevel());
        return configurationMap.values().stream().allMatch(ConfigurationManager.MaybeConfiguration::isPresent);
    }

    public PaymentResult doPayment(PaymentSpecification spec) {
        PurchaseContext purchaseContext = spec.getPurchaseContext();
        Map configuration = this.loadConfiguration(purchaseContext);
        String reservationId = spec.getReservationId();
        TicketReservation reservation = this.ticketReservationRepository.findReservationById(reservationId);
        int items = spec.getPurchaseContext().getType() == PurchaseContext.PurchaseContextType.event ? this.ticketRepository.countTicketsInReservation(spec.getReservationId()) : 1;
        int retryCount = 0;
        Optional existingTransaction = this.transactionRepository.loadOptionalByStatusAndPaymentProxyForUpdate(reservationId, Transaction.Status.PENDING, PaymentProxy.SAFERPAY);
        if (existingTransaction.isPresent()) {
            Transaction transaction = (Transaction)existingTransaction.get();
            PaymentWebhookResult processResult = this.internalProcessWebhook(transaction, spec.getPaymentContext());
            if (processResult.getType() == PaymentWebhookResult.Type.SUCCESSFUL) {
                return PaymentResult.successful((String)processResult.getPaymentToken().getToken());
            }
            retryCount = Integer.parseInt(transaction.getMetadata().getOrDefault(RETRY_COUNT, "0")) + 1;
        }
        String description = purchaseContext.ofType(PurchaseContext.PurchaseContextType.event) ? "ticket(s) for event" : "x subscription";
        String paymentDescription = String.format("%s - %d %s %s", this.configurationManager.getShortReservationID((Configurable)purchaseContext, reservation), items, description, purchaseContext.getDisplayName());
        String requestBody = new PaymentPageInitializeRequestBuilder(((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.BASE_URL)).getRequiredValue(), spec).addAuthentication(((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.SAFERPAY_CUSTOMER_ID)).getRequiredValue(), reservationId, ((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.SAFERPAY_TERMINAL_ID)).getRequiredValue()).addOrderInformation(reservationId, Integer.toString(spec.getPriceWithVAT()), spec.getCurrencyCode(), paymentDescription, retryCount).build();
        HttpRequest request = this.buildRequest(configuration, "/Payment/v1/PaymentPage/Initialize", requestBody);
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            if (!HttpUtils.callSuccessful(response)) {
                LOGGER.warn("Create session failed with status {}, body {}", (Object)response.statusCode(), (Object)response.body());
                throw new IllegalStateException("session creation was not successful (HTTP " + response.statusCode() + ")");
            }
            LOGGER.debug("received successful response {}", (Object)response.body());
            return PaymentResult.redirect((String)this.processPaymentInitializationResponse(response, spec, retryCount));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Payment init interrupted", (Throwable)e);
            return PaymentResult.failed((String)e.getMessage());
        }
        catch (Exception ex) {
            LOGGER.error("unexpected error while calling payment init", (Throwable)ex);
            return PaymentResult.failed((String)ex.getMessage());
        }
    }

    private String authorizationHeader(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration) {
        String credentials = configuration.get(ConfigurationKeys.SAFERPAY_API_USERNAME).getRequiredValue() + ":" + configuration.get(ConfigurationKeys.SAFERPAY_API_PASSWORD).getRequiredValue();
        return Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
    }

    public Optional<TransactionWebhookPayload> parseTransactionPayload(String body, String signature, Map<String, String> additionalInfo, PaymentContext paymentContext) {
        return Optional.of(new EmptyWebhookPayload(additionalInfo.get("reservationId"), TransactionWebhookPayload.Status.SUCCESS));
    }

    public PaymentWebhookResult processWebhook(TransactionWebhookPayload payload, Transaction transaction, PaymentContext paymentContext) {
        return this.internalProcessWebhook(transaction, paymentContext);
    }

    PaymentWebhookResult internalProcessWebhook(Transaction transaction, PaymentContext paymentContext) {
        int retryCount = Integer.parseInt(transaction.getMetadata().getOrDefault(RETRY_COUNT, "0"));
        Map configuration = this.loadConfiguration(paymentContext.getPurchaseContext());
        PaymentStatus paymentStatus = this.retrievePaymentStatus(configuration, transaction.getPaymentId(), transaction.getReservationId(), retryCount);
        if (paymentStatus.isEmpty()) {
            LOGGER.debug("Invalidating transaction with ID {}", (Object)transaction.getId());
            this.transactionRepository.invalidateById(transaction.getId());
            this.ticketReservationRepository.updateValidity(transaction.getReservationId(), DateUtils.addMinutes((Date)new Date(), (int)((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.RESERVATION_TIMEOUT)).getValueAsIntOrDefault(25)));
            return PaymentWebhookResult.cancelled();
        }
        if (paymentStatus.isSuccessful()) {
            this.transactionRepository.update(transaction.getId(), paymentStatus.transactionId, paymentStatus.captureId, paymentStatus.timestamp, transaction.getPlatformFee(), transaction.getGatewayFee(), Transaction.Status.COMPLETE, transaction.getMetadata());
            return PaymentWebhookResult.successful((PaymentToken)new SaferpayToken(paymentStatus.captureId));
        }
        if (paymentStatus.isInitialized()) {
            return PaymentWebhookResult.processStarted((PaymentToken)new SaferpayToken(transaction.getPaymentId()));
        }
        return PaymentWebhookResult.pending();
    }

    public PaymentWebhookResult forceTransactionCheck(TicketReservation reservation, Transaction transaction, PaymentContext paymentContext) {
        return this.internalProcessWebhook(transaction, paymentContext);
    }

    public boolean requiresSignedBody() {
        return false;
    }

    public Optional<PaymentInformation> getInfo(Transaction transaction, PurchaseContext purchaseContext) {
        Map configuration = this.loadConfiguration(purchaseContext);
        String requestBody = new TransactionInquireRequestBuilder(transaction.getTransactionId(), 0).addAuthentication(((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.SAFERPAY_CUSTOMER_ID)).getRequiredValue(), transaction.getReservationId()).build();
        HttpRequest request = this.buildRequest(configuration, "/Payment/v1/Transaction/Inquire", requestBody);
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            if (!HttpUtils.callSuccessful(response)) {
                LOGGER.warn("Cannot retrieve transaction info. Status {}, body {}", (Object)response.statusCode(), (Object)response.body());
                return Optional.empty();
            }
            LOGGER.debug("received successful response {}", (Object)response.body());
            JsonObject responseBody = JsonParser.parseString((String)response.body()).getAsJsonObject();
            JsonObject amount = responseBody.get(TRANSACTION).getAsJsonObject().get("Amount").getAsJsonObject();
            String centsAsString = amount.get("Value").getAsString();
            String formattedAmount = MonetaryUtil.formatCents((int)Integer.parseInt(centsAsString), (String)amount.get("CurrencyCode").getAsString());
            return Optional.of(new PaymentInformation(formattedAmount, null, null, null));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Request interrupted while calling getInfo", (Throwable)e);
        }
        catch (Exception ex) {
            LOGGER.error("unexpected error while calling getInfo", (Throwable)ex);
        }
        return Optional.empty();
    }

    public boolean refund(Transaction transaction, PurchaseContext purchaseContext, Integer amount) {
        Map configuration = this.loadConfiguration(purchaseContext);
        String requestBody = new TransactionRefundBuilder(transaction.getPaymentId(), 0).addAuthentication(((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.SAFERPAY_CUSTOMER_ID)).getRequiredValue(), transaction.getReservationId()).build(Integer.toString(amount), transaction.getCurrency());
        HttpRequest request = this.buildRequest(configuration, "/Payment/v1/Transaction/Refund", requestBody);
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            if (!HttpUtils.callSuccessful(response)) {
                LOGGER.warn("Cannot refund transaction. Status {}, body {}", (Object)response.statusCode(), (Object)response.body());
                return false;
            }
            JsonObject transactionResponse = JsonParser.parseString((String)response.body()).getAsJsonObject().get(TRANSACTION).getAsJsonObject();
            Validate.isTrue((boolean)"REFUND".equals(transactionResponse.get("Type").getAsString()), (String)"Unexpected transaction type", (Object[])new Object[0]);
            if ("AUTHORIZED".equals(transactionResponse.get(STATUS).getAsString())) {
                return this.confirmTransaction(configuration, transactionResponse.get("Id").getAsString(), null, UUID.randomUUID().toString(), 0).isSuccessful();
            }
            LOGGER.debug("received successful response {}", (Object)response.body());
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Refund request interrupted", (Throwable)e);
            return false;
        }
        catch (Exception ex) {
            LOGGER.error("unexpected error while trying to refund transaction {}", (Object)transaction.getTransactionId(), (Object)ex);
            return false;
        }
    }

    private PaymentStatus retrievePaymentStatus(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration, String token, String reservationId, int retryCount) {
        String requestBody = new PaymentPageAssertRequestBuilder(token, retryCount).addAuthentication(configuration.get(ConfigurationKeys.SAFERPAY_CUSTOMER_ID).getRequiredValue(), reservationId).build();
        HttpRequest request = this.buildRequest(configuration, "/Payment/v1/PaymentPage/Assert", requestBody);
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            if (HttpUtils.callSuccessful(response)) {
                JsonObject responseBody = JsonParser.parseString((String)response.body()).getAsJsonObject();
                JsonObject transaction = responseBody.get(TRANSACTION).getAsJsonObject();
                String paymentStatus = transaction.get(STATUS).getAsString();
                String transactionId = transaction.get("Id").getAsString();
                switch (paymentStatus) {
                    case "CAPTURED": {
                        String captureId = transaction.get("CaptureId").getAsString();
                        ZonedDateTime timestamp = ZonedDateTime.parse(transaction.get("Date").getAsString());
                        return new PaymentStatus(PaymentResult.successful((String)captureId), transactionId, captureId, timestamp);
                    }
                    case "AUTHORIZED": {
                        return this.confirmTransaction(configuration, transactionId, token, reservationId, retryCount);
                    }
                    case "PENDING": {
                        throw new IllegalStateException("PENDING status is not supported");
                    }
                }
                return PaymentStatus.EMPTY;
            }
            int statusCode = response.statusCode();
            if (statusCode > 499) {
                throw new IllegalStateException("Internal server error");
            }
            return PaymentStatus.EMPTY;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private PaymentStatus confirmTransaction(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration, String transactionId, String token, String requestId, int retryCount) {
        String requestBody = new TransactionCaptureRequestBuilder(transactionId, retryCount).addAuthentication(configuration.get(ConfigurationKeys.SAFERPAY_CUSTOMER_ID).getRequiredValue(), requestId).build();
        HttpRequest request = this.buildRequest(configuration, "/Payment/v1/Transaction/Capture", requestBody);
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            if (HttpUtils.callSuccessful(response)) {
                JsonObject responseBody = JsonParser.parseString((String)response.body()).getAsJsonObject();
                String paymentStatus = responseBody.get(STATUS).getAsString();
                Validate.isTrue((boolean)paymentStatus.equals("CAPTURED"), (String)"Expected CAPTURED Payment Status, got %s", (Object[])new Object[]{paymentStatus});
                String captureId = responseBody.get("CaptureId").getAsString();
                ZonedDateTime timestamp = ZonedDateTime.parse(responseBody.get("Date").getAsString());
                return new PaymentStatus(PaymentResult.successful((String)captureId), transactionId, captureId, timestamp);
            }
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        return new PaymentStatus(PaymentResult.initialized((String)token), token, null, null);
    }

    private HttpRequest buildRequest(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration, String api, String requestBody) {
        String endpoint = configuration.get(ConfigurationKeys.SAFERPAY_LIVE_MODE).getValueAsBooleanOrDefault() ? LIVE_ENDPOINT : TEST_ENDPOINT;
        return HttpRequest.newBuilder().uri(URI.create(endpoint + api)).header("Authorization", "Basic " + this.authorizationHeader(configuration)).header("Content-Type", "application/json; charset=utf-8").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
    }

    private Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> loadConfiguration(PurchaseContext purchaseContext) {
        return this.configurationManager.getFor(EnumSet.of(ConfigurationKeys.SAFERPAY_ENABLED, new ConfigurationKeys[]{ConfigurationKeys.SAFERPAY_API_USERNAME, ConfigurationKeys.SAFERPAY_API_PASSWORD, ConfigurationKeys.SAFERPAY_CUSTOMER_ID, ConfigurationKeys.SAFERPAY_TERMINAL_ID, ConfigurationKeys.SAFERPAY_LIVE_MODE, ConfigurationKeys.BASE_URL, ConfigurationKeys.RESERVATION_TIMEOUT}), purchaseContext.getConfigurationLevel());
    }

    private String processPaymentInitializationResponse(HttpResponse<String> response, PaymentSpecification spec, int retryCount) {
        String reservationId = spec.getReservationId();
        JsonObject responseBody = JsonParser.parseString((String)response.body()).getAsJsonObject();
        String paymentToken = responseBody.get("Token").getAsString();
        ZonedDateTime expiration = ZonedDateTime.parse(responseBody.get("Expiration").getAsString());
        this.ticketReservationRepository.updateReservationStatus(reservationId, TicketReservation.TicketReservationStatus.EXTERNAL_PROCESSING_PAYMENT.toString());
        this.ticketReservationRepository.updateValidity(reservationId, Date.from(expiration.toInstant()));
        PaymentManagerUtils.invalidateExistingTransactions((String)reservationId, (TransactionRepository)this.transactionRepository);
        this.transactionRepository.insert(paymentToken, paymentToken, reservationId, ZonedDateTime.now(this.clockProvider.withZone(spec.getPurchaseContext().getZoneId())), spec.getPriceWithVAT(), spec.getPurchaseContext().getCurrency(), "Saferpay Payment", PaymentProxy.SAFERPAY.name(), 0L, 0L, Transaction.Status.PENDING, Map.of(RETRY_COUNT, String.valueOf(retryCount)));
        return responseBody.get("RedirectUrl").getAsString();
    }

    @ConstructorProperties(value={"configurationManager", "httpClient", "ticketReservationRepository", "transactionRepository", "ticketRepository", "clockProvider"})
    @Generated
    public SaferpayManager(ConfigurationManager configurationManager, HttpClient httpClient, TicketReservationRepository ticketReservationRepository, TransactionRepository transactionRepository, TicketRepository ticketRepository, ClockProvider clockProvider) {
        this.configurationManager = configurationManager;
        this.httpClient = httpClient;
        this.ticketReservationRepository = ticketReservationRepository;
        this.transactionRepository = transactionRepository;
        this.ticketRepository = ticketRepository;
        this.clockProvider = clockProvider;
    }
}

