/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.payment;

import alfio.manager.ExtensionManager;
import alfio.manager.payment.BaseStripeManager;
import alfio.manager.payment.OAuthPaymentProviderConnector;
import alfio.manager.payment.StripeConnectManager;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.model.system.Configuration;
import alfio.model.system.ConfigurationKeys;
import alfio.repository.TicketRepository;
import alfio.repository.system.ConfigurationRepository;
import alfio.util.Json;
import alfio.util.oauth2.AccessTokenResponseDetails;
import alfio.util.oauth2.AuthorizationRequestDetails;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class StripeConnectManager
implements OAuthPaymentProviderConnector {
    public static final String STRIPE_CONNECT_REDIRECT_PATH = "/admin/configuration/payment/stripe/authorize";
    private static final Logger log = LoggerFactory.getLogger(StripeConnectManager.class);
    private final ExtensionManager extensionManager;
    private final ConfigurationManager configurationManager;
    private final BaseStripeManager baseStripeManager;

    public StripeConnectManager(ExtensionManager extensionManager, ConfigurationManager configurationManager, ConfigurationRepository configurationRepository, TicketRepository ticketRepository, Environment environment) {
        this.extensionManager = extensionManager;
        this.configurationManager = configurationManager;
        this.baseStripeManager = new BaseStripeManager(configurationManager, configurationRepository, ticketRepository, environment);
    }

    public AuthorizationRequestDetails getConnectURL(int organizationId) {
        Map options = this.configurationManager.getFor(Set.of(ConfigurationKeys.STRIPE_CONNECT_CLIENT_ID, ConfigurationKeys.STRIPE_CONNECT_CALLBACK, ConfigurationKeys.BASE_URL), ConfigurationLevel.organization((int)organizationId));
        String clientId = ((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.STRIPE_CONNECT_CLIENT_ID)).getRequiredValue();
        String callbackURL = ((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.STRIPE_CONNECT_CALLBACK)).getValueOrDefault(((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.BASE_URL)).getRequiredValue() + STRIPE_CONNECT_REDIRECT_PATH);
        String state = this.extensionManager.generateOAuth2StateParam(organizationId).orElse(UUID.randomUUID().toString());
        return new AuthorizationRequestDetails(new StripeConnectApi().getAuthorizationUrl("code", clientId, callbackURL, "read_write", state, Collections.emptyMap()), state);
    }

    public AccessTokenResponseDetails storeConnectedAccountId(String code, int organizationId) {
        try {
            String clientSecret = this.baseStripeManager.getSystemSecretKey();
            OAuth20Service service = new ServiceBuilder(clientSecret).apiSecret(clientSecret).build((DefaultApi20)new StripeConnectApi());
            Map token = (Map)Json.fromJson((String)service.getAccessToken(code).getRawResponse(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            String accountId = (String)token.get("stripe_user_id");
            if (accountId != null) {
                this.configurationManager.saveConfig(Configuration.from((int)organizationId, (ConfigurationKeys)ConfigurationKeys.STRIPE_CONNECTED_ID), accountId);
            }
            return new AccessTokenResponseDetails(accountId, null, (String)token.get("error_message"), accountId != null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Request interrupted while retrieving access token", (Throwable)e);
            return new AccessTokenResponseDetails(null, null, e.getMessage(), false);
        }
        catch (Exception e) {
            log.error("cannot retrieve account ID", (Throwable)e);
            return new AccessTokenResponseDetails(null, null, e.getMessage(), false);
        }
    }
}

