/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.payment;

import alfio.manager.payment.BaseStripeManager;
import alfio.manager.payment.PaymentManagerUtils;
import alfio.manager.payment.PaymentSpecification;
import alfio.manager.support.PaymentResult;
import alfio.manager.system.ConfigurationManager;
import alfio.model.PaymentInformation;
import alfio.model.PurchaseContext;
import alfio.model.system.ConfigurationKeys;
import alfio.model.transaction.PaymentContext;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.PaymentProvider;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.PaymentToken;
import alfio.model.transaction.Transaction;
import alfio.model.transaction.TransactionRequest;
import alfio.model.transaction.capabilities.ClientServerTokenRequest;
import alfio.model.transaction.capabilities.PaymentInfo;
import alfio.model.transaction.capabilities.RefundRequest;
import alfio.model.transaction.token.StripeCreditCardToken;
import alfio.repository.TicketRepository;
import alfio.repository.TransactionRepository;
import alfio.repository.system.ConfigurationRepository;
import alfio.util.ClockProvider;
import com.stripe.exception.StripeException;
import java.time.ZonedDateTime;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class StripeCreditCardManager
implements PaymentProvider,
ClientServerTokenRequest,
RefundRequest,
PaymentInfo {
    public static final String STRIPE_UNEXPECTED = "error.STEP2_STRIPE_unexpected";
    private static final Logger log = LoggerFactory.getLogger(StripeCreditCardManager.class);
    private static final String STRIPE_MANAGER = StripeCreditCardManager.class.getName();
    protected static final EnumSet<ConfigurationKeys> OPTIONS_TO_LOAD = EnumSet.of(ConfigurationKeys.STRIPE_ENABLE_SCA, ConfigurationKeys.STRIPE_SECRET_KEY, ConfigurationKeys.STRIPE_PUBLIC_KEY);
    private final TransactionRepository transactionRepository;
    private final BaseStripeManager baseStripeManager;
    private final ClockProvider clockProvider;

    @Autowired
    public StripeCreditCardManager(ConfigurationManager configurationManager, TicketRepository ticketRepository, TransactionRepository transactionRepository, ConfigurationRepository configurationRepository, Environment environment, ClockProvider clockProvider) {
        this(transactionRepository, new BaseStripeManager(configurationManager, configurationRepository, ticketRepository, environment), clockProvider);
    }

    StripeCreditCardManager(TransactionRepository transactionRepository, BaseStripeManager baseStripeManager, ClockProvider clockProvider) {
        this.transactionRepository = transactionRepository;
        this.baseStripeManager = baseStripeManager;
        this.clockProvider = clockProvider;
    }

    public Optional<Boolean> processWebhookEvent(String body, String signature) {
        return this.baseStripeManager.processWebhookEvent(body, signature);
    }

    public PaymentResult getToken(PaymentSpecification spec) {
        return this.baseStripeManager.getToken(spec);
    }

    public Optional<PaymentInformation> getInfo(Transaction transaction, PurchaseContext purchaseContext) {
        return this.baseStripeManager.getInfo(transaction, purchaseContext);
    }

    public boolean refund(Transaction transaction, PurchaseContext purchaseContext, Integer amountToRefund) {
        return this.baseStripeManager.refund(transaction, purchaseContext, amountToRefund);
    }

    public Map<String, ?> getModelOptions(PaymentContext context) {
        return this.baseStripeManager.getModelOptions(context);
    }

    public Set<PaymentMethod> getSupportedPaymentMethods(PaymentContext paymentContext, TransactionRequest transactionRequest) {
        if (!this.isActive(paymentContext)) {
            return EnumSet.noneOf(PaymentMethod.class);
        }
        return EnumSet.of(PaymentMethod.CREDIT_CARD);
    }

    public PaymentProxy getPaymentProxy() {
        return PaymentProxy.STRIPE;
    }

    public boolean accept(PaymentMethod paymentMethod, PaymentContext context, TransactionRequest transactionRequest) {
        return this.baseStripeManager.accept(paymentMethod, context, OPTIONS_TO_LOAD, arg_0 -> this.checkConfiguration(arg_0));
    }

    private boolean checkConfiguration(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> config) {
        return !config.get(ConfigurationKeys.STRIPE_ENABLE_SCA).getValueAsBooleanOrDefault() && config.get(ConfigurationKeys.STRIPE_SECRET_KEY).isPresent() && config.get(ConfigurationKeys.STRIPE_PUBLIC_KEY).isPresent();
    }

    public boolean accept(Transaction transaction) {
        boolean hasMetadata = !transaction.getMetadata().isEmpty();
        boolean isCCManager = STRIPE_MANAGER.equals(transaction.getMetadata().get("stripeManagerType")) || transaction.getMetadata().get("clientSecret") == null;
        return transaction.getPaymentProxy() == PaymentProxy.STRIPE && (!hasMetadata || isCCManager);
    }

    public PaymentMethod getPaymentMethodForTransaction(Transaction transaction) {
        return PaymentMethod.CREDIT_CARD;
    }

    public boolean isActive(PaymentContext paymentContext) {
        return this.baseStripeManager.isActive(paymentContext, OPTIONS_TO_LOAD, arg_0 -> this.checkConfiguration(arg_0));
    }

    public PaymentResult doPayment(PaymentSpecification spec) {
        try {
            Optional optionalCharge = this.baseStripeManager.chargeCreditCard(spec);
            return optionalCharge.map(charge -> {
                log.info("transaction {} paid: {}", (Object)spec.getReservationId(), (Object)charge.getPaid());
                Pair fees = Optional.ofNullable(charge.getBalanceTransactionObject()).map(bt -> {
                    List feeDetails = bt.getFeeDetails();
                    return Pair.of((Object)Optional.ofNullable(BaseStripeManager.getFeeAmount((List)feeDetails, (String)"application_fee")).map(Long::parseLong).orElse(0L), (Object)Optional.ofNullable(BaseStripeManager.getFeeAmount((List)feeDetails, (String)"stripe_fee")).map(Long::parseLong).orElse(0L));
                }).orElse(null);
                PaymentManagerUtils.invalidateExistingTransactions((String)spec.getReservationId(), (TransactionRepository)this.transactionRepository);
                this.transactionRepository.insert(charge.getId(), null, spec.getReservationId(), ZonedDateTime.now(this.clockProvider.withZone(spec.getPurchaseContext().getZoneId())), spec.getPriceWithVAT(), spec.getPurchaseContext().getCurrency(), charge.getDescription(), PaymentProxy.STRIPE.name(), fees != null ? (Long)fees.getLeft() : 0L, fees != null ? (Long)fees.getRight() : 0L, Transaction.Status.COMPLETE, Map.of("stripeManagerType", STRIPE_MANAGER));
                return PaymentResult.successful((String)charge.getId());
            }).orElseGet(() -> PaymentResult.failed((String)"error.STEP2_UNABLE_TO_TRANSITION"));
        }
        catch (StripeException e) {
            return PaymentResult.failed((String)this.baseStripeManager.handleException(e));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public PaymentToken buildPaymentToken(String clientToken, PaymentContext context) {
        return new StripeCreditCardToken(clientToken);
    }
}

