/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.payment;

import alfio.manager.payment.BaseStripeManager;
import alfio.manager.payment.PaymentManagerUtils;
import alfio.manager.payment.PaymentSpecification;
import alfio.manager.payment.StripeWebhookPaymentManager;
import alfio.manager.support.PaymentResult;
import alfio.manager.support.PaymentWebhookResult;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.model.Audit;
import alfio.model.Configurable;
import alfio.model.PaymentInformation;
import alfio.model.PurchaseContext;
import alfio.model.TicketReservation;
import alfio.model.system.ConfigurationKeys;
import alfio.model.transaction.PaymentContext;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.PaymentProvider;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.PaymentToken;
import alfio.model.transaction.Transaction;
import alfio.model.transaction.TransactionInitializationToken;
import alfio.model.transaction.TransactionRequest;
import alfio.model.transaction.TransactionWebhookPayload;
import alfio.model.transaction.capabilities.ClientServerTokenRequest;
import alfio.model.transaction.capabilities.PaymentInfo;
import alfio.model.transaction.capabilities.RefundRequest;
import alfio.model.transaction.capabilities.ServerInitiatedTransaction;
import alfio.model.transaction.capabilities.WebhookHandler;
import alfio.model.transaction.token.StripeSCACreditCardToken;
import alfio.model.transaction.webhook.StripeChargeTransactionWebhookPayload;
import alfio.model.transaction.webhook.StripePaymentIntentWebhookPayload;
import alfio.repository.AuditingRepository;
import alfio.repository.EventRepository;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import alfio.repository.TransactionRepository;
import alfio.repository.system.ConfigurationRepository;
import alfio.util.ClockProvider;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stripe.exception.StripeException;
import com.stripe.model.Charge;
import com.stripe.model.Event;
import com.stripe.model.EventDataObjectDeserializer;
import com.stripe.model.PaymentIntent;
import com.stripe.model.StripeObject;
import com.stripe.net.HttpHeaders;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponse;
import com.stripe.net.Webhook;
import java.io.Reader;
import java.io.StringReader;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class StripeWebhookPaymentManager
implements PaymentProvider,
RefundRequest,
PaymentInfo,
WebhookHandler,
ClientServerTokenRequest,
ServerInitiatedTransaction {
    private static final Logger log = LoggerFactory.getLogger(StripeWebhookPaymentManager.class);
    private static final String STRIPE_MANAGER = StripeWebhookPaymentManager.class.getName();
    static final String CLIENT_SECRET_METADATA = "clientSecret";
    private static final String PAYMENT_INTENT_SUCCEEDED = "payment_intent.succeeded";
    private static final String PAYMENT_INTENT_PAYMENT_FAILED = "payment_intent.payment_failed";
    private static final String PAYMENT_INTENT_CREATED = "payment_intent.created";
    private static final EnumSet<ConfigurationKeys> OPTIONS_TO_LOAD = EnumSet.of(ConfigurationKeys.STRIPE_ENABLE_SCA, ConfigurationKeys.BASE_URL, ConfigurationKeys.STRIPE_WEBHOOK_PAYMENT_KEY);
    private static final String REQUIRES_PAYMENT_METHOD = "requires_payment_method";
    private final ConfigurationManager configurationManager;
    private final BaseStripeManager baseStripeManager;
    private final TransactionRepository transactionRepository;
    private final TicketReservationRepository ticketReservationRepository;
    private final EventRepository eventRepository;
    private final AuditingRepository auditingRepository;
    private final ClockProvider clockProvider;
    private final List<String> interestingEventTypes = List.of("payment_intent.succeeded", "payment_intent.payment_failed", "payment_intent.created");
    private final Set<String> cancellableStatuses = Set.of("requires_payment_method", "requires_confirmation", "requires_action");

    @Autowired
    public StripeWebhookPaymentManager(ConfigurationManager configurationManager, TicketRepository ticketRepository, TransactionRepository transactionRepository, ConfigurationRepository configurationRepository, TicketReservationRepository ticketReservationRepository, EventRepository eventRepository, AuditingRepository auditingRepository, Environment environment, ClockProvider clockProvider) {
        this(configurationManager, transactionRepository, ticketReservationRepository, eventRepository, auditingRepository, clockProvider, new BaseStripeManager(configurationManager, configurationRepository, ticketRepository, environment));
    }

    StripeWebhookPaymentManager(ConfigurationManager configurationManager, TransactionRepository transactionRepository, TicketReservationRepository ticketReservationRepository, EventRepository eventRepository, AuditingRepository auditingRepository, ClockProvider clockProvider, BaseStripeManager baseStripeManager) {
        this.configurationManager = configurationManager;
        this.transactionRepository = transactionRepository;
        this.ticketReservationRepository = ticketReservationRepository;
        this.eventRepository = eventRepository;
        this.auditingRepository = auditingRepository;
        this.baseStripeManager = baseStripeManager;
        this.clockProvider = clockProvider;
    }

    public TransactionInitializationToken initTransaction(PaymentSpecification paymentSpecification, Map<String, List<String>> params) {
        String reservationId = paymentSpecification.getReservationId();
        return this.transactionRepository.loadOptionalByReservationId(reservationId).map(transaction -> {
            if (transaction.getStatus() == Transaction.Status.PENDING) {
                return this.buildTokenFromTransaction(transaction, paymentSpecification.getPurchaseContext(), true);
            }
            return this.errorToken("Reload reservation", true);
        }).orElseGet(() -> this.createNewToken(paymentSpecification));
    }

    public TransactionInitializationToken errorToken(String errorMessage, boolean reservationStatusChanged) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public boolean discardTransaction(Transaction transaction, PurchaseContext purchaseContext) {
        String paymentId = transaction.getPaymentId();
        try {
            RequestOptions requestOptions = (RequestOptions)this.baseStripeManager.options(purchaseContext).orElseThrow();
            PaymentIntent paymentIntent = PaymentIntent.retrieve((String)paymentId, (RequestOptions)requestOptions);
            if (this.cancellableStatuses.contains(paymentIntent.getStatus())) {
                paymentIntent.cancel(requestOptions);
                return true;
            }
            log.warn("An attempt to cancel a non-cancellable Payment Intent has been detected for reservation ID {}, PaymentIntent ID {}", (Object)transaction.getReservationId(), (Object)transaction.getPaymentId());
        }
        catch (StripeException e) {
            log.warn("got Stripe error while trying to cancel transaction", (Throwable)e);
        }
        return false;
    }

    private TransactionInitializationToken buildTokenFromTransaction(Transaction transaction, PurchaseContext purchaseContext, boolean performRemoteVerification) {
        String chargeId;
        String clientSecret = Optional.ofNullable(transaction.getMetadata()).map(m -> (String)m.get(CLIENT_SECRET_METADATA)).orElse(null);
        String string = chargeId = transaction.getStatus() == Transaction.Status.COMPLETE ? transaction.getTransactionId() : null;
        if (performRemoteVerification && transaction.getStatus() == Transaction.Status.PENDING) {
            try {
                RequestOptions requestOptions = (RequestOptions)this.baseStripeManager.options(purchaseContext).orElseThrow();
                PaymentIntent paymentIntent = PaymentIntent.retrieve((String)transaction.getPaymentId(), (RequestOptions)requestOptions);
                String status = paymentIntent.getStatus();
                if (status.equals("succeeded")) {
                    log.info("marking reservation {} as paid, because PaymentIntent reports success", (Object)transaction.getReservationId());
                    this.processSuccessfulPaymentIntent(transaction, paymentIntent, this.ticketReservationRepository.findReservationById(transaction.getReservationId()), purchaseContext, requestOptions);
                    return this.errorToken("Reservation status changed", true);
                }
                if (!status.equals(REQUIRES_PAYMENT_METHOD)) {
                    return this.errorToken("Payment in process", true);
                }
            }
            catch (StripeException e) {
                throw new IllegalStateException(e);
            }
        }
        return new StripeSCACreditCardToken(transaction.getPaymentId(), chargeId, clientSecret);
    }

    private StripeSCACreditCardToken createNewToken(PaymentSpecification paymentSpecification) {
        Map baseMetadata = this.configurationManager.getFor(ConfigurationKeys.BASE_URL, paymentSpecification.getPurchaseContext().getConfigurationLevel()).getValue().map(baseUrl -> Map.of("alfioBaseUrl", baseUrl)).orElse(Map.of());
        Map paymentIntentParams = this.baseStripeManager.createParams(paymentSpecification, baseMetadata);
        paymentIntentParams.put("payment_method_types", List.of("card"));
        try {
            RequestOptions options = (RequestOptions)this.baseStripeManager.options(paymentSpecification.getPurchaseContext(), builder -> builder.setIdempotencyKey(paymentSpecification.getReservationId())).orElseThrow();
            PaymentIntent intent = PaymentIntent.create((Map)paymentIntentParams, (RequestOptions)options);
            String clientSecret = intent.getClientSecret();
            long platformFee = paymentIntentParams.containsKey("application_fee") ? (Long)paymentIntentParams.get("application_fee") : 0L;
            PaymentManagerUtils.invalidateExistingTransactions((String)paymentSpecification.getReservationId(), (TransactionRepository)this.transactionRepository);
            this.transactionRepository.insert(intent.getId(), intent.getId(), paymentSpecification.getReservationId(), ZonedDateTime.now(this.clockProvider.withZone(paymentSpecification.getPurchaseContext().getZoneId())), paymentSpecification.getPriceWithVAT(), paymentSpecification.getPurchaseContext().getCurrency(), "Payment Intent", PaymentProxy.STRIPE.name(), platformFee, 0L, Transaction.Status.PENDING, Map.of(CLIENT_SECRET_METADATA, clientSecret, "stripeManagerType", STRIPE_MANAGER));
            return new StripeSCACreditCardToken(intent.getId(), null, clientSecret);
        }
        catch (StripeException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getWebhookSignatureKey(ConfigurationLevel configurationLevel) {
        return this.configurationManager.getFor(ConfigurationKeys.STRIPE_WEBHOOK_PAYMENT_KEY, configurationLevel).getRequiredValue();
    }

    public Optional<TransactionWebhookPayload> parseTransactionPayload(String body, String signature, Map<String, String> additionalInfo, PaymentContext paymentContext) {
        try {
            Event stripeEvent = Webhook.constructEvent((String)body, (String)signature, (String)this.getWebhookSignatureKey(paymentContext.getConfigurationLevel()));
            String eventType = stripeEvent.getType();
            if (eventType.startsWith("charge.")) {
                return this.deserializeObject(stripeEvent, body).map(obj -> new StripeChargeTransactionWebhookPayload(eventType, (Charge)obj));
            }
            if (eventType.startsWith("payment_intent.")) {
                return this.deserializeObject(stripeEvent, body).map(obj -> new StripePaymentIntentWebhookPayload(eventType, (PaymentIntent)obj));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            log.error("got exception while handling stripe webhook", (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<StripeObject> deserializeObject(Event stripeEvent, String rawJson) {
        EventDataObjectDeserializer dataObjectDeserializer = stripeEvent.getDataObjectDeserializer();
        Optional cleanDeserialization = dataObjectDeserializer.getObject();
        if (cleanDeserialization.isPresent()) {
            return cleanDeserialization;
        }
        log.warn("unable to deserialize payload. Expected version {}, actual {}, falling back to unsafe deserialization", (Object)"2024-04-10", (Object)stripeEvent.getApiVersion());
        try {
            return Optional.ofNullable(dataObjectDeserializer.deserializeUnsafe()).map(stripeObject -> {
                if (stripeObject.getLastResponse() == null && "2022-11-15".compareTo(stripeEvent.getApiVersion()) > 0) {
                    log.debug("API version requires raw JSON body. Forcing 'lastResponse' property");
                    stripeObject.setLastResponse(new StripeResponse(200, HttpHeaders.of(Map.of()), rawJson));
                }
                return stripeObject;
            });
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot deserialize webhook event.", e);
        }
    }

    public PaymentWebhookResult processWebhook(TransactionWebhookPayload payload, Transaction transaction, PaymentContext paymentContext) {
        if (!this.interestingEventTypes.contains(payload.getType())) {
            return PaymentWebhookResult.notRelevant((String)payload.getType());
        }
        boolean live = Boolean.TRUE.equals(((PaymentIntent)payload.getPayload()).getLivemode());
        if (!this.baseStripeManager.getSecretKey((Configurable)paymentContext.getPurchaseContext()).startsWith(live ? "sk_live_" : "sk_test_")) {
            String description = live ? "live" : "test";
            log.warn("received a {} event of type {}, which is not compatible with the current configuration", (Object)description, (Object)payload.getType());
            return PaymentWebhookResult.notRelevant((String)description);
        }
        try {
            PaymentIntent paymentIntent = (PaymentIntent)payload.getPayload();
            Optional<TicketReservation> optionalReservation = this.ticketReservationRepository.findOptionalReservationById((String)paymentIntent.getMetadata().get("reservationId")).filter(reservation -> reservation.getStatus() == TicketReservation.TicketReservationStatus.EXTERNAL_PROCESSING_PAYMENT || reservation.getStatus() == TicketReservation.TicketReservationStatus.WAITING_EXTERNAL_CONFIRMATION);
            if (optionalReservation.isEmpty()) {
                return PaymentWebhookResult.error((String)"reservation not found");
            }
            TicketReservation reservation2 = optionalReservation.get();
            PurchaseContext purchaseContext = paymentContext.getPurchaseContext();
            return switch (payload.getType()) {
                case PAYMENT_INTENT_CREATED -> PaymentWebhookResult.processStarted((PaymentToken)this.buildTokenFromTransaction(transaction, purchaseContext, false));
                case PAYMENT_INTENT_SUCCEEDED -> this.processSuccessfulPaymentIntent(transaction, paymentIntent, reservation2, purchaseContext, (RequestOptions)this.baseStripeManager.options(purchaseContext).orElseThrow());
                case PAYMENT_INTENT_PAYMENT_FAILED -> this.processFailedPaymentIntent(transaction, reservation2, purchaseContext);
                default -> PaymentWebhookResult.notRelevant((String)"event is not relevant");
            };
        }
        catch (Exception e) {
            log.error("Error while trying to confirm the reservation", (Throwable)e);
            return PaymentWebhookResult.error((String)"unexpected error");
        }
    }

    private PaymentWebhookResult processFailedPaymentIntent(Transaction transaction, TicketReservation reservation, PurchaseContext purchaseContext) {
        List<Map<String, String>> modifications = List.of(Map.of("paymentId", transaction.getPaymentId(), "paymentMethod", "stripe"));
        this.auditingRepository.insert(reservation.getId(), null, purchaseContext, Audit.EventType.PAYMENT_FAILED, new Date(), Audit.EntityType.RESERVATION, reservation.getId(), modifications);
        return PaymentWebhookResult.failed((String)"Charge has been reset by Stripe. This is usually caused by a rejection from the customer's bank");
    }

    private PaymentWebhookResult processSuccessfulPaymentIntent(Transaction transaction, PaymentIntent paymentIntent, TicketReservation reservation, PurchaseContext purchaseContext, RequestOptions requestOptions) throws StripeException {
        ChargeIdAndFees chargeAndFees = this.retrieveChargeIdAndFees(paymentIntent, requestOptions);
        String chargeId = chargeAndFees.getChargeId();
        this.transactionRepository.lockByIdForUpdate(Integer.valueOf(transaction.getId()));
        int affectedRows = this.transactionRepository.updateIfStatus(transaction.getId(), chargeId, transaction.getPaymentId(), purchaseContext.now(this.clockProvider), transaction.getPlatformFee(), chargeAndFees.getFeesOrZero(), Transaction.Status.COMPLETE, Map.of(), Transaction.Status.PENDING);
        List<Map<String, String>> modifications = List.of(Map.of("paymentId", chargeId, "paymentMethod", "stripe"));
        if (affectedRows == 0) {
            this.auditingRepository.insert(reservation.getId(), null, purchaseContext, Audit.EventType.PAYMENT_ALREADY_CONFIRMED, new Date(), Audit.EntityType.RESERVATION, reservation.getId(), modifications);
            return PaymentWebhookResult.successful((PaymentToken)new StripeSCACreditCardToken(transaction.getPaymentId(), chargeId, null));
        }
        this.auditingRepository.insert(reservation.getId(), null, purchaseContext, Audit.EventType.PAYMENT_CONFIRMED, new Date(), Audit.EntityType.RESERVATION, reservation.getId(), modifications);
        return PaymentWebhookResult.successful((PaymentToken)new StripeSCACreditCardToken(transaction.getPaymentId(), chargeId, null));
    }

    private ChargeIdAndFees retrieveChargeIdAndFees(PaymentIntent paymentIntent, RequestOptions requestOptions) throws StripeException {
        String chargeId = paymentIntent.getLatestCharge();
        String balanceTransactionId = null;
        long fees = 0L;
        if (chargeId == null) {
            JsonObject jsonObject = paymentIntent.getRawJsonObject();
            JsonObject chargesContainer = Objects.requireNonNull(jsonObject.getAsJsonObject("data").getAsJsonObject("object").getAsJsonObject("charges"), "data -> object -> charges is null!");
            JsonObject latestCharge = Objects.requireNonNull(chargesContainer.getAsJsonArray("data").get(0), "charges is empty!").getAsJsonObject();
            chargeId = Objects.requireNonNull(latestCharge.get("id"), "charges array is empty!").getAsString();
            if (latestCharge.has("balance_transaction")) {
                balanceTransactionId = latestCharge.get("balance_transaction").getAsString();
            }
        }
        if (balanceTransactionId == null) {
            Charge charge = this.baseStripeManager.retrieveCharge(chargeId, requestOptions);
            balanceTransactionId = charge.getBalanceTransaction();
        }
        if (balanceTransactionId != null) {
            fees = this.baseStripeManager.retrieveBalanceTransaction(balanceTransactionId, requestOptions).getFee();
        }
        return new ChargeIdAndFees(chargeId, Long.valueOf(fees));
    }

    public boolean accept(PaymentMethod paymentMethod, PaymentContext context, TransactionRequest transactionRequest) {
        return this.baseStripeManager.accept(paymentMethod, context, OPTIONS_TO_LOAD, arg_0 -> this.isConfigurationValid(arg_0));
    }

    private boolean isConfigurationValid(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration) {
        return configuration.get(ConfigurationKeys.BASE_URL).isPresent() && configuration.get(ConfigurationKeys.STRIPE_WEBHOOK_PAYMENT_KEY).isPresent() && configuration.get(ConfigurationKeys.STRIPE_ENABLE_SCA).getValueAsBooleanOrDefault();
    }

    public Set<PaymentMethod> getSupportedPaymentMethods(PaymentContext paymentContext, TransactionRequest transactionRequest) {
        if (!this.isActive(paymentContext)) {
            return EnumSet.noneOf(PaymentMethod.class);
        }
        return EnumSet.of(PaymentMethod.CREDIT_CARD);
    }

    public PaymentProxy getPaymentProxy() {
        return PaymentProxy.STRIPE;
    }

    public boolean accept(Transaction transaction) {
        boolean isWebHookManager = STRIPE_MANAGER.equals(transaction.getMetadata().get("stripeManagerType")) || transaction.getMetadata().get(CLIENT_SECRET_METADATA) != null;
        return transaction.getPaymentProxy() == PaymentProxy.STRIPE && isWebHookManager;
    }

    public PaymentMethod getPaymentMethodForTransaction(Transaction transaction) {
        return PaymentMethod.CREDIT_CARD;
    }

    public boolean isActive(PaymentContext paymentContext) {
        return this.baseStripeManager.isActive(paymentContext, OPTIONS_TO_LOAD, arg_0 -> this.isConfigurationValid(arg_0));
    }

    public PaymentResult doPayment(PaymentSpecification spec) {
        Optional optionalTransaction = this.transactionRepository.loadOptionalByReservationId(spec.getReservationId());
        if (optionalTransaction.isEmpty()) {
            return PaymentResult.failed((String)"error.STEP2_STRIPE_unexpected");
        }
        Transaction transaction = (Transaction)optionalTransaction.get();
        return transaction.getStatus() == Transaction.Status.COMPLETE ? PaymentResult.successful((String)transaction.getTransactionId()) : PaymentResult.initialized((String)transaction.getPaymentId());
    }

    public Optional<PaymentInformation> getInfo(Transaction transaction, PurchaseContext purchaseContext) {
        return this.baseStripeManager.getInfo(transaction, purchaseContext);
    }

    public boolean refund(Transaction transaction, PurchaseContext purchaseContext, Integer amount) {
        return this.baseStripeManager.refund(transaction, purchaseContext, amount);
    }

    public PaymentToken buildPaymentToken(String clientToken, PaymentContext paymentContext) {
        String reservationId = (String)paymentContext.getReservationId().orElseThrow();
        Optional optionalTransaction = this.transactionRepository.loadOptionalByReservationId(reservationId);
        return new StripeSCACreditCardToken((String)optionalTransaction.map(Transaction::getPaymentId).orElse(null), clientToken, null);
    }

    public Map<String, ?> getModelOptions(PaymentContext context) {
        HashMap<String, Boolean> baseOptions = new HashMap<String, Boolean>(this.baseStripeManager.getModelOptions(context));
        Optional connectedAccountOptional = this.baseStripeManager.getConnectedAccount(context);
        baseOptions.put("platformMode", connectedAccountOptional.isPresent());
        connectedAccountOptional.ifPresent(account -> baseOptions.put("stripeConnectedAccount", (Boolean)account));
        return baseOptions;
    }

    public PaymentWebhookResult forceTransactionCheck(TicketReservation reservation, Transaction transaction, PaymentContext paymentContext) {
        Validate.isTrue((transaction.getPaymentProxy() == PaymentProxy.STRIPE ? 1 : 0) != 0, (String)"invalid transaction", (Object[])new Object[0]);
        try {
            PurchaseContext purchaseContext = paymentContext.getPurchaseContext();
            RequestOptions options = (RequestOptions)this.baseStripeManager.options(purchaseContext, builder -> builder.setIdempotencyKey(reservation.getId())).orElseThrow();
            PaymentIntent intent = PaymentIntent.retrieve((String)transaction.getPaymentId(), (RequestOptions)options);
            return switch (intent.getStatus()) {
                case "processing", "requires_action", "requires_confirmation" -> PaymentWebhookResult.pending();
                case "succeeded" -> this.processSuccessfulPaymentIntent(transaction, intent, reservation, purchaseContext, options);
                case REQUIRES_PAYMENT_METHOD -> this.processFailedPaymentIntent(transaction, reservation, purchaseContext);
                default -> null;
            };
        }
        catch (Exception ex) {
            log.error("Error trying to check PaymentIntent status", (Throwable)ex);
            return PaymentWebhookResult.error((String)"failed");
        }
    }

    public Optional<PaymentContext> detectPaymentContext(String payload) {
        StringReader stringReader = new StringReader(payload);
        try {
            String reservationId = JsonParser.parseReader((Reader)stringReader).getAsJsonObject().getAsJsonObject("data").getAsJsonObject("object").getAsJsonObject("metadata").get("reservationId").getAsString();
            alfio.model.Event event = this.eventRepository.findByReservationId(reservationId);
            Optional<PaymentContext> optional = Optional.of(new PaymentContext((PurchaseContext)event, reservationId));
            stringReader.close();
            return optional;
        }
        catch (Throwable throwable) {
            try {
                try {
                    stringReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                log.warn("Cannot detect PaymentContext from the webhook body. Using a generic one", (Throwable)ex);
                return Optional.empty();
            }
        }
    }
}

