/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.payment.saferpay;

import alfio.manager.payment.PaymentSpecification;
import alfio.manager.payment.saferpay.RequestHeaderBuilder;
import alfio.model.transaction.PaymentMethod;
import com.google.gson.stream.JsonWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class PaymentPageInitializeRequestBuilder {
    public static final String WEBHOOK_URL_TEMPLATE = "/api/payment/webhook/saferpay/reservation/{reservationId}/success";
    public static final String SUCCESS_URL_TEMPLATE = "/{purchaseContextType}/{purchaseContextIdentifier}/reservation/{reservationId}";
    public static final String CANCEL_URL_TEMPLATE = "/{purchaseContextType}/{purchaseContextIdentifier}/reservation/{reservationId}/payment/saferpay/cancel";
    static final Set<String> SUPPORTED_METHODS = Set.of(PaymentMethod.ALIPAY.name(), "AMEX", "VISA", "VPAY", "DINERS", "BONUS", "JCB", "MAESTRO", "MASTERCARD", "POSTCARD", PaymentMethod.POSTFINANCE.name(), PaymentMethod.TWINT.name());
    private String customerId;
    private String requestId;
    private int retryIndicator;
    private String terminalId;
    private String formattedAmount;
    private String currencyCode;
    private String orderId;
    private String description;
    private final String successURL;
    private final String failureURL;
    private final String notifyURL;

    public PaymentPageInitializeRequestBuilder(String baseUrl, PaymentSpecification paymentSpecification) {
        String cleanBaseUrl = StringUtils.removeEnd((String)baseUrl, (String)"/");
        String purchaseContextType = paymentSpecification.getPurchaseContext().getType().getUrlComponent();
        String purchaseContextIdentifier = paymentSpecification.getPurchaseContext().getPublicIdentifier();
        String reservationId = paymentSpecification.getReservationId();
        String eventUrl = cleanBaseUrl + this.expandUriTemplate(SUCCESS_URL_TEMPLATE, purchaseContextType, purchaseContextIdentifier, reservationId);
        this.successURL = eventUrl + "/book";
        this.failureURL = cleanBaseUrl + this.expandUriTemplate(CANCEL_URL_TEMPLATE, purchaseContextType, purchaseContextIdentifier, reservationId);
        this.notifyURL = cleanBaseUrl + this.expandUriTemplate(WEBHOOK_URL_TEMPLATE, reservationId);
    }

    public PaymentPageInitializeRequestBuilder addAuthentication(String customerId, String requestId, String terminalId) {
        this.customerId = customerId;
        this.requestId = requestId;
        this.terminalId = terminalId;
        return this;
    }

    public PaymentPageInitializeRequestBuilder addOrderInformation(String orderId, String formattedAmount, String currencyCode, String description, int numTry) {
        this.orderId = orderId;
        this.formattedAmount = formattedAmount;
        this.currencyCode = currencyCode;
        this.description = description;
        this.retryIndicator = numTry;
        return this;
    }

    public String build() {
        StringWriter out = new StringWriter();
        RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder(this.customerId, this.requestId, Integer.valueOf(this.retryIndicator));
        try (JsonWriter writer = new JsonWriter((Writer)out);){
            this.addPaymentMethods(requestHeaderBuilder.appendTo(writer.beginObject()).name("TerminalId").value(this.terminalId).name("Payment").beginObject().name("Amount").beginObject().name("Value").value(this.formattedAmount).name("CurrencyCode").value(this.currencyCode).endObject().name("OrderId").value(this.orderId).name("Description").value(this.description).endObject().name("ReturnUrls").beginObject().name("Success").value(this.successURL).name("Fail").value(this.failureURL).endObject().name("Notification").beginObject().name("NotifyUrl").value(this.notifyURL).endObject()).endObject();
        }
        return out.toString();
    }

    private JsonWriter addPaymentMethods(JsonWriter writer) {
        JsonWriter array = writer.name("PaymentMethods").beginArray();
        for (String method : SUPPORTED_METHODS) {
            array.value(method);
        }
        return array.endArray();
    }

    private String expandUriTemplate(String template, String reservationId) {
        return UriComponentsBuilder.fromPath((String)template).buildAndExpand(new Object[]{reservationId}).toUriString();
    }

    private String expandUriTemplate(String template, String purchaseContextType, String purchaseContextIdentifier, String reservationId) {
        return UriComponentsBuilder.fromPath((String)template).buildAndExpand(new Object[]{purchaseContextType, purchaseContextIdentifier, reservationId}).toUriString();
    }
}

