/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.support;

import alfio.controller.api.support.AdditionalField;
import alfio.controller.api.support.AdditionalServiceWithData;
import alfio.controller.api.support.BookingInfoTicketLoader;
import alfio.controller.api.support.Field;
import alfio.manager.AdditionalServiceManager;
import alfio.manager.PurchaseContextFieldManager;
import alfio.model.AdditionalService;
import alfio.model.AdditionalServiceFieldValue;
import alfio.model.AdditionalServiceItem;
import alfio.model.AdditionalServiceText;
import alfio.model.Event;
import alfio.model.FieldConfigurationDescriptionAndValue;
import alfio.model.PurchaseContext;
import alfio.model.PurchaseContextFieldConfiguration;
import alfio.model.PurchaseContextFieldDescription;
import alfio.model.Ticket;
import alfio.repository.PurchaseContextFieldRepository;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class AdditionalServiceHelper {
    private final AdditionalServiceManager additionalServiceManager;
    private final PurchaseContextFieldRepository purchaseContextFieldRepository;
    private final PurchaseContextFieldManager purchaseContextFieldManager;

    public AdditionalServiceHelper(AdditionalServiceManager additionalServiceManager, PurchaseContextFieldRepository purchaseContextFieldRepository, PurchaseContextFieldManager purchaseContextFieldManager) {
        this.additionalServiceManager = additionalServiceManager;
        this.purchaseContextFieldRepository = purchaseContextFieldRepository;
        this.purchaseContextFieldManager = purchaseContextFieldManager;
    }

    public List<AdditionalServiceWithData> getAdditionalServicesWithData(PurchaseContext purchaseContext, List<AdditionalServiceItem> additionalServiceItems, Map<Integer, List<AdditionalServiceFieldValue>> valuesByItemId, Map<Long, List<PurchaseContextFieldDescription>> descriptionsByTicketFieldId, List<Ticket> tickets) {
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event) && ((Event)purchaseContext).supportsLinkedAdditionalServices()) {
            Event event = (Event)purchaseContext;
            if (!additionalServiceItems.isEmpty()) {
                List<Integer> additionalServiceIds = additionalServiceItems.stream().map(AdditionalServiceItem::getAdditionalServiceId).toList();
                Map additionalItemDescriptionsById = this.additionalServiceManager.getDescriptionsByAdditionalServiceIds(additionalServiceIds);
                Map additionalItemTypeById = this.additionalServiceManager.getTypeByIds(additionalServiceIds);
                Map<Integer, List<PurchaseContextFieldConfiguration>> additionalFieldsById = this.purchaseContextFieldRepository.findAdditionalFieldsForEvent(event.getId()).stream().filter(f -> f.getContext() == PurchaseContextFieldConfiguration.Context.ADDITIONAL_SERVICE && additionalServiceIds.contains(f.getAdditionalServiceId())).collect(Collectors.groupingBy(PurchaseContextFieldConfiguration::getAdditionalServiceId));
                return additionalServiceItems.stream().map(as -> {
                    Map additionalItemTitle = additionalItemDescriptionsById.getOrDefault(as.getAdditionalServiceId(), Map.of()).getOrDefault(AdditionalServiceText.TextType.TITLE, Collections.emptyMap());
                    Integer ticketId = as.getTicketId();
                    List itemValues = (List)valuesByItemId.get(as.getId());
                    List<AdditionalField> fields = additionalFieldsById.getOrDefault(as.getAdditionalServiceId(), List.of()).stream().map(fieldConfiguration -> {
                        Optional<AdditionalServiceFieldValue> value = Optional.empty();
                        if (itemValues != null) {
                            value = itemValues.stream().filter(fv -> fv.getTicketId() == ticketId.intValue() && fv.getFieldConfigurationId() == fieldConfiguration.getId()).findFirst();
                        }
                        String valueAsString = value.map(AdditionalServiceFieldValue::getValue).orElse("");
                        return AdditionalField.fromFieldConfiguration((PurchaseContextFieldConfiguration)fieldConfiguration, (String)valueAsString, List.of(new Field(0, valueAsString)), (boolean)FieldConfigurationDescriptionAndValue.isBeforeStandardFields((PurchaseContextFieldConfiguration)fieldConfiguration), (Map)BookingInfoTicketLoader.fromFieldDescriptions((List)((List)descriptionsByTicketFieldId.get(fieldConfiguration.getId()))));
                    }).toList();
                    String ticketUUID = tickets.stream().filter(t -> ticketId != null && t.getId() == ticketId.intValue()).map(t -> t.getPublicUuid().toString()).findFirst().orElse(null);
                    return new AdditionalServiceWithData(additionalItemTitle, as.getId(), Integer.valueOf(as.getAdditionalServiceId()), ticketUUID, fields, (AdditionalService.AdditionalServiceType)additionalItemTypeById.get(as.getAdditionalServiceId()));
                }).sorted(Comparator.comparing(AdditionalServiceWithData::getServiceId)).toList();
            }
        }
        return List.of();
    }

    public List<AdditionalServiceWithData> findForTicket(Ticket ticket, Event event) {
        if (!event.supportsLinkedAdditionalServices()) {
            return List.of();
        }
        List additionalServiceItems = this.additionalServiceManager.findItemsForTicket(ticket);
        Map additionalServicesByItemId = additionalServiceItems.isEmpty() ? Map.of() : this.purchaseContextFieldRepository.findAdditionalServicesValueByItemIds(additionalServiceItems.stream().map(AdditionalServiceItem::getId).toList()).stream().collect(Collectors.groupingBy(AdditionalServiceFieldValue::getAdditionalServiceItemId));
        Map descriptionsByTicketFieldId = this.purchaseContextFieldManager.findDescriptionsGroupedByFieldId((PurchaseContext)event);
        return this.getAdditionalServicesWithData((PurchaseContext)event, additionalServiceItems, additionalServicesByItemId, descriptionsByTicketFieldId, List.of(ticket));
    }
}

