/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.support;

import alfio.manager.EventManager;
import alfio.manager.ExtensionManager;
import alfio.manager.NotificationManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.system.Mailer;
import alfio.model.Configurable;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.EventCheckInInfo;
import alfio.model.PurchaseContext;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketReservation;
import alfio.model.modification.MessageModification;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Organization;
import alfio.repository.EventRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.util.EventUtil;
import alfio.util.Json;
import alfio.util.ReservationUtil;
import alfio.util.TemplateManager;
import alfio.util.TemplateResource;
import alfio.util.Validator;
import alfio.util.checkin.TicketCheckInUtil;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.ui.Model;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CustomMessageManager {
    private final TemplateManager templateManager;
    private final EventManager eventManager;
    private final TicketRepository ticketRepository;
    private final TicketReservationManager ticketReservationManager;
    private final NotificationManager notificationManager;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final Executor sendMessagesExecutor = Executors.newSingleThreadExecutor();
    private final ConfigurationManager configurationManager;
    private final MessageSourceManager messageSourceManager;
    private final ExtensionManager extensionManager;
    private final EventRepository eventRepository;

    public Map<String, Object> generatePreview(String eventName, Optional<Integer> categoryId, List<MessageModification> input, String username) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Event event = this.eventManager.getSingleEvent(eventName, username);
        result.put("affectedUsers", categoryId.map(id -> this.ticketRepository.countAssignedTickets(event.getId(), id.intValue())).orElseGet(() -> this.ticketRepository.countAllAssigned(event.getId())));
        result.put("preview", this.preview(event, input, username));
        return result;
    }

    public void sendMessages(String eventName, Optional<Integer> categoryId, List<MessageModification> input, String username) {
        Event event = this.eventManager.getSingleEvent(eventName, username);
        this.preview(event, input, username);
        Organization organization = this.eventManager.loadOrganizer((EventAndOrganizationId)event, username);
        Map<String, List<MessageModification>> byLanguage = input.stream().collect(Collectors.groupingBy(m -> m.getLocale().getLanguage()));
        Map categoriesById = this.ticketCategoryRepository.findByEventIdAsMap(event.getId());
        Map configuration = this.configurationManager.getFor(EnumSet.of(ConfigurationKeys.BASE_URL, ConfigurationKeys.ENABLE_WALLET, ConfigurationKeys.ENABLE_PASS, ConfigurationKeys.ENABLE_HTML_EMAILS), event.getConfigurationLevel());
        String baseUrl = ((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.BASE_URL)).getRequiredValue();
        boolean googleWalletEnabled = ((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.ENABLE_WALLET)).getValueAsBooleanOrDefault();
        boolean appleWalletEnabled = ((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.ENABLE_PASS)).getValueAsBooleanOrDefault();
        this.sendMessagesExecutor.execute(() -> {
            MessageSource messageSource = this.messageSourceManager.getMessageSourceFor((PurchaseContext)event);
            ((Stream)categoryId.map(id -> this.ticketRepository.findConfirmedByCategoryId(event.getId(), id.intValue())).orElseGet(() -> this.ticketRepository.findAllConfirmed(event.getId())).stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getFullName()) && Validator.isEmailValid((String)t.getEmail())).parallel()).map(t -> {
                ExtendedModelMap model = new ExtendedModelMap();
                model.addAttribute("eventName", (Object)event.getDisplayName());
                model.addAttribute("fullName", (Object)t.getFullName());
                model.addAttribute("organizationName", (Object)organization.getName());
                model.addAttribute("organizationEmail", (Object)organization.getEmail());
                model.addAttribute("reservationURL", (Object)this.ticketReservationManager.reservationUrl(t.getTicketsReservationId(), (PurchaseContext)event));
                model.addAttribute("reservationID", (Object)this.ticketReservationManager.getShortReservationID((Configurable)event, t.getTicketsReservationId()));
                model.addAttribute("ticketURL", (Object)ReservationUtil.ticketUpdateUrl((Event)event, (Ticket)t, (ConfigurationManager)this.configurationManager));
                model.addAttribute("ticketID", (Object)t.getPublicUuid().toString());
                model.addAttribute("ticket", t);
                return Triple.of((Object)t, (Object)t.getEmail(), (Object)model);
            }).forEach(triple -> {
                Ticket ticket = (Ticket)triple.getLeft();
                MessageModification m = (MessageModification)Optional.ofNullable((List)byLanguage.get(ticket.getUserLanguage())).orElseGet(() -> (List)byLanguage.get(byLanguage.keySet().stream().findFirst().orElseThrow(IllegalStateException::new))).get(0);
                Model model = (Model)triple.getRight();
                String subject = CustomMessageManager.renderResource((String)m.getSubject(), (PurchaseContext)event, (Model)model, (Locale)m.getLocale(), (TemplateManager)this.templateManager);
                StringBuilder text = new StringBuilder(CustomMessageManager.renderResource((String)m.getText(), (PurchaseContext)event, (Model)model, (Locale)m.getLocale(), (TemplateManager)this.templateManager));
                ArrayList<Mailer.Attachment> attachments = new ArrayList<Mailer.Attachment>();
                HashMap templateModel = new HashMap(model.asMap());
                if (m.isAttachTicket()) {
                    boolean onlineTicket;
                    Optional optionalReservation = this.ticketReservationManager.findById(ticket.getTicketsReservationId());
                    Optional optionalTicketCategory = this.ticketCategoryRepository.getByIdAndActive(ticket.getCategoryId().intValue());
                    boolean bl = onlineTicket = optionalTicketCategory.isPresent() && EventUtil.isAccessOnline((TicketCategory)((TicketCategory)optionalTicketCategory.get()), (EventCheckInInfo)event);
                    if (optionalReservation.isPresent() && onlineTicket) {
                        HashMap onlineCheckInModel = new HashMap(TicketCheckInUtil.getOnlineCheckInInfo((ExtensionManager)this.extensionManager, (EventRepository)this.eventRepository, (TicketCategoryRepository)this.ticketCategoryRepository, (ConfigurationManager)this.configurationManager, (Event)event, (Locale)Locale.forLanguageTag(ticket.getUserLanguage()), (Ticket)ticket, (TicketCategory)((TicketCategory)categoriesById.get(ticket.getCategoryId())), (Map)this.ticketReservationManager.retrieveAttendeeAdditionalInfoForTicket(ticket)));
                        onlineCheckInModel.putAll(CustomMessageManager.getModelForTicket((Ticket)ticket, (TicketReservation)((TicketReservation)optionalReservation.get()), (TicketCategory)((TicketCategory)optionalTicketCategory.get()), (Organization)organization));
                        attachments.add(CustomMessageManager.generateCalendarAttachmentForOnlineEvent(onlineCheckInModel));
                        text.append(this.notificationManager.buildOnlineCheckInText(onlineCheckInModel, Locale.forLanguageTag(ticket.getUserLanguage()), messageSource));
                        templateModel.putAll(onlineCheckInModel);
                    } else if (optionalReservation.isPresent() && optionalTicketCategory.isPresent()) {
                        boolean htmlEmailsEnabled = ((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.ENABLE_HTML_EMAILS)).getValueAsBooleanOrDefault();
                        attachments.add(CustomMessageManager.generateTicketAttachment((Ticket)ticket, (TicketReservation)((TicketReservation)optionalReservation.get()), (TicketCategory)((TicketCategory)optionalTicketCategory.get()), (Organization)organization, (boolean)htmlEmailsEnabled));
                    }
                    templateModel.put("googleWalletEnabled", googleWalletEnabled && !onlineTicket);
                    templateModel.put("appleWalletEnabled", appleWalletEnabled && !onlineTicket);
                    templateModel.put("walletEnabled", (googleWalletEnabled || appleWalletEnabled) && !onlineTicket);
                } else {
                    templateModel.put("googleWalletEnabled", false);
                    templateModel.put("appleWalletEnabled", false);
                    templateModel.put("walletEnabled", false);
                }
                templateModel.put("message", text);
                templateModel.put("event", event);
                templateModel.put("baseUrl", baseUrl);
                this.notificationManager.sendSimpleEmail((PurchaseContext)event, ticket.getTicketsReservationId(), (String)triple.getMiddle(), subject, () -> this.templateManager.renderTemplate((PurchaseContext)event, TemplateResource.CUSTOM_MESSAGE, (Map)templateModel, Locale.forLanguageTag(ticket.getUserLanguage())), attachments);
            });
        });
    }

    private List<MessageModification> preview(Event event, List<MessageModification> input, String username) {
        ExtendedModelMap model = new ExtendedModelMap();
        Organization organization = this.eventManager.loadOrganizer((EventAndOrganizationId)event, username);
        model.addAttribute("eventName", (Object)event.getDisplayName());
        model.addAttribute("fullName", (Object)"John Doe");
        model.addAttribute("organizationName", (Object)organization.getName());
        model.addAttribute("organizationEmail", (Object)organization.getEmail());
        model.addAttribute("reservationURL", (Object)"https://this-is-the-reservation-url");
        model.addAttribute("ticketURL", (Object)"https://this-is-the-ticket-url");
        model.addAttribute("reservationID", (Object)"RESID");
        model.addAttribute("ticketID", (Object)"TICKETID");
        return input.stream().map(arg_0 -> this.lambda$preview$11(event, (Model)model, arg_0)).collect(Collectors.toList());
    }

    public static Mailer.Attachment generateTicketAttachment(Ticket ticket, TicketReservation reservation, TicketCategory ticketCategory, Organization organization, boolean htmlEmailEnabled) {
        Map model = CustomMessageManager.getModelForTicket((Ticket)ticket, (TicketReservation)reservation, (TicketCategory)ticketCategory, (Organization)organization);
        if (htmlEmailEnabled) {
            model.put("skipPassbook", "true");
        }
        return new Mailer.Attachment("ticket-" + ticket.getPublicUuid() + ".pdf", null, "application/pdf", model, Mailer.AttachmentIdentifier.TICKET_PDF);
    }

    private static Map<String, String> getModelForTicket(Ticket ticket, TicketReservation reservation, TicketCategory ticketCategory, Organization organization) {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("ticket", Json.toJson((Object)ticket));
        model.put("ticketCategory", Json.toJson((Object)ticketCategory));
        model.put("reservationId", reservation.getId());
        model.put("organizationId", Integer.toString(organization.getId()));
        return model;
    }

    public static Mailer.Attachment generateCalendarAttachmentForOnlineEvent(Event event, Ticket ticket, Locale attachmentLanguage, TicketReservation reservation, TicketCategory ticketCategory, Organization organization, ExtensionManager extensionManager, EventRepository eventRepository, TicketCategoryRepository ticketCategoryRepository, ConfigurationManager configurationManager, Map<String, List<String>> ticketAdditionalInfo) {
        Map model = CustomMessageManager.getModelForTicket((Ticket)ticket, (TicketReservation)reservation, (TicketCategory)ticketCategory, (Organization)organization);
        model.putAll(TicketCheckInUtil.getOnlineCheckInInfo((ExtensionManager)extensionManager, (EventRepository)eventRepository, (TicketCategoryRepository)ticketCategoryRepository, (ConfigurationManager)configurationManager, (Event)event, (Locale)attachmentLanguage, (Ticket)ticket, (TicketCategory)ticketCategory, ticketAdditionalInfo));
        return CustomMessageManager.generateCalendarAttachmentForOnlineEvent((Map)model);
    }

    public static Mailer.Attachment generateCalendarAttachmentForOnlineEvent(Map<String, String> model) {
        return new Mailer.Attachment(Mailer.AttachmentIdentifier.CALENDAR_ICS.fileName(""), null, Mailer.AttachmentIdentifier.CALENDAR_ICS.contentType(""), model, Mailer.AttachmentIdentifier.CALENDAR_ICS);
    }

    private static String renderResource(String template, PurchaseContext purchaseContext, Model model, Locale locale, TemplateManager templateManager) {
        return templateManager.renderString(purchaseContext, template, model.asMap(), locale, TemplateManager.TemplateOutput.TEXT);
    }

    @ConstructorProperties(value={"templateManager", "eventManager", "ticketRepository", "ticketReservationManager", "notificationManager", "ticketCategoryRepository", "configurationManager", "messageSourceManager", "extensionManager", "eventRepository"})
    @Generated
    public CustomMessageManager(TemplateManager templateManager, EventManager eventManager, TicketRepository ticketRepository, TicketReservationManager ticketReservationManager, NotificationManager notificationManager, TicketCategoryRepository ticketCategoryRepository, ConfigurationManager configurationManager, MessageSourceManager messageSourceManager, ExtensionManager extensionManager, EventRepository eventRepository) {
        this.templateManager = templateManager;
        this.eventManager = eventManager;
        this.ticketRepository = ticketRepository;
        this.ticketReservationManager = ticketReservationManager;
        this.notificationManager = notificationManager;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.configurationManager = configurationManager;
        this.messageSourceManager = messageSourceManager;
        this.extensionManager = extensionManager;
        this.eventRepository = eventRepository;
    }

    private /* synthetic */ MessageModification lambda$preview$11(Event event, Model model, MessageModification m) {
        return MessageModification.preview((MessageModification)m, (String)CustomMessageManager.renderResource((String)m.getSubject(), (PurchaseContext)event, (Model)model, (Locale)m.getLocale(), (TemplateManager)this.templateManager), (String)CustomMessageManager.renderResource((String)m.getText(), (PurchaseContext)event, (Model)model, (Locale)m.getLocale(), (TemplateManager)this.templateManager), (boolean)m.isAttachTicket());
    }
}

