/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.support;

import alfio.manager.system.ConfigurationManager;
import alfio.model.Configurable;
import alfio.model.system.ConfigurationKeys;
import alfio.util.MonetaryUtil;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FeeCalculator {
    private final BigDecimal fee;
    private final BigDecimal percentageFee;
    private final BigDecimal minimumFee;
    private final BigDecimal maximumFee;
    private final boolean maxFeeDefined;
    private final int numTickets;
    private final String currencyCode;

    private FeeCalculator(String feeAsString, String percentageFeeAsString, String minimumFeeAsString, String maxFeeAsString, String currencyCode, int numTickets) {
        this.fee = new BigDecimal((String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.trimToNull((String)feeAsString), (CharSequence)"0"));
        this.percentageFee = new BigDecimal((String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.substringBefore((String)StringUtils.trimToNull((String)percentageFeeAsString), (String)"%"), (CharSequence)"0"));
        this.minimumFee = new BigDecimal((String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.trimToNull((String)minimumFeeAsString), (CharSequence)"0"));
        this.maximumFee = StringUtils.isEmpty((CharSequence)maxFeeAsString) ? null : new BigDecimal(StringUtils.trimToNull((String)maxFeeAsString));
        this.maxFeeDefined = this.maximumFee != null;
        this.numTickets = numTickets;
        this.currencyCode = currencyCode;
    }

    private long calculate(long price) {
        long percentage = (Long)MonetaryUtil.calcPercentage((long)price, (BigDecimal)this.percentageFee, BigDecimal::longValueExact);
        long fixed = (long)MonetaryUtil.unitToCents((BigDecimal)this.fee, (String)this.currencyCode) * (long)this.numTickets;
        long minFee = (Long)MonetaryUtil.unitToCents((BigDecimal)this.minimumFee, (String)this.currencyCode, BigDecimal::longValueExact) * (long)this.numTickets;
        long maxFee = this.maxFeeDefined ? (Long)MonetaryUtil.unitToCents((BigDecimal)this.maximumFee, (String)this.currencyCode, BigDecimal::longValueExact) * (long)this.numTickets : Long.MAX_VALUE;
        return Math.min(maxFee, Math.max(percentage + fixed, minFee));
    }

    public static BiFunction<Integer, Long, Optional<Long>> getCalculator(Configurable configurable, ConfigurationManager configurationManager, String currencyCode) {
        return (numTickets, amountInCent) -> {
            if (FeeCalculator.isPlatformModeEnabled((Configurable)configurable, (ConfigurationManager)configurationManager)) {
                Map fees = configurationManager.getFor(Set.of(ConfigurationKeys.PLATFORM_FIXED_FEE, ConfigurationKeys.PLATFORM_PERCENTAGE_FEE, ConfigurationKeys.PLATFORM_MINIMUM_FEE, ConfigurationKeys.PLATFORM_MAXIMUM_FEE), configurable.getConfigurationLevel());
                String fixedFee = ((ConfigurationManager.MaybeConfiguration)fees.get(ConfigurationKeys.PLATFORM_FIXED_FEE)).getValueOrDefault("0");
                String percentageFee = ((ConfigurationManager.MaybeConfiguration)fees.get(ConfigurationKeys.PLATFORM_PERCENTAGE_FEE)).getValueOrDefault("0");
                String minimumFee = ((ConfigurationManager.MaybeConfiguration)fees.get(ConfigurationKeys.PLATFORM_MINIMUM_FEE)).getValueOrDefault("0");
                String maximumFee = ((ConfigurationManager.MaybeConfiguration)fees.get(ConfigurationKeys.PLATFORM_MAXIMUM_FEE)).getValueOrDefault("");
                return Optional.of(new FeeCalculator(fixedFee, percentageFee, minimumFee, maximumFee, currencyCode, numTickets.intValue()).calculate(amountInCent.longValue()));
            }
            return Optional.empty();
        };
    }

    private static boolean isPlatformModeEnabled(Configurable configurable, ConfigurationManager configurationManager) {
        return configurationManager.getFor(ConfigurationKeys.PLATFORM_MODE_ENABLED, configurable.getConfigurationLevel()).getValueAsBooleanOrDefault();
    }
}

