/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.support;

import alfio.manager.support.PaymentResult;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import lombok.Generated;

public final class PaymentResult {
    private final Type type;
    @JsonIgnore
    private Optional<String> gatewayId = Optional.empty();
    @JsonIgnore
    private Optional<String> errorCode = Optional.empty();
    private String redirectUrl;

    private PaymentResult(Type type) {
        this.type = type;
    }

    public boolean isSuccessful() {
        return this.type == Type.SUCCESSFUL;
    }

    public boolean isFailed() {
        return this.type == Type.FAILED;
    }

    public boolean isRedirect() {
        return this.type == Type.REDIRECT;
    }

    public boolean isInitialized() {
        return this.type == Type.INITIALIZED;
    }

    public Optional<String> getErrorCode() {
        return this.errorCode;
    }

    private PaymentResult setErrorCode(String errorCode) {
        this.errorCode = Optional.ofNullable(errorCode);
        return this;
    }

    public Optional<String> getGatewayId() {
        return this.gatewayId;
    }

    public String getGatewayIdOrNull() {
        return this.gatewayId.orElse(null);
    }

    private PaymentResult setGatewayId(String gatewayId) {
        this.gatewayId = Optional.ofNullable(gatewayId);
        return this;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    private PaymentResult setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    public static PaymentResult successful(String gatewayId) {
        return new PaymentResult(Type.SUCCESSFUL).setGatewayId(gatewayId);
    }

    public static PaymentResult redirect(String redirectUrl) {
        return new PaymentResult(Type.REDIRECT).setRedirectUrl(redirectUrl);
    }

    public static PaymentResult pending(String gatewayId) {
        return new PaymentResult(Type.PENDING).setGatewayId(gatewayId);
    }

    public static PaymentResult initialized(String gatewayId) {
        return new PaymentResult(Type.INITIALIZED).setGatewayId(gatewayId);
    }

    public static PaymentResult failed(String errorCode) {
        return new PaymentResult(Type.FAILED).setErrorCode(errorCode);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentResult)) {
            return false;
        }
        PaymentResult other = (PaymentResult)o;
        Type this$type = this.type;
        Type other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Optional this$gatewayId = this.getGatewayId();
        Optional other$gatewayId = other.getGatewayId();
        if (this$gatewayId == null ? other$gatewayId != null : !((Object)this$gatewayId).equals(other$gatewayId)) {
            return false;
        }
        Optional this$errorCode = this.getErrorCode();
        Optional other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !((Object)this$errorCode).equals(other$errorCode)) {
            return false;
        }
        String this$redirectUrl = this.getRedirectUrl();
        String other$redirectUrl = other.getRedirectUrl();
        return !(this$redirectUrl == null ? other$redirectUrl != null : !this$redirectUrl.equals(other$redirectUrl));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Optional $gatewayId = this.getGatewayId();
        result = result * 59 + ($gatewayId == null ? 43 : ((Object)$gatewayId).hashCode());
        Optional $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : ((Object)$errorCode).hashCode());
        String $redirectUrl = this.getRedirectUrl();
        result = result * 59 + ($redirectUrl == null ? 43 : $redirectUrl.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PaymentResult(type=" + this.type + ", gatewayId=" + this.getGatewayId() + ", errorCode=" + this.getErrorCode() + ", redirectUrl=" + this.getRedirectUrl() + ")";
    }
}

