/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.support;

import alfio.manager.support.PaymentWebhookResult;
import alfio.model.transaction.PaymentToken;
import java.beans.ConstructorProperties;
import lombok.Generated;

public class PaymentWebhookResult {
    private final Type type;
    private final PaymentToken paymentToken;
    private final String reason;
    private final String redirectUrl;

    public boolean isSuccessful() {
        return this.type == Type.SUCCESSFUL;
    }

    public boolean isError() {
        return this.type == Type.ERROR;
    }

    public static PaymentWebhookResult successful(PaymentToken paymentToken) {
        return new PaymentWebhookResult(Type.SUCCESSFUL, paymentToken, null, null);
    }

    public static PaymentWebhookResult failed(String reason) {
        return new PaymentWebhookResult(Type.FAILED, null, reason, null);
    }

    public static PaymentWebhookResult cancelled() {
        return new PaymentWebhookResult(Type.CANCELLED, null, null, null);
    }

    public static PaymentWebhookResult error(String reason) {
        return new PaymentWebhookResult(Type.ERROR, null, reason, null);
    }

    public static PaymentWebhookResult notRelevant(String reason) {
        return new PaymentWebhookResult(Type.NOT_RELEVANT, null, reason, null);
    }

    public static PaymentWebhookResult processStarted(PaymentToken paymentToken) {
        return new PaymentWebhookResult(Type.TRANSACTION_INITIATED, paymentToken, null, null);
    }

    public static PaymentWebhookResult pending() {
        return new PaymentWebhookResult(Type.TRANSACTION_INITIATED, null, null, null);
    }

    public static PaymentWebhookResult redirect(String redirectUrl) {
        return new PaymentWebhookResult(Type.TRANSACTION_INITIATED, null, null, redirectUrl);
    }

    @ConstructorProperties(value={"type", "paymentToken", "reason", "redirectUrl"})
    @Generated
    public PaymentWebhookResult(Type type, PaymentToken paymentToken, String reason, String redirectUrl) {
        this.type = type;
        this.paymentToken = paymentToken;
        this.reason = reason;
        this.redirectUrl = redirectUrl;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public PaymentToken getPaymentToken() {
        return this.paymentToken;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public String getRedirectUrl() {
        return this.redirectUrl;
    }
}

