/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.support;

import alfio.manager.payment.PaymentSpecification;
import alfio.model.TicketReservation;
import alfio.model.system.command.FinalizeReservation;
import alfio.model.transaction.PaymentProxy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class RetryFinalizeReservation {
    private final String reservationId;
    private final PaymentProxy paymentProxy;
    private final boolean sendReservationConfirmationEmail;
    private final boolean sendTickets;
    private final String username;
    private final boolean tcAccepted;
    private final boolean privacyPolicyAccepted;
    private final TicketReservation.TicketReservationStatus originalStatus;

    @JsonCreator
    public RetryFinalizeReservation(@JsonProperty(value="reservationId") String reservationId, @JsonProperty(value="paymentProxy") PaymentProxy paymentProxy, @JsonProperty(value="sendReservationConfirmationEmail") boolean sendReservationConfirmationEmail, @JsonProperty(value="sendTickets") boolean sendTickets, @JsonProperty(value="username") String username, @JsonProperty(value="tcAccepted") boolean tcAccepted, @JsonProperty(value="privacyPolicyAccepted") boolean privacyPolicyAccepted, @JsonProperty(value="originalStatus") TicketReservation.TicketReservationStatus originalStatus) {
        this.reservationId = reservationId;
        this.paymentProxy = paymentProxy;
        this.sendReservationConfirmationEmail = sendReservationConfirmationEmail;
        this.sendTickets = sendTickets;
        this.username = username;
        this.tcAccepted = tcAccepted;
        this.privacyPolicyAccepted = privacyPolicyAccepted;
        this.originalStatus = originalStatus;
    }

    public String getReservationId() {
        return this.reservationId;
    }

    public PaymentProxy getPaymentProxy() {
        return this.paymentProxy;
    }

    public boolean isSendReservationConfirmationEmail() {
        return this.sendReservationConfirmationEmail;
    }

    public boolean isSendTickets() {
        return this.sendTickets;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isTcAccepted() {
        return this.tcAccepted;
    }

    public boolean isPrivacyPolicyAccepted() {
        return this.privacyPolicyAccepted;
    }

    public TicketReservation.TicketReservationStatus getOriginalStatus() {
        return this.originalStatus;
    }

    public static RetryFinalizeReservation fromFinalizeReservation(FinalizeReservation finalizeReservation) {
        PaymentSpecification paymentSpecification = finalizeReservation.getPaymentSpecification();
        return new RetryFinalizeReservation(paymentSpecification.getReservationId(), finalizeReservation.getPaymentProxy(), finalizeReservation.isSendReservationConfirmationEmail(), finalizeReservation.isSendTickets(), finalizeReservation.getUsername(), paymentSpecification.isTcAccepted(), paymentSpecification.isPrivacyAccepted(), finalizeReservation.getOriginalStatus());
    }
}

