/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.support.reservation;

import alfio.manager.PaymentManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.support.reservation.ReservationCostCalculator;
import alfio.model.AdditionalService;
import alfio.model.AdditionalServiceItem;
import alfio.model.AdditionalServiceText;
import alfio.model.Audit;
import alfio.model.OrderSummary;
import alfio.model.PriceContainer;
import alfio.model.PromoCodeDiscount;
import alfio.model.PurchaseContext;
import alfio.model.SummaryPriceContainer;
import alfio.model.SummaryRow;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketReservation;
import alfio.model.TotalPrice;
import alfio.model.decorator.AdditionalServiceItemPriceContainer;
import alfio.model.decorator.TicketPriceContainer;
import alfio.model.subscription.Subscription;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.subscription.SubscriptionPriceContainer;
import alfio.model.transaction.PaymentProxy;
import alfio.repository.AdditionalServiceTextRepository;
import alfio.repository.AuditingRepository;
import alfio.repository.SubscriptionRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import alfio.repository.TransactionRepository;
import alfio.util.LocaleUtil;
import alfio.util.MonetaryUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class OrderSummaryGenerator {
    private static final Logger log = LoggerFactory.getLogger(OrderSummaryGenerator.class);
    private final TicketReservationRepository ticketReservationRepository;
    private final AuditingRepository auditingRepository;
    private final PaymentManager paymentManager;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final AdditionalServiceTextRepository additionalServiceTextRepository;
    private final SubscriptionRepository subscriptionRepository;
    private final TicketRepository ticketRepository;
    private final MessageSourceManager messageSourceManager;
    private final ReservationCostCalculator reservationCostCalculator;
    private final TransactionRepository transactionRepository;

    public OrderSummaryGenerator(TicketReservationRepository ticketReservationRepository, AuditingRepository auditingRepository, PaymentManager paymentManager, TicketCategoryRepository ticketCategoryRepository, AdditionalServiceTextRepository additionalServiceTextRepository, SubscriptionRepository subscriptionRepository, TicketRepository ticketRepository, MessageSourceManager messageSourceManager, ReservationCostCalculator reservationCostCalculator, TransactionRepository transactionRepository) {
        this.ticketReservationRepository = ticketReservationRepository;
        this.auditingRepository = auditingRepository;
        this.paymentManager = paymentManager;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.additionalServiceTextRepository = additionalServiceTextRepository;
        this.subscriptionRepository = subscriptionRepository;
        this.ticketRepository = ticketRepository;
        this.messageSourceManager = messageSourceManager;
        this.reservationCostCalculator = reservationCostCalculator;
        this.transactionRepository = transactionRepository;
    }

    public OrderSummary orderSummaryForReservationId(String reservationId, PurchaseContext purchaseContext) {
        TicketReservation reservation = this.ticketReservationRepository.findReservationById(reservationId);
        return this.orderSummaryForReservation(reservation, purchaseContext);
    }

    public OrderSummary orderSummaryForReservation(TicketReservation reservation, PurchaseContext context) {
        boolean hasRefund;
        Pair totalPriceAndDiscount = this.reservationCostCalculator.totalReservationCostWithVAT(reservation);
        TotalPrice reservationCost = (TotalPrice)totalPriceAndDiscount.getLeft();
        PromoCodeDiscount discount = ((Optional)totalPriceAndDiscount.getRight()).orElse(null);
        boolean free = reservationCost.getPriceWithVAT() == 0;
        String refundedAmount = null;
        boolean bl = hasRefund = this.auditingRepository.countAuditsOfTypeForReservation(reservation.getId(), Audit.EventType.REFUND) > 0;
        if (hasRefund) {
            refundedAmount = this.paymentManager.getInfo(reservation, context).getPaymentInformation().getRefundedAmount();
        }
        String currencyCode = reservation.getCurrencyCode();
        return new OrderSummary(reservationCost, this.extractSummary(reservation.getId(), reservation.getVatStatus(), context, LocaleUtil.forLanguageTag((String)reservation.getUserLanguage()), discount, reservationCost), free, MonetaryUtil.formatCents((int)reservationCost.getPriceWithVAT(), (String)currencyCode), MonetaryUtil.formatCents((int)reservationCost.getVAT(), (String)currencyCode), reservation.getStatus() == TicketReservation.TicketReservationStatus.OFFLINE_PAYMENT, reservation.getStatus() == TicketReservation.TicketReservationStatus.DEFERRED_OFFLINE_PAYMENT, this.isCashPayment(reservation), (String)Optional.ofNullable(context.getVat()).map(p -> MonetaryUtil.formatCents((int)MonetaryUtil.unitToCents((BigDecimal)p, (String)currencyCode), (String)currencyCode)).orElse(null), reservation.getVatStatus(), refundedAmount);
    }

    private boolean isCashPayment(TicketReservation reservation) {
        return reservation.getPaymentMethod() == PaymentProxy.ON_SITE && !this.transactionRepository.transactionExists(reservation.getId());
    }

    public OrderSummary orderSummaryForCreditNote(TicketReservation reservation, PurchaseContext purchaseContext, List<Ticket> removedTickets) {
        Pair totalPriceAndDiscount = ReservationCostCalculator.totalReservationCostWithVAT(null, (PurchaseContext)purchaseContext, (TicketReservation)reservation, removedTickets, List.of(), List.of(), Optional.empty());
        TotalPrice reservationCost = (TotalPrice)totalPriceAndDiscount.getLeft();
        boolean free = reservationCost.getPriceWithVAT() == 0;
        String currencyCode = reservation.getCurrencyCode();
        return new OrderSummary(reservationCost, this.extractSummary(reservation.getVatStatus(), purchaseContext, LocaleUtil.forLanguageTag((String)reservation.getUserLanguage()), null, reservationCost, removedTickets, Stream.empty(), this.subscriptionRepository.findSubscriptionsByReservationId(reservation.getId())), free, MonetaryUtil.formatCents((int)reservationCost.getPriceWithVAT(), (String)currencyCode), MonetaryUtil.formatCents((int)reservationCost.getVAT(), (String)currencyCode), reservation.getStatus() == TicketReservation.TicketReservationStatus.OFFLINE_PAYMENT, reservation.getStatus() == TicketReservation.TicketReservationStatus.DEFERRED_OFFLINE_PAYMENT, this.isCashPayment(reservation), (String)Optional.ofNullable(purchaseContext.getVat()).map(p -> MonetaryUtil.formatCents((int)MonetaryUtil.unitToCents((BigDecimal)p, (String)currencyCode), (String)currencyCode)).orElse(null), reservation.getVatStatus(), null);
    }

    List<SummaryRow> extractSummary(PriceContainer.VatStatus reservationVatStatus, PurchaseContext purchaseContext, Locale locale, PromoCodeDiscount promoCodeDiscount, TotalPrice reservationCost, List<Ticket> ticketsToInclude, Stream<Pair<AdditionalService, List<AdditionalServiceItem>>> additionalServicesToInclude, List<Subscription> subscriptionsToInclude) {
        log.trace("extract summary subscriptionsToInclude {}", subscriptionsToInclude);
        ArrayList<SummaryRow> summary = new ArrayList<SummaryRow>();
        String currencyCode = reservationCost.getCurrencyCode();
        List<TicketPriceContainer> tickets = ticketsToInclude.stream().map(t -> TicketPriceContainer.from((Ticket)t, (PriceContainer.VatStatus)reservationVatStatus, (BigDecimal)purchaseContext.getVat(), (PriceContainer.VatStatus)purchaseContext.getVatStatus(), (PromoCodeDiscount)promoCodeDiscount)).toList();
        purchaseContext.event().ifPresent(event -> {
            boolean multipleTaxRates = tickets.stream().map(TicketPriceContainer::getVatStatus).collect(Collectors.toSet()).size() > 1;
            Map<Integer, List<TicketPriceContainer>> ticketsByCategory = tickets.stream().collect(Collectors.groupingBy(TicketPriceContainer::getCategoryId));
            List<Map.Entry<Integer, List<Object>>> sorted = multipleTaxRates ? ticketsByCategory.entrySet().stream().sorted(Comparator.comparing(e -> ((TicketPriceContainer)((List)e.getValue()).get(0)).getVatStatus()).reversed()).toList() : new ArrayList<Map.Entry<Integer, List<TicketPriceContainer>>>(ticketsByCategory.entrySet());
            Map<Object, Object> categoriesById = ticketsByCategory.isEmpty() ? Map.of() : this.ticketCategoryRepository.getByIdsAndActive(ticketsByCategory.keySet(), event.getId()).stream().collect(Collectors.toMap(TicketCategory::getId, Function.identity()));
            for (Map.Entry<Integer, List<Object>> entry : sorted) {
                List<Object> categoryTickets = entry.getValue();
                int subTotal = categoryTickets.stream().mapToInt(TicketPriceContainer::getSummarySrcPriceCts).sum();
                int subTotalBeforeVat = SummaryPriceContainer.getSummaryPriceBeforeVatCts(categoryTickets);
                TicketPriceContainer firstTicket = (TicketPriceContainer)categoryTickets.get(0);
                int ticketPriceCts = firstTicket.getSummarySrcPriceCts();
                int priceBeforeVat = SummaryPriceContainer.getSummaryPriceBeforeVatCts(Collections.singletonList(firstTicket));
                String categoryName = ((TicketCategory)categoriesById.get(entry.getKey())).getName();
                PriceContainer.VatStatus ticketVatStatus = firstTicket.getVatStatus();
                summary.add(new SummaryRow(categoryName, MonetaryUtil.formatCents((int)ticketPriceCts, (String)currencyCode), MonetaryUtil.formatCents((int)priceBeforeVat, (String)currencyCode), categoryTickets.size(), MonetaryUtil.formatCents((int)subTotal, (String)currencyCode), MonetaryUtil.formatCents((int)subTotalBeforeVat, (String)currencyCode), subTotal, SummaryRow.SummaryType.TICKET, null, ticketVatStatus));
                if (!PriceContainer.VatStatus.isVatExempt((PriceContainer.VatStatus)ticketVatStatus) || ticketVatStatus == reservationVatStatus) continue;
                summary.add(new SummaryRow(null, "", "", 0, MonetaryUtil.formatCents((long)0L, (String)currencyCode, (boolean)true), MonetaryUtil.formatCents((long)0L, (String)currencyCode, (boolean)true), 0, SummaryRow.SummaryType.TAX_DETAIL, "0", ticketVatStatus));
            }
        });
        summary.addAll(additionalServicesToInclude.map(entry -> {
            String language = locale.getLanguage();
            AdditionalServiceText title = this.additionalServiceTextRepository.findBestMatchByLocaleAndType(((AdditionalService)entry.getKey()).id(), language, AdditionalServiceText.TextType.TITLE);
            if (!title.getLocale().equals(language) || title.getId() == -1) {
                log.debug("additional service {}: title not found for locale {}", (Object)title.getAdditionalServiceId(), (Object)language);
            }
            List prices = ((Stream)OrderSummaryGenerator.generateASIPriceContainers((PurchaseContext)purchaseContext, null).apply(entry)).collect(Collectors.toList());
            AdditionalServiceItemPriceContainer first = (AdditionalServiceItemPriceContainer)prices.get(0);
            int subtotal = prices.stream().mapToInt(AdditionalServiceItemPriceContainer::getSrcPriceCts).sum();
            int subtotalBeforeVat = SummaryPriceContainer.getSummaryPriceBeforeVatCts(prices);
            return new SummaryRow(title.getValue(), MonetaryUtil.formatCents((int)first.getSrcPriceCts(), (String)currencyCode), MonetaryUtil.formatCents((int)SummaryPriceContainer.getSummaryPriceBeforeVatCts(Collections.singletonList(first)), (String)currencyCode), prices.size(), MonetaryUtil.formatCents((int)subtotal, (String)currencyCode), MonetaryUtil.formatCents((int)subtotalBeforeVat, (String)currencyCode), subtotal, SummaryRow.SummaryType.ADDITIONAL_SERVICE, null, first.getVatStatus());
        }).toList());
        Optional.ofNullable(promoCodeDiscount).ifPresent(promo -> {
            String formattedSingleAmount = "-" + (String)(PromoCodeDiscount.DiscountType.isFixedAmount((PromoCodeDiscount.DiscountType)promo.getDiscountType()) ? MonetaryUtil.formatCents((int)promo.getDiscountAmount(), (String)currencyCode) : promo.getDiscountAmount() + "%");
            summary.add(new SummaryRow(this.formatPromoCode(promo, ticketsToInclude, locale, purchaseContext), formattedSingleAmount, formattedSingleAmount, reservationCost.getDiscountAppliedCount(), MonetaryUtil.formatCents((int)reservationCost.getDiscount(), (String)currencyCode), MonetaryUtil.formatCents((int)reservationCost.getDiscount(), (String)currencyCode), reservationCost.getDiscount(), promo.isDynamic() ? SummaryRow.SummaryType.DYNAMIC_DISCOUNT : SummaryRow.SummaryType.PROMOTION_CODE, null, reservationVatStatus));
        });
        if (purchaseContext instanceof SubscriptionDescriptor) {
            SubscriptionDescriptor descriptor = (SubscriptionDescriptor)purchaseContext;
            if (!subscriptionsToInclude.isEmpty()) {
                Subscription subscription = subscriptionsToInclude.get(0);
                SubscriptionPriceContainer priceContainer = new SubscriptionPriceContainer(subscription, promoCodeDiscount, descriptor);
                String priceBeforeVat = MonetaryUtil.formatUnit((BigDecimal)priceContainer.getNetPrice(), (String)currencyCode);
                summary.add(new SummaryRow((String)purchaseContext.getTitle().get(locale.getLanguage()), MonetaryUtil.formatCents((int)priceContainer.getSummarySrcPriceCts(), (String)currencyCode), priceBeforeVat, subscriptionsToInclude.size(), MonetaryUtil.formatCents((int)(priceContainer.getSummarySrcPriceCts() * subscriptionsToInclude.size()), (String)currencyCode), MonetaryUtil.formatUnit((BigDecimal)priceContainer.getNetPrice().multiply(new BigDecimal(subscriptionsToInclude.size())), (String)currencyCode), priceContainer.getSummarySrcPriceCts(), SummaryRow.SummaryType.SUBSCRIPTION, null, reservationVatStatus));
            }
        } else if (CollectionUtils.isNotEmpty(subscriptionsToInclude)) {
            log.trace("subscriptions to include is not empty");
            Subscription subscription = subscriptionsToInclude.get(0);
            this.subscriptionRepository.findOne(subscription.getSubscriptionDescriptorId(), subscription.getOrganizationId()).ifPresent(subscriptionDescriptor -> {
                log.trace("found subscriptionDescriptor with ID {}", (Object)subscriptionDescriptor.getId());
                List<TicketPriceContainer> ticketsSubscription = tickets.stream().filter(t -> Objects.equals(subscription.getId(), t.getSubscriptionId())).toList();
                int ticketPriceCts = ticketsSubscription.stream().mapToInt(TicketPriceContainer::getSummarySrcPriceCts).sum();
                int priceBeforeVat = SummaryPriceContainer.getSummaryPriceBeforeVatCts(ticketsSubscription);
                summary.add(new SummaryRow(subscriptionDescriptor.getLocalizedTitle(locale), "-" + MonetaryUtil.formatCents((int)ticketPriceCts, (String)currencyCode), "-" + MonetaryUtil.formatCents((int)priceBeforeVat, (String)currencyCode), ticketsSubscription.size(), "-" + MonetaryUtil.formatCents((int)ticketPriceCts, (String)currencyCode), "-" + MonetaryUtil.formatCents((int)priceBeforeVat, (String)currencyCode), ticketPriceCts, SummaryRow.SummaryType.APPLIED_SUBSCRIPTION, null, reservationVatStatus));
            });
        }
        return summary;
    }

    public List<SummaryRow> extractSummary(String reservationId, PriceContainer.VatStatus reservationVatStatus, PurchaseContext purchaseContext, Locale locale, PromoCodeDiscount promoCodeDiscount, TotalPrice reservationCost) {
        List subscriptionsToInclude = purchaseContext.ofType(PurchaseContext.PurchaseContextType.event) ? this.subscriptionRepository.findAppliedSubscriptionByReservationId(reservationId).map(List::of).orElse(List.of()) : this.subscriptionRepository.findSubscriptionsByReservationId(reservationId);
        return this.extractSummary(reservationVatStatus, purchaseContext, locale, promoCodeDiscount, reservationCost, this.ticketRepository.findTicketsInReservation(reservationId), this.reservationCostCalculator.streamAdditionalServiceItems(reservationId, purchaseContext), subscriptionsToInclude);
    }

    private String formatPromoCode(PromoCodeDiscount promoCodeDiscount, List<Ticket> tickets, Locale locale, PurchaseContext purchaseContext) {
        if (promoCodeDiscount.getCodeType() == PromoCodeDiscount.CodeType.DYNAMIC) {
            return this.messageSourceManager.getMessageSourceFor(purchaseContext).getMessage("reservation.dynamic.discount.description", null, locale);
        }
        List<Ticket> filteredTickets = tickets.stream().filter(ticket -> promoCodeDiscount.getCategories().contains(ticket.getCategoryId())).toList();
        if (promoCodeDiscount.getCategories().isEmpty() || filteredTickets.isEmpty()) {
            return promoCodeDiscount.getPromoCode();
        }
        String formattedDiscountedCategories = filteredTickets.stream().map(Ticket::getCategoryId).collect(Collectors.toSet()).stream().map(categoryId -> this.ticketCategoryRepository.getByIdAndActive(categoryId.intValue(), promoCodeDiscount.getEventId().intValue()).getName()).collect(Collectors.joining(", ", "(", ")"));
        return promoCodeDiscount.getPromoCode() + " " + formattedDiscountedCategories;
    }

    private static Function<Pair<AdditionalService, List<AdditionalServiceItem>>, Stream<? extends AdditionalServiceItemPriceContainer>> generateASIPriceContainers(PurchaseContext purchaseContext, PromoCodeDiscount discount) {
        return p -> ((List)p.getValue()).stream().map(asi -> AdditionalServiceItemPriceContainer.from((AdditionalServiceItem)asi, (AdditionalService)((AdditionalService)p.getKey()), (PurchaseContext)purchaseContext, (PromoCodeDiscount)discount));
    }
}

