/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.support.reservation;

import alfio.model.Audit;
import alfio.model.Ticket;
import alfio.model.metadata.TicketMetadataContainer;
import alfio.repository.AuditingRepository;
import alfio.util.ObjectDiffUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReservationAuditingHelper {
    private final AuditingRepository auditingRepository;

    public ReservationAuditingHelper(AuditingRepository auditingRepository) {
        this.auditingRepository = auditingRepository;
    }

    public void auditUpdateMetadata(String reservationId, int ticketId, int eventId, TicketMetadataContainer newMetadata, TicketMetadataContainer oldMetadata) {
        List changes = ObjectDiffUtil.diff((Object)oldMetadata, (Object)newMetadata, TicketMetadataContainer.class).stream().map(arg_0 -> this.processChange(arg_0)).collect(Collectors.toList());
        this.auditingRepository.insert(reservationId, null, Integer.valueOf(eventId), Audit.EventType.UPDATE_TICKET_METADATA, new Date(), Audit.EntityType.TICKET, Integer.toString(ticketId), changes);
    }

    public void auditUpdateTicket(Ticket preUpdateTicket, Map<String, List<String>> preUpdateTicketFields, Ticket postUpdateTicket, Map<String, List<String>> postUpdateTicketFields, int eventId) {
        List diffTicket = ObjectDiffUtil.diff((Ticket)preUpdateTicket, (Ticket)postUpdateTicket);
        List diffTicketFields = ObjectDiffUtil.diff(preUpdateTicketFields, postUpdateTicketFields);
        List changes = Stream.concat(diffTicket.stream(), diffTicketFields.stream()).map(arg_0 -> this.processChange(arg_0)).collect(Collectors.toList());
        this.auditingRepository.insert(preUpdateTicket.getTicketsReservationId(), null, Integer.valueOf(eventId), Audit.EventType.UPDATE_TICKET, new Date(), Audit.EntityType.TICKET, Integer.toString(preUpdateTicket.getId()), changes);
    }

    private HashMap<String, Object> processChange(ObjectDiffUtil.Change change) {
        HashMap<String, Object> v = new HashMap<String, Object>();
        v.put("propertyName", change.getPropertyName());
        v.put("state", change.getState());
        v.put("oldValue", change.getOldValue());
        v.put("newValue", change.getNewValue());
        return v;
    }
}

