/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.support.reservation;

import alfio.manager.PurchaseContextManager;
import alfio.manager.system.ReservationPriceCalculator;
import alfio.model.AdditionalService;
import alfio.model.AdditionalServiceItem;
import alfio.model.Event;
import alfio.model.PriceContainer;
import alfio.model.PromoCodeDiscount;
import alfio.model.PurchaseContext;
import alfio.model.Ticket;
import alfio.model.TicketReservation;
import alfio.model.TotalPrice;
import alfio.model.decorator.TicketPriceContainer;
import alfio.model.subscription.Subscription;
import alfio.repository.AdditionalServiceItemRepository;
import alfio.repository.AdditionalServiceRepository;
import alfio.repository.PromoCodeDiscountRepository;
import alfio.repository.SubscriptionRepository;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import alfio.util.MonetaryUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ReservationCostCalculator {
    private final TicketReservationRepository ticketReservationRepository;
    private final PurchaseContextManager purchaseContextManager;
    private final PromoCodeDiscountRepository promoCodeDiscountRepository;
    private final SubscriptionRepository subscriptionRepository;
    private final TicketRepository ticketRepository;
    private final AdditionalServiceRepository additionalServiceRepository;
    private final AdditionalServiceItemRepository additionalServiceItemRepository;

    public ReservationCostCalculator(TicketReservationRepository ticketReservationRepository, PurchaseContextManager purchaseContextManager, PromoCodeDiscountRepository promoCodeDiscountRepository, SubscriptionRepository subscriptionRepository, TicketRepository ticketRepository, AdditionalServiceRepository additionalServiceRepository, AdditionalServiceItemRepository additionalServiceItemRepository) {
        this.ticketReservationRepository = ticketReservationRepository;
        this.purchaseContextManager = purchaseContextManager;
        this.promoCodeDiscountRepository = promoCodeDiscountRepository;
        this.subscriptionRepository = subscriptionRepository;
        this.ticketRepository = ticketRepository;
        this.additionalServiceRepository = additionalServiceRepository;
        this.additionalServiceItemRepository = additionalServiceItemRepository;
    }

    public Pair<TotalPrice, Optional<PromoCodeDiscount>> totalReservationCostWithVAT(String reservationId) {
        return this.totalReservationCostWithVAT(this.ticketReservationRepository.findReservationById(reservationId));
    }

    public Pair<TotalPrice, Optional<PromoCodeDiscount>> totalReservationCostWithVAT(TicketReservation reservation) {
        return this.totalReservationCostWithVAT((PurchaseContext)this.purchaseContextManager.findByReservationId(reservation.getId()).orElseThrow(), reservation, this.ticketRepository.findTicketsInReservation(reservation.getId()));
    }

    private Pair<TotalPrice, Optional<PromoCodeDiscount>> totalReservationCostWithVAT(PurchaseContext purchaseContext, TicketReservation reservation, List<Ticket> tickets) {
        Optional<PromoCodeDiscount> promoCodeDiscount = Optional.ofNullable(reservation.getPromoCodeDiscountId()).map(arg_0 -> ((PromoCodeDiscountRepository)this.promoCodeDiscountRepository).findById(arg_0));
        List subscriptions = this.subscriptionRepository.findSubscriptionsByReservationId(reservation.getId());
        Optional appliedSubscription = this.subscriptionRepository.findAppliedSubscriptionByReservationId(reservation.getId());
        return ReservationCostCalculator.totalReservationCostWithVAT((PromoCodeDiscount)promoCodeDiscount.orElse(null), (PurchaseContext)purchaseContext, (TicketReservation)reservation, tickets, purchaseContext.event().map(event -> this.collectAdditionalServiceItems(reservation.getId(), event)).orElse(List.of()), (List)subscriptions, (Optional)appliedSubscription);
    }

    public static Pair<TotalPrice, Optional<PromoCodeDiscount>> totalReservationCostWithVAT(PromoCodeDiscount promoCodeDiscount, PurchaseContext purchaseContext, TicketReservation reservation, List<Ticket> tickets, List<Pair<AdditionalService, List<AdditionalServiceItem>>> additionalServiceItems, List<Subscription> subscriptions, Optional<Subscription> appliedSubscription) {
        int discountAppliedCount;
        String currencyCode = purchaseContext.getCurrency();
        List ticketPrices = tickets.stream().map(t -> TicketPriceContainer.from((Ticket)t, (PriceContainer.VatStatus)reservation.getVatStatus(), (BigDecimal)purchaseContext.getVat(), (PriceContainer.VatStatus)purchaseContext.getVatStatus(), (PromoCodeDiscount)promoCodeDiscount)).collect(Collectors.toList());
        int discountedTickets = (int)ticketPrices.stream().filter(t -> t.getAppliedDiscount().compareTo(BigDecimal.ZERO) > 0).count();
        int n = discountAppliedCount = discountedTickets <= 1 || promoCodeDiscount.getDiscountType() == PromoCodeDiscount.DiscountType.FIXED_AMOUNT ? discountedTickets : 1;
        if (discountAppliedCount == 0 && promoCodeDiscount != null && promoCodeDiscount.getDiscountType() == PromoCodeDiscount.DiscountType.FIXED_AMOUNT_RESERVATION) {
            discountAppliedCount = 1;
        }
        ReservationPriceCalculator reservationPriceCalculator = ReservationPriceCalculator.from((TicketReservation)reservation, (PromoCodeDiscount)promoCodeDiscount, tickets, (PurchaseContext)purchaseContext, additionalServiceItems, subscriptions, appliedSubscription);
        TotalPrice price = new TotalPrice(MonetaryUtil.unitToCents((BigDecimal)reservationPriceCalculator.getFinalPrice(), (String)currencyCode), MonetaryUtil.unitToCents((BigDecimal)reservationPriceCalculator.getVAT(), (String)currencyCode), -MonetaryUtil.unitToCents((BigDecimal)reservationPriceCalculator.getAppliedDiscount(), (String)currencyCode), discountAppliedCount, currencyCode);
        return Pair.of((Object)price, Optional.ofNullable(promoCodeDiscount));
    }

    Stream<Pair<AdditionalService, List<AdditionalServiceItem>>> streamAdditionalServiceItems(String reservationId, PurchaseContext purchaseContext) {
        return purchaseContext.event().map(event -> this.additionalServiceItemRepository.findByReservationUuid(event.getId(), reservationId).stream().collect(Collectors.groupingBy(AdditionalServiceItem::getAdditionalServiceId)).entrySet().stream().map(entry -> Pair.of((Object)this.additionalServiceRepository.getById(((Integer)entry.getKey()).intValue(), event.getId()), (Object)((List)entry.getValue())))).orElse(Stream.empty());
    }

    public List<Pair<AdditionalService, List<AdditionalServiceItem>>> collectAdditionalServiceItems(String reservationId, Event event) {
        return this.streamAdditionalServiceItems(reservationId, (PurchaseContext)event).collect(Collectors.toList());
    }
}

