/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.support.reservation;

import alfio.controller.support.TemplateProcessor;
import alfio.manager.BillingDocumentManager;
import alfio.manager.ExtensionManager;
import alfio.manager.NotificationManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.support.ConfirmationEmailConfiguration;
import alfio.manager.support.IncompatibleStateException;
import alfio.manager.support.PartialTicketTextGenerator;
import alfio.manager.support.reservation.OrderSummaryGenerator;
import alfio.manager.support.reservation.ReservationEmailContentHelper;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.system.Mailer;
import alfio.model.BillingDocument;
import alfio.model.Configurable;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.EventCheckInInfo;
import alfio.model.FieldNameAndValue;
import alfio.model.OrderSummary;
import alfio.model.PriceContainer;
import alfio.model.PurchaseContext;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketReservation;
import alfio.model.extension.CustomEmailText;
import alfio.model.metadata.SubscriptionMetadata;
import alfio.model.subscription.Subscription;
import alfio.model.subscription.UsageDetails;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Organization;
import alfio.repository.EventRepository;
import alfio.repository.PurchaseContextFieldRepository;
import alfio.repository.SubscriptionRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.util.EventUtil;
import alfio.util.Json;
import alfio.util.ReservationUtil;
import alfio.util.TemplateManager;
import alfio.util.TemplateResource;
import alfio.util.checkin.TicketCheckInUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ReservationEmailContentHelper {
    private static final String RESERVATION_ID = "reservationId";
    private final ConfigurationManager configurationManager;
    private final NotificationManager notificationManager;
    private final SubscriptionRepository subscriptionRepository;
    private final MessageSourceManager messageSourceManager;
    private final OrderSummaryGenerator orderSummaryGenerator;
    private final TicketReservationRepository ticketReservationRepository;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final PurchaseContextFieldRepository purchaseContextFieldRepository;
    private final OrganizationRepository organizationRepository;
    private final TicketRepository ticketRepository;
    private final TemplateManager templateManager;
    private final BillingDocumentManager billingDocumentManager;
    private final ExtensionManager extensionManager;
    private final EventRepository eventRepository;

    public ReservationEmailContentHelper(ConfigurationManager configurationManager, NotificationManager notificationManager, SubscriptionRepository subscriptionRepository, MessageSourceManager messageSourceManager, OrderSummaryGenerator orderSummaryGenerator, TicketReservationRepository ticketReservationRepository, TicketCategoryRepository ticketCategoryRepository, PurchaseContextFieldRepository purchaseContextFieldRepository, OrganizationRepository organizationRepository, TicketRepository ticketRepository, TemplateManager templateManager, BillingDocumentManager billingDocumentManager, ExtensionManager extensionManager, EventRepository eventRepository) {
        this.configurationManager = configurationManager;
        this.notificationManager = notificationManager;
        this.subscriptionRepository = subscriptionRepository;
        this.messageSourceManager = messageSourceManager;
        this.orderSummaryGenerator = orderSummaryGenerator;
        this.ticketReservationRepository = ticketReservationRepository;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.purchaseContextFieldRepository = purchaseContextFieldRepository;
        this.organizationRepository = organizationRepository;
        this.ticketRepository = ticketRepository;
        this.templateManager = templateManager;
        this.billingDocumentManager = billingDocumentManager;
        this.extensionManager = extensionManager;
        this.eventRepository = eventRepository;
    }

    public void sendConfirmationEmail(PurchaseContext purchaseContext, TicketReservation ticketReservation, Locale language, String username) {
        String reservationId = ticketReservation.getId();
        this.checkIfFinalized(reservationId);
        OrderSummary summary = this.orderSummaryGenerator.orderSummaryForReservationId(reservationId, purchaseContext);
        List attachments = this.configurationManager.canAttachBillingDocumentToConfirmationEmail((Configurable)purchaseContext) ? this.generateAttachmentForConfirmationEmail(purchaseContext, ticketReservation, language, summary, username) : List.of();
        Optional vat = this.getVAT(purchaseContext);
        ArrayList<ConfirmationEmailConfiguration> configurations = new ArrayList<ConfirmationEmailConfiguration>();
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.subscription)) {
            Subscription firstSubscription = (Subscription)this.subscriptionRepository.findSubscriptionsByReservationId(reservationId).stream().findFirst().orElseThrow();
            boolean sendSeparateEmailToOwner = !Objects.equals(firstSubscription.getEmail(), ticketReservation.getEmail());
            SubscriptionMetadata metadata = Objects.requireNonNullElseGet(this.subscriptionRepository.getSubscriptionMetadata(firstSubscription.getId()), SubscriptionMetadata::empty);
            Map<String, Map> initialModel = Map.of("pin", firstSubscription.getPin(), "subscriptionId", firstSubscription.getId(), "includePin", metadata.getConfiguration().isDisplayPin(), "fullName", firstSubscription.getFirstName() + " " + firstSubscription.getLastName(), "metadata-attributes", metadata.getProperties());
            Map model = this.prepareModelForReservationEmail(purchaseContext, ticketReservation, vat, summary, List.of(), initialModel);
            ArrayList<Mailer.Attachment> subscriptionAttachments = new ArrayList<Mailer.Attachment>(attachments);
            Mailer.Attachment subscriptionAttachment = this.generateSubscriptionAttachment(firstSubscription);
            subscriptionAttachments.add(subscriptionAttachment);
            configurations.add(new ConfirmationEmailConfiguration(TemplateResource.CONFIRMATION_EMAIL_SUBSCRIPTION, firstSubscription.getEmail(), model, sendSeparateEmailToOwner ? List.of(subscriptionAttachment) : subscriptionAttachments));
            if (sendSeparateEmailToOwner) {
                HashMap<String, Object> separateModel = new HashMap<String, Object>(model);
                separateModel.put("includePin", false);
                separateModel.put("fullName", ticketReservation.getFullName());
                configurations.add(new ConfirmationEmailConfiguration(TemplateResource.CONFIRMATION_EMAIL_SUBSCRIPTION, ticketReservation.getEmail(), separateModel, subscriptionAttachments));
            }
        } else {
            Map model = this.prepareModelForReservationEmail(purchaseContext, ticketReservation, vat, summary, this.ticketRepository.findTicketsInReservation(ticketReservation.getId()), Map.of());
            configurations.add(new ConfirmationEmailConfiguration(TemplateResource.CONFIRMATION_EMAIL, ticketReservation.getEmail(), model, attachments));
        }
        MessageSource messageSource = this.messageSourceManager.getMessageSourceFor(purchaseContext);
        String localizedType = messageSource.getMessage("purchase-context." + purchaseContext.getType(), null, language);
        configurations.forEach(configuration -> this.notificationManager.sendSimpleEmail(purchaseContext, ticketReservation.getId(), configuration.getEmailAddress(), messageSource.getMessage("reservation-email-subject", new Object[]{this.configurationManager.getShortReservationID((Configurable)purchaseContext, ticketReservation), purchaseContext.getTitle().get(language.getLanguage()), localizedType}, language), () -> this.templateManager.renderTemplate(purchaseContext, configuration.getTemplateResource(), configuration.getModel(), language), configuration.getAttachments()));
    }

    private Mailer.Attachment generateSubscriptionAttachment(Subscription subscription) {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("subscriptionId", subscription.getId().toString());
        return new Mailer.Attachment("subscription_" + subscription.getId() + ".pdf", null, MediaType.APPLICATION_PDF.toString(), model, Mailer.AttachmentIdentifier.SUBSCRIPTION_PDF);
    }

    private List<Mailer.Attachment> generateAttachmentForConfirmationEmail(PurchaseContext purchaseContext, TicketReservation ticketReservation, Locale language, OrderSummary summary, String username) {
        if (ReservationEmailContentHelper.mustGenerateBillingDocument((OrderSummary)summary, (TicketReservation)ticketReservation)) {
            BillingDocument.Type type = ticketReservation.getHasInvoiceNumber() ? BillingDocument.Type.INVOICE : BillingDocument.Type.RECEIPT;
            return this.billingDocumentManager.generateBillingDocumentAttachment(purchaseContext, ticketReservation, language, type, username, summary);
        }
        return List.of();
    }

    public void sendReservationCompleteEmailToOrganizer(PurchaseContext purchaseContext, TicketReservation ticketReservation, Locale language, String username) {
        String reservationId = ticketReservation.getId();
        this.checkIfFinalized(reservationId);
        Organization organization = this.organizationRepository.getById(purchaseContext.getOrganizationId());
        List cc = this.notificationManager.getCCForEventOrganizer(purchaseContext);
        Map reservationEmailModel = this.prepareModelForReservationEmail(purchaseContext, ticketReservation);
        OrderSummary summary = this.orderSummaryGenerator.orderSummaryForReservationId(reservationId, purchaseContext);
        List attachments = Collections.emptyList();
        if (!this.configurationManager.canGenerateReceiptOrInvoiceToCustomer((Configurable)purchaseContext) || this.configurationManager.isInvoiceOnly((Configurable)purchaseContext)) {
            attachments = this.generateAttachmentForConfirmationEmail(purchaseContext, ticketReservation, language, summary, username);
        }
        String shortReservationID = this.configurationManager.getShortReservationID((Configurable)purchaseContext, ticketReservation);
        this.notificationManager.sendSimpleEmail(purchaseContext, null, organization.getEmail(), cc, "Reservation complete " + shortReservationID, () -> this.templateManager.renderTemplate(purchaseContext, TemplateResource.CONFIRMATION_EMAIL_FOR_ORGANIZER, reservationEmailModel, language), attachments);
    }

    private static boolean mustGenerateBillingDocument(OrderSummary summary, TicketReservation ticketReservation) {
        return !summary.getFree() && (!summary.getNotYetPaid() || summary.getWaitingForPayment() && ticketReservation.isInvoiceRequested());
    }

    public List<Mailer.Attachment> generateBillingDocumentAttachment(PurchaseContext purchaseContext, TicketReservation ticketReservation, Locale language, Map<String, Object> billingDocumentModel, BillingDocument.Type documentType) {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("reservationId", ticketReservation.getId());
        purchaseContext.event().ifPresent(event -> model.put("eventId", Integer.toString(event.getId())));
        model.put("language", Json.toJson((Object)language));
        model.put("reservationEmailModel", Json.toJson(billingDocumentModel));
        return switch (1.$SwitchMap$alfio$model$BillingDocument$Type[documentType.ordinal()]) {
            case 1 -> Collections.singletonList(new Mailer.Attachment("invoice.pdf", null, MediaType.APPLICATION_PDF.getType(), model, Mailer.AttachmentIdentifier.INVOICE_PDF));
            case 2 -> Collections.singletonList(new Mailer.Attachment("receipt.pdf", null, MediaType.APPLICATION_PDF.getType(), model, Mailer.AttachmentIdentifier.RECEIPT_PDF));
            case 3 -> Collections.singletonList(new Mailer.Attachment("credit-note.pdf", null, MediaType.APPLICATION_PDF.getType(), model, Mailer.AttachmentIdentifier.CREDIT_NOTE_PDF));
            default -> throw new IllegalStateException(documentType + " is not supported");
        };
    }

    public String getReservationEmailSubject(PurchaseContext purchaseContext, Locale reservationLanguage, String key, String id) {
        return this.messageSourceManager.getMessageSourceFor(purchaseContext).getMessage(key, new Object[]{id, purchaseContext.getDisplayName()}, reservationLanguage);
    }

    public Map<String, Object> prepareModelForReservationEmail(PurchaseContext purchaseContext, TicketReservation reservation, Optional<String> vat, OrderSummary summary, List<Ticket> ticketsToInclude, Map<String, Object> initialOptions) {
        Organization organization = this.organizationRepository.getById(purchaseContext.getOrganizationId());
        String baseUrl = this.configurationManager.baseUrl(purchaseContext);
        String reservationId = reservation.getId();
        String reservationUrl = ReservationUtil.reservationUrl((TicketReservation)reservation, (PurchaseContext)purchaseContext, (ConfigurationManager)this.configurationManager);
        String reservationShortID = this.configurationManager.getShortReservationID((Configurable)purchaseContext, reservation);
        Map bankingInfo = this.configurationManager.getFor(Set.of(ConfigurationKeys.INVOICE_ADDRESS, ConfigurationKeys.BANK_ACCOUNT_NR, ConfigurationKeys.BANK_ACCOUNT_OWNER), ConfigurationLevel.purchaseContext((PurchaseContext)purchaseContext));
        Optional invoiceAddress = ((ConfigurationManager.MaybeConfiguration)bankingInfo.get(ConfigurationKeys.INVOICE_ADDRESS)).getValue();
        Optional bankAccountNr = ((ConfigurationManager.MaybeConfiguration)bankingInfo.get(ConfigurationKeys.BANK_ACCOUNT_NR)).getValue();
        Optional bankAccountOwner = ((ConfigurationManager.MaybeConfiguration)bankingInfo.get(ConfigurationKeys.BANK_ACCOUNT_OWNER)).getValue();
        Map<Integer, List<Ticket>> ticketsByCategory = ticketsToInclude.stream().collect(Collectors.groupingBy(Ticket::getCategoryId));
        List ticketsWithCategory = ReservationUtil.collectTicketsWithCategory(ticketsByCategory, (TicketCategoryRepository)this.ticketCategoryRepository);
        HashMap<String, Object> baseModel = new HashMap<String, Object>();
        baseModel.putAll(initialOptions);
        baseModel.putAll(this.extensionManager.handleReservationEmailCustomText(purchaseContext, reservation, this.ticketReservationRepository.getAdditionalInfo(reservationId)).map(CustomEmailText::toMap).orElse(Map.of()));
        Map model = TemplateResource.prepareModelForConfirmationEmail((Organization)organization, (PurchaseContext)purchaseContext, (TicketReservation)reservation, vat, (List)ticketsWithCategory, (OrderSummary)summary, (String)baseUrl, (String)reservationUrl, (String)reservationShortID, (Optional)invoiceAddress, (Optional)bankAccountNr, (Optional)bankAccountOwner, baseModel);
        boolean euBusiness = StringUtils.isNotBlank((CharSequence)reservation.getVatCountryCode()) && StringUtils.isNotBlank((CharSequence)reservation.getVatNr()) && this.configurationManager.getForSystem(ConfigurationKeys.EU_COUNTRIES_LIST).getRequiredValue().contains(reservation.getVatCountryCode()) && PriceContainer.VatStatus.isVatExempt((PriceContainer.VatStatus)reservation.getVatStatus());
        model.put("euBusiness", euBusiness);
        model.put("publicId", this.configurationManager.getPublicReservationID((Configurable)purchaseContext, reservation));
        model.put("invoicingAdditionalInfo", this.ticketReservationRepository.getAdditionalInfo(reservationId).getInvoicingAdditionalInfo());
        if (purchaseContext.getType() == PurchaseContext.PurchaseContextType.event) {
            Event event = (Event)purchaseContext.event().orElseThrow();
            model.put("displayLocation", ticketsWithCategory.stream().noneMatch(tc -> EventUtil.isAccessOnline((TicketCategory)tc.category(), (EventCheckInInfo)event)));
        } else {
            model.put("displayLocation", false);
        }
        if (this.ticketReservationRepository.hasSubscriptionApplied(reservationId)) {
            model.put("displaySubscriptionUsage", true);
            Subscription subscription = (Subscription)this.subscriptionRepository.findAppliedSubscriptionByReservationId(reservationId).orElseThrow();
            if (subscription.getMaxEntries() > -1) {
                UsageDetails subscriptionUsageDetails = UsageDetails.fromSubscription((Subscription)subscription, (int)this.ticketRepository.countSubscriptionUsage(subscription.getId(), null));
                model.put("subscriptionUsageDetails", subscriptionUsageDetails);
                model.put("subscriptionUrl", ReservationUtil.reservationUrl((TicketReservation)reservation, (PurchaseContext)purchaseContext, (ConfigurationManager)this.configurationManager));
            }
        }
        return model;
    }

    public void sendTicketByEmail(Ticket ticket, Locale locale, Event event, PartialTicketTextGenerator confirmationTextBuilder) {
        TicketReservation reservation = this.ticketReservationRepository.findReservationById(ticket.getTicketsReservationId());
        this.checkIfFinalized(reservation.getId());
        TicketCategory ticketCategory = this.ticketCategoryRepository.getByIdAndActive(ticket.getCategoryId().intValue(), event.getId());
        this.notificationManager.sendTicketByEmail(ticket, event, locale, confirmationTextBuilder, reservation, ticketCategory, () -> this.retrieveAttendeeAdditionalInfoForTicket(ticket));
    }

    private void checkIfFinalized(String reservationId) {
        if (!Boolean.TRUE.equals(this.ticketReservationRepository.checkIfFinalized(reservationId))) {
            throw new IncompatibleStateException("Reservation was confirmed but not finalized yet. Cannot send emails.");
        }
    }

    public Map<String, List<String>> retrieveAttendeeAdditionalInfoForTicket(Ticket ticket) {
        return this.purchaseContextFieldRepository.findNameAndValue(ticket.getId()).stream().collect(Collectors.groupingBy(FieldNameAndValue::getName, Collectors.mapping(FieldNameAndValue::getValue, Collectors.toList())));
    }

    public Map<String, List<String>> retrieveAttendeeAdditionalInfoForSubscription(UUID subscriptionId) {
        return this.purchaseContextFieldRepository.findNameAndValue(subscriptionId).stream().collect(Collectors.groupingBy(FieldNameAndValue::getName, Collectors.mapping(FieldNameAndValue::getValue, Collectors.toList())));
    }

    public PartialTicketTextGenerator getTicketEmailGenerator(Event event, TicketReservation ticketReservation, Locale ticketLanguage, Map<String, List<String>> additionalInfo) {
        return ticket -> {
            Organization organization = this.organizationRepository.getById(event.getOrganizationId());
            String ticketUrl = ReservationUtil.ticketUpdateUrl((Event)event, (Ticket)ticket, (ConfigurationManager)this.configurationManager);
            TicketCategory ticketCategory = this.ticketCategoryRepository.getById(ticket.getCategoryId().intValue());
            HashMap initialModel = new HashMap(this.extensionManager.handleTicketEmailCustomText(event, ticketReservation, this.ticketReservationRepository.getAdditionalInfo(ticketReservation.getId()), this.purchaseContextFieldRepository.findAllByTicketId(ticket.getId())).map(CustomEmailText::toMap).orElse(Map.of()));
            if (EventUtil.isAccessOnline((TicketCategory)ticketCategory, (EventCheckInInfo)event)) {
                initialModel.putAll(TicketCheckInUtil.getOnlineCheckInInfo((ExtensionManager)this.extensionManager, (EventRepository)this.eventRepository, (TicketCategoryRepository)this.ticketCategoryRepository, (ConfigurationManager)this.configurationManager, (Event)event, (Locale)ticketLanguage, (Ticket)ticket, (TicketCategory)ticketCategory, (Map)additionalInfo));
            }
            String baseUrl = StringUtils.removeEnd((String)this.configurationManager.getFor(ConfigurationKeys.BASE_URL, ConfigurationLevel.event((EventAndOrganizationId)event)).getRequiredValue(), (String)"/");
            String calendarUrl = UriComponentsBuilder.fromUriString((String)(baseUrl + "/api/v2/public/event/{eventShortName}/calendar/{currentLang}")).queryParam("type", new Object[]{"google"}).build(Map.of("eventShortName", event.getShortName(), "currentLang", ticketLanguage.getLanguage())).toString();
            return TemplateProcessor.buildPartialEmail((Event)event, (Organization)organization, (TicketReservation)ticketReservation, (TicketCategory)ticketCategory, (TemplateManager)this.templateManager, (String)baseUrl, (String)ticketUrl, (String)calendarUrl, (Locale)ticketLanguage, initialModel).generate(ticket);
        };
    }

    public Optional<String> getVAT(PurchaseContext purchaseContext) {
        return this.configurationManager.getFor(ConfigurationKeys.VAT_NR, purchaseContext.getConfigurationLevel()).getValue();
    }

    public Map<String, Object> prepareModelForReservationEmail(PurchaseContext purchaseContext, TicketReservation reservation) {
        Optional vat = this.getVAT(purchaseContext);
        OrderSummary summary = this.orderSummaryGenerator.orderSummaryForReservationId(reservation.getId(), purchaseContext);
        return this.prepareModelForReservationEmail(purchaseContext, reservation, vat, summary, this.ticketRepository.findTicketsInReservation(reservation.getId()), Map.of());
    }
}

