/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.system;

import alfio.manager.support.RetryFinalizeReservation;
import alfio.manager.system.AdminJobExecutor;
import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import alfio.model.system.AdminJobSchedule;
import alfio.repository.system.AdminJobQueueRepository;
import alfio.util.ClockProvider;
import alfio.util.Json;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Transactional
public class AdminJobManager {
    private static final Logger log = LoggerFactory.getLogger(AdminJobManager.class);
    static final int MAX_ATTEMPTS = 17;
    private static final Set<AdminJobExecutor.JobName> REGULAR = EnumSet.complementOf(EnumSet.of(AdminJobExecutor.JobName.EXECUTE_EXTENSION, AdminJobExecutor.JobName.RETRY_RESERVATION_CONFIRMATION));
    private static final Set<String> ADMIN_JOBS = REGULAR.stream().map(Enum::name).collect(Collectors.toSet());
    private static final Set<String> EXTENSIONS_JOB = Set.of(AdminJobExecutor.JobName.EXECUTE_EXTENSION.name());
    private static final Set<String> RESERVATIONS_JOB = Set.of(AdminJobExecutor.JobName.RETRY_RESERVATION_CONFIRMATION.name());
    private final Map<AdminJobExecutor.JobName, List<AdminJobExecutor>> executorsByJobId;
    private final AdminJobQueueRepository adminJobQueueRepository;
    private final TransactionTemplate nestedTransactionTemplate;
    private final Set<String> executedStatuses;
    private final Set<String> notExecutedStatuses;
    private final ClockProvider clockProvider;

    public AdminJobManager(List<AdminJobExecutor> jobExecutors, AdminJobQueueRepository adminJobQueueRepository, PlatformTransactionManager transactionManager, ClockProvider clockProvider) {
        this.executorsByJobId = jobExecutors.stream().flatMap(je -> je.getJobNames().stream().map(n -> Pair.of((Object)n, (Object)je))).collect(Collectors.groupingBy(Pair::getLeft, () -> new EnumMap(AdminJobExecutor.JobName.class), Collectors.mapping(Pair::getValue, Collectors.toList())));
        this.adminJobQueueRepository = adminJobQueueRepository;
        this.nestedTransactionTemplate = new TransactionTemplate(transactionManager, (TransactionDefinition)new DefaultTransactionDefinition(6));
        EnumSet<AdminJobSchedule.Status> executed = EnumSet.of(AdminJobSchedule.Status.EXECUTED);
        this.executedStatuses = executed.stream().map(Enum::name).collect(Collectors.toSet());
        this.notExecutedStatuses = EnumSet.complementOf(executed).stream().map(Enum::name).collect(Collectors.toSet());
        this.clockProvider = clockProvider;
    }

    void processPendingExtensionRetry(ZonedDateTime timestamp) {
        this.internalProcessPendingSchedules(this.adminJobQueueRepository.loadPendingSchedules((Collection)EXTENSIONS_JOB, timestamp));
    }

    void processPendingReservationsRetry(ZonedDateTime timestamp) {
        this.internalProcessPendingSchedules(this.adminJobQueueRepository.loadPendingSchedules((Collection)RESERVATIONS_JOB, timestamp));
    }

    void processPendingRequests() {
        log.trace("Processing pending requests");
        this.internalProcessPendingSchedules(this.adminJobQueueRepository.loadPendingSchedules((Collection)ADMIN_JOBS, ZonedDateTime.now(this.clockProvider.getClock())));
        log.trace("done processing pending requests");
    }

    private void internalProcessPendingSchedules(List<AdminJobSchedule> pendingSchedules) {
        pendingSchedules.stream().map(arg_0 -> this.processPendingRequest(arg_0)).filter(p -> !((List)p.getRight()).isEmpty()).forEach(scheduleWithResults -> {
            AdminJobSchedule schedule = (AdminJobSchedule)scheduleWithResults.getLeft();
            Map<Boolean, List<Result>> partitionedResults = ((List)scheduleWithResults.getRight()).stream().collect(Collectors.partitioningBy(Result::isSuccess));
            if (!partitionedResults.get(false).isEmpty()) {
                partitionedResults.get(false).forEach(r -> log.warn("Processing failed for {}: {}", (Object)schedule.getJobName(), (Object)r.getErrors()));
                if (REGULAR.contains(schedule.getJobName()) || schedule.getAttempts() > 17) {
                    this.adminJobQueueRepository.updateSchedule(schedule.getId(), AdminJobSchedule.Status.FAILED, ZonedDateTime.now(this.clockProvider.getClock()), Map.of());
                } else {
                    ZonedDateTime nextExecution = AdminJobManager.getNextExecution((int)schedule.getAttempts());
                    AdminJobManager.logReschedule((ZonedDateTime)nextExecution, (Map)schedule.getMetadata(), (AdminJobExecutor.JobName)schedule.getJobName());
                    this.adminJobQueueRepository.scheduleRetry(schedule.getId(), nextExecution);
                }
            } else {
                partitionedResults.get(true).forEach(result -> {
                    if (result.getData() != null) {
                        log.trace("Message from {}: {}", (Object)schedule.getJobName(), result.getData());
                    }
                });
                this.adminJobQueueRepository.updateSchedule(schedule.getId(), AdminJobSchedule.Status.EXECUTED, ZonedDateTime.now(this.clockProvider.getClock()), Map.of());
            }
        });
    }

    static ZonedDateTime getNextExecution(int currentAttempt) {
        return ZonedDateTime.now(ClockProvider.clock()).plusSeconds((long)Math.pow(2.0, (double)currentAttempt + 1.0));
    }

    void cleanupExpiredRequests() {
        log.trace("Cleanup expired requests");
        ZonedDateTime now = ZonedDateTime.now(this.clockProvider.getClock());
        int deleted = this.adminJobQueueRepository.removePastSchedules(now.minusDays(1L), this.executedStatuses);
        if (deleted > 0) {
            log.trace("Deleted {} executed jobs", (Object)deleted);
        }
        if ((deleted = this.adminJobQueueRepository.removePastSchedules(now.minusWeeks(1L), this.notExecutedStatuses)) > 0) {
            log.warn("Deleted {} NOT executed jobs", (Object)deleted);
        }
    }

    public boolean scheduleExecution(AdminJobExecutor.JobName jobName, Map<String, Object> metadata) {
        return this.scheduleExecution(jobName, metadata, ZonedDateTime.now(this.clockProvider.getClock()).truncatedTo(ChronoUnit.MINUTES));
    }

    public boolean scheduleExecution(AdminJobExecutor.JobName jobName, Map<String, Object> metadata, ZonedDateTime executionTime) {
        return (Boolean)AdminJobManager.executionScheduler((AdminJobExecutor.JobName)jobName, metadata, (ZonedDateTime)executionTime).apply(this.adminJobQueueRepository);
    }

    private Pair<AdminJobSchedule, List<Result<String>>> processPendingRequest(AdminJobSchedule schedule) {
        return Pair.of((Object)schedule, this.executorsByJobId.getOrDefault(schedule.getJobName(), List.of()).stream().map(s -> {
            try {
                return Result.success((Object)((String)this.nestedTransactionTemplate.execute(status -> s.process(schedule))));
            }
            catch (Exception ex) {
                return Result.error((ErrorCode)ErrorCode.custom((String)"exception", (String)ex.getMessage()));
            }
        }).collect(Collectors.toList()));
    }

    public static Function<AdminJobQueueRepository, Boolean> executionScheduler(AdminJobExecutor.JobName jobName, Map<String, Object> metadata, ZonedDateTime executionTime) {
        return adminJobQueueRepository -> {
            try {
                int result = adminJobQueueRepository.schedule(jobName, executionTime, metadata, jobName.allowsMultipleScheduling() ? null : "N");
                if (result == 0) {
                    log.trace("Possible duplication detected while inserting {}", (Object)jobName);
                }
                return result == 1;
            }
            catch (DataIntegrityViolationException ex) {
                log.trace("Integrity violation", (Throwable)ex);
                return false;
            }
        };
    }

    private static void logReschedule(ZonedDateTime nextExecution, Map<String, Object> metadata, AdminJobExecutor.JobName jobName) {
        try {
            String name;
            boolean isExtension;
            boolean bl = isExtension = jobName == AdminJobExecutor.JobName.EXECUTE_EXTENSION;
            if (isExtension) {
                name = String.valueOf(metadata.get("extensionName"));
            } else {
                RetryFinalizeReservation payload = (RetryFinalizeReservation)Json.fromJson((String)((String)metadata.get("payload")), RetryFinalizeReservation.class);
                name = payload.getReservationId();
            }
            log.debug("scheduling failed {} {} to be executed at {}", new Object[]{isExtension ? "extension" : "reservation", name, nextExecution});
        }
        catch (Exception e) {
            log.warn("Cannot log reschedule", (Throwable)e);
        }
    }
}

