/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.system;

import alfio.manager.system.AdminJobManager;
import alfio.util.ClockProvider;
import java.time.ZonedDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!disable-jobs"})
public class AdminJobManagerScheduler {
    private static final Logger log = LoggerFactory.getLogger(AdminJobManagerScheduler.class);
    private final AdminJobManager adminJobManager;
    private final ClockProvider clockProvider;

    public AdminJobManagerScheduler(AdminJobManager adminJobManager, ClockProvider clockProvider) {
        this.adminJobManager = adminJobManager;
        this.clockProvider = clockProvider;
    }

    @Scheduled(fixedDelay=1000L)
    void processPendingExtensionRetry() {
        log.trace("Processing pending extensions retry");
        this.adminJobManager.processPendingExtensionRetry(ZonedDateTime.now(this.clockProvider.getClock()));
        log.trace("done processing pending extensions retry");
    }

    @Scheduled(fixedDelay=1000L)
    void processPendingReservationsRetry() {
        log.trace("Processing pending reservations retry");
        this.adminJobManager.processPendingReservationsRetry(ZonedDateTime.now(this.clockProvider.getClock()));
        log.trace("done processing pending reservations retry");
    }

    @Scheduled(fixedDelay=60000L)
    void processPendingRequests() {
        log.trace("Processing pending requests");
        this.adminJobManager.processPendingRequests();
        log.trace("done processing pending requests");
    }

    @Scheduled(cron="#{environment.acceptsProfiles('dev') ? '0 * * * * *' : '0 0 0 * * *'}")
    void cleanupExpiredRequests() {
        this.adminJobManager.cleanupExpiredRequests();
    }
}

