/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.system;

import alfio.manager.system.ConfigurationManager;
import alfio.manager.system.Mailer;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Organization;
import alfio.repository.user.OrganizationRepository;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;

abstract class BaseMailer
implements Mailer {
    static final String MISSING_CONFIG_MESSAGE = "config cannot be null";
    private final OrganizationRepository organizationRepository;
    private static final Cache<Integer, String> ORG_ADDRESS_CACHE = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).build();

    BaseMailer(OrganizationRepository organizationRepository) {
        this.organizationRepository = organizationRepository;
    }

    void setReplyToIfPresent(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> conf, int organizationId, Consumer<String> replyToSetter) {
        String address;
        String replyToConfig = Objects.requireNonNull(Objects.requireNonNull(conf, MISSING_CONFIG_MESSAGE).get(ConfigurationKeys.MAIL_REPLY_TO), "MAIL_REPLY_TO is required").getValueOrDefault("");
        if (StringUtils.isNotBlank((CharSequence)replyToConfig)) {
            replyToSetter.accept(replyToConfig);
        } else if (Objects.requireNonNull(conf.get(ConfigurationKeys.MAIL_SET_ORG_REPLY_TO), "MAIL_SET_ORG_REPLY_TO is required").getValueAsBooleanOrDefault() && StringUtils.isNotBlank((CharSequence)(address = (String)ORG_ADDRESS_CACHE.get((Object)organizationId, id -> {
            Organization.OrganizationContact organization = this.organizationRepository.getContactById(organizationId);
            if (StringUtils.isNotBlank((CharSequence)organization.getEmail())) {
                return organization.getEmail();
            }
            return null;
        })))) {
            replyToSetter.accept(address);
        }
    }
}

