/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.system;

import alfio.manager.system.ConfigurationLevels;
import alfio.model.EventAndOrganizationId;
import alfio.model.PurchaseContext;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.system.ConfigurationPathLevel;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;

/*
 * Exception performing whole class analysis ignored.
 */
public interface ConfigurationLevel {
    public ConfigurationPathLevel getPathLevel();

    default public OptionalInt getOrganizationId() {
        return OptionalInt.empty();
    }

    default public OptionalInt getEventId() {
        return OptionalInt.empty();
    }

    default public Optional<UUID> getSubscriptionDescriptorId() {
        return Optional.empty();
    }

    default public OptionalInt getTicketCategoryId() {
        return OptionalInt.empty();
    }

    default public boolean isSystem() {
        return this.getPathLevel() == ConfigurationPathLevel.SYSTEM;
    }

    public static ConfigurationLevel external() {
        return new ConfigurationLevels.ExternalLevel();
    }

    public static ConfigurationLevel system() {
        return new ConfigurationLevels.SystemLevel();
    }

    public static ConfigurationLevel event(EventAndOrganizationId eventAndOrganizationId) {
        return new ConfigurationLevels.EventLevel(eventAndOrganizationId.getOrganizationId(), eventAndOrganizationId.getId());
    }

    public static ConfigurationLevel subscriptionDescriptor(SubscriptionDescriptor subscriptionDescriptor) {
        return new ConfigurationLevels.SubscriptionDescriptorLevel(subscriptionDescriptor.getOrganizationId(), subscriptionDescriptor.getId());
    }

    public static ConfigurationLevel purchaseContext(PurchaseContext purchaseContext) {
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            return ConfigurationLevel.event((EventAndOrganizationId)((EventAndOrganizationId)purchaseContext.event().orElseThrow()));
        }
        return ConfigurationLevel.subscriptionDescriptor((SubscriptionDescriptor)((SubscriptionDescriptor)purchaseContext));
    }

    public static ConfigurationLevel organization(int organizationId) {
        return new ConfigurationLevels.OrganizationLevel(organizationId);
    }

    public static ConfigurationLevel ticketCategory(EventAndOrganizationId eventAndOrganizationId, int ticketCategoryId) {
        return new ConfigurationLevels.CategoryLevel(eventAndOrganizationId.getOrganizationId(), eventAndOrganizationId.getId(), ticketCategoryId);
    }
}

