/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.system;

import alfio.controller.api.v2.model.AlfioInfo;
import alfio.controller.api.v2.model.AnalyticsConfiguration;
import alfio.controller.api.v2.model.ChallengeConfiguration;
import alfio.controller.api.v2.model.WalletConfiguration;
import alfio.controller.api.v2.user.support.PurchaseContextInfoBuilder;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationLevels;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.system.ExternalConfiguration;
import alfio.manager.user.UserManager;
import alfio.model.Configurable;
import alfio.model.EventAndOrganizationId;
import alfio.model.PurchaseContext;
import alfio.model.TicketCategory;
import alfio.model.TicketReservation;
import alfio.model.modification.ConfigurationModification;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.system.Configuration;
import alfio.model.system.ConfigurationKeyValuePathLevel;
import alfio.model.system.ConfigurationKeys;
import alfio.model.system.ConfigurationPathLevel;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.PaymentProxy;
import alfio.model.user.User;
import alfio.repository.EventRepository;
import alfio.repository.system.ConfigurationRepository;
import com.github.benmanes.caffeine.cache.Cache;
import jakarta.servlet.http.HttpSession;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Transactional
public class ConfigurationManager {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationManager.class);
    private static final Map<ConfigurationKeys.SettingCategory, List<Configuration>> ORGANIZATION_CONFIGURATION = ConfigurationManager.collectConfigurationKeysByCategory((ConfigurationPathLevel)ConfigurationPathLevel.ORGANIZATION);
    private static final Map<ConfigurationKeys.SettingCategory, List<Configuration>> PURCHASE_CONTEXT_CONFIGURATION = ConfigurationManager.collectConfigurationKeysByCategory((ConfigurationPathLevel)ConfigurationPathLevel.PURCHASE_CONTEXT);
    private static final Map<ConfigurationKeys.SettingCategory, List<Configuration>> CATEGORY_CONFIGURATION = ConfigurationManager.collectConfigurationKeysByCategory((ConfigurationPathLevel)ConfigurationPathLevel.TICKET_CATEGORY);
    private final ConfigurationRepository configurationRepository;
    private final UserManager userManager;
    private final EventRepository eventRepository;
    private final ExternalConfiguration externalConfiguration;
    private final Environment environment;
    private final Cache<Set<ConfigurationKeys>, Map<ConfigurationKeys, MaybeConfiguration>> oneMinuteCache;
    private final SecureRandom secureRandom = new SecureRandom();

    private Optional<Configuration> findByConfigurationPathAndKey(Configuration.ConfigurationPath path, ConfigurationKeys key) {
        String keyAsString = key.getValue();
        ArrayList configList = new ArrayList(this.externalConfiguration.load(keyAsString));
        switch (1.$SwitchMap$alfio$model$system$ConfigurationPathLevel[path.pathLevel().ordinal()]) {
            case 1: {
                configList.addAll(this.configurationRepository.findByKeyAtSystemLevel(keyAsString));
                return this.selectPath(configList);
            }
            case 2: {
                Configuration.OrganizationConfigurationPath o = (Configuration.OrganizationConfigurationPath)path;
                configList.addAll(this.configurationRepository.findByOrganizationAndKey(o.getId(), key.getValue()));
                return this.selectPath(configList);
            }
            case 3: {
                if (path instanceof Configuration.EventConfigurationPath) {
                    Configuration.EventConfigurationPath o = (Configuration.EventConfigurationPath)path;
                    configList.addAll(this.configurationRepository.findByEventAndKey(o.getOrganizationId(), o.getId(), keyAsString));
                } else {
                    Configuration.SubscriptionDescriptorConfigurationPath o = (Configuration.SubscriptionDescriptorConfigurationPath)path;
                    configList.addAll(this.configurationRepository.findBySubscriptionDescriptorAndKey(o.getOrganizationId(), o.getId(), keyAsString));
                }
                return this.selectPath(configList);
            }
            case 4: {
                Configuration.TicketCategoryConfigurationPath o = (Configuration.TicketCategoryConfigurationPath)path;
                configList.addAll(this.configurationRepository.findByTicketCategoryAndKey(o.getOrganizationId(), o.getEventId(), o.getId(), keyAsString));
                return this.selectPath(configList);
            }
        }
        throw new IllegalStateException("Can't reach here");
    }

    private Optional<Configuration> selectPath(List<Configuration> conf) {
        return conf.size() == 1 ? Optional.of(conf.get(0)) : conf.stream().max(Comparator.comparing(Configuration::getConfigurationPathLevel));
    }

    public void saveConfig(Configuration.ConfigurationPathKey pathKey, String value) {
        Configuration.ConfigurationPath path = pathKey.getPath();
        switch (1.$SwitchMap$alfio$model$system$ConfigurationPathLevel[path.pathLevel().ordinal()]) {
            case 1: {
                this.saveSystemConfiguration(pathKey.getKey(), value);
                break;
            }
            case 2: {
                Configuration.OrganizationConfigurationPath orgPath = (Configuration.OrganizationConfigurationPath)path;
                this.saveOrganizationConfiguration(orgPath.getId(), pathKey.getKey().name(), value);
                break;
            }
            case 3: {
                if (path instanceof Configuration.EventConfigurationPath) {
                    Configuration.EventConfigurationPath eventPath = (Configuration.EventConfigurationPath)path;
                    this.saveEventConfiguration(eventPath.getId(), eventPath.getOrganizationId(), pathKey.getKey().name(), value);
                    break;
                }
                Configuration.SubscriptionDescriptorConfigurationPath subscriptionDescriptorPath = (Configuration.SubscriptionDescriptorConfigurationPath)path;
                this.saveSubscriptionDescriptorConfiguration(subscriptionDescriptorPath.getId(), subscriptionDescriptorPath.getOrganizationId(), pathKey.getKey().name(), value);
                break;
            }
            default: {
                throw new IllegalStateException("can't reach here");
            }
        }
    }

    public void saveAllSystemConfiguration(List<ConfigurationModification> list) {
        list.forEach(c -> this.saveSystemConfiguration(ConfigurationKeys.fromString((String)c.getKey()), c.getValue()));
    }

    private void saveOrganizationConfiguration(int organizationId, String key, String optionValue) {
        Optional value = this.evaluateValue(key, optionValue);
        Optional existing = this.configurationRepository.findByKeyAtOrganizationLevel(organizationId, key);
        if (value.isEmpty()) {
            this.configurationRepository.deleteOrganizationLevelByKey(key, organizationId);
        } else if (existing.isPresent()) {
            this.configurationRepository.updateOrganizationLevel(organizationId, key, (String)value.get());
        } else {
            this.configurationRepository.insertOrganizationLevel(organizationId, key, (String)value.get(), ConfigurationKeys.fromString((String)key).getDescription());
        }
    }

    public void saveAllOrganizationConfiguration(int organizationId, List<ConfigurationModification> list, String username) {
        Validate.isTrue((boolean)this.userManager.isOwnerOfOrganization(this.userManager.findUserByUsername(username), organizationId), (String)"Cannot update settings, user is not owner", (Object[])new Object[0]);
        list.stream().filter(ConfigurationManager::toBeSaved).forEach(c -> this.saveOrganizationConfiguration(organizationId, c.getKey(), c.getValue()));
    }

    private void saveEventConfiguration(int eventId, int organizationId, String key, String optionValue) {
        Optional existing = this.configurationRepository.findByKeyAtEventLevel(eventId, organizationId, key);
        Optional value = this.evaluateValue(key, optionValue);
        if (value.isEmpty()) {
            this.configurationRepository.deleteEventLevelByKey(key, eventId);
        } else if (existing.isPresent()) {
            this.configurationRepository.updateEventLevel(eventId, organizationId, key, (String)value.get());
        } else {
            this.configurationRepository.insertEventLevel(organizationId, eventId, key, (String)value.get(), ConfigurationKeys.fromString((String)key).getDescription());
        }
    }

    private void saveSubscriptionDescriptorConfiguration(UUID id, int organizationId, String key, String optionValue) {
        Optional existing = this.configurationRepository.findByKeyAtSubscriptionDescriptorLevel(id, organizationId, key);
        Optional value = this.evaluateValue(key, optionValue);
        if (value.isEmpty()) {
            this.configurationRepository.deleteSubscriptionDescriptorLevelByKey(key, id);
        } else if (existing.isPresent()) {
            this.configurationRepository.updateSubscriptionDescriptorLevel(id, organizationId, key, (String)value.get());
        } else {
            this.configurationRepository.insertSubscriptionDescriptorLevel(organizationId, id, key, (String)value.get(), ConfigurationKeys.fromString((String)key).getDescription());
        }
    }

    public void saveAllSubscriptionDescriptorConfiguration(SubscriptionDescriptor sd, List<ConfigurationModification> list, String username) {
        User user = this.userManager.findUserByUsername(username);
        Validate.isTrue((boolean)this.userManager.isOwnerOfOrganization(user, sd.getOrganizationId()), (String)"Cannot update settings, user is not owner", (Object[])new Object[0]);
        list.stream().filter(ConfigurationManager::toBeSaved).forEach(c -> this.saveSubscriptionDescriptorConfiguration(sd.getId(), sd.getOrganizationId(), c.getKey(), c.getValue()));
    }

    public void saveAllEventConfiguration(int eventId, int organizationId, List<ConfigurationModification> list, String username) {
        User user = this.userManager.findUserByUsername(username);
        Validate.isTrue((boolean)this.userManager.isOwnerOfOrganization(user, organizationId), (String)"Cannot update settings, user is not owner", (Object[])new Object[0]);
        EventAndOrganizationId event = this.eventRepository.findEventAndOrganizationIdById(eventId);
        Validate.notNull((Object)event, (String)"event does not exist", (Object[])new Object[0]);
        if (organizationId != event.getOrganizationId()) {
            Validate.isTrue((boolean)this.userManager.isOwnerOfOrganization(user, event.getOrganizationId()), (String)"Cannot update settings, user is not owner of event", (Object[])new Object[0]);
        }
        list.stream().filter(ConfigurationManager::toBeSaved).forEach(c -> this.saveEventConfiguration(eventId, organizationId, c.getKey(), c.getValue()));
    }

    public void saveCategoryConfiguration(int categoryId, int eventId, List<ConfigurationModification> list, String username) {
        User user = this.userManager.findUserByUsername(username);
        EventAndOrganizationId event = this.eventRepository.findEventAndOrganizationIdById(eventId);
        Validate.notNull((Object)event, (String)"event does not exist", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.userManager.isOwnerOfOrganization(user, event.getOrganizationId()), (String)"Cannot update settings, user is not owner of event", (Object[])new Object[0]);
        list.stream().filter(ConfigurationManager::toBeSaved).forEach(c -> {
            Optional existing = this.configurationRepository.findByKeyAtCategoryLevel(eventId, event.getOrganizationId(), categoryId, c.getKey());
            Optional value = this.evaluateValue(c.getKey(), c.getValue());
            if (value.isEmpty()) {
                this.configurationRepository.deleteCategoryLevelByKey(c.getKey(), eventId, categoryId);
            } else if (existing.isPresent()) {
                this.configurationRepository.updateCategoryLevel(eventId, event.getOrganizationId(), categoryId, c.getKey(), (String)value.get());
            } else {
                this.configurationRepository.insertTicketCategoryLevel(event.getOrganizationId(), eventId, categoryId, c.getKey(), (String)value.get(), ConfigurationKeys.fromString((String)c.getKey()).getDescription());
            }
        });
    }

    private Optional<String> evaluateValue(String key, String value) {
        if (ConfigurationKeys.fromString((String)key).isBooleanComponentType()) {
            return Optional.ofNullable(StringUtils.trimToNull((String)value));
        }
        return Optional.of(Objects.requireNonNull(value));
    }

    private Optional<Boolean> getThreeStateValue(String value) {
        return Optional.ofNullable(StringUtils.trimToNull((String)value)).map(Boolean::parseBoolean);
    }

    public void saveSystemConfiguration(ConfigurationKeys key, String value) {
        Optional conf = this.findByConfigurationPathAndKey(Configuration.system(), key);
        if (key.isBooleanComponentType()) {
            Optional state = this.getThreeStateValue(value);
            if (conf.filter(c -> c.getConfigurationPathLevel() != ConfigurationPathLevel.EXTERNAL).isPresent()) {
                if (state.isPresent()) {
                    this.configurationRepository.update(key.getValue(), value);
                } else {
                    this.configurationRepository.deleteByKey(key.getValue());
                }
            } else {
                state.ifPresent(v -> this.configurationRepository.insert(key.getValue(), v.toString(), key.getDescription()));
            }
        } else {
            Optional<String> valueOpt = Optional.ofNullable(value);
            if (conf.isEmpty() || ((Configuration)conf.get()).getConfigurationPathLevel() == ConfigurationPathLevel.EXTERNAL) {
                valueOpt.ifPresent(v -> this.configurationRepository.insert(key.getValue(), v, key.getDescription()));
            } else {
                this.configurationRepository.update(key.getValue(), value);
            }
        }
    }

    public boolean isBasicConfigurationNeeded() {
        return ConfigurationKeys.basic().stream().anyMatch(key -> {
            boolean absent = this.externalConfiguration.getSingle(key.getValue()).or(() -> this.configurationRepository.findOptionalByKey(key.getValue())).isEmpty();
            if (absent) {
                log.warn("cannot find a value for " + key.getValue());
            }
            return absent;
        });
    }

    private Predicate<Configuration> checkActualConfigurationLevel(boolean isAdmin, ConfigurationPathLevel level) {
        return conf -> isAdmin || conf.getConfigurationKey().supports(level);
    }

    public Map<ConfigurationKeys.SettingCategory, List<Configuration>> loadOrganizationConfig(int organizationId, String username) {
        User user = this.userManager.findUserByUsername(username);
        if (!this.userManager.isOwnerOfOrganization(user, organizationId)) {
            return Collections.emptyMap();
        }
        boolean isAdmin = this.userManager.isAdmin(user);
        Map existing = (Map)this.configurationRepository.findOrganizationConfiguration(organizationId).stream().filter(this.checkActualConfigurationLevel(isAdmin, ConfigurationPathLevel.ORGANIZATION)).sorted().collect(ConfigurationManager.groupByCategory());
        String paymentMethodsBlacklist = this.getFor(ConfigurationKeys.PAYMENT_METHODS_BLACKLIST, (ConfigurationLevel)new ConfigurationLevels.OrganizationLevel(organizationId)).getValueOrDefault("");
        Map result = this.groupByCategory(isAdmin ? ConfigurationManager.union((ConfigurationPathLevel[])new ConfigurationPathLevel[]{ConfigurationPathLevel.SYSTEM, ConfigurationPathLevel.ORGANIZATION}) : ORGANIZATION_CONFIGURATION, existing);
        List toBeRemoved = PaymentProxy.availableProxies().stream().filter(pp -> paymentMethodsBlacklist.contains(pp.getKey())).flatMap(pp -> pp.getSettingCategories().stream()).collect(Collectors.toList());
        if (toBeRemoved.isEmpty()) {
            return result;
        }
        return result.entrySet().stream().filter(entry -> !toBeRemoved.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public String getSingleConfigForOrganization(int organizationId, String keyAsString, String username) {
        User user = this.userManager.findUserByUsername(username);
        if (!this.userManager.isOwnerOfOrganization(user, organizationId)) {
            return null;
        }
        ConfigurationKeys key = ConfigurationKeys.safeValueOf((String)keyAsString);
        return this.getFirstConfigurationResult(this.configurationRepository.findByOrganizationAndKey(organizationId, key.name()), keyAsString);
    }

    public String getSingleConfigForEvent(int eventId, String keyAsString, String username) {
        EventAndOrganizationId event;
        int organizationId;
        User user = this.userManager.findUserByUsername(username);
        if (!this.userManager.isOwnerOfOrganization(user, organizationId = (event = this.eventRepository.findEventAndOrganizationIdById(eventId)).getOrganizationId())) {
            return null;
        }
        ConfigurationKeys key = ConfigurationKeys.safeValueOf((String)keyAsString);
        return this.getFirstConfigurationResult(this.configurationRepository.findByEventAndKey(organizationId, eventId, key.name()), keyAsString);
    }

    private String getFirstConfigurationResult(List<Configuration> results, String keyAsString) {
        return Objects.requireNonNull(results).stream().findFirst().map(Configuration::getValue).or(() -> this.externalConfiguration.getSingle(keyAsString).map(Configuration::getValue)).orElse(null);
    }

    public Map<ConfigurationKeys.SettingCategory, List<Configuration>> loadEventConfig(int eventId, String username) {
        EventAndOrganizationId event;
        int organizationId;
        User user = this.userManager.findUserByUsername(username);
        if (!this.userManager.isOwnerOfOrganization(user, organizationId = (event = this.eventRepository.findEventAndOrganizationIdById(eventId)).getOrganizationId())) {
            return Collections.emptyMap();
        }
        boolean isAdmin = this.userManager.isAdmin(user);
        Map existing = (Map)this.configurationRepository.findEventConfiguration(organizationId, eventId).stream().filter(this.checkActualConfigurationLevel(isAdmin, ConfigurationPathLevel.PURCHASE_CONTEXT)).sorted().collect(ConfigurationManager.groupByCategory());
        boolean offlineCheckInEnabled = this.areBooleanSettingsEnabledForEvent(new ConfigurationKeys[]{ConfigurationKeys.ALFIO_PI_INTEGRATION_ENABLED, ConfigurationKeys.OFFLINE_CHECKIN_ENABLED}).test(event);
        return ConfigurationManager.removeAlfioPISettingsIfNeeded((boolean)offlineCheckInEnabled, (Map)this.groupByCategory(isAdmin ? ConfigurationManager.union((ConfigurationPathLevel[])new ConfigurationPathLevel[]{ConfigurationPathLevel.SYSTEM, ConfigurationPathLevel.PURCHASE_CONTEXT}) : PURCHASE_CONTEXT_CONFIGURATION, existing));
    }

    public Map<ConfigurationKeys.SettingCategory, List<Configuration>> loadSubscriptionDescriptorConfig(SubscriptionDescriptor subscriptionDescriptor, String username) {
        int organizationId;
        User user = this.userManager.findUserByUsername(username);
        if (!this.userManager.isOwnerOfOrganization(user, organizationId = subscriptionDescriptor.getOrganizationId())) {
            return Collections.emptyMap();
        }
        boolean isAdmin = this.userManager.isAdmin(user);
        Map existing = (Map)this.configurationRepository.findSubscriptionDescriptorConfiguration(organizationId, subscriptionDescriptor.getId()).stream().filter(this.checkActualConfigurationLevel(isAdmin, ConfigurationPathLevel.PURCHASE_CONTEXT)).sorted().collect(ConfigurationManager.groupByCategory());
        return this.groupByCategory(isAdmin ? ConfigurationManager.union((ConfigurationPathLevel[])new ConfigurationPathLevel[]{ConfigurationPathLevel.SYSTEM, ConfigurationPathLevel.PURCHASE_CONTEXT}) : PURCHASE_CONTEXT_CONFIGURATION, existing);
    }

    public Predicate<EventAndOrganizationId> areBooleanSettingsEnabledForEvent(ConfigurationKeys ... keys) {
        return event -> this.getFor(Set.of(keys), event.getConfigurationLevel()).entrySet().stream().allMatch(kv -> ((MaybeConfiguration)kv.getValue()).getValueAsBooleanOrDefault());
    }

    private static Map<ConfigurationKeys.SettingCategory, List<Configuration>> removeAlfioPISettingsIfNeeded(boolean offlineCheckInEnabled, Map<ConfigurationKeys.SettingCategory, List<Configuration>> settings) {
        if (offlineCheckInEnabled) {
            return settings;
        }
        return settings.entrySet().stream().filter(e -> e.getKey() != ConfigurationKeys.SettingCategory.ALFIO_PI).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static Map<ConfigurationKeys.SettingCategory, List<Configuration>> union(ConfigurationPathLevel ... levels) {
        List configurations = Arrays.stream(levels).sorted(ConfigurationPathLevel.COMPARATOR.reversed()).flatMap(l -> ConfigurationKeys.byPathLevel((ConfigurationPathLevel)l).stream().map(ConfigurationManager.mapEmptyKeys((ConfigurationPathLevel)l))).sorted((c1, c2) -> new CompareToBuilder().append((Object)c2.getConfigurationPathLevel(), (Object)c1.getConfigurationPathLevel()).append((Object)c1.getConfigurationKey(), (Object)c2.getConfigurationKey()).toComparison()).collect(ArrayList::new, (list, conf) -> {
            int existing = (int)list.stream().filter(c -> c.getConfigurationKey() == conf.getConfigurationKey()).count();
            if (existing == 0) {
                list.add(conf);
            }
        }, (l1, l2) -> {});
        return (Map)configurations.stream().collect(ConfigurationManager.groupByCategory());
    }

    public Map<ConfigurationKeys.SettingCategory, List<Configuration>> loadCategoryConfig(int eventId, int categoryId, String username) {
        EventAndOrganizationId event;
        int organizationId;
        User user = this.userManager.findUserByUsername(username);
        if (!this.userManager.isOwnerOfOrganization(user, organizationId = (event = this.eventRepository.findEventAndOrganizationIdById(eventId)).getOrganizationId())) {
            return Collections.emptyMap();
        }
        Map existing = (Map)this.configurationRepository.findCategoryConfiguration(organizationId, eventId, categoryId).stream().sorted().collect(ConfigurationManager.groupByCategory());
        return this.groupByCategory(CATEGORY_CONFIGURATION, existing);
    }

    private Map<ConfigurationKeys.SettingCategory, List<Configuration>> groupByCategory(Map<ConfigurationKeys.SettingCategory, List<Configuration>> all, Map<ConfigurationKeys.SettingCategory, List<Configuration>> existing) {
        return all.entrySet().stream().map(e -> {
            ConfigurationKeys.SettingCategory key = (ConfigurationKeys.SettingCategory)e.getKey();
            TreeSet<Configuration> entries = new TreeSet<Configuration>((Collection)e.getValue());
            if (existing.containsKey(key)) {
                List<Configuration> configurations = ((List)existing.get(key)).stream().filter(Predicate.not(Configuration::isInternal)).collect(Collectors.toList());
                configurations.forEach(entries::remove);
                entries.addAll(configurations);
            }
            return Pair.of((Object)key, new ArrayList(entries));
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public Map<ConfigurationKeys.SettingCategory, List<Configuration>> loadAllSystemConfigurationIncludingMissing(String username) {
        if (!this.userManager.isAdmin(this.userManager.findUserByUsername(username))) {
            return Collections.emptyMap();
        }
        List existing = this.configurationRepository.findSystemConfiguration().stream().filter(c -> !ConfigurationKeys.fromString((String)c.getKey()).isInternal()).collect(Collectors.toList());
        List missing = Arrays.stream(ConfigurationKeys.visible()).filter(k -> existing.stream().noneMatch(c -> c.getKey().equals(k.getValue()))).map(ConfigurationManager.mapEmptyKeys((ConfigurationPathLevel)ConfigurationPathLevel.SYSTEM)).collect(Collectors.toList());
        ArrayList result = new ArrayList(existing);
        result.addAll(missing);
        return (Map)result.stream().sorted().collect(ConfigurationManager.groupByCategory());
    }

    private static Collector<Configuration, ?, Map<ConfigurationKeys.SettingCategory, List<Configuration>>> groupByCategory() {
        return Collectors.groupingBy(c -> c.getConfigurationKey().getCategory());
    }

    private static Function<ConfigurationKeys, Configuration> mapEmptyKeys(ConfigurationPathLevel level) {
        return k -> new Configuration(-1, k.getValue(), null, level);
    }

    public void deleteKey(String key) {
        this.configurationRepository.deleteByKey(key);
    }

    public void deleteOrganizationLevelByKey(String key, int organizationId, String username) {
        Validate.isTrue((boolean)this.userManager.isOwnerOfOrganization(this.userManager.findUserByUsername(username), organizationId), (String)"User is not owner of the organization. Therefore, delete is not allowed.", (Object[])new Object[0]);
        this.configurationRepository.deleteOrganizationLevelByKey(key, organizationId);
    }

    public void deleteEventLevelByKey(String key, int eventId, String username) {
        EventAndOrganizationId event = this.eventRepository.findEventAndOrganizationIdById(eventId);
        Validate.notNull((Object)event, (String)"Wrong event id", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.userManager.isOwnerOfOrganization(this.userManager.findUserByUsername(username), event.getOrganizationId()), (String)"User is not owner of the organization. Therefore, delete is not allowed.", (Object[])new Object[0]);
        this.configurationRepository.deleteEventLevelByKey(key, eventId);
    }

    public void deleteCategoryLevelByKey(String key, int eventId, int categoryId, String username) {
        EventAndOrganizationId event = this.eventRepository.findEventAndOrganizationIdById(eventId);
        Validate.notNull((Object)event, (String)"Wrong event id", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.userManager.isOwnerOfOrganization(this.userManager.findUserByUsername(username), event.getOrganizationId()), (String)"User is not owner of the organization. Therefore, delete is not allowed.", (Object[])new Object[0]);
        this.configurationRepository.deleteCategoryLevelByKey(key, eventId, categoryId);
    }

    private static Map<ConfigurationKeys.SettingCategory, List<Configuration>> collectConfigurationKeysByCategory(ConfigurationPathLevel pathLevel) {
        return (Map)ConfigurationKeys.byPathLevel((ConfigurationPathLevel)pathLevel).stream().map(ConfigurationManager.mapEmptyKeys((ConfigurationPathLevel)pathLevel)).sorted().collect(ConfigurationManager.groupByCategory());
    }

    public String getShortReservationID(Configurable configurable, TicketReservation reservation) {
        Map conf = this.getFor(Set.of(ConfigurationKeys.USE_INVOICE_NUMBER_AS_ID, ConfigurationKeys.PARTIAL_RESERVATION_ID_LENGTH), configurable.getConfigurationLevel());
        if (((MaybeConfiguration)conf.get(ConfigurationKeys.USE_INVOICE_NUMBER_AS_ID)).getValueAsBooleanOrDefault() && reservation.getHasInvoiceNumber()) {
            return reservation.getInvoiceNumber();
        }
        return StringUtils.substring((String)reservation.getId(), (int)0, (int)((MaybeConfiguration)conf.get(ConfigurationKeys.PARTIAL_RESERVATION_ID_LENGTH)).getValueAsIntOrDefault(8)).toUpperCase();
    }

    public String getPublicReservationID(Configurable configurable, TicketReservation reservation) {
        if (this.getFor(ConfigurationKeys.USE_INVOICE_NUMBER_AS_ID, configurable.getConfigurationLevel()).getValueAsBooleanOrDefault() && reservation.getHasInvoiceNumber()) {
            return reservation.getInvoiceNumber();
        }
        return reservation.getId();
    }

    public boolean hasAllConfigurationsForInvoice(Configurable configurable) {
        Map r = this.getFor(Set.of(ConfigurationKeys.INVOICE_ADDRESS, ConfigurationKeys.VAT_NR), configurable.getConfigurationLevel());
        return this.hasAllConfigurationsForInvoice(r);
    }

    public boolean hasAllConfigurationsForInvoice(Map<ConfigurationKeys, MaybeConfiguration> configurationValues) {
        Validate.isTrue((configurationValues.containsKey(ConfigurationKeys.INVOICE_ADDRESS) && configurationValues.containsKey(ConfigurationKeys.VAT_NR) ? 1 : 0) != 0);
        return configurationValues.get(ConfigurationKeys.INVOICE_ADDRESS).isPresent() && configurationValues.get(ConfigurationKeys.VAT_NR).isPresent();
    }

    public boolean isRecaptchaForOfflinePaymentAndFreeEnabled(Map<ConfigurationKeys, MaybeConfiguration> configurationValues) {
        Validate.isTrue((configurationValues.containsKey(ConfigurationKeys.ENABLE_CAPTCHA_FOR_OFFLINE_PAYMENTS) && configurationValues.containsKey(ConfigurationKeys.RECAPTCHA_API_KEY) ? 1 : 0) != 0);
        return configurationValues.get(ConfigurationKeys.ENABLE_CAPTCHA_FOR_OFFLINE_PAYMENTS).getValueAsBooleanOrDefault() && configurationValues.get(ConfigurationKeys.RECAPTCHA_API_KEY).getValueOrNull() != null;
    }

    public boolean isRecaptchaForOfflinePaymentAndFreeEnabled(ConfigurationLevel configurationLevel) {
        Map conf = this.getFor(Set.of(ConfigurationKeys.ENABLE_CAPTCHA_FOR_OFFLINE_PAYMENTS, ConfigurationKeys.RECAPTCHA_API_KEY), configurationLevel);
        return this.isRecaptchaForOfflinePaymentAndFreeEnabled(conf);
    }

    public boolean canAttachBillingDocumentToConfirmationEmail(Configurable configurable) {
        Map config = this.getFor(List.of(ConfigurationKeys.ENABLE_ITALY_E_INVOICING, ConfigurationKeys.ITALY_E_INVOICING_SEND_PROFORMA), configurable.getConfigurationLevel());
        return !this.isItalianEInvoicingEnabled(config) || ((MaybeConfiguration)config.get(ConfigurationKeys.ITALY_E_INVOICING_SEND_PROFORMA)).getValueAsBooleanOrDefault();
    }

    public boolean canGenerateReceiptOrInvoiceToCustomer(Configurable configurable) {
        return !this.isItalianEInvoicingEnabled(configurable);
    }

    public boolean canGenerateReceiptOrInvoiceToCustomer(Map<ConfigurationKeys, MaybeConfiguration> configurationValues) {
        return !this.isItalianEInvoicingEnabled(configurationValues);
    }

    public boolean isInvoiceOnly(Configurable configurable) {
        Map res = this.getFor(Set.of(ConfigurationKeys.GENERATE_ONLY_INVOICE, ConfigurationKeys.ENABLE_ITALY_E_INVOICING), configurable.getConfigurationLevel());
        return this.isInvoiceOnly(res);
    }

    public boolean isInvoiceOnly(Map<ConfigurationKeys, MaybeConfiguration> configurationValues) {
        Validate.isTrue((configurationValues.containsKey(ConfigurationKeys.GENERATE_ONLY_INVOICE) && configurationValues.containsKey(ConfigurationKeys.ENABLE_ITALY_E_INVOICING) ? 1 : 0) != 0);
        return configurationValues.get(ConfigurationKeys.GENERATE_ONLY_INVOICE).getValueAsBooleanOrDefault() || configurationValues.get(ConfigurationKeys.ENABLE_ITALY_E_INVOICING).getValueAsBooleanOrDefault();
    }

    public boolean isItalianEInvoicingEnabled(Configurable configurable) {
        return this.isItalianEInvoicingEnabled(configurable.getConfigurationLevel());
    }

    public boolean isItalianEInvoicingEnabled(ConfigurationLevel configurationLevel) {
        Map res = this.getFor(List.of(ConfigurationKeys.ENABLE_ITALY_E_INVOICING), configurationLevel);
        return this.isItalianEInvoicingEnabled(res);
    }

    public boolean isItalianEInvoicingEnabled(Map<ConfigurationKeys, MaybeConfiguration> configurationValues) {
        Validate.isTrue((boolean)configurationValues.containsKey(ConfigurationKeys.ENABLE_ITALY_E_INVOICING));
        return configurationValues.get(ConfigurationKeys.ENABLE_ITALY_E_INVOICING).getValueAsBooleanOrDefault();
    }

    public MaybeConfiguration getForSystem(ConfigurationKeys key) {
        return (MaybeConfiguration)this.getFor(Set.of(key), ConfigurationLevel.system()).get(key);
    }

    public MaybeConfiguration getFor(ConfigurationKeys key, ConfigurationLevel configurationLevel) {
        return (MaybeConfiguration)this.getFor(Set.of(key), configurationLevel).get(key);
    }

    public Map<ConfigurationKeys, MaybeConfiguration> getFor(Collection<ConfigurationKeys> keys, ConfigurationLevel configurationLevel) {
        Set keysAsString = keys.stream().map(ConfigurationKeys::getValue).collect(Collectors.toSet());
        ArrayList found = new ArrayList(this.externalConfiguration.getAll(keysAsString));
        switch (1.$SwitchMap$alfio$model$system$ConfigurationPathLevel[configurationLevel.getPathLevel().ordinal()]) {
            case 1: {
                found.addAll(this.configurationRepository.findByKeysAtSystemLevel(keysAsString));
                break;
            }
            case 2: {
                found.addAll(this.configurationRepository.findByOrganizationAndKeys(((ConfigurationLevels.OrganizationLevel)configurationLevel).organizationId, keysAsString));
                break;
            }
            case 3: {
                if (configurationLevel instanceof ConfigurationLevels.EventLevel) {
                    ConfigurationLevels.EventLevel eventLevel = (ConfigurationLevels.EventLevel)configurationLevel;
                    found.addAll(this.configurationRepository.findByEventAndKeys(eventLevel.organizationId, eventLevel.eventId, keysAsString));
                    break;
                }
                ConfigurationLevels.SubscriptionDescriptorLevel subscriptionDescriptorLevel = (ConfigurationLevels.SubscriptionDescriptorLevel)configurationLevel;
                found.addAll(this.configurationRepository.findBySubscriptionDescriptorAndKeys(subscriptionDescriptorLevel.organizationId, subscriptionDescriptorLevel.subscriptionDescriptorId, keysAsString));
                break;
            }
            case 4: {
                ConfigurationLevels.CategoryLevel categoryLevel = (ConfigurationLevels.CategoryLevel)configurationLevel;
                found.addAll(this.configurationRepository.findByTicketCategoryAndKeys(categoryLevel.organizationId, categoryLevel.eventId, categoryLevel.categoryId, keysAsString));
                break;
            }
        }
        return this.buildKeyConfigurationMapResult(keys, found);
    }

    private Map<ConfigurationKeys, MaybeConfiguration> buildKeyConfigurationMapResult(Collection<ConfigurationKeys> keys, List<ConfigurationKeyValuePathLevel> found) {
        EnumMap<ConfigurationKeys, MaybeConfiguration> res = new EnumMap<ConfigurationKeys, MaybeConfiguration>(ConfigurationKeys.class);
        for (ConfigurationKeys k : keys) {
            res.put(k, new MaybeConfiguration(k));
        }
        for (ConfigurationKeyValuePathLevel c : found) {
            res.get(c.getConfigurationKey()).ifPresentOrElse(alreadyPresent -> {
                if (alreadyPresent.getConfigurationPathLevel().getPriority() < c.getConfigurationPathLevel().getPriority()) {
                    res.put(c.getConfigurationKey(), new MaybeConfiguration(c.getConfigurationKey(), c));
                }
            }, () -> res.put(c.getConfigurationKey(), new MaybeConfiguration(c.getConfigurationKey(), c)));
        }
        return res;
    }

    public List<PaymentMethod> getBlacklistedMethodsForReservation(PurchaseContext p, Collection<Integer> categoryIds) {
        return p.event().map(e -> {
            if (categoryIds.size() > 1) {
                Map blacklistForCategories = this.configurationRepository.getAllCategoriesAndValueWith(e.getOrganizationId(), e.getId(), ConfigurationKeys.PAYMENT_METHODS_BLACKLIST);
                return categoryIds.stream().filter(blacklistForCategories::containsKey).flatMap(id -> Arrays.stream(((String)blacklistForCategories.get(id)).split(","))).filter(StringUtils::isNotBlank).map(name -> PaymentProxy.valueOf((String)name).getPaymentMethod()).collect(Collectors.toList());
            }
            if (!categoryIds.isEmpty()) {
                return this.configurationRepository.findByKeyAtCategoryLevel(e.getId(), e.getOrganizationId(), ((Integer)IterableUtils.get((Iterable)categoryIds, (int)0)).intValue(), ConfigurationKeys.PAYMENT_METHODS_BLACKLIST.name()).filter(v -> StringUtils.isNotBlank((CharSequence)v.getValue())).map(v -> Arrays.stream(v.getValue().split(",")).map(name -> PaymentProxy.valueOf((String)name).getPaymentMethod()).collect(Collectors.toList())).orElse(List.of());
            }
            return List.of();
        }).orElse(List.of());
    }

    private static boolean toBeSaved(ConfigurationModification c) {
        return Optional.ofNullable(c.getId()).orElse(-1) > -1 || !StringUtils.isBlank((CharSequence)c.getValue());
    }

    public List<Integer> getCategoriesWithNoTaxes(List<Integer> categoriesIds) {
        if (categoriesIds.isEmpty()) {
            return List.of();
        }
        return this.configurationRepository.getCategoriesWithFlag(categoriesIds, ConfigurationKeys.APPLY_TAX_TO_CATEGORY.name(), "false");
    }

    public boolean noTaxesFlagDefinedFor(List<TicketCategory> categories) {
        return !this.getCategoriesWithNoTaxes(categories.stream().map(TicketCategory::getId).collect(Collectors.toList())).isEmpty();
    }

    public Map<Integer, String> getAllCategoriesAndValueWith(EventAndOrganizationId event, ConfigurationKeys key) {
        return this.configurationRepository.getAllCategoriesAndValueWith(event.getOrganizationId(), event.getId(), key);
    }

    public AlfioInfo getInfo(HttpSession session) {
        boolean demoMode = this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"demo"}));
        boolean devMode = this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"dev"}));
        boolean prodMode = this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"!dev"}));
        EnumSet<ConfigurationKeys[]> options = EnumSet.of(ConfigurationKeys.GOOGLE_ANALYTICS_ANONYMOUS_MODE, new ConfigurationKeys[]{ConfigurationKeys.GOOGLE_ANALYTICS_KEY, ConfigurationKeys.GLOBAL_PRIVACY_POLICY, ConfigurationKeys.GLOBAL_TERMS, ConfigurationKeys.ENABLE_ITALY_E_INVOICING, ConfigurationKeys.ENABLE_CUSTOMER_REFERENCE, ConfigurationKeys.VAT_NUMBER_IS_REQUIRED, ConfigurationKeys.GENERATE_ONLY_INVOICE, ConfigurationKeys.INVOICE_ADDRESS, ConfigurationKeys.VAT_NR, ConfigurationKeys.ENABLE_EU_VAT_DIRECTIVE, ConfigurationKeys.COUNTRY_OF_BUSINESS, ConfigurationKeys.ENABLE_REVERSE_CHARGE_IN_PERSON, ConfigurationKeys.ENABLE_REVERSE_CHARGE_ONLINE, ConfigurationKeys.ANNOUNCEMENT_BANNER_CONTENT, ConfigurationKeys.ENABLE_WALLET, ConfigurationKeys.ENABLE_PASS, ConfigurationKeys.CF_TURNSTILE_SITE_KEY, ConfigurationKeys.CF_TURNSTILE_ENABLED});
        Map conf = this.getFor(options, ConfigurationLevel.system());
        AnalyticsConfiguration analyticsConf = AnalyticsConfiguration.build((Map)conf, (HttpSession)session);
        ChallengeConfiguration challengeConfiguration = ChallengeConfiguration.build((Map)conf);
        return new AlfioInfo(demoMode, devMode, prodMode, analyticsConf, ((MaybeConfiguration)conf.get(ConfigurationKeys.GLOBAL_PRIVACY_POLICY)).getValueOrNull(), ((MaybeConfiguration)conf.get(ConfigurationKeys.GLOBAL_TERMS)).getValueOrNull(), PurchaseContextInfoBuilder.invoicingInfo((ConfigurationManager)this, (Map)conf), StringUtils.trimToNull((String)((MaybeConfiguration)conf.get(ConfigurationKeys.ANNOUNCEMENT_BANNER_CONTENT)).getValueOrNull()), new WalletConfiguration(((MaybeConfiguration)conf.get(ConfigurationKeys.ENABLE_WALLET)).getValueAsBooleanOrDefault(), ((MaybeConfiguration)conf.get(ConfigurationKeys.ENABLE_PASS)).getValueAsBooleanOrDefault()), challengeConfiguration);
    }

    public Map<ConfigurationKeys, MaybeConfiguration> getPublicOpenIdConfiguration() {
        return (Map)this.oneMinuteCache.get(EnumSet.of(ConfigurationKeys.OPENID_PUBLIC_ENABLED, ConfigurationKeys.OPENID_CONFIGURATION_JSON), k -> this.getFor((Collection)k, ConfigurationLevel.system()));
    }

    public Map<ConfigurationKeys, MaybeConfiguration> getTurnstileConfiguration() {
        return (Map)this.oneMinuteCache.get(EnumSet.of(ConfigurationKeys.CF_TURNSTILE_ENABLED, ConfigurationKeys.CF_TURNSTILE_SECRET_KEY, ConfigurationKeys.CF_TURNSTILE_SITE_KEY, ConfigurationKeys.CF_TURNSTILE_PRE_CLEARANCE), k -> this.getFor((Collection)k, ConfigurationLevel.system()));
    }

    public boolean isPublicOpenIdEnabled() {
        return ((MaybeConfiguration)this.getPublicOpenIdConfiguration().get(ConfigurationKeys.OPENID_PUBLIC_ENABLED)).getValueAsBooleanOrDefault();
    }

    public String baseUrl(PurchaseContext purchaseContext) {
        ConfigurationLevel configurationLevel = purchaseContext.event().map(ConfigurationLevel::event).orElseGet(() -> ConfigurationLevel.organization((int)purchaseContext.getOrganizationId()));
        return StringUtils.removeEnd((String)this.getFor(ConfigurationKeys.BASE_URL, configurationLevel).getRequiredValue(), (String)"/");
    }

    public String retrieveSystemApiKey(boolean rotate) {
        String apiKeyValue;
        Optional existing = this.configurationRepository.findOptionalByKey(ConfigurationKeys.SYSTEM_API_KEY.name());
        if (existing.isPresent() && rotate) {
            apiKeyValue = this.generateApiKey();
            this.configurationRepository.update(ConfigurationKeys.SYSTEM_API_KEY.name(), apiKeyValue);
        } else if (existing.isPresent()) {
            apiKeyValue = ((Configuration)existing.get()).getValue();
        } else {
            apiKeyValue = this.generateApiKey();
            this.configurationRepository.insert(ConfigurationKeys.SYSTEM_API_KEY.name(), apiKeyValue, ConfigurationKeys.SYSTEM_API_KEY.getDescription());
        }
        return apiKeyValue;
    }

    private String generateApiKey() {
        byte[] bytes = new byte[48];
        this.secureRandom.nextBytes(bytes);
        return new BigInteger(1, bytes).toString(36);
    }

    @ConstructorProperties(value={"configurationRepository", "userManager", "eventRepository", "externalConfiguration", "environment", "oneMinuteCache"})
    @Generated
    public ConfigurationManager(ConfigurationRepository configurationRepository, UserManager userManager, EventRepository eventRepository, ExternalConfiguration externalConfiguration, Environment environment, Cache<Set<ConfigurationKeys>, Map<ConfigurationKeys, MaybeConfiguration>> oneMinuteCache) {
        this.configurationRepository = configurationRepository;
        this.userManager = userManager;
        this.eventRepository = eventRepository;
        this.externalConfiguration = externalConfiguration;
        this.environment = environment;
        this.oneMinuteCache = oneMinuteCache;
    }
}

