/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.system;

import alfio.manager.BillingDocumentManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.system.ReservationPriceCalculator;
import alfio.model.AdditionalService;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.PriceContainer;
import alfio.model.PromoCodeDiscount;
import alfio.model.PurchaseContext;
import alfio.model.TicketCategory;
import alfio.model.TicketReservation;
import alfio.model.TicketWithReservationAndTransaction;
import alfio.model.system.ConfigurationKeys;
import alfio.model.system.EventMigration;
import alfio.repository.AdditionalServiceItemRepository;
import alfio.repository.AdditionalServiceRepository;
import alfio.repository.EventRepository;
import alfio.repository.PromoCodeDiscountRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketSearchRepository;
import alfio.repository.system.ConfigurationRepository;
import alfio.repository.system.EventMigrationRepository;
import alfio.util.ClockProvider;
import alfio.util.MonetaryUtil;
import alfio.util.Wrappers;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.namedparam.EmptySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Transactional
public class DataMigrator {
    private static final Logger log = LoggerFactory.getLogger(DataMigrator.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d\\.)([0-9.]*)(-SNAPSHOT)?");
    private static final Map<String, String> PRICE_UPDATE_BY_KEY = new LinkedHashMap();
    private final EventMigrationRepository eventMigrationRepository;
    private final EventRepository eventRepository;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final BigDecimal currentVersion;
    private final String currentVersionAsString;
    private final ZonedDateTime buildTimestamp;
    private final TransactionTemplate transactionTemplate;
    private final ConfigurationRepository configurationRepository;
    private final NamedParameterJdbcTemplate jdbc;
    private final TicketReservationManager ticketReservationManager;
    private final TicketSearchRepository ticketSearchRepository;
    private final PromoCodeDiscountRepository promoCodeDiscountRepository;
    private final AdditionalServiceItemRepository additionalServiceItemRepository;
    private final AdditionalServiceRepository additionalServiceRepository;
    private final BillingDocumentManager billingDocumentManager;
    private final ClockProvider clockProvider;

    public DataMigrator(EventMigrationRepository eventMigrationRepository, EventRepository eventRepository, TicketCategoryRepository ticketCategoryRepository, @Value(value="${alfio.version}") String currentVersion, @Value(value="${alfio.build-ts}") String buildTimestamp, PlatformTransactionManager transactionManager, ConfigurationRepository configurationRepository, NamedParameterJdbcTemplate jdbc, TicketReservationManager ticketReservationManager, TicketSearchRepository ticketSearchRepository, PromoCodeDiscountRepository promoCodeDiscountRepository, AdditionalServiceItemRepository additionalServiceItemRepository, AdditionalServiceRepository additionalServiceRepository, BillingDocumentManager billingDocumentManager, ClockProvider clockProvider) {
        this.eventMigrationRepository = eventMigrationRepository;
        this.eventRepository = eventRepository;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.configurationRepository = configurationRepository;
        this.jdbc = jdbc;
        this.currentVersion = DataMigrator.parseVersion((String)currentVersion);
        this.currentVersionAsString = currentVersion;
        this.buildTimestamp = ZonedDateTime.parse(buildTimestamp);
        this.transactionTemplate = new TransactionTemplate(transactionManager, (TransactionDefinition)new DefaultTransactionDefinition(3));
        this.ticketReservationManager = ticketReservationManager;
        this.ticketSearchRepository = ticketSearchRepository;
        this.promoCodeDiscountRepository = promoCodeDiscountRepository;
        this.additionalServiceItemRepository = additionalServiceItemRepository;
        this.additionalServiceRepository = additionalServiceRepository;
        this.billingDocumentManager = billingDocumentManager;
        this.clockProvider = clockProvider;
    }

    public void migrateEventsToCurrentVersion() {
        List events = this.eventRepository.findAll();
        events.forEach(arg_0 -> this.migrateEventToCurrentVersion(arg_0));
        this.fillReservationsLanguage();
        this.fillDefaultOptions();
        this.fixReservationPrice(events);
        this.fixVatStatus();
    }

    private void fixVatStatus() {
        this.transactionTemplate.execute(ts -> {
            int rows = this.jdbc.update("update tickets_reservation set vat_status = e.vat_status from event e where tickets_reservation.vat_status is null and tickets_reservation.event_id_fk = e.id", Map.of());
            log.debug("update VAT/GST on {} reservations", (Object)rows);
            return null;
        });
    }

    private void fixReservationPrice(List<Event> events) {
        this.transactionTemplate.execute(ts -> {
            Map candidates = this.jdbc.queryForList("select id, event_id_fk from tickets_reservation where event_id_fk is not null and src_price_cts = 0 and payment_method <> 'NONE' and status not in ('CANCELLED', 'CREDIT_NOTE_ISSUED') order by 2", Map.of()).stream().map(m -> Pair.of((Object)((Integer)m.get("event_id_fk")), (Object)((String)m.get("id")))).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toList())));
            for (Map.Entry entry : candidates.entrySet()) {
                Event event = events.stream().filter(e -> e.getId() == ((Integer)entry.getKey()).intValue()).findFirst().orElseThrow();
                ListUtils.partition(entry.getValue(), (int)1000).forEach(reservations -> this.fixReservationsForEvent(event, reservations));
            }
            return null;
        });
    }

    private void fixReservationsForEvent(Event event, List<String> reservations) {
        Map<String, List<TicketWithReservationAndTransaction>> byReservationId = this.ticketSearchRepository.loadAllReservationsWithTickets(event.getId(), reservations).stream().collect(Collectors.groupingBy(trt -> trt.getTicketReservation().getId()));
        log.trace("found {} reservations to fix for event {}", (Object)byReservationId.size(), (Object)event.getShortName());
        if (!byReservationId.isEmpty()) {
            List additionalServices = this.additionalServiceRepository.loadAllForEvent(event.getId());
            MapSqlParameterSource[] reservationsToUpdate = (MapSqlParameterSource[])byReservationId.values().stream().map(ticketsReservationAndTransactions -> {
                List tickets = ticketsReservationAndTransactions.stream().map(TicketWithReservationAndTransaction::getTicket).collect(Collectors.toList());
                TicketReservation ticketReservation = ((TicketWithReservationAndTransaction)ticketsReservationAndTransactions.get(0)).getTicketReservation();
                Integer promoCodeDiscountId = ticketReservation.getPromoCodeDiscountId();
                PromoCodeDiscount discount = promoCodeDiscountId != null ? this.promoCodeDiscountRepository.findById(promoCodeDiscountId.intValue()) : null;
                List additionalServiceItems = this.additionalServiceItemRepository.findByReservationUuid(event.getId(), ticketReservation.getId());
                ReservationPriceCalculator calculator = new ReservationPriceCalculator(ticketReservation, discount, tickets, additionalServiceItems, additionalServices, (PurchaseContext)event, List.of(), Optional.empty());
                String currencyCode = calculator.getCurrencyCode();
                return new MapSqlParameterSource("reservationId", (Object)calculator.reservation.getId()).addValue("srcPrice", (Object)calculator.getSrcPriceCts()).addValue("finalPrice", (Object)MonetaryUtil.unitToCents((BigDecimal)calculator.getFinalPrice(), (String)currencyCode)).addValue("discount", (Object)MonetaryUtil.unitToCents((BigDecimal)calculator.getAppliedDiscount(), (String)currencyCode)).addValue("vat", (Object)MonetaryUtil.unitToCents((BigDecimal)calculator.getVAT(), (String)currencyCode)).addValue("currencyCode", (Object)currencyCode);
            }).toArray(MapSqlParameterSource[]::new);
            log.trace("updating {} reservations", (Object)reservationsToUpdate.length);
            int[] results = this.jdbc.batchUpdate("update tickets_reservation set src_price_cts = :srcPrice, final_price_cts = :finalPrice, discount_cts = :discount, vat_cts = :vat, currency_code = :currencyCode where id = :reservationId", (SqlParameterSource[])reservationsToUpdate);
            int sum = IntStream.of(results).sum();
            if (sum != reservationsToUpdate.length) {
                log.warn("Expected {} reservations to be affected, actual number: {}", (Object)reservationsToUpdate.length, (Object)sum);
            }
        }
    }

    private void fillDefaultOptions() {
        this.transactionTemplate.execute(ts -> {
            Integer count = (Integer)this.jdbc.queryForObject("select count(*) from configuration where c_key = :key", (SqlParameterSource)new MapSqlParameterSource("key", (Object)ConfigurationKeys.GOOGLE_ANALYTICS_ANONYMOUS_MODE.getValue()), Integer.class);
            if (count == null || count == 0) {
                this.configurationRepository.insert(ConfigurationKeys.GOOGLE_ANALYTICS_ANONYMOUS_MODE.getValue(), "true", ConfigurationKeys.GOOGLE_ANALYTICS_ANONYMOUS_MODE.getDescription());
            }
            return null;
        });
    }

    private void migrateEventToCurrentVersion(Event event) {
        Optional optional = Wrappers.optionally(() -> this.eventMigrationRepository.loadEventMigration(event.getId()));
        boolean alreadyDefined = optional.isPresent();
        if (!alreadyDefined || optional.filter(arg_0 -> this.needsFixing(arg_0)).isPresent()) {
            this.transactionTemplate.execute(s -> {
                if (event.now(this.clockProvider).isBefore(event.getEnd())) {
                    this.fixAvailableSeats(event);
                    this.fillDescriptions(event);
                    this.fixCategoriesSize((EventAndOrganizationId)event);
                }
                this.migratePrices(event.getId());
                this.fixStuckTickets(event.getId());
                this.createBillingDocuments(event);
                if (alreadyDefined) {
                    EventMigration eventMigration = (EventMigration)optional.get();
                    int result = this.eventMigrationRepository.updateMigrationData(eventMigration.getId(), this.currentVersionAsString, this.buildTimestamp, EventMigration.Status.COMPLETE.name());
                    Validate.isTrue((result == 1 ? 1 : 0) != 0, (String)("error during update " + result), (Object[])new Object[0]);
                } else {
                    this.eventMigrationRepository.insertMigrationData(event.getId(), this.currentVersionAsString, this.buildTimestamp, EventMigration.Status.COMPLETE.name());
                }
                return null;
            });
        }
    }

    private void createBillingDocuments(Event event) {
        if (event.getEnd().isAfter(event.now(this.clockProvider))) {
            List reservations = this.jdbc.queryForList("select id from tickets_reservation where event_id_fk = :eventId and status in ('OFFLINE_PAYMENT', 'COMPLETE') and invoice_number is not null and id not in(select distinct reservation_id_fk from billing_document where event_id_fk = :eventId)", (SqlParameterSource)new MapSqlParameterSource("eventId", (Object)event.getId()), String.class);
            if (reservations.isEmpty()) {
                return;
            }
            log.info("creating BillingDocument(s) for event {}", (Object)event.getDisplayName());
            for (String reservationId : reservations) {
                TicketReservation reservation = (TicketReservation)this.ticketReservationManager.findById(reservationId).orElseThrow(IllegalStateException::new);
                this.billingDocumentManager.getOrCreateBillingDocument((PurchaseContext)event, reservation, null, this.ticketReservationManager.orderSummaryForReservation(reservation, (PurchaseContext)event));
            }
            log.info("checked {} BillingDocument(s) for event {}", (Object)reservations.size(), (Object)event.getDisplayName());
        }
    }

    void fixStuckTickets(int eventId) {
        List ticketIds = this.jdbc.queryForList("select a.id from ticket a, tickets_reservation b where a.event_id = :eventId and a.status in('PENDING','TO_BE_PAID') and a.tickets_reservation_id = b.id and b.status = 'CANCELLED'", (SqlParameterSource)new MapSqlParameterSource("eventId", (Object)eventId), Integer.class);
        if (!ticketIds.isEmpty()) {
            int toBeFixed = ticketIds.size();
            log.warn("********* reverting {} stuck tickets ({}) for event id {}", new Object[]{toBeFixed, ticketIds, eventId});
            int[] results = this.jdbc.batchUpdate("update ticket set status = 'RELEASED', TICKETS_RESERVATION_ID = null, FULL_NAME = null, EMAIL_ADDRESS = null, SPECIAL_PRICE_ID_FK = null, LOCKED_ASSIGNMENT = false, USER_LANGUAGE = null, REMINDER_SENT = false, SRC_PRICE_CTS = 0, FINAL_PRICE_CTS = 0, VAT_CTS = 0, DISCOUNT_CTS = 0, FIRST_NAME = null, LAST_NAME = null, EXT_REFERENCE = null, TAGS = array[]::text[], VAT_STATUS = null, METADATA = '{}'::jsonb  where id = :ticketId", (SqlParameterSource[])ticketIds.stream().map(id -> new MapSqlParameterSource("ticketId", id)).toArray(MapSqlParameterSource[]::new));
            int result = Arrays.stream(results).sum();
            Validate.isTrue((result == toBeFixed ? 1 : 0) != 0, (String)("Error while fixing stuck tickets: expected " + toBeFixed + ", got " + result), (Object[])new Object[0]);
        }
    }

    void fixCategoriesSize(EventAndOrganizationId event) {
        this.ticketCategoryRepository.findAllTicketCategories(event.getId()).stream().filter(TicketCategory::isBounded).forEach(tc -> {
            Integer result = (Integer)this.jdbc.queryForObject("select count(*) from ticket where event_id = :eventId and category_id = :categoryId and status <> 'INVALIDATED'", (SqlParameterSource)new MapSqlParameterSource("eventId", (Object)tc.getEventId()).addValue("categoryId", (Object)tc.getId()), Integer.class);
            if (result != null && result.intValue() != tc.getMaxTickets()) {
                log.warn("********* updating category size for {} from {} to {} tickets", new Object[]{tc.getName(), tc.getMaxTickets(), result});
                this.ticketCategoryRepository.updateSeatsAvailability(tc.getId(), result.intValue());
            }
        });
    }

    void fillReservationsLanguage() {
        this.transactionTemplate.execute(s -> {
            this.jdbc.queryForList("select id from tickets_reservation where user_language is null and event_id_fk is not null", (SqlParameterSource)EmptySqlParameterSource.INSTANCE, String.class).forEach(id -> {
                MapSqlParameterSource param = new MapSqlParameterSource("reservationId", id);
                String language = Wrappers.optionally(() -> (String)this.jdbc.queryForObject("select user_language from ticket where tickets_reservation_id = :reservationId limit 1", (SqlParameterSource)param, String.class)).orElse("en");
                this.jdbc.update("update tickets_reservation set user_language = :userLanguage where id = :reservationId", (SqlParameterSource)param.addValue("userLanguage", (Object)language));
            });
            return null;
        });
    }

    private void fillDescriptions(Event event) {
        int result = this.eventRepository.fillDisplayNameIfRequired(event.getId());
        if (result > 0) {
            log.debug("Event {} didn't have displayName, filled with shortName", (Object)event.getShortName());
        }
    }

    private void fixAvailableSeats(Event event) {
        try {
            int availableSeats = this.eventRepository.countExistingTickets(event.getId());
            String paymentProxies = event.getAllowedPaymentProxies().stream().map(Enum::name).collect(Collectors.joining(","));
            this.eventRepository.updatePrices(event.getCurrency(), availableSeats, event.isVatIncluded(), event.getVat(), paymentProxies, event.getId(), event.getVatStatus(), event.getSrcPriceCts());
        }
        catch (Exception ex) {
            log.trace("got exception while fixing available seats", (Throwable)ex);
        }
    }

    boolean needsFixing(EventMigration eventMigration) {
        return eventMigration.getBuildTimestamp().isBefore(this.buildTimestamp) || DataMigrator.parseVersion((String)eventMigration.getCurrentVersion()).compareTo(this.currentVersion) < 0;
    }

    static BigDecimal parseVersion(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.find()) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(matcher.group(1) + matcher.group(2).replaceAll("\\.", ""));
    }

    private void migratePrices(int eventId) {
        Map<String, Integer> eventIdParam = Collections.singletonMap("eventId", eventId);
        String srcPriceCtsParam = "srcPriceCts";
        Map migrationData = this.jdbc.queryForList("select * from event where type = :type and id = :eventId and regular_price_cts > 0", (SqlParameterSource)new MapSqlParameterSource("type", (Object)"INTERNAL").addValue("eventId", (Object)eventId)).stream().flatMap(event -> {
            boolean eventVatIncluded = (Boolean)event.get("vat_included");
            BigDecimal vatPercentage = Optional.ofNullable((BigDecimal)event.get("vat")).orElse(BigDecimal.ZERO);
            int price = (Integer)event.get("regular_price_cts");
            String currencyCode = (String)event.get("currency");
            int eventSrcPrice = eventVatIncluded ? MonetaryUtil.addVAT((int)price, (BigDecimal)vatPercentage) : price;
            ArrayList<Pair> modifications = new ArrayList<Pair>();
            if ((Integer)event.get("src_price_cts") == 0) {
                modifications.add(Pair.of((Object)"event", (Object)new MapSqlParameterSource("srcPriceCts", (Object)eventSrcPrice).addValue("vatStatus", (Object)(eventVatIncluded ? PriceContainer.VatStatus.INCLUDED.name() : PriceContainer.VatStatus.NOT_INCLUDED.name())).addValue("eventId", (Object)eventId)));
            }
            modifications.addAll(this.collectTicketCategoryMigrationData("srcPriceCts", eventVatIncluded, vatPercentage, eventIdParam));
            modifications.addAll(this.collectTicketMigrationData("srcPriceCts", eventVatIncluded, vatPercentage, currencyCode, eventId, eventIdParam));
            modifications.addAll(this.collectASMigrationData("srcPriceCts", eventVatIncluded, vatPercentage, eventIdParam));
            modifications.addAll(this.collectASItemMigrationData("srcPriceCts", eventVatIncluded, vatPercentage, currencyCode, eventIdParam));
            log.debug("Price migration: got {} modifications for event {}", (Object)modifications.size(), event.get("short_name"));
            return modifications.stream();
        }).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toList())));
        if (migrationData.size() > 0) {
            log.debug("Price migration: got modifications for: {}", migrationData.keySet());
            PRICE_UPDATE_BY_KEY.entrySet().stream().filter(e -> migrationData.containsKey(e.getKey())).map(e -> Pair.of((Object)e, (Object)((List)migrationData.get(e.getKey())))).forEach(p -> {
                Map.Entry entry = (Map.Entry)p.getLeft();
                log.debug("migrating {} prices...", entry.getKey());
                DataMigrator.performPriceMigration((String)((String)entry.getValue()), (List)((List)p.getRight()), (NamedParameterJdbcTemplate)this.jdbc);
            });
        }
    }

    private static void performPriceMigration(String updateStatement, List<MapSqlParameterSource> data, NamedParameterJdbcTemplate jdbc) {
        int size = data.size();
        jdbc.batchUpdate(updateStatement, (SqlParameterSource[])data.toArray(new MapSqlParameterSource[size]));
        log.debug("{} records updated", (Object)size);
    }

    private List<Pair<String, MapSqlParameterSource>> collectASItemMigrationData(String srcPriceCtsParam, boolean eventVatIncluded, BigDecimal vatPercentage, String currencyCode, Map<String, Integer> eventIdParam) {
        return this.jdbc.queryForList("select ai.id as id, ai.paid_price_cts as paid_price_cts, a.vat_type as vat_type from additional_service_item ai, additional_service a where ai.paid_price_cts > 0 and ai.src_price_cts = 0 and ai.event_id_fk = :eventId", eventIdParam).stream().map(item -> {
            int oldPrice = (Integer)item.get("paid_price_cts");
            AdditionalService.VatType vatType = AdditionalService.VatType.valueOf((String)((String)item.get("vat_type")));
            return Pair.of((Object)((Integer)item.get("id")), (Object)new /* Unavailable Anonymous Inner Class!! */);
        }).map(p -> {
            PriceContainer priceContainer = (PriceContainer)p.getValue();
            return Pair.of((Object)"additional_service_item", (Object)new MapSqlParameterSource(srcPriceCtsParam, (Object)priceContainer.getSrcPriceCts()).addValue("finalPriceCts", (Object)MonetaryUtil.unitToCents((BigDecimal)priceContainer.getFinalPrice(), (String)currencyCode)).addValue("vatCts", (Object)MonetaryUtil.unitToCents((BigDecimal)priceContainer.getVAT(), (String)currencyCode)).addValue("additionalServiceItemId", p.getKey()));
        }).collect(Collectors.toList());
    }

    private List<Pair<String, MapSqlParameterSource>> collectASMigrationData(String srcPriceCtsParam, boolean eventVatIncluded, BigDecimal vatPercentage, Map<String, Integer> eventIdParam) {
        return this.jdbc.queryForList("select id, price_cts, vat_type from additional_service where event_id_fk = :eventId and fix_price = true and price_cts > 0 and src_price_cts = 0", eventIdParam).stream().map(as -> {
            int priceCts = (Integer)as.get("price_cts");
            AdditionalService.VatType vatType = AdditionalService.VatType.valueOf((String)((String)as.get("vat_type")));
            int srcPrice = vatType == AdditionalService.VatType.INHERITED && eventVatIncluded ? MonetaryUtil.addVAT((int)priceCts, (BigDecimal)vatPercentage) : priceCts;
            return Pair.of((Object)"additional_service", (Object)new MapSqlParameterSource(srcPriceCtsParam, (Object)srcPrice).addValue("additionalServiceId", as.get("id")));
        }).collect(Collectors.toList());
    }

    private List<Pair<String, MapSqlParameterSource>> collectTicketMigrationData(String srcPriceCtsParam, boolean eventVatIncluded, BigDecimal vatPercentage, String currencyCode, int eventId, Map<String, Integer> eventIdParam) {
        return this.jdbc.queryForList("select ticket.id as id, ticket.original_price_cts as original_price_cts, ticket.paid_price_cts as paid_price_cts, promo_code.discount_amount as discount_amount, promo_code.discount_type as discount_type from ticket join tickets_reservation on tickets_reservation.id = ticket.tickets_reservation_id left join promo_code on tickets_reservation.promo_code_id_fk = promo_code.id where ticket.event_id = :eventId and ticket.original_price_cts > 0 and ticket.src_price_cts = 0", eventIdParam).stream().map(ticket -> {
            int oldTicketPrice = (Integer)ticket.get("original_price_cts");
            return Pair.of((Object)((Integer)ticket.get("id")), (Object)new /* Unavailable Anonymous Inner Class!! */);
        }).map(p -> {
            PriceContainer priceContainer = (PriceContainer)p.getValue();
            return Pair.of((Object)"ticket", (Object)new MapSqlParameterSource(srcPriceCtsParam, (Object)priceContainer.getSrcPriceCts()).addValue("finalPriceCts", (Object)MonetaryUtil.unitToCents((BigDecimal)priceContainer.getFinalPrice(), (String)currencyCode)).addValue("vatCts", (Object)MonetaryUtil.unitToCents((BigDecimal)priceContainer.getVAT(), (String)currencyCode)).addValue("discountCts", (Object)MonetaryUtil.unitToCents((BigDecimal)priceContainer.getAppliedDiscount(), (String)currencyCode)).addValue("ticketId", p.getKey()));
        }).collect(Collectors.toList());
    }

    private List<Pair<String, MapSqlParameterSource>> collectTicketCategoryMigrationData(String srcPriceCtsParam, boolean eventVatIncluded, BigDecimal vatPercentage, Map<String, Integer> eventIdParam) {
        return this.jdbc.queryForList("select id, price_cts from ticket_category where event_id = :eventId and price_cts > 0 and src_price_cts = 0", eventIdParam).stream().map(category -> {
            int oldCategoryPrice = (Integer)category.get("price_cts");
            int categorySrcPrice = eventVatIncluded ? MonetaryUtil.addVAT((int)oldCategoryPrice, (BigDecimal)vatPercentage) : oldCategoryPrice;
            return Pair.of((Object)"category", (Object)new MapSqlParameterSource(srcPriceCtsParam, (Object)categorySrcPrice).addValue("categoryId", category.get("id")));
        }).collect(Collectors.toList());
    }

    static {
        PRICE_UPDATE_BY_KEY.put("event", "update event set src_price_cts = :srcPriceCts, vat_status = :vatStatus where id = :eventId");
        PRICE_UPDATE_BY_KEY.put("category", "update ticket_category set src_price_cts = :srcPriceCts where id = :categoryId");
        PRICE_UPDATE_BY_KEY.put("ticket", "update ticket set src_price_cts = :srcPriceCts, final_price_cts = :finalPriceCts, vat_cts = :vatCts, discount_cts = :discountCts where id = :ticketId");
        PRICE_UPDATE_BY_KEY.put("additional_service", "update additional_service set src_price_cts = :srcPriceCts where id = :additionalServiceId");
        PRICE_UPDATE_BY_KEY.put("additional_service_item", "update additional_service_item set src_price_cts = :srcPriceCts, final_price_cts = :finalPriceCts, vat_cts = :vatCts where id = :additionalServiceItemId");
    }
}

