/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.system;

import alfio.manager.system.ConfigurationManager;
import alfio.manager.system.Mailer;
import alfio.manager.system.MailgunMailer;
import alfio.manager.system.MailjetMailer;
import alfio.manager.system.MockMailer;
import alfio.manager.system.SendGridMailer;
import alfio.manager.system.SmtpMailer;
import alfio.model.Configurable;
import alfio.model.system.ConfigurationKeys;
import alfio.repository.user.OrganizationRepository;
import java.net.http.HttpClient;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class DefaultMailer
implements Mailer {
    private final ConfigurationManager configurationManager;
    private final Map<String, Mailer> mailers;
    private final Mailer defaultMailer;
    private final Environment environment;

    public DefaultMailer(ConfigurationManager configurationManager, Environment environment, HttpClient httpClient, OrganizationRepository organizationRepository) {
        this.configurationManager = configurationManager;
        this.environment = environment;
        this.mailers = new HashMap();
        this.defaultMailer = new SmtpMailer(configurationManager, organizationRepository);
        this.mailers.put("smtp", this.defaultMailer);
        this.mailers.put("mailgun", new MailgunMailer(httpClient, configurationManager, organizationRepository));
        this.mailers.put("mailjet", new MailjetMailer(httpClient, configurationManager, organizationRepository));
        this.mailers.put("sendgrid", new SendGridMailer(httpClient, configurationManager, organizationRepository));
        this.mailers.put("disabled", new MockMailer(configurationManager, environment, organizationRepository));
    }

    public void send(Configurable configurable, String fromName, String to, List<String> cc, String subject, String text, Optional<String> html, Mailer.Attachment ... attachments) {
        subject = this.decorateSubjectIfDemo(subject, this.environment);
        String mailerType = this.configurationManager.getFor(ConfigurationKeys.MAILER_TYPE, configurable.getConfigurationLevel()).getValueOrDefault("disabled").toLowerCase(Locale.ENGLISH);
        this.mailers.getOrDefault(mailerType, this.defaultMailer).send(configurable, fromName, to, cc, subject, text, html, attachments);
    }
}

