/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.system;

import alfio.manager.support.extension.ExtensionCapability;
import alfio.manager.system.ExternalConfiguration;
import alfio.model.ExtensionCapabilitySummary;
import alfio.model.ExtensionSupport;
import alfio.model.system.Configuration;
import alfio.model.system.ConfigurationKeyValuePathLevel;
import alfio.model.system.ConfigurationPathLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!integration-test"})
@ConfigurationProperties(value="alfio.override.system")
public class ExternalConfiguration {
    private static final String EXTERNAL_EXTENSION_PATH = "::EXTERNAL::";
    private static final int EXTERNAL_CONFIGURATION_ID = Integer.MIN_VALUE;
    private Map<String, String> settings = new HashMap();
    private List<ExtensionOverride> extensions = new ArrayList();

    public List<Configuration> load(String key) {
        return this.getSingle(key).map(List::of).orElse(List.of());
    }

    public Optional<Configuration> getSingle(String key) {
        return Optional.ofNullable((String)this.settings.get(key)).map(value -> new Configuration(Integer.MIN_VALUE, key, value, ConfigurationPathLevel.EXTERNAL));
    }

    public List<ConfigurationKeyValuePathLevel> getAll(Collection<String> keys) {
        return keys.stream().map(arg_0 -> this.getSingle(arg_0)).flatMap(Optional::stream).map(c -> new ConfigurationKeyValuePathLevel(c.getKey(), c.getValue(), c.getConfigurationPathLevel())).collect(Collectors.toList());
    }

    public Optional<String> getScript(String path, String name) {
        if (EXTERNAL_EXTENSION_PATH.equals(path)) {
            return this.extensions.stream().filter(e -> e.isValid() && e.id.equals(name)).map(ExtensionOverride::getContent).findFirst();
        }
        return Optional.empty();
    }

    public List<ExtensionSupport.ScriptPathNameHash> getAllExtensionsFor(String event, boolean async) {
        return this.extensions.stream().filter(e -> e.async == async && e.isValid() && e.getEvents().contains(event)).map(e -> new ExtensionSupport.ScriptPathNameHash(EXTERNAL_EXTENSION_PATH, e.getId(), DigestUtils.sha256Hex((String)e.file))).collect(Collectors.toList());
    }

    public List<ExtensionSupport.ScriptPathNameHash> getAllExtensionsForCapability(ExtensionCapability capability) {
        List eventsAsString = capability.getCompatibleEvents().stream().map(Enum::name).collect(Collectors.toList());
        return this.extensions.stream().filter(e -> e.isValid() && CollectionUtils.containsAny((Collection)e.events, (Collection)eventsAsString) && e.getCapabilities().contains(capability.name())).map(e -> new ExtensionSupport.ScriptPathNameHash(EXTERNAL_EXTENSION_PATH, e.getId(), DigestUtils.sha256Hex((String)e.file))).collect(Collectors.toList());
    }

    public Set<ExtensionCapabilitySummary> getSupportedCapabilities(Set<ExtensionCapability> requested) {
        return this.extensions.stream().map(e -> Pair.of((Object)e, e.getCapabilityDetails().stream().filter(cd -> requested.contains(cd.key)).collect(Collectors.toList()))).filter(p -> !((List)p.getRight()).isEmpty()).flatMap(p -> {
            Map byCapability = ((List)p.getRight()).stream().collect(Collectors.groupingBy(ExtensionCapabilityDetailsOverride::getKey, Collectors.mapping(cd -> new ExtensionCapabilitySummary.ExtensionCapabilityDetails(cd.label, cd.description, cd.selector), Collectors.toList())));
            return byCapability.entrySet().stream().map(e -> new ExtensionCapabilitySummary((ExtensionCapability)e.getKey(), (List)e.getValue()));
        }).collect(Collectors.toSet());
    }

    public Map<String, String> getParametersForExtension(String id) {
        return this.extensions.stream().filter(ExtensionOverride::isValid).filter(extensionOverride -> extensionOverride.id.equals(id)).map(ExtensionOverride::getParams).findFirst().orElse(Map.of());
    }

    public static boolean isExternalPath(String path) {
        return EXTERNAL_EXTENSION_PATH.equals(path);
    }

    @Generated
    public Map<String, String> getSettings() {
        return this.settings;
    }

    @Generated
    public List<ExtensionOverride> getExtensions() {
        return this.extensions;
    }

    @Generated
    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }

    @Generated
    public void setExtensions(List<ExtensionOverride> extensions) {
        this.extensions = extensions;
    }
}

