/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.system;

import alfio.manager.system.BaseMailer;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.system.Mailer;
import alfio.model.Configurable;
import alfio.model.system.ConfigurationKeys;
import alfio.repository.user.OrganizationRepository;
import alfio.util.HttpUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
class MailgunMailer
extends BaseMailer {
    private static final Logger log = LoggerFactory.getLogger(MailgunMailer.class);
    private final HttpClient client;
    private final ConfigurationManager configurationManager;

    MailgunMailer(HttpClient client, ConfigurationManager configurationManager, OrganizationRepository organizationRepository) {
        super(organizationRepository);
        this.client = client;
        this.configurationManager = configurationManager;
    }

    private static Map<String, String> getEmailData(String from, String to, List<String> cc, String subject, String text, Optional<String> html) {
        HashMap<String, String> emailData = new HashMap<String, String>(Map.of("from", from, "to", to, "subject", subject, "text", text));
        if (cc != null && !cc.isEmpty()) {
            emailData.put("cc", StringUtils.join(cc, (char)','));
        }
        html.ifPresent(htmlContent -> emailData.put("html", (String)htmlContent));
        return emailData;
    }

    public void send(Configurable configurable, String fromName, String to, List<String> cc, String subject, String text, Optional<String> html, Mailer.Attachment ... attachment) {
        Map conf = this.configurationManager.getFor(Set.of(ConfigurationKeys.MAILGUN_KEY, ConfigurationKeys.MAILGUN_DOMAIN, ConfigurationKeys.MAILGUN_EU, ConfigurationKeys.MAILGUN_FROM, ConfigurationKeys.MAIL_REPLY_TO, ConfigurationKeys.MAIL_SET_ORG_REPLY_TO), configurable.getConfigurationLevel());
        String apiKey = ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.MAILGUN_KEY)).getRequiredValue();
        String domain = ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.MAILGUN_DOMAIN)).getRequiredValue();
        boolean useEU = ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.MAILGUN_EU)).getValueAsBooleanOrDefault();
        String baseUrl = useEU ? "https://api.eu.mailgun.net/v3/" : "https://api.mailgun.net/v3/";
        try {
            String from = fromName + " <" + ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.MAILGUN_FROM)).getRequiredValue() + ">";
            Map emailData = MailgunMailer.getEmailData((String)from, (String)to, cc, (String)subject, (String)text, html);
            this.setReplyToIfPresent(conf, configurable.getOrganizationId(), replyTo -> emailData.put("h:Reply-To", replyTo));
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(baseUrl + domain + "/messages")).header("Authorization", HttpUtils.basicAuth((String)"api", (String)apiKey));
            if (ArrayUtils.isEmpty((Object[])attachment)) {
                requestBuilder.header("Content-Type", "application/x-www-form-urlencoded");
                requestBuilder.POST(HttpUtils.ofFormUrlEncodedBody((Map)emailData));
            } else {
                HttpUtils.MultiPartBodyPublisher mpb = new HttpUtils.MultiPartBodyPublisher();
                requestBuilder.header("Content-Type", "multipart/form-data;boundary=\"" + mpb.getBoundary() + "\"");
                emailData.forEach((arg_0, arg_1) -> ((HttpUtils.MultiPartBodyPublisher)mpb).addPart(arg_0, arg_1));
                Stream.of(attachment).forEach(a -> mpb.addPart("attachment", () -> new ByteArrayInputStream(a.getSource()), a.getFilename(), a.getContentType()));
                requestBuilder.POST(mpb.build());
            }
            HttpRequest request = requestBuilder.build();
            HttpResponse<Void> response = this.client.send(request, HttpResponse.BodyHandlers.discarding());
            if (!HttpUtils.callSuccessful(response)) {
                log.warn("sending email was not successful:" + response);
                throw new IllegalStateException("Attempt to send a message failed. Result is: " + response.statusCode());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Request interrupted while calling Mailgun API", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            log.warn("error while sending email", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }
}

