/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.system;

import alfio.manager.system.BaseMailer;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.system.Mailer;
import alfio.model.Configurable;
import alfio.model.system.ConfigurationKeys;
import alfio.repository.user.OrganizationRepository;
import alfio.util.HttpUtils;
import alfio.util.Json;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MailjetMailer
extends BaseMailer {
    private static final Logger log = LoggerFactory.getLogger(MailjetMailer.class);
    private final HttpClient client;
    private final ConfigurationManager configurationManager;

    MailjetMailer(HttpClient httpClient, ConfigurationManager configurationManager, OrganizationRepository organizationRepository) {
        super(organizationRepository);
        this.client = httpClient;
        this.configurationManager = configurationManager;
    }

    public void send(Configurable configurable, String fromName, String to, List<String> cc, String subject, String text, Optional<String> html, Mailer.Attachment ... attachment) {
        Map conf = this.configurationManager.getFor(EnumSet.of(ConfigurationKeys.MAILJET_APIKEY_PUBLIC, ConfigurationKeys.MAILJET_APIKEY_PRIVATE, ConfigurationKeys.MAILJET_FROM, ConfigurationKeys.MAIL_REPLY_TO, ConfigurationKeys.MAIL_SET_ORG_REPLY_TO), configurable.getConfigurationLevel());
        String apiKeyPublic = ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.MAILJET_APIKEY_PUBLIC)).getRequiredValue();
        String apiKeyPrivate = ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.MAILJET_APIKEY_PRIVATE)).getRequiredValue();
        String fromEmail = ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.MAILJET_FROM)).getRequiredValue();
        HashMap<String, Object> mailPayload = new HashMap<String, Object>();
        ArrayList<Map<String, String>> recipients = new ArrayList<Map<String, String>>();
        recipients.add(Collections.singletonMap("Email", to));
        if (cc != null && !cc.isEmpty()) {
            recipients.addAll(cc.stream().map(email -> Collections.singletonMap("Email", email)).collect(Collectors.toList()));
        }
        mailPayload.put("FromEmail", fromEmail);
        mailPayload.put("FromName", fromName);
        mailPayload.put("Subject", subject);
        mailPayload.put("Text-part", text);
        html.ifPresent(h -> mailPayload.put("Html-part", h));
        mailPayload.put("Recipients", recipients);
        this.setReplyToIfPresent(conf, configurable.getOrganizationId(), address -> mailPayload.put("Headers", Collections.singletonMap("Reply-To", address)));
        if (attachment != null && attachment.length > 0) {
            mailPayload.put("Attachments", Arrays.stream(attachment).map(MailjetMailer::fromAttachment).collect(Collectors.toList()));
        }
        HttpRequest request = HttpRequest.newBuilder(URI.create("https://api.mailjet.com/v3/send")).header("Authorization", HttpUtils.basicAuth((String)apiKeyPublic, (String)apiKeyPrivate)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(Json.GSON.toJson(mailPayload))).build();
        try {
            HttpResponse<Void> response = this.client.send(request, HttpResponse.BodyHandlers.discarding());
            if (!HttpUtils.callSuccessful(response)) {
                log.warn("sending email was not successful:" + response);
                throw new IllegalStateException("Attempt to send a message failed. Result is: " + response.statusCode());
            }
        }
        catch (IOException e) {
            log.warn("error while sending email", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("error while sending email", (Throwable)e);
        }
    }

    private static Map<String, String> fromAttachment(Mailer.Attachment a) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("Content-type", a.getContentType());
        m.put("Filename", a.getFilename());
        m.put("content", Base64.encodeBase64String((byte[])a.getSource()));
        return m;
    }
}

