/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.system;

import alfio.manager.system.BaseMailer;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.system.Mailer;
import alfio.model.Configurable;
import alfio.model.system.ConfigurationKeys;
import alfio.repository.user.OrganizationRepository;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

class MockMailer
extends BaseMailer {
    private static final Logger log = LoggerFactory.getLogger(MockMailer.class);
    private final ConfigurationManager configurationManager;
    private final Environment environment;

    MockMailer(ConfigurationManager configurationManager, Environment environment, OrganizationRepository organizationRepository) {
        super(organizationRepository);
        this.configurationManager = configurationManager;
        this.environment = environment;
    }

    public void send(Configurable configurable, String fromName, String to, List<String> cc, String subject, String text, Optional<String> html, Mailer.Attachment ... attachments) {
        subject = this.decorateSubjectIfDemo(subject, this.environment);
        String printedAttachments = Optional.ofNullable(attachments).map(Arrays::asList).orElse(Collections.emptyList()).stream().map(a -> "{filename:" + a.getFilename() + ", contentType: " + a.getContentType() + "}").collect(Collectors.joining(", "));
        Map conf = this.configurationManager.getFor(EnumSet.of(ConfigurationKeys.MAIL_REPLY_TO, ConfigurationKeys.MAIL_SET_ORG_REPLY_TO), configurable.getConfigurationLevel());
        AtomicReference<Object> replyTo = new AtomicReference<Object>(null);
        this.setReplyToIfPresent(conf, configurable.getOrganizationId(), replyTo::set);
        log.info("Email: from: {}, replyTo: {}, to: {}, cc: {}, subject: {}, text: {}, html: {}, attachments: {}", new Object[]{fromName, replyTo.get(), to, cc, subject, text, html.orElse("no html"), printedAttachments});
    }
}

