/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.system;

import alfio.model.AdditionalService;
import alfio.model.AdditionalServiceItem;
import alfio.model.PriceContainer;
import alfio.model.PromoCodeDiscount;
import alfio.model.PurchaseContext;
import alfio.model.Ticket;
import alfio.model.TicketReservation;
import alfio.model.decorator.AdditionalServiceItemPriceContainer;
import alfio.model.decorator.SubscriptionPriceContainer;
import alfio.model.decorator.TicketPriceContainer;
import alfio.model.subscription.Subscription;
import alfio.util.MonetaryUtil;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ReservationPriceCalculator
implements PriceContainer {
    final TicketReservation reservation;
    final PromoCodeDiscount discount;
    final List<Ticket> tickets;
    final List<AdditionalServiceItem> additionalServiceItems;
    final List<AdditionalService> additionalServices;
    final PurchaseContext purchaseContext;
    private final List<Subscription> subscriptions;
    private final Optional<Subscription> appliedSubscription;

    public int getSrcPriceCts() {
        return this.tickets.stream().mapToInt(arg_0 -> this.getTicketSrcPriceCts(arg_0)).sum() + this.additionalServiceItems.stream().mapToInt(AdditionalServiceItem::getSrcPriceCts).sum() + this.subscriptions.stream().mapToInt(Subscription::getSrcPriceCts).sum();
    }

    public BigDecimal getAppliedDiscount() {
        int subscriptionDiscount = this.appliedSubscription.map(subscription -> this.tickets.stream().filter(t -> Objects.equals(t.getSubscriptionId(), subscription.getId())).mapToInt(Ticket::getSrcPriceCts).sum()).orElse(0);
        if (this.discount != null) {
            if (this.discount.getDiscountType() == PromoCodeDiscount.DiscountType.FIXED_AMOUNT_RESERVATION) {
                return MonetaryUtil.centsToUnit((int)(this.discount.getDiscountAmount() + subscriptionDiscount), (String)this.reservation.getCurrencyCode());
            }
            int ticketDiscount = this.tickets.stream().mapToInt(t -> MonetaryUtil.unitToCents((BigDecimal)TicketPriceContainer.from((Ticket)t, (PriceContainer.VatStatus)this.reservation.getVatStatus(), (BigDecimal)this.reservation.getVatPercentageOrZero(), (PriceContainer.VatStatus)this.purchaseContext.getVatStatus(), (PromoCodeDiscount)this.discount).getAppliedDiscount(), (String)this.reservation.getCurrencyCode())).sum();
            return MonetaryUtil.centsToUnit((int)(ticketDiscount + this.additionalServiceItems.stream().mapToInt(AdditionalServiceItem::getDiscountCts).sum() + this.subscriptions.stream().mapToInt(Subscription::getDiscountCts).sum() + subscriptionDiscount), (String)this.reservation.getCurrencyCode());
        }
        return MonetaryUtil.centsToUnit((int)subscriptionDiscount, (String)this.reservation.getCurrencyCode());
    }

    public String getCurrencyCode() {
        return this.purchaseContext.getCurrency();
    }

    public Optional<BigDecimal> getOptionalVatPercentage() {
        return Optional.ofNullable((BigDecimal)ObjectUtils.firstNonNull((Object[])new BigDecimal[]{this.reservation.getUsedVatPercent(), this.purchaseContext.getVat()}));
    }

    public PriceContainer.VatStatus getVatStatus() {
        return (PriceContainer.VatStatus)ObjectUtils.firstNonNull((Object[])new PriceContainer.VatStatus[]{this.reservation.getVatStatus(), this.purchaseContext.getVatStatus()});
    }

    public Optional<PromoCodeDiscount> getDiscount() {
        return Optional.ofNullable(this.discount);
    }

    public BigDecimal getTaxablePrice() {
        BigDecimal ticketsTaxablePrice = this.tickets.stream().map(t -> TicketPriceContainer.from((Ticket)t, (PriceContainer.VatStatus)this.reservation.getVatStatus(), (BigDecimal)this.getVatPercentageOrZero(), (PriceContainer.VatStatus)this.purchaseContext.getVatStatus(), (PromoCodeDiscount)this.discount).getTaxablePrice()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal additionalServiceTaxablePrice = this.additionalServiceItems.stream().map(asi -> AdditionalServiceItemPriceContainer.from((AdditionalServiceItem)asi, (AdditionalService)this.additionalServices.stream().filter(as -> as.id() == asi.getAdditionalServiceId()).findFirst().orElseThrow(), (PurchaseContext)this.purchaseContext, (PromoCodeDiscount)this.discount).getTaxablePrice()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal subscriptionsPrice = this.subscriptions.stream().map(s -> SubscriptionPriceContainer.from((Subscription)s, (PurchaseContext)this.purchaseContext, (PromoCodeDiscount)this.discount).getTaxablePrice()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalTicketsAndAdditional = ticketsTaxablePrice.add(additionalServiceTaxablePrice).add(subscriptionsPrice);
        if (this.discount != null && this.discount.getDiscountType() != PromoCodeDiscount.DiscountType.FIXED_AMOUNT_RESERVATION) {
            return totalTicketsAndAdditional;
        }
        return totalTicketsAndAdditional.subtract(this.getAppliedDiscount());
    }

    public static ReservationPriceCalculator from(TicketReservation reservation, PromoCodeDiscount discount, List<Ticket> tickets, PurchaseContext purchaseContext, List<Pair<AdditionalService, List<AdditionalServiceItem>>> additionalServiceItemsByAdditionalService, List<Subscription> subscriptions, Optional<Subscription> appliedSubscription) {
        List additionalServiceItems = additionalServiceItemsByAdditionalService.stream().flatMap(p -> ((List)p.getRight()).stream()).collect(Collectors.toList());
        List additionalServices = additionalServiceItemsByAdditionalService.stream().map(Pair::getKey).collect(Collectors.toList());
        return new ReservationPriceCalculator(reservation, discount, tickets, additionalServiceItems, additionalServices, purchaseContext, subscriptions, appliedSubscription);
    }

    private int getTicketSrcPriceCts(Ticket t) {
        if (PriceContainer.VatStatus.isVatExempt((PriceContainer.VatStatus)t.getVatStatus())) {
            return t.getSrcPriceCts() - Math.abs(t.getVatCts());
        }
        return t.getSrcPriceCts();
    }

    @ConstructorProperties(value={"reservation", "discount", "tickets", "additionalServiceItems", "additionalServices", "purchaseContext", "subscriptions", "appliedSubscription"})
    @Generated
    public ReservationPriceCalculator(TicketReservation reservation, PromoCodeDiscount discount, List<Ticket> tickets, List<AdditionalServiceItem> additionalServiceItems, List<AdditionalService> additionalServices, PurchaseContext purchaseContext, List<Subscription> subscriptions, Optional<Subscription> appliedSubscription) {
        this.reservation = reservation;
        this.discount = discount;
        this.tickets = tickets;
        this.additionalServiceItems = additionalServiceItems;
        this.additionalServices = additionalServices;
        this.purchaseContext = purchaseContext;
        this.subscriptions = subscriptions;
        this.appliedSubscription = appliedSubscription;
    }
}

