/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.system;

import alfio.manager.system.BaseMailer;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.system.Mailer;
import alfio.model.Configurable;
import alfio.model.system.ConfigurationKeys;
import alfio.repository.user.OrganizationRepository;
import alfio.util.HttpUtils;
import alfio.util.Json;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SendGridMailer
extends BaseMailer {
    private static final String EMAIL = "email";
    private static final Logger log = LoggerFactory.getLogger(SendGridMailer.class);
    private final HttpClient client;
    private final ConfigurationManager configurationManager;

    SendGridMailer(HttpClient client, ConfigurationManager configurationManager, OrganizationRepository organizationRepository) {
        super(organizationRepository);
        this.client = client;
        this.configurationManager = configurationManager;
    }

    public void send(Configurable configurable, String fromName, String to, List<String> cc, String subject, String text, Optional<String> html, Mailer.Attachment ... attachment) {
        Map config = this.configurationManager.getFor(EnumSet.of(ConfigurationKeys.SENDGRID_API_KEY, ConfigurationKeys.SENDGRID_FROM, ConfigurationKeys.MAIL_REPLY_TO, ConfigurationKeys.MAIL_SET_ORG_REPLY_TO), configurable.getConfigurationLevel());
        String from = ((ConfigurationManager.MaybeConfiguration)config.get(ConfigurationKeys.SENDGRID_FROM)).getRequiredValue();
        List personalizations = this.createPersonalizations(to, cc, subject);
        List contents = this.createContents(text, html);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (ArrayUtils.isNotEmpty((Object[])attachment)) {
            this.addAttachments(payload, attachment);
        }
        payload.put("from", Map.of(EMAIL, from, "name", fromName));
        payload.put("personalizations", personalizations);
        payload.put("content", contents);
        this.setReplyToIfPresent(config, configurable.getOrganizationId(), replyTo -> payload.put("reply_to", Map.of(EMAIL, replyTo)));
        String body = Json.GSON.toJson(payload);
        HttpRequest request = HttpRequest.newBuilder(URI.create("https://api.sendgrid.com/v3/mail/send")).header("Authorization", "Bearer %s".formatted(((ConfigurationManager.MaybeConfiguration)config.get(ConfigurationKeys.SENDGRID_API_KEY)).getRequiredValue())).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body)).build();
        try {
            HttpResponse<Void> response = this.client.send(request, HttpResponse.BodyHandlers.discarding());
            if (!HttpUtils.callSuccessful(response)) {
                log.warn("sending email was not successful: {} ", response);
                throw new IllegalStateException("Attempt to send a message failed. Result is: " + response.statusCode());
            }
        }
        catch (IOException e) {
            log.warn("error while sending email", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("error while sending email", (Throwable)e);
        }
    }

    private List<Map<String, Object>> createPersonalizations(String to, List<String> cc, String subject) {
        ArrayList<Map> recipients = new ArrayList<Map>();
        recipients.add(Map.of(EMAIL, to));
        if (CollectionUtils.isNotEmpty(cc)) {
            recipients.addAll(cc.stream().map(email -> Map.of(EMAIL, email)).toList());
        }
        return List.of(Map.of("to", recipients, "subject", subject));
    }

    private List<Map<String, String>> createContents(String text, Optional<String> html) {
        ArrayList<Map<String, String>> contents = new ArrayList<Map<String, String>>();
        contents.add(Map.of("type", "text/plain", "value", text));
        Objects.requireNonNull(html).ifPresent(htmlContent -> contents.add(Map.of("type", "text/html", "value", htmlContent)));
        return contents;
    }

    private void addAttachments(Map<String, Object> payload, Mailer.Attachment[] attachment) {
        List attachments = Stream.of(attachment).map(attach -> Map.of("filename", attach.getFilename(), "content", attach.getSource(), "content_id", attach.getIdentifier().name(), "type", attach.getContentType())).collect(Collectors.toList());
        payload.put("attachments", attachments);
    }
}

