/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.system;

import alfio.manager.system.BaseMailer;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.system.Mailer;
import alfio.manager.system.SmtpMailer;
import alfio.model.Configurable;
import alfio.model.system.ConfigurationKeys;
import alfio.repository.user.OrganizationRepository;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;

/*
 * Exception performing whole class analysis ignored.
 */
class SmtpMailer
extends BaseMailer {
    private static final Logger log = LoggerFactory.getLogger(SmtpMailer.class);
    private final ConfigurationManager configurationManager;

    SmtpMailer(ConfigurationManager configurationManager, OrganizationRepository organizationRepository) {
        super(organizationRepository);
        this.configurationManager = configurationManager;
    }

    public void send(Configurable configurable, String fromName, String to, List<String> cc, String subject, String text, Optional<String> html, Mailer.Attachment ... attachments) {
        Map conf = this.configurationManager.getFor(Set.of(ConfigurationKeys.SMTP_FROM_EMAIL, ConfigurationKeys.MAIL_REPLY_TO, ConfigurationKeys.MAIL_SET_ORG_REPLY_TO, ConfigurationKeys.SMTP_HOST, ConfigurationKeys.SMTP_PORT, ConfigurationKeys.SMTP_PROTOCOL, ConfigurationKeys.SMTP_USERNAME, ConfigurationKeys.SMTP_PASSWORD, ConfigurationKeys.SMTP_PROPERTIES), configurable.getConfigurationLevel());
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = html.isPresent() || !ArrayUtils.isEmpty((Object[])attachments) ? new MimeMessageHelper(mimeMessage, true, StandardCharsets.UTF_8.name()) : new MimeMessageHelper(mimeMessage, StandardCharsets.UTF_8.name());
            message.setSubject(subject);
            message.setFrom(((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.SMTP_FROM_EMAIL)).getRequiredValue(), fromName);
            this.setReplyToIfPresent(conf, configurable.getOrganizationId(), replyTo -> {
                try {
                    message.setReplyTo(replyTo);
                }
                catch (MessagingException e) {
                    throw new RuntimeException(e);
                }
            });
            message.setTo(to);
            if (cc != null && !cc.isEmpty()) {
                message.setCc(cc.toArray(new String[0]));
            }
            if (html.isPresent()) {
                message.setText(text, (String)html.get());
            } else {
                message.setText(text, false);
            }
            if (attachments != null) {
                for (Mailer.Attachment a : attachments) {
                    message.addAttachment(a.getFilename(), (InputStreamSource)new ByteArrayResource(a.getSource()), a.getContentType());
                }
            }
            message.getMimeMessage().saveChanges();
            message.getMimeMessage().removeHeader("Message-ID");
        };
        SmtpMailer.toMailSender((Map)conf).send(preparator);
    }

    private static JavaMailSender toMailSender(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> conf) {
        CustomJavaMailSenderImpl r = new CustomJavaMailSenderImpl();
        r.setDefaultEncoding(StandardCharsets.UTF_8.name());
        r.setHost(conf.get(ConfigurationKeys.SMTP_HOST).getRequiredValue());
        r.setPort(Integer.parseInt(conf.get(ConfigurationKeys.SMTP_PORT).getRequiredValue()));
        r.setProtocol(conf.get(ConfigurationKeys.SMTP_PROTOCOL).getRequiredValue());
        r.setUsername(conf.get(ConfigurationKeys.SMTP_USERNAME).getValueOrNull());
        r.setPassword(conf.get(ConfigurationKeys.SMTP_PASSWORD).getValueOrNull());
        String properties = conf.get(ConfigurationKeys.SMTP_PROPERTIES).getValueOrNull();
        if (properties != null) {
            try {
                Properties prop = PropertiesLoaderUtils.loadProperties((EncodedResource)new EncodedResource((Resource)new ByteArrayResource(properties.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8.name()));
                r.setJavaMailProperties(prop);
            }
            catch (IOException e) {
                log.warn("error while setting the mail sender properties", (Throwable)e);
            }
        }
        return r;
    }
}

