/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.user;

import alfio.controller.form.ContactAndTicketsForm;
import alfio.controller.form.UpdateProfileForm;
import alfio.controller.form.UpdateTicketOwnerForm;
import alfio.manager.ExtensionManager;
import alfio.manager.user.UserManager;
import alfio.model.Event;
import alfio.model.PurchaseContext;
import alfio.model.PurchaseContextFieldConfiguration;
import alfio.model.PurchaseContextFieldDescription;
import alfio.model.TicketReservationAdditionalInfo;
import alfio.model.TicketReservationInvoicingAdditionalInfo;
import alfio.model.extension.AdditionalInfoItem;
import alfio.model.user.AdditionalInfoWithLabel;
import alfio.model.user.PublicUserProfile;
import alfio.model.user.User;
import alfio.repository.PurchaseContextFieldRepository;
import alfio.repository.user.UserRepository;
import java.beans.ConstructorProperties;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;

@Component
@Transactional
public class PublicUserManager {
    private final UserRepository userRepository;
    private final ExtensionManager extensionManager;
    private final UserManager userManager;
    private final PurchaseContextFieldRepository purchaseContextFieldRepository;

    public boolean deleteUserProfile(OAuth2AuthenticationToken authentication) {
        return this.userManager.findOptionalEnabledUserByUsername(authentication.getName()).filter(u -> u.getType() == User.Type.PUBLIC).map(user -> {
            this.userRepository.deleteUserProfile(user.getId());
            this.userRepository.invalidatePublicUser(user.getId(), UUID.randomUUID() + "@deleted.alf.io");
            this.extensionManager.handlePublicUserDelete(authentication, user);
            return true;
        }).orElse(false);
    }

    public Optional<Pair<User, Optional<PublicUserProfile>>> findOptionalProfileForUser(Authentication authentication) {
        return this.userManager.findOptionalEnabledUserByUsername(authentication.getName()).map(user -> Pair.of((Object)user, (Object)this.userRepository.loadUserProfile(user.getId())));
    }

    public Optional<PublicUserProfile> updateProfile(User original, UpdateProfileForm update, boolean italianEInvoicingEnabled) {
        int userId = original.getId();
        this.userRepository.update(userId, original.getUsername(), update.getFirstName(), update.getLastName(), original.getEmailAddress(), original.getDescription());
        Map currentAdditionalData = this.userRepository.loadUserProfile(userId).map(PublicUserProfile::getAdditionalData).orElse(Map.of());
        Validate.isTrue((1 == this.userRepository.persistUserProfile(userId, update.getBillingAddressCompany(), update.getBillingAddressLine1(), update.getBillingAddressLine2(), update.getBillingAddressZip(), update.getBillingAddressCity(), update.getBillingAddressState(), update.getVatCountryCode(), update.getVatNr(), this.getAdditionalInfo((ContactAndTicketsForm)update, italianEInvoicingEnabled), this.updateExistingAdditionalData(currentAdditionalData, update)) ? 1 : 0) != 0);
        return this.userRepository.loadUserProfile(userId);
    }

    private Map<String, AdditionalInfoWithLabel> updateExistingAdditionalData(Map<String, AdditionalInfoWithLabel> existingData, UpdateProfileForm form) {
        if (existingData == null || existingData.isEmpty() || !form.hasAdditionalInfo()) {
            return Map.of();
        }
        Map additionalInfoMap = form.getAdditionalInfo();
        return existingData.entrySet().stream().map(entry -> {
            AdditionalInfoWithLabel existingAdditionalInfoWithLabel = (AdditionalInfoWithLabel)entry.getValue();
            List<String> newVal = additionalInfoMap.containsKey(entry.getKey()) ? List.of((String)additionalInfoMap.get(entry.getKey())) : existingAdditionalInfoWithLabel.getValues();
            return Map.entry((String)entry.getKey(), new AdditionalInfoWithLabel(existingAdditionalInfoWithLabel.getLabel(), newVal));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, AdditionalInfoWithLabel> buildAdditionalInfoWithLabels(PublicUserProfile existingProfile, PurchaseContext purchaseContext, UpdateTicketOwnerForm form) {
        Event event = (Event)purchaseContext.event().orElseThrow();
        List fields = this.purchaseContextFieldRepository.findAdditionalFieldsOfTypeForEvent(event.getId(), "input:text");
        Map fieldsById = fields.stream().collect(Collectors.toMap(PurchaseContextFieldConfiguration::getId, Function.identity()));
        String userLanguage = form.getUserLanguage();
        Optional filteredItems = this.extensionManager.filterAdditionalInfoToSave(purchaseContext, form.getAdditional(), existingProfile);
        Map filteredItemsByKey = filteredItems.map(additionalInfoItems -> additionalInfoItems.stream().collect(Collectors.toMap(AdditionalInfoItem::getKey, Function.identity()))).orElse(null);
        Map<String, String> labels = this.purchaseContextFieldRepository.findDescriptionsForLocale(event.getId(), userLanguage).stream().filter(f -> fieldsById.containsKey(f.getFieldConfigurationId())).map(f -> Map.entry(((PurchaseContextFieldConfiguration)fieldsById.get(f.getFieldConfigurationId())).getName(), f)).filter(f -> filteredItemsByKey == null || filteredItemsByKey.containsKey(f.getKey())).map(e -> {
            if (filteredItemsByKey != null) {
                return Map.entry((String)e.getKey(), ((AdditionalInfoItem)filteredItemsByKey.get(e.getKey())).getLabel());
            }
            return Map.entry((String)e.getKey(), ((PurchaseContextFieldDescription)e.getValue()).getLabelDescription());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap<String, AdditionalInfoWithLabel> result = new HashMap<String, AdditionalInfoWithLabel>(Optional.ofNullable(existingProfile).map(PublicUserProfile::getAdditionalData).orElse(Map.of()));
        result.putAll(form.getAdditional().entrySet().stream().filter(e -> labels.containsKey(e.getKey())).map(e -> {
            String label = (String)labels.get(e.getKey());
            return Map.entry((String)e.getKey(), new AdditionalInfoWithLabel(Map.of(userLanguage, label), (List)e.getValue()));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return result;
    }

    public Map<String, AdditionalInfoWithLabel> buildAdditionalInfoWithLabels(Authentication principal, PurchaseContext purchaseContext, UpdateTicketOwnerForm form) {
        Optional optionalExistingProfile = this.findOptionalProfileForUser(principal).flatMap(Pair::getValue);
        return this.buildAdditionalInfoWithLabels((PublicUserProfile)optionalExistingProfile.orElse(null), purchaseContext, form);
    }

    private TicketReservationInvoicingAdditionalInfo getAdditionalInfo(ContactAndTicketsForm update, boolean italianEInvoicingEnabled) {
        if (italianEInvoicingEnabled) {
            return new TicketReservationInvoicingAdditionalInfo(new TicketReservationInvoicingAdditionalInfo.ItalianEInvoicing(update.getItalyEInvoicingFiscalCode(), update.getItalyEInvoicingReferenceType(), update.getItalyEInvoicingReferenceAddresseeCode(), update.getItalyEInvoicingReferencePEC(), update.isItalyEInvoicingSplitPayment()));
        }
        return new TicketReservationInvoicingAdditionalInfo(null);
    }

    public Optional<User> findOptionalEnabledUserByUsername(String username) {
        return this.userManager.findOptionalEnabledUserByUsername(username);
    }

    public void persistProfileForPublicUser(Principal principal, Object form, BindingResult bindingResult, TicketReservationAdditionalInfo reservationAdditionalInfo, Map<String, AdditionalInfoWithLabel> userAdditionalData) {
        if (principal == null) {
            return;
        }
        this.extensionManager.handleUserProfileValidation(form, bindingResult);
        if (!bindingResult.hasErrors()) {
            this.userRepository.findIdByUserName(principal.getName()).ifPresent(id -> this.userRepository.persistUserProfile(id.intValue(), reservationAdditionalInfo.getBillingAddressCompany(), reservationAdditionalInfo.getBillingAddressLine1(), reservationAdditionalInfo.getBillingAddressLine2(), reservationAdditionalInfo.getBillingAddressZip(), reservationAdditionalInfo.getBillingAddressCity(), reservationAdditionalInfo.getBillingAddressState(), reservationAdditionalInfo.getBillingAddressCountry(), reservationAdditionalInfo.getVatNr(), reservationAdditionalInfo.getInvoicingAdditionalInfo(), userAdditionalData));
        }
    }

    @ConstructorProperties(value={"userRepository", "extensionManager", "userManager", "purchaseContextFieldRepository"})
    @Generated
    public PublicUserManager(UserRepository userRepository, ExtensionManager extensionManager, UserManager userManager, PurchaseContextFieldRepository purchaseContextFieldRepository) {
        this.userRepository = userRepository;
        this.extensionManager = extensionManager;
        this.userManager = userManager;
        this.purchaseContextFieldRepository = purchaseContextFieldRepository;
    }
}

