/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.user;

import alfio.config.authentication.support.APITokenAuthentication;
import alfio.manager.AccessService;
import alfio.model.modification.OrganizationModification;
import alfio.model.result.ValidationResult;
import alfio.model.user.Authority;
import alfio.model.user.Organization;
import alfio.model.user.Role;
import alfio.model.user.User;
import alfio.model.user.UserWithOrganizations;
import alfio.model.user.UserWithPassword;
import alfio.model.user.join.UserOrganization;
import alfio.repository.InvoiceSequencesRepository;
import alfio.repository.user.AuthorityRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.repository.user.UserRepository;
import alfio.repository.user.join.UserOrganizationRepository;
import alfio.util.PasswordGenerator;
import alfio.util.RequestUtils;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import java.beans.ConstructorProperties;
import java.security.Principal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Component
@Transactional
public class UserManager {
    public static final String ADMIN_USERNAME = "admin";
    private static final Logger log = LoggerFactory.getLogger(UserManager.class);
    private static final Pattern SLUG_VALIDATOR = Pattern.compile("^[A-Za-z-_0-9]+$");
    private final AuthorityRepository authorityRepository;
    private final OrganizationRepository organizationRepository;
    private final UserOrganizationRepository userOrganizationRepository;
    private final UserRepository userRepository;
    private final PasswordEncoder passwordEncoder;
    private final InvoiceSequencesRepository invoiceSequencesRepository;
    private final FindByIndexNameSessionRepository<?> sessionsByPrincipalFinder;
    private final AccessService accessService;

    private List<Authority> getUserAuthorities(User user) {
        return this.authorityRepository.findGrantedAuthorities(user.getUsername());
    }

    @Transactional(readOnly=true)
    public List<UserWithOrganizations> findAllUsers(String username) {
        List organizations = this.findUserOrganizations(username);
        Predicate<Collection> isNotEmpty = ks -> !ks.isEmpty();
        return Optional.of(organizations).filter(isNotEmpty).flatMap(org -> {
            Map<Integer, List<UserOrganization>> usersAndOrganizations = this.userOrganizationRepository.findByOrganizationIdsOrderByUserId(organizations.stream().map(Organization::getId).collect(Collectors.toList())).stream().collect(Collectors.groupingBy(UserOrganization::getUserId));
            return Optional.of(usersAndOrganizations.keySet()).filter(isNotEmpty).map(ks -> this.userRepository.findByIds((Collection)ks).stream().map(u -> {
                List userOrganizations = (List)usersAndOrganizations.get(u.getId());
                List filteredOrganizations = organizations.stream().filter(o -> userOrganizations.stream().anyMatch(uo -> uo.getOrganizationId() == o.getId())).collect(Collectors.toList());
                List roles = this.authorityRepository.findRoles(u.getUsername()).stream().map(Role::fromRoleName).collect(Collectors.toList());
                return new UserWithOrganizations(u, filteredOrganizations, roles);
            }).collect(Collectors.toList()));
        }).orElseGet(Collections::emptyList);
    }

    @Transactional(readOnly=true)
    public List<User> findAllEnabledUsers(String username) {
        return this.findUserOrganizations(username).stream().flatMap(o -> this.userOrganizationRepository.findByOrganizationId(o.getId()).stream()).map(uo -> this.userRepository.findById(uo.getUserId())).filter(User::isEnabled).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<User> findAllApiKeysFor(int organizationId) {
        return this.userRepository.findAllApiKeysForOrganization(organizationId);
    }

    @Transactional(readOnly=true)
    public User findUserByUsername(String username) {
        return (User)this.userRepository.findEnabledByUsername(username).orElseThrow(IllegalArgumentException::new);
    }

    public Optional<Integer> findUserIdByApiKey(String apiKey, int organizationId) {
        return this.userRepository.findUserIdForApiKey(organizationId, apiKey);
    }

    @Transactional(readOnly=true)
    public Optional<User> findOptionalEnabledUserByUsername(String username) {
        return this.userRepository.findEnabledByUsername(username);
    }

    @Transactional(readOnly=true)
    public boolean usernameExists(String username) {
        return this.userRepository.findIdByUserName(username).isPresent();
    }

    @Transactional(readOnly=true)
    public User findUser(int id, Principal principal) {
        this.checkAccessToUserId(principal, id);
        return this.internalFindUser(id);
    }

    private User internalFindUser(int id) {
        return this.userRepository.findById(id);
    }

    @Transactional(readOnly=true)
    public Collection<Role> getAvailableRoles(String username) {
        User user = this.findUserByUsername(username);
        return this.isAdmin(user) || this.isOwner(user) ? EnumSet.of(Role.OWNER, Role.OPERATOR, Role.SUPERVISOR, Role.SPONSOR, Role.API_CONSUMER) : Collections.emptySet();
    }

    @Transactional(readOnly=true)
    public Role getUserRole(User user) {
        return this.getUserAuthorities(user).stream().map(Authority::getRole).sorted().findFirst().orElse(Role.OPERATOR);
    }

    @Transactional(readOnly=true)
    public List<Organization> findUserOrganizations(String username) {
        return this.organizationRepository.findAllForUser(username);
    }

    @Transactional(readOnly=true)
    public Organization findOrganizationById(int id, String username) {
        return (Organization)this.findOptionalOrganizationById(id, username).orElseThrow(IllegalArgumentException::new);
    }

    @Transactional(readOnly=true)
    public Optional<Organization> findOptionalOrganizationById(int id, String username) {
        return this.findUserOrganizations(username).stream().filter(o -> o.getId() == id).findFirst();
    }

    @Transactional(readOnly=true)
    public boolean isAdmin(User user) {
        return this.checkRole(user, Collections.singleton(Role.ADMIN));
    }

    @Transactional(readOnly=true)
    public boolean isOwner(User user) {
        return this.checkRole(user, EnumSet.of(Role.ADMIN, Role.OWNER, Role.API_CONSUMER));
    }

    @Transactional(readOnly=true)
    public boolean isOwnerOfOrganization(User user, int organizationId) {
        return this.isAdmin(user) || this.isOwner(user) && this.userOrganizationRepository.findByUserId(user.getId()).stream().anyMatch(uo -> uo.getOrganizationId() == organizationId);
    }

    @Transactional(readOnly=true)
    public boolean isOwnerOfOrganization(String username, int organizationId) {
        return this.userRepository.findByUsername(username).filter(user -> this.isOwnerOfOrganization(user, organizationId)).isPresent();
    }

    private boolean checkRole(User user, Set<Role> expectedRoles) {
        Set roleNames = expectedRoles.stream().map(Role::getRoleName).collect(Collectors.toSet());
        return this.authorityRepository.checkRole(user.getUsername(), roleNames);
    }

    public int createOrganization(OrganizationModification om, Principal principal) {
        this.checkIsAdmin(principal);
        AffectedRowCountAndKey affectedRowNumAndKey = this.organizationRepository.create(om.getName(), om.getDescription(), om.getEmail(), om.getExternalId(), om.getSlug());
        int orgId = (Integer)affectedRowNumAndKey.getKey();
        Validate.isTrue((this.invoiceSequencesRepository.initFor(orgId) == 2 ? 1 : 0) != 0);
        return orgId;
    }

    public void updateOrganization(OrganizationModification om, Principal principal) {
        int orgId = Objects.requireNonNull(om.getId());
        this.checkAccessToOrganizationId(principal, orgId);
        boolean isAdmin = RequestUtils.isAdmin((Principal)principal) || RequestUtils.isSystemApiKey((Principal)principal);
        Organization currentOrg = this.organizationRepository.getById(orgId);
        this.organizationRepository.update(om.getId().intValue(), om.getName(), om.getDescription(), om.getEmail(), isAdmin ? om.getExternalId() : currentOrg.getExternalId(), isAdmin ? om.getSlug() : currentOrg.getSlug());
    }

    @Transactional(readOnly=true)
    public ValidationResult validateOrganizationSlug(OrganizationModification om, Principal principal) {
        if (!RequestUtils.isAdmin((Principal)principal)) {
            return ValidationResult.failed((ValidationResult.ErrorDescriptor[])new ValidationResult.ErrorDescriptor[]{new ValidationResult.ErrorDescriptor("slug", "Cannot update Organizer URL.")});
        }
        String slug = om.getSlug();
        if (StringUtils.isBlank((CharSequence)slug) || !SLUG_VALIDATOR.matcher(om.getSlug()).matches()) {
            return ValidationResult.failed((ValidationResult.ErrorDescriptor[])new ValidationResult.ErrorDescriptor[]{new ValidationResult.ErrorDescriptor("slug", "Invalid value")});
        }
        if (this.organizationRepository.countBySlug(slug, om.getId()) > 0) {
            return ValidationResult.failed((ValidationResult.ErrorDescriptor[])new ValidationResult.ErrorDescriptor[]{new ValidationResult.ErrorDescriptor("slug", "URL is already taken", "value_already_in_use")});
        }
        return ValidationResult.success();
    }

    @Transactional(readOnly=true)
    public ValidationResult validateOrganization(OrganizationModification om, Principal principal) {
        if (om.getId() == null && this.organizationRepository.findByName(om.getName()).isPresent()) {
            return ValidationResult.failed((ValidationResult.ErrorDescriptor[])new ValidationResult.ErrorDescriptor[]{new ValidationResult.ErrorDescriptor("name", "There is already another organization with the same name.")});
        }
        Validate.notBlank((CharSequence)om.getName(), (String)"name can't be empty", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)om.getEmail(), (String)"email can't be empty", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)om.getDescription(), (String)"description can't be empty", (Object[])new Object[0]);
        if (!RequestUtils.isAdmin((Principal)principal)) {
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)om.getExternalId()), (String)"cannot update external id", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)om.getSlug()), (String)"cannot update slug", (Object[])new Object[0]);
        } else if (StringUtils.isNotBlank((CharSequence)om.getSlug())) {
            Validate.isTrue((boolean)SLUG_VALIDATOR.matcher(om.getSlug()).matches(), (String)"Organizer address is not valid", (Object[])new Object[0]);
        }
        return ValidationResult.success();
    }

    public void editUser(int id, int organizationId, String username, String firstName, String lastName, String emailAddress, String description, Role role, Principal principal) {
        int userResult;
        boolean admin;
        this.checkAccessToUserIdAndNewOrganization(principal, id, organizationId);
        String currentUsername = principal.getName();
        boolean bl = admin = ADMIN_USERNAME.equals(username) && Role.ADMIN == role;
        if (!admin) {
            int userOrganizationResult = this.userOrganizationRepository.updateUserOrganization(id, organizationId);
            Assert.isTrue((userOrganizationResult == 1 ? 1 : 0) != 0, (String)"unexpected error during organization update");
        }
        Assert.isTrue(((userResult = this.userRepository.update(id, username, firstName, lastName, emailAddress, description)) == 1 ? 1 : 0) != 0, (String)"unexpected error during user update");
        if (!admin && !username.equals(currentUsername)) {
            Assert.isTrue((boolean)this.getAvailableRoles(currentUsername).contains(role), (String)("cannot assign role " + role));
            this.authorityRepository.revokeAll(username);
            this.authorityRepository.create(username, role.getRoleName());
        }
    }

    public void updateCurrentUserContactInfo(String firstName, String lastName, String emailAddress, Principal principal) {
        Integer id = (Integer)this.userRepository.findIdByUserName(principal.getName()).orElseThrow();
        this.userRepository.updateContactInfo(id.intValue(), firstName, lastName, emailAddress);
    }

    public UserWithPassword insertUser(int organizationId, String username, String firstName, String lastName, String emailAddress, Role role, User.Type userType, Principal principal) {
        return this.insertUser(organizationId, username, firstName, lastName, emailAddress, role, userType, null, null, principal);
    }

    public UserWithPassword insertUser(int organizationId, String username, String firstName, String lastName, String emailAddress, Role role, User.Type userType, ZonedDateTime validTo, String description, Principal principal) {
        if (userType == User.Type.API_KEY) {
            username = UUID.randomUUID().toString();
            firstName = "apikey";
            lastName = "";
            emailAddress = "";
        }
        String userPassword = PasswordGenerator.generateRandomPassword();
        return this.insertUser(organizationId, username, firstName, lastName, emailAddress, role, userType, userPassword, validTo, description, principal);
    }

    public void bulkInsertApiKeys(int organizationId, Role role, List<String> descriptions, Principal principal) {
        for (String description : descriptions) {
            this.insertUser(organizationId, null, null, null, null, role, User.Type.API_KEY, null, description, principal);
        }
    }

    public UserWithPassword insertUser(int organizationId, String username, String firstName, String lastName, String emailAddress, Role role, User.Type userType, String userPassword, ZonedDateTime validTo, String description, Principal principal) {
        this.checkAccessToOrganizationId(principal, organizationId);
        Organization organization = this.organizationRepository.getById(organizationId);
        AffectedRowCountAndKey result = this.userRepository.create(username, this.passwordEncoder.encode((CharSequence)userPassword), firstName, lastName, emailAddress, true, userType, validTo, description);
        this.userOrganizationRepository.create(((Integer)result.getKey()).intValue(), organization.getId());
        this.authorityRepository.create(username, role.getRoleName());
        return new UserWithPassword(this.userRepository.findById(((Integer)result.getKey()).intValue()), userType != User.Type.API_KEY ? userPassword : "", UUID.randomUUID().toString());
    }

    public UserWithPassword resetPassword(int userId, Principal principal) {
        String password;
        this.checkAccessToUserId(principal, userId);
        User user = this.internalFindUser(userId);
        if (!principal.getName().equals(user.getUsername())) {
            this.invalidateSessionsForUser(user.getUsername());
        }
        Validate.isTrue((this.userRepository.resetPassword(userId, this.passwordEncoder.encode((CharSequence)(password = PasswordGenerator.generateRandomPassword()))) == 1 ? 1 : 0) != 0, (String)"error during password reset", (Object[])new Object[0]);
        return new UserWithPassword(user, password, UUID.randomUUID().toString());
    }

    public void updateCurrentUserPassword(String newPassword, Principal principal) {
        String username = principal.getName();
        User user = (User)this.userRepository.findByUsername(username).orElseThrow(IllegalStateException::new);
        Validate.isTrue((boolean)PasswordGenerator.isValid((String)newPassword), (String)"invalid password", (Object[])new Object[0]);
        Validate.isTrue((this.userRepository.resetPassword(user.getId(), this.passwordEncoder.encode((CharSequence)newPassword)) == 1 ? 1 : 0) != 0, (String)"error during password update", (Object[])new Object[0]);
    }

    public void deleteUser(int userId, Principal principal) {
        this.checkAccessToUserId(principal, userId);
        if (!this.isSystemApiUser(principal)) {
            String currentUsername = principal.getName();
            User currentUser = (User)this.userRepository.findEnabledByUsername(currentUsername).orElseThrow(IllegalArgumentException::new);
            Assert.isTrue((userId != currentUser.getId() ? 1 : 0) != 0, (String)"sorry but you cannot delete your own account.");
        }
        User userToDelete = this.userRepository.findById(userId);
        this.userRepository.deleteUserAndReferences(userId);
        this.invalidateSessionsForUser(userToDelete.getUsername());
        log.warn("Deleted user (id: {}, username: {}) as requested by {}", new Object[]{userId, userToDelete.getUsername(), principal.getName()});
    }

    private void invalidateSessionsForUser(String username) {
        Set sessionsToInvalidate = this.sessionsByPrincipalFinder.findByPrincipalName(username).keySet();
        sessionsToInvalidate.forEach(arg_0 -> ((FindByIndexNameSessionRepository)this.sessionsByPrincipalFinder).deleteById(arg_0));
    }

    public void enable(int userId, boolean status, Principal principal) {
        this.checkAccessToUserId(principal, userId);
        String currentUsername = principal.getName();
        User currentUser = (User)this.userRepository.findEnabledByUsername(currentUsername).orElseThrow(IllegalArgumentException::new);
        Assert.isTrue((userId != currentUser.getId() ? 1 : 0) != 0, (String)"sorry but you cannot commit suicide");
        this.userRepository.toggleEnabled(userId, status);
        if (!status) {
            User userToDisable = this.userRepository.findById(userId);
            this.invalidateSessionsForUser(userToDisable.getUsername());
        }
    }

    @Transactional(readOnly=true)
    public ValidationResult validateUser(Integer id, String username, String firstName, String lastName, String emailAddress) {
        Optional existing = Optional.ofNullable(id).flatMap(arg_0 -> ((UserRepository)this.userRepository).findOptionalById(arg_0));
        if (existing.filter(e -> e.getUsername().equals(username)).isEmpty() && this.usernameExists(username)) {
            return ValidationResult.failed((ValidationResult.ErrorDescriptor[])new ValidationResult.ErrorDescriptor[]{new ValidationResult.ErrorDescriptor("username", "There is already another user with the same username.")});
        }
        return ValidationResult.of(Stream.of(Pair.of((Object)firstName, (Object)"firstName"), Pair.of((Object)lastName, (Object)"lastName"), Pair.of((Object)emailAddress, (Object)"emailAddress")).filter(p -> StringUtils.isEmpty((CharSequence)((CharSequence)p.getKey()))).map(p -> new ValidationResult.ErrorDescriptor((String)p.getKey(), (String)p.getValue() + " is required")).collect(Collectors.toList()));
    }

    @Transactional(readOnly=true)
    public ValidationResult validateNewPassword(String username, String oldPassword, String newPassword, String newPasswordConfirm) {
        return this.userRepository.findByUsername(username).map(u -> {
            ArrayList<ValidationResult.ErrorDescriptor> errors = new ArrayList<ValidationResult.ErrorDescriptor>();
            Optional password = this.userRepository.findPasswordByUsername(username);
            if (password.filter(p -> oldPassword == null || this.passwordEncoder.matches((CharSequence)oldPassword, p)).isEmpty()) {
                errors.add(new ValidationResult.ErrorDescriptor("alfio.old-password-invalid", "wrong password"));
            }
            if (!PasswordGenerator.isValid((String)newPassword)) {
                errors.add(new ValidationResult.ErrorDescriptor("alfio.new-password-invalid", "new password is not strong enough"));
            }
            if (!StringUtils.equals((CharSequence)newPassword, (CharSequence)newPasswordConfirm)) {
                errors.add(new ValidationResult.ErrorDescriptor("alfio.new-password-does-not-match", "new password has not been confirmed"));
            }
            return ValidationResult.of(errors);
        }).orElseGet(() -> ValidationResult.failed((ValidationResult.ErrorDescriptor[])new ValidationResult.ErrorDescriptor[0]));
    }

    public Integer createPublicUserIfNotExists(String username, String email, String firstName, String lastName) {
        int result = this.userRepository.createPublicUserIfNotExists(username, this.passwordEncoder.encode((CharSequence)PasswordGenerator.generateRandomPassword()), firstName, lastName, email, true);
        if (result == 1) {
            log.info("Created public user");
        } else {
            log.info("User was not created because already existed");
        }
        return this.userRepository.findIdByUserName(username).orElse(null);
    }

    private void checkIsAdmin(Principal principal) {
        if (principal == null) {
            return;
        }
        if (this.isSystemApiUser(principal)) {
            log.trace("Allowing call for System API Key");
            return;
        }
        if (this.isAdmin(this.findUserByUsername(principal.getName()))) {
            return;
        }
        log.warn("User {} is not an admin", (Object)principal.getName());
        throw new IllegalArgumentException("User " + principal.getName() + " is not an admin");
    }

    private void checkAccessToUserId(Principal principal, int userId) {
        if (principal == null || this.isSystemApiUser(principal)) {
            return;
        }
        this.accessService.checkAccessToUser(principal, Integer.valueOf(userId));
    }

    private void checkAccessToUserIdAndNewOrganization(Principal principal, int userId, int newOrganization) {
        this.checkAccessToUserId(principal, userId);
        this.checkAccessToOrganizationId(principal, newOrganization);
    }

    private void checkAccessToOrganizationId(Principal principal, int organizationId) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
    }

    private boolean isSystemApiUser(Principal principal) {
        APITokenAuthentication apita;
        return principal instanceof APITokenAuthentication && (apita = (APITokenAuthentication)principal).getAuthorities().stream().allMatch(authority -> authority.getAuthority().equals("ROLE_SYSTEM_API_CLIENT"));
    }

    @ConstructorProperties(value={"authorityRepository", "organizationRepository", "userOrganizationRepository", "userRepository", "passwordEncoder", "invoiceSequencesRepository", "sessionsByPrincipalFinder", "accessService"})
    @Generated
    public UserManager(AuthorityRepository authorityRepository, OrganizationRepository organizationRepository, UserOrganizationRepository userOrganizationRepository, UserRepository userRepository, PasswordEncoder passwordEncoder, InvoiceSequencesRepository invoiceSequencesRepository, FindByIndexNameSessionRepository<?> sessionsByPrincipalFinder, AccessService accessService) {
        this.authorityRepository = authorityRepository;
        this.organizationRepository = organizationRepository;
        this.userOrganizationRepository = userOrganizationRepository;
        this.userRepository = userRepository;
        this.passwordEncoder = passwordEncoder;
        this.invoiceSequencesRepository = invoiceSequencesRepository;
        this.sessionsByPrincipalFinder = sessionsByPrincipalFinder;
        this.accessService = accessService;
    }
}

