/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.wallet;

import alfio.manager.wallet.EventTicketClass;
import alfio.manager.wallet.WalletEntity;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import lombok.Generated;

public class EventTicketClass
implements WalletEntity {
    public static final String WALLET_URL = "https://walletobjects.googleapis.com/walletobjects/v1/eventTicketClass";
    private static final DateTimeFormatter EVENT_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSX");
    private String id;
    private String eventName;
    private String eventOrGroupingId;
    private String description;
    private String venue;
    private LatitudeLongitudePoint location;
    private String ticketType;
    private String logoUri;
    private ZonedDateTime start;
    private ZonedDateTime end;

    public String build(ObjectMapper mapper) {
        ObjectNode object = mapper.createObjectNode();
        object.put("id", this.id);
        object.put("eventId", this.eventOrGroupingId);
        object.put("multipleDevicesAndHoldersAllowedStatus", "ONE_USER_ALL_DEVICES");
        object.put("issuerName", this.eventName);
        object.set("eventName", mapper.createObjectNode().set("defaultValue", (JsonNode)mapper.createObjectNode().put("language", "en-US").put("value", this.ticketType)));
        object.set("venue", mapper.createObjectNode().setAll(Map.of("name", mapper.createObjectNode().set("defaultValue", (JsonNode)mapper.createObjectNode().put("language", "en-US").put("value", this.venue)), "address", mapper.createObjectNode().set("defaultValue", (JsonNode)mapper.createObjectNode().put("language", "en-US").put("value", this.venue)))));
        object.set("dateTime", (JsonNode)mapper.createObjectNode().put("start", this.start.format(EVENT_TIME_FORMATTER)).put("end", this.end.format(EVENT_TIME_FORMATTER)));
        object.put("reviewStatus", "UNDER_REVIEW");
        object.put("hexBackgroundColor", "#FFFFFF");
        object.set("logo", mapper.createObjectNode().set("sourceUri", (JsonNode)mapper.createObjectNode().put("uri", this.logoUri)));
        object.set("classTemplateInfo", mapper.createObjectNode().set("cardTemplateOverride", mapper.createObjectNode().set("cardRowTemplateInfos", (JsonNode)mapper.createArrayNode().add(mapper.createObjectNode().set("oneItem", mapper.createObjectNode().setAll(Map.of("item", mapper.createObjectNode().set("firstValue", mapper.createObjectNode().set("fields", (JsonNode)mapper.createArrayNode().add((JsonNode)mapper.createObjectNode().put("fieldPath", "class.dateTime.start")))))))).add(mapper.createObjectNode().set("oneItem", mapper.createObjectNode().setAll(Map.of("item", mapper.createObjectNode().set("firstValue", mapper.createObjectNode().set("fields", (JsonNode)mapper.createArrayNode().add((JsonNode)mapper.createObjectNode().put("fieldPath", "class.dateTime.end")))))))))));
        object.set("linksModuleData", mapper.createObjectNode().set("uris", (JsonNode)mapper.createArrayNode().add((JsonNode)mapper.createObjectNode().put("uri", "https://alf.io").put("description", "Powered by Alf.io, the Open Source ticket reservation system.").put("id", "alfio"))));
        object.set("messages", (JsonNode)mapper.createArrayNode().add((JsonNode)mapper.createObjectNode().put("header", "Event Description").put("body", this.description)));
        if (this.location != null) {
            object.set("locations", (JsonNode)this.location.accept(mapper));
        }
        try {
            return mapper.writeValueAsString((Object)object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @ConstructorProperties(value={"id", "eventName", "eventOrGroupingId", "description", "venue", "location", "ticketType", "logoUri", "start", "end"})
    @Generated
    EventTicketClass(String id, String eventName, String eventOrGroupingId, String description, String venue, LatitudeLongitudePoint location, String ticketType, String logoUri, ZonedDateTime start, ZonedDateTime end) {
        this.id = id;
        this.eventName = eventName;
        this.eventOrGroupingId = eventOrGroupingId;
        this.description = description;
        this.venue = venue;
        this.location = location;
        this.ticketType = ticketType;
        this.logoUri = logoUri;
        this.start = start;
        this.end = end;
    }

    @Generated
    public static EventTicketClassBuilder builder() {
        return new EventTicketClassBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getEventName() {
        return this.eventName;
    }

    @Generated
    public String getEventOrGroupingId() {
        return this.eventOrGroupingId;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getVenue() {
        return this.venue;
    }

    @Generated
    public LatitudeLongitudePoint getLocation() {
        return this.location;
    }

    @Generated
    public String getTicketType() {
        return this.ticketType;
    }

    @Generated
    public String getLogoUri() {
        return this.logoUri;
    }

    @Generated
    public ZonedDateTime getStart() {
        return this.start;
    }

    @Generated
    public ZonedDateTime getEnd() {
        return this.end;
    }
}

