/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.wallet;

import alfio.manager.wallet.EventTicketObject;
import alfio.manager.wallet.WalletEntity;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import lombok.Generated;

public class EventTicketObject
implements WalletEntity {
    public static final String WALLET_URL = "https://walletobjects.googleapis.com/walletobjects/v1/eventTicketObject";
    private String id;
    private String classId;
    private String ticketHolderName;
    private String ticketNumber;
    private String barcode;

    public String build(ObjectMapper mapper) {
        ObjectNode object = mapper.createObjectNode();
        object.put("id", this.id);
        object.put("classId", this.classId);
        object.put("state", "ACTIVE");
        object.put("ticketHolderName", this.ticketHolderName);
        object.put("ticketNumber", this.ticketNumber);
        object.set("barcode", (JsonNode)mapper.createObjectNode().put("type", "QR_CODE").put("value", this.barcode));
        try {
            return mapper.writeValueAsString((Object)object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @ConstructorProperties(value={"id", "classId", "ticketHolderName", "ticketNumber", "barcode"})
    @Generated
    EventTicketObject(String id, String classId, String ticketHolderName, String ticketNumber, String barcode) {
        this.id = id;
        this.classId = classId;
        this.ticketHolderName = ticketHolderName;
        this.ticketNumber = ticketNumber;
        this.barcode = barcode;
    }

    @Generated
    public static EventTicketObjectBuilder builder() {
        return new EventTicketObjectBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getClassId() {
        return this.classId;
    }

    @Generated
    public String getTicketHolderName() {
        return this.ticketHolderName;
    }

    @Generated
    public String getTicketNumber() {
        return this.ticketNumber;
    }

    @Generated
    public String getBarcode() {
        return this.barcode;
    }
}

