/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager.wallet;

import alfio.manager.system.ConfigurationManager;
import alfio.manager.wallet.EventTicketClass;
import alfio.manager.wallet.EventTicketObject;
import alfio.manager.wallet.GoogleWalletException;
import alfio.manager.wallet.GoogleWalletManager;
import alfio.manager.wallet.WalletEntity;
import alfio.model.Audit;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.EventDescription;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.metadata.TicketMetadata;
import alfio.model.metadata.TicketMetadataContainer;
import alfio.model.system.ConfigurationKeys;
import alfio.model.system.command.InvalidateAccess;
import alfio.repository.AuditingRepository;
import alfio.repository.EventDescriptionRepository;
import alfio.repository.EventRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.util.HttpUtils;
import alfio.util.MiscUtils;
import alfio.util.MustacheCustomTag;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPrivateKey;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Transactional
public class GoogleWalletManager {
    private static final Logger log = LoggerFactory.getLogger(GoogleWalletManager.class);
    private static final String WALLET_OBJECT_ID = "gWalletObjectId";
    private static final String AUTHORIZATION = "Authorization";
    private static final String BEARER_PLACEHOLDER = "Bearer %s";
    private final EventRepository eventRepository;
    private final ConfigurationManager configurationManager;
    private final EventDescriptionRepository eventDescriptionRepository;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final TicketRepository ticketRepository;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;
    private final Environment environment;
    private final AuditingRepository auditingRepository;

    public Optional<Pair<EventAndOrganizationId, Ticket>> validateTicket(String eventName, String ticketUuid) {
        Optional eventOptional = this.eventRepository.findOptionalEventAndOrganizationIdByShortName(eventName);
        if (eventOptional.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("event {} not found", (Object)MiscUtils.removeTabsAndNewlines((String)eventName));
            }
            return Optional.empty();
        }
        EventAndOrganizationId event = (EventAndOrganizationId)eventOptional.get();
        return this.ticketRepository.findOptionalByPublicUUID(UUID.fromString(ticketUuid)).filter(t -> t.getEventId() == event.getId()).map(t -> Pair.of((Object)event, (Object)t));
    }

    public String createAddToWalletUrl(Ticket ticket, EventAndOrganizationId event) {
        Map passConf = this.getConfigurationKeys(event);
        if (!passConf.isEmpty()) {
            return this.buildWalletPassUrl(ticket, this.eventRepository.findById(event.getId()), passConf);
        }
        throw new GoogleWalletException("Google Wallet integration is not enabled.");
    }

    @EventListener
    public void invalidateAccessForTicket(InvalidateAccess invalidateAccess) {
        try {
            Map passConf = this.getConfigurationKeys((EventAndOrganizationId)invalidateAccess.event());
            if (!passConf.isEmpty()) {
                invalidateAccess.ticketMetadataContainer().getMetadataForKey("general").map(m -> (String)m.getAttributes().get("gWalletObjectId")).ifPresent(s -> this.invalidateObject(invalidateAccess.ticket().getUuid(), s, passConf));
            }
        }
        catch (Exception e) {
            log.warn("Error while invalidating access for ticket " + invalidateAccess.ticket().getUuid(), (Throwable)e);
        }
    }

    private void invalidateObject(String ticketId, String objectId, Map<ConfigurationKeys, String> passConf) {
        try {
            log.trace("Invalidating access to object ID: {}", (Object)objectId);
            GoogleCredentials credentials = GoogleWalletManager.retrieveCredentials((String)passConf.get(ConfigurationKeys.WALLET_SERVICE_ACCOUNT_KEY));
            URI uriWithId = URI.create("%s/%s".formatted("https://walletobjects.googleapis.com/walletobjects/v1/eventTicketObject", objectId));
            HttpRequest expireRequest = HttpRequest.newBuilder().uri(uriWithId).header("Authorization", "Bearer %s".formatted(credentials.refreshAccessToken().getTokenValue())).method("PATCH", HttpRequest.BodyPublishers.ofString("{\"state\":\"INACTIVE\"}")).build();
            HttpResponse<String> response = this.httpClient.send(expireRequest, HttpResponse.BodyHandlers.ofString());
            if (HttpUtils.callSuccessful(response)) {
                log.debug("Access invalidated for ticket {}", (Object)ticketId);
            } else {
                this.logIfWarnEnabled(() -> log.warn("Cannot invalidate access for ticket {}, response: {}", (Object)ticketId, response.body()));
            }
        }
        catch (IOException e) {
            throw new GoogleWalletException(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new GoogleWalletException(e.getMessage(), (Throwable)e);
        }
    }

    private Map<ConfigurationKeys, String> getConfigurationKeys(EventAndOrganizationId event) {
        Map conf = this.configurationManager.getFor(Set.of(ConfigurationKeys.ENABLE_WALLET, ConfigurationKeys.WALLET_ISSUER_IDENTIFIER, ConfigurationKeys.WALLET_SERVICE_ACCOUNT_KEY, ConfigurationKeys.WALLET_OVERWRITE_PREVIOUS_CLASSES_AND_EVENTS, ConfigurationKeys.BASE_URL), event.getConfigurationLevel());
        if (!((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.ENABLE_WALLET)).getValueAsBooleanOrDefault()) {
            return Map.of();
        }
        Map<ConfigurationKeys, Optional> configValues = Map.of(ConfigurationKeys.WALLET_ISSUER_IDENTIFIER, ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.WALLET_ISSUER_IDENTIFIER)).getValue(), ConfigurationKeys.WALLET_SERVICE_ACCOUNT_KEY, ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.WALLET_SERVICE_ACCOUNT_KEY)).getValue(), ConfigurationKeys.WALLET_OVERWRITE_PREVIOUS_CLASSES_AND_EVENTS, ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.WALLET_OVERWRITE_PREVIOUS_CLASSES_AND_EVENTS)).getValue(), ConfigurationKeys.BASE_URL, ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.BASE_URL)).getValue());
        if (configValues.values().stream().anyMatch(Optional::isEmpty)) {
            return Map.of();
        }
        return configValues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((Optional)e.getValue()).orElseThrow()));
    }

    private String buildWalletPassUrl(Ticket ticket, Event event, Map<ConfigurationKeys, String> config) {
        String baseUrl = config.get(ConfigurationKeys.BASE_URL);
        String issuerId = config.get(ConfigurationKeys.WALLET_ISSUER_IDENTIFIER);
        String serviceAccountKey = config.get(ConfigurationKeys.WALLET_SERVICE_ACCOUNT_KEY);
        boolean overwritePreviousClassesAndEvents = Boolean.parseBoolean(config.get(ConfigurationKeys.WALLET_OVERWRITE_PREVIOUS_CLASSES_AND_EVENTS));
        String eventDescription = MustacheCustomTag.renderToTextCommonmark((String)this.eventDescriptionRepository.findDescriptionByEventIdTypeAndLocale(event.getId(), EventDescription.EventDescriptionType.DESCRIPTION, ticket.getUserLanguage()).orElse(""));
        TicketCategory category = this.ticketCategoryRepository.getById(ticket.getCategoryId().intValue());
        ZonedDateTime ticketValidityStart = Optional.ofNullable(category.getTicketValidityStart(event.getZoneId())).orElse(event.getBegin());
        ZonedDateTime ticketValidityEnd = Optional.ofNullable(category.getTicketValidityEnd(event.getZoneId())).orElse(event.getEnd());
        EventTicketClass.LatitudeLongitudePoint latitudeLongitudePoint = null;
        if (event.getLatitude() != null && event.getLongitude() != null) {
            latitudeLongitudePoint = EventTicketClass.LatitudeLongitudePoint.of((Double)Double.parseDouble(event.getLatitude()), (Double)Double.parseDouble(event.getLongitude()));
        }
        String host = URI.create(baseUrl).getHost().replace(".", "-");
        EventTicketClass eventTicketClass = EventTicketClass.builder().id(this.formatEventTicketClassId(event, issuerId, category, host)).eventOrGroupingId(Integer.toString(event.getId())).logoUri(baseUrl + "/file/" + event.getFileBlobId()).eventName(event.getDisplayName()).description(eventDescription).venue(event.getLocation()).location(latitudeLongitudePoint).ticketType(category.getName()).start(ticketValidityStart).end(ticketValidityEnd).build();
        String walletTicketId = this.formatEventTicketObjectId(ticket, event, issuerId, host);
        EventTicketObject eventTicketObject = EventTicketObject.builder().id(walletTicketId).classId(eventTicketClass.getId()).ticketHolderName(ticket.getFullName()).ticketNumber(ticket.getUuid()).barcode(ticket.ticketCode(event.getPrivateKey(), event.supportsQRCodeCaseInsensitive())).build();
        GoogleCredentials credentials = GoogleWalletManager.retrieveCredentials((String)serviceAccountKey);
        this.createEventClass(credentials, eventTicketClass, overwritePreviousClassesAndEvents);
        String eventObjectId = this.createEventObject(credentials, eventTicketObject, overwritePreviousClassesAndEvents);
        String walletPassUrl = this.generateWalletPassUrl(credentials, eventObjectId, baseUrl);
        this.persistPassId(ticket, eventObjectId);
        return walletPassUrl;
    }

    private static GoogleCredentials retrieveCredentials(String serviceAccountKey) {
        try {
            return GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(serviceAccountKey.getBytes(StandardCharsets.UTF_8))).createScoped(Collections.singleton("https://www.googleapis.com/auth/wallet_object.issuer"));
        }
        catch (IOException e) {
            throw new GoogleWalletException("Unable to retrieve Service Account Credentials from configuration", (Throwable)e);
        }
    }

    private void persistPassId(Ticket ticket, String eventObjectId) {
        TicketMetadataContainer metadataContainer = Objects.requireNonNullElseGet(this.ticketRepository.getTicketMetadata(ticket.getId()), TicketMetadataContainer::empty);
        Optional existingMetadata = metadataContainer.getMetadataForKey("general");
        HashMap attributesMap = existingMetadata.map(ticketMetadata -> new HashMap(ticketMetadata.getAttributes())).orElseGet(HashMap::new);
        attributesMap.put("gWalletObjectId", eventObjectId);
        metadataContainer.putMetadata("general", existingMetadata.map(tm -> tm.withAttributes((Map)attributesMap)).orElseGet(() -> new TicketMetadata(null, null, (Map)attributesMap)));
        this.ticketRepository.updateTicketMetadata(ticket.getId(), metadataContainer);
    }

    private String formatEventTicketObjectId(Ticket ticket, Event event, String issuerId, String host) {
        return String.format("%s.%s-%s-object.%s-%s", issuerId, this.walletIdPrefix(), host, event.getShortName().replaceAll("[^\\w.-]", "_"), ticket.getUuid() + "_" + this.auditingRepository.countAuditsOfTypeForTicket(ticket.getTicketsReservationId(), ticket.getId(), Audit.EventType.TICKET_HOLDER_CHANGED));
    }

    private String formatEventTicketClassId(Event event, String issuerId, TicketCategory category, String host) {
        return String.format("%s.%s-%s-class.%s-%d", issuerId, this.walletIdPrefix(), host, event.getShortName().replaceAll("[^\\w.-]", "_"), category.getId());
    }

    private String generateWalletPassUrl(GoogleCredentials credentials, String eventObjectId, String url) {
        Map<String, String> objectIdMap = Map.of("id", eventObjectId);
        Map<String, List<Map<String, String>>> payload = Map.of("genericObjects", List.of(objectIdMap));
        Map<String, Map<String, List<Map<String, String>>>> claims = Map.of("iss", ((ServiceAccountCredentials)credentials).getClientEmail(), "aud", "google", "origins", List.of(url), "typ", "savetowallet", "payload", payload);
        Algorithm algorithm = Algorithm.RSA256(null, (RSAPrivateKey)((RSAPrivateKey)((ServiceAccountCredentials)credentials).getPrivateKey()));
        String token = JWT.create().withPayload(claims).sign(algorithm);
        return "https://pay.google.com/gp/v/save/%s".formatted(token);
    }

    private String createEventClass(GoogleCredentials credentials, EventTicketClass eventTicketClass, boolean overwritePreviousClassesAndEvents) {
        return this.createOnWallet("https://walletobjects.googleapis.com/walletobjects/v1/eventTicketClass", credentials, (WalletEntity)eventTicketClass, overwritePreviousClassesAndEvents);
    }

    private String createEventObject(GoogleCredentials credentials, EventTicketObject eventTicketObject, boolean overwritePreviousClassesAndEvents) {
        return this.createOnWallet("https://walletobjects.googleapis.com/walletobjects/v1/eventTicketObject", credentials, (WalletEntity)eventTicketObject, overwritePreviousClassesAndEvents);
    }

    private String createOnWallet(String uri, GoogleCredentials credentials, WalletEntity entity, boolean overwritePreviousClassesAndEvents) {
        try {
            URI uriWithId = URI.create("%s/%s".formatted(uri, entity.getId()));
            HttpRequest getRequest = HttpRequest.newBuilder().uri(uriWithId).header("Authorization", "Bearer %s".formatted(credentials.refreshAccessToken().getTokenValue())).GET().build();
            log.debug("GET Request: {}", (Object)getRequest);
            HttpResponse<String> getResponse = this.httpClient.send(getRequest, HttpResponse.BodyHandlers.ofString());
            log.debug("GET Response: {}", getResponse);
            if (getResponse.statusCode() != 200 && getResponse.statusCode() != 404) {
                this.logIfWarnEnabled(() -> log.warn("Received {} status code when creating entity but 200 or 404 were expected: {}", (Object)getResponse.statusCode(), getResponse.body()));
                throw new GoogleWalletException("Cannot create Wallet class. Response status: " + getResponse.statusCode());
            }
            if (getResponse.statusCode() == 404 || overwritePreviousClassesAndEvents) {
                HttpRequest.Builder builder = HttpRequest.newBuilder().header("Authorization", "Bearer %s".formatted(credentials.refreshAccessToken().getTokenValue()));
                builder = getResponse.statusCode() == 404 ? builder.uri(URI.create(uri)).POST(HttpRequest.BodyPublishers.ofString(entity.build(this.objectMapper))) : builder.uri(uriWithId).PUT(HttpRequest.BodyPublishers.ofString(entity.build(this.objectMapper)));
                HttpRequest postOrPutRequest = builder.build();
                log.debug("POST or PUT Request: {}", (Object)postOrPutRequest);
                HttpResponse<String> postOrPutResponse = this.httpClient.send(postOrPutRequest, HttpResponse.BodyHandlers.ofString());
                log.debug("POST or PUT Response: {}", postOrPutResponse);
                if (postOrPutResponse.statusCode() != 200) {
                    this.logIfWarnEnabled(() -> log.warn("Received {} status code when creating entity: {}", (Object)postOrPutResponse.statusCode(), postOrPutResponse.body()));
                    throw new GoogleWalletException("Cannot create wallet. Response status: " + postOrPutResponse.statusCode());
                }
            }
            return entity.getId();
        }
        catch (IOException e) {
            throw new GoogleWalletException("Error while communicating with the Google Wallet API", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new GoogleWalletException("Error while communicating with the Google Wallet API", (Throwable)e);
        }
    }

    private String walletIdPrefix() {
        String profile = Stream.of("demo", "dev", "!dev").filter(p -> this.environment.acceptsProfiles(Profiles.of((String[])new String[]{p}))).findFirst().orElseThrow(() -> new NoSuchElementException("No suitable Spring Profile found to create a Wallet ID prefix for classes and objects. Must have one of PROFILE_DEMO, PROFILE_DEV, or PROFILE_LIVE"));
        if (profile.equals("!dev")) {
            return "live";
        }
        return profile;
    }

    private void logIfWarnEnabled(ConditionalLogger logger) {
        if (log.isWarnEnabled()) {
            logger.log();
        }
    }

    @ConstructorProperties(value={"eventRepository", "configurationManager", "eventDescriptionRepository", "ticketCategoryRepository", "ticketRepository", "httpClient", "objectMapper", "environment", "auditingRepository"})
    @Generated
    public GoogleWalletManager(EventRepository eventRepository, ConfigurationManager configurationManager, EventDescriptionRepository eventDescriptionRepository, TicketCategoryRepository ticketCategoryRepository, TicketRepository ticketRepository, HttpClient httpClient, ObjectMapper objectMapper, Environment environment, AuditingRepository auditingRepository) {
        this.eventRepository = eventRepository;
        this.configurationManager = configurationManager;
        this.eventDescriptionRepository = eventDescriptionRepository;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.ticketRepository = ticketRepository;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
        this.environment = environment;
        this.auditingRepository = auditingRepository;
    }
}

